import matplotlib.pyplot as plt
numargs = exponweib.numargs
[ a, c ] = [0.9,] * numargs
rv = exponweib(a, c)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = exponweib.cdf(x, a, c)
h = plt.semilogy(np.abs(x - exponweib.ppf(prb, a, c)) + 1e-20)

# Random number generation

R = exponweib.rvs(a, c, size=100)
