import matplotlib.pyplot as plt
numargs = gengamma.numargs
[ a, c ] = [0.9,] * numargs
rv = gengamma(a, c)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = gengamma.cdf(x, a, c)
h = plt.semilogy(np.abs(x - gengamma.ppf(prb, a, c)) + 1e-20)

# Random number generation

R = gengamma.rvs(a, c, size=100)
