import matplotlib.pyplot as plt
numargs = invweibull.numargs
[ c ] = [0.9,] * numargs
rv = invweibull(c)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = invweibull.cdf(x, c)
h = plt.semilogy(np.abs(x - invweibull.ppf(prb, c)) + 1e-20)

# Random number generation

R = invweibull.rvs(c, size=100)
