import matplotlib.pyplot as plt
numargs = nakagami.numargs
[ nu ] = [0.9,] * numargs
rv = nakagami(nu)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = nakagami.cdf(x, nu)
h = plt.semilogy(np.abs(x - nakagami.ppf(prb, nu)) + 1e-20)

# Random number generation

R = nakagami.rvs(nu, size=100)
