import matplotlib.pyplot as plt
numargs = powerlognorm.numargs
[ c, s ] = [0.9,] * numargs
rv = powerlognorm(c, s)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = powerlognorm.cdf(x, c, s)
h = plt.semilogy(np.abs(x - powerlognorm.ppf(prb, c, s)) + 1e-20)

# Random number generation

R = powerlognorm.rvs(c, s, size=100)
