import matplotlib.pyplot as plt
numargs = recipinvgauss.numargs
[ mu ] = [0.9,] * numargs
rv = recipinvgauss(mu)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = recipinvgauss.cdf(x, mu)
h = plt.semilogy(np.abs(x - recipinvgauss.ppf(prb, mu)) + 1e-20)

# Random number generation

R = recipinvgauss.rvs(mu, size=100)
