import matplotlib.pyplot as plt
numargs = tukeylambda.numargs
[ lam ] = [0.9,] * numargs
rv = tukeylambda(lam)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = tukeylambda.cdf(x, lam)
h = plt.semilogy(np.abs(x - tukeylambda.ppf(prb, lam)) + 1e-20)

# Random number generation

R = tukeylambda.rvs(lam, size=100)
