import matplotlib.pyplot as plt
numargs = vonmises.numargs
[ b ] = [0.9,] * numargs
rv = vonmises(b)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = vonmises.cdf(x, b)
h = plt.semilogy(np.abs(x - vonmises.ppf(prb, b)) + 1e-20)

# Random number generation

R = vonmises.rvs(b, size=100)
