import matplotlib.pyplot as plt
numargs = wrapcauchy.numargs
[ c ] = [0.9,] * numargs
rv = wrapcauchy(c)

# Display frozen pdf

x = np.linspace(0, np.minimum(rv.dist.b, 3))
h = plt.plot(x, rv.pdf(x))

# Check accuracy of cdf and ppf

prb = wrapcauchy.cdf(x, c)
h = plt.semilogy(np.abs(x - wrapcauchy.ppf(prb, c)) + 1e-20)

# Random number generation

R = wrapcauchy.rvs(c, size=100)
