#ifndef SCREEM_VIEW_H
#define SCREEM_VIEW_H

#include <gtk/gtkbin.h>

#define SCREEM_TYPE_VIEW  (screem_view_get_type())
#define SCREEM_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ),   \
                                                SCREEM_TYPE_VIEW, \
                                                ScreemView ) )
#define SCREEM_IS_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                               SCREEM_TYPE_VIEW ) )

typedef struct ScreemViewPrivate ScreemViewPrivate;

typedef struct ScreemView ScreemView;

struct ScreemView {
	GtkBin parent;

	ScreemViewPrivate *priv;

	/* Methods */
	void (*display)( ScreemView *view );
	void (*print)( ScreemView *view, gboolean preview );

	void (*undo)( ScreemView *view );
	void (*redo)( ScreemView *view );

	void (*show_message)( ScreemView *view, const gchar *msg );
	void (*show_error)( ScreemView *view, const gchar *msg );

		/* clipboard */
	void (*cut)( ScreemView *view );
	void (*copy)( ScreemView *view );
	void (*paste)( ScreemView *view );
	void (*paste_unformatted)( ScreemView *view );
	void (*paste_encoded)( ScreemView *view );
	void (*clear_selection)( ScreemView *view );
	gboolean (*has_selection)( ScreemView *view, 
			guint *start, guint *end );
	void (*select_region)( ScreemView *view, 
			guint start, guint end );

		/* text insertion / deletion */
	void (*insert)( ScreemView *view, gint pos,
			const gchar *text );
	void (*insert_markup)( ScreemView *view,
			const gchar *open_element,
			const gchar *close_element );
	void (*insert_file)( ScreemView *view,
			const gchar *fielname );
	void (*insert_attribute)( ScreemView *view,
			const gchar *attribute );
	void (*delete_forward)( ScreemView *view,
			guint pos, guint len );

		/* position / text functions */
	gchar* (*get_text)( ScreemView *view, 
			guint from, guint len );
	void (*set_pos)( ScreemView *view, guint pos );
	guint (*get_pos)( ScreemView *view );

};

typedef struct {
	GtkBinClass parent_class;

} ScreemViewClass;

GType screem_view_get_type( void );

void screem_view_display( ScreemView *view );
void screem_view_print( ScreemView *view, gboolean preview );

void screem_view_undo( ScreemView *view );
void screem_view_redo( ScreemView *view );

void screem_view_show_message( ScreemView *view, const gchar *msg );
void screem_view_show_error( ScreemView *view, const gchar *msg );

/* clipboard */
void screem_view_cut( ScreemView *view );
void screem_view_copy( ScreemView *view );
void screem_view_paste( ScreemView *view );
void screem_view_paste_unformatted( ScreemView *view );
void screem_view_paste_encoded( ScreemView *view );
void screem_view_clear_selection( ScreemView *view );
gboolean screem_view_has_selection( ScreemView *view, 
		guint *start, guint *end );
void screem_view_select_region( ScreemView *view, 
		guint start, guint end );

/* text insertion / deletion */
void screem_view_insert( ScreemView *view, gint pos,
		const gchar *text );
void screem_view_insert_markup( ScreemView *view,
		const gchar *open_element,
		const gchar *close_element );
void screem_view_insert_file( ScreemView *view,
		const gchar *fielname );
void screem_view_insert_attribute( ScreemView *view,
		const gchar *attribute );
void screem_view_delete_forward( ScreemView *view,
		guint pos, guint len );

/* position / text functions */
gchar* screem_view_get_text( ScreemView *view, 
		guint from, guint len );
void screem_view_set_pos( ScreemView *view, guint pos );
guint screem_view_get_pos( ScreemView *view );




#endif
