# -*- coding: utf-8 -*-
# Copyright © 2005 Lateef Alabi-Oki
#
# This file is part of Scribes.
#
# Scribes is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Scribes is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Scribes; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
This module exposes a class reponsible for creating trigger objects for the
text editor. A trigger is an action that a user can perform such as, opening a
new editor window, showing the open dialog, indenting lines and so on.

@author: Lateef Alabi-Oki
@organization: The Scribes Project
@copyright: Copyright © 2005 Lateef Alabi-Oki
@license: GNU GPLv2 or Later
@contact: mystilleef@gmail.com
"""

from gobject import GObject, SIGNAL_RUN_LAST, TYPE_NONE

class Trigger(GObject):
	"""
	This class creates trigger objects for the text editor. A trigger is an
	action that users can perform such as, opening a new editor window, showing
	the open dialog, indenting lines and so on.
	"""
	__gsignals__ = {
		"activate": (SIGNAL_RUN_LAST, TYPE_NONE, ())
	}

	def __init__(self, name=None):
		"""
		Initialize the trigger object.

		@param self: Reference to the Trigger instance.
		@type self: A Trigger object.

		@param name: The name of a trigger object
		@type name: A String object.

		@param accelerator: A short cut key associated with this trigger object
		@type accelerator: A String object.
		"""
		GObject.__init__(self)
		self.__init_attributes(name)

	def __init_attributes(self, name):
		"""
		Initialize the trigger's attributes.

		@param self: Reference to the Trigger instance.
		@type self: A Trigger object.

		@param name: The name of a trigger object
		@type name: A String object.
		"""
		self.name = name
		self.description = None
		return

	def activate(self):
		"""
		Activate the trigger.

		Activate the trigger makes it perform an action associated with the
		trigger.

		@param self: Reference to the Trigger instance.
		@type self: A Trigger object.
		"""
		self.emit("activate")
		return

	def destroy(self):
		del self.name, self.description, self
		self = None
		return
