<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE TS>
<TS version="2.0">
<context>
    <name></name>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="17"/>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="27"/>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="41"/>
        <source>getColorAsRGB(&quot;name&quot;) -&gt; tuple

Returns a tuple (R,G,B) containing the three color components of the
color &quot;name&quot; from the current document, converted to the RGB color
space. If no document is open, returns the value of the named color
from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="56"/>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="70"/>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="83"/>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="100"/>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddialog.h" line="17"/>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddialog.h" line="28"/>
        <source>fileDialog(&quot;caption&quot;, [&quot;filter&quot;, &quot;defaultname&quot;, haspreview, issave, isdir]) -&gt; string with filename

Shows a File Open dialog box with the caption &quot;caption&quot;. Files are filtered
with the filter string &quot;filter&quot;. A default filename or file path can also
supplied, leave this string empty when you don&apos;t want to use it.  A value of
True for haspreview enables a small preview widget in the FileSelect box.  When
the issave parameter is set to True the dialog acts like a &quot;Save As&quot; dialog
otherwise it acts like a &quot;File Open Dialog&quot;. When the isdir parameter is True
the dialog shows and returns only directories. The default for all of the
optional parameters is False.

The filter, if specified, takes the form &apos;comment (*.type *.type2 ...)&apos;.
For example &apos;Images (*.png *.xpm *.jpg)&apos;.

Refer to the Qt-Documentation for QFileDialog for details on filters.

Example: fileDialog(&apos;Open input&apos;, &apos;CSV files (*.csv)&apos;)
Example: fileDialog(&apos;Save report&apos;, defaultname=&apos;report.txt&apos;, issave=True)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddialog.h" line="56"/>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddialog.h" line="95"/>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddialog.h" line="107"/>
        <source>newStyleDialog() -&gt; string

Shows &apos;Create new paragraph style&apos; dialog. Function returns real
style name or None when user cancels the dialog.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="16"/>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="62"/>
        <source>newDoc(size, margins, orientation, firstPageNumber,
                   unit, facingPages, firstSideLeft) -&gt; bool

WARNING: Obsolete procedure! Use newDocument instead.

Creates a new document and returns true if successful. The parameters have the
following meaning:

    size = A tuple (width, height) describing the size of the document. You can
    use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

    margins = A tuple (left, right, top, bottom) describing the document
    margins

    orientation = the page orientation - constants PORTRAIT, LANDSCAPE

    firstPageNumer = is the number of the first page in the document used for
    pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
    numbers if you&apos;re creating a document in several parts.

    unit: this value sets the measurement units used by the document. Use a
    predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
    UNIT_PICAS, UNIT_POINTS.

    facingPages = FACINGPAGES, NOFACINGPAGES

    firstSideLeft = FIRSTPAGELEFT, FIRSTPAGERIGHT

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDoc(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 1, UNIT_POINTS,
                FACINGPAGES, FIRSTPAGERIGHT)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="103"/>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="114"/>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="123"/>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="134"/>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="146"/>
        <source>getDocName() -&gt; string

Returns the name the document was saved under.
If the document was not saved before the name is empty.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="156"/>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="168"/>
        <source>setInfo(&quot;author&quot;, &quot;info&quot;, &quot;description&quot;) -&gt; bool

Sets the document information. &quot;Author&quot;, &quot;Info&quot;, &quot;Description&quot; are
strings.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="178"/>
        <source>setMargins(lr, rr, tr, br)

Sets the margins of the document, Qt::DockLeft(lr), Qt::DockRight(rr), Qt::DockTop(tr) and Qt::DockBottom(br)
margins are given in the measurement units of the document - see UNIT_&lt;type&gt;
constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="189"/>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="201"/>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="212"/>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="222"/>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="232"/>
        <source>closeMasterPage()

Closes the currently active master page, if any, and returns editing
to normal. Begin editing with editMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="240"/>
        <source>masterPageNames()

Returns a list of the names of all master pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="247"/>
        <source>editMasterPage(pageName)

Enables master page editing and opens the named master page
for editing. Finish editing with closeMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="255"/>
        <source>createMasterPage(pageName)

Creates a new master page named pageName and opens it for
editing.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmddoc.h" line="263"/>
        <source>deleteMasterPage(pageName)

Delete the named master page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="17"/>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="27"/>
        <source>getFillTransparency([&quot;name&quot;]) -&gt; float

Returns the fill transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="37"/>
        <source>getFillBlendmode([&quot;name&quot;]) -&gt; integer

Returns the fill blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="47"/>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="57"/>
        <source>getLineTransparency([&quot;name&quot;]) -&gt; float

Returns the line transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="67"/>
        <source>getLineBlendmode([&quot;name&quot;]) -&gt; integer

Returns the line blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="77"/>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="87"/>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="97"/>
        <source>getLineJoin([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line join style of the object &quot;name&quot;. If &quot;name&quot; is not given
the currently selected item is used.  The join types are:
JOIN_BEVEL, JOIN_MITTER, JOIN_ROUND
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="108"/>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="119"/>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="130"/>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="140"/>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="151"/>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="161"/>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="171"/>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="183"/>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="195"/>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetprop.h" line="206"/>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="77"/>
        <source>getPropertyCType(object, property, includesuper=True)

Returns the name of the C type of `property&apos; of `object&apos;. See getProperty()
for details of arguments.

If `includesuper&apos; is true, search inherited properties too.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="96"/>
        <source>getPropertyNames(object, includesuper=True)

Return a list of property names supported by `object&apos;.
If `includesuper&apos; is true, return properties supported
by parent classes as well.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="123"/>
        <source>getProperty(object, property)

Return the value of the property `property&apos; of the passed `object&apos;.

The `object&apos; argument may be a string, in which case the named PageItem
is searched for. It may also be a PyCObject, which may point to any
C++ QObject instance.

The `property&apos; argument must be a string, and is the name of the property
to look up on `object&apos;.

The return value varies depending on the type of the property.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="158"/>
        <source>setProperty(object, property, value)

Set `property&apos; of `object&apos; to `value&apos;. If `value&apos; cannot be converted to a type
compatible with the type of `property&apos;, an exception is raised. An exception may
also be raised if the underlying setter fails.

See getProperty() for more information.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="17"/>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="29"/>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="41"/>
        <source>rotateObject(rot [, &quot;name&quot;])

Rotates the object &quot;name&quot; by &quot;rot&quot; degrees relatively. The object is
rotated by the vertex that is currently selected as the rotation point - by
default, the top left vertex at zero rotation. Positive values mean counter
clockwise rotation when the default rotation point is used. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="54"/>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="65"/>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="75"/>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="86"/>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="95"/>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="104"/>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="113"/>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="124"/>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="132"/>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="147"/>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="186"/>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="197"/>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="206"/>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="19"/>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="30"/>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="39"/>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="52"/>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="68"/>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="77"/>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="89"/>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="98"/>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="111"/>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="124"/>
        <source>setLayerPrintable(&quot;layer&quot;, printable)

Sets the layer &quot;layer&quot; to be printable or not. If is the
printable set to false the layer won&apos;t be printed.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="137"/>
        <source>setLayerLocked(&quot;layer&quot;, locked)

Sets the layer &quot;layer&quot; to be locked or not. If locked is set to
true the layer will be locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="150"/>
        <source>setLayerOutlined(&quot;layer&quot;, outline)

Sets the layer &quot;layer&quot; to be locked or not. If outline is set to
true the layer will be displayed outlined.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="163"/>
        <source>setLayerFlow(&quot;layer&quot;, flow)

Sets the layers &quot;layer&quot;  flowcontrol to flow. If flow is set to
true text in layers above this one will flow around objects on this layer.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="176"/>
        <source>setLayerBlendmode(&quot;layer&quot;, blend)

Sets the layers &quot;layer&quot;  blendmode to blend.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="188"/>
        <source>setLayerTransparency(&quot;layer&quot;, trans)

Sets the layers &quot;layer&quot;  transparency to trans.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="200"/>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="214"/>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="228"/>
        <source>isLayerLocked(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is locked or not, a value of True means
that the layer &quot;layer&quot; is editable, a value of False means that the layer
&quot;layer&quot; is locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="242"/>
        <source>isLayerOutlined(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is outlined or not, a value of True means
that the layer &quot;layer&quot; is outlined, a value of False means that the layer
&quot;layer&quot; is normal.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="256"/>
        <source>isLayerFlow(&quot;layer&quot;) -&gt; bool

Returns whether text flows around objects on layer &quot;layer&quot;, a value of True means
that text flows around, a value of False means that the text does not flow around.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="269"/>
        <source>getLayerBlendmode(&quot;layer&quot;) -&gt; int

Returns the &quot;layer&quot; layer blendmode,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="281"/>
        <source>getLayerTransparency(&quot;layer&quot;) -&gt; float

Returns the &quot;layer&quot; layer transparency,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="293"/>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="306"/>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="317"/>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="326"/>
        <source>moveSelectionToFront()

Moves current selection to front.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmisc.h" line="335"/>
        <source>moveSelectionToFront()

Moves current selection to back.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="17"/>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="34"/>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="51"/>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="66"/>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="81"/>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="96"/>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="114"/>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="134"/>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="155"/>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="173"/>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="184"/>
        <source>textFlowMode(&quot;name&quot; [, state])

Enables/disables &quot;Text Flows Around Frame&quot; feature for object &quot;name&quot;.
Called with parameters string name and optional int &quot;state&quot; (0 &lt;= state &lt;= 3).
Setting &quot;state&quot; to 0 will disable text flow.
Setting &quot;state&quot; to 1 will make text flow around object frame.
Setting &quot;state&quot; to 2 will make text flow around bounding box.
Setting &quot;state&quot; to 3 will make text flow around contour line.
If &quot;state&quot; is not passed, text flow is toggled.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="206"/>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="223"/>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="237"/>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdobj.h" line="249"/>
        <source>duplicateObject([&quot;name&quot;]) -&gt; string

creates a Duplicate of the selected Object (or Selection Group).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="17"/>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="32"/>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="42"/>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="51"/>
        <source>getPageType() -&gt; integer

Returns the type of the Page, 0 means left Page, 1 is a middle Page and 2 is a right Page
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="60"/>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="71"/>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="84"/>
        <source>gotoPage(nr)

Moves to the page &quot;nr&quot; (that is, makes the current page &quot;nr&quot;). Note that
gotoPage doesn&apos;t (currently) change the page the user&apos;s view is displaying, it
just sets the page that script commands will operates on.

May raise IndexError if the page number is out of range.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="97"/>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="106"/>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="116"/>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="129"/>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="138"/>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="147"/>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="161"/>
        <source>getPageNSize() -&gt; tuple

Returns a tuple with a particular page&apos;s size measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="174"/>
        <source>getPageNMargins() -&gt; tuple

Returns a tuple with a particular page&apos;s margins measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="187"/>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="203"/>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdpage.h" line="216"/>
        <source>importPage(&quot;fromDoc&quot;, (pageList), [create, imortwhere, importwherePage])

Imports a set of pages (given as a tuple) from an existing document (the file name must be given). This functions maps the &quot;Page-&gt;Import&quot; dropdown menu function.
fromDoc: string; the filename of the document to import pages from
pageList: tuple with page numbers of pages to import
create: number; 0 to replace existing pages, 1 (default) to insert new pages
importWhere: number; the page number (of the current document) at which import the pages
importWherePage: number; used if create==1; 0 to create pages before selected page; 1 to create pages after selected page; 2 (default) to create pages at the end of the document
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="17"/>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="39"/>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="50"/>
        <source>setFillTransparency(transparency, [&quot;name&quot;])

Sets the fill transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="60"/>
        <source>setFillBlendmode(blendmode, [&quot;name&quot;])

Sets the fill blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="70"/>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="80"/>
        <source>setLineTransparency(transparency, [&quot;name&quot;])

Sets the line transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="90"/>
        <source>setLineBlendmode(blendmode, [&quot;name&quot;])

Sets the line blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="100"/>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="113"/>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="127"/>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="138"/>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="149"/>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="160"/>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="174"/>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="186"/>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdstyle.h" line="22"/>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdstyle.h" line="52"/>
        <source>createCharStyle(...)

Creates a character style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; name of the char style to create

&quot;font&quot; [optional] -&gt; name of the font to use

fontsize [optional] -&gt; font size to set (double)

&quot;features&quot; [optional] -&gt; nearer typographic details can be defined by a string that might contain the following phrases comma-seperated (without spaces!):

-&gt; inherit

-&gt; bold

-&gt; italic

-&gt; underline

-&gt; underlinewords

-&gt; strike

-&gt; superscript

-&gt; subscript

-&gt; outline

-&gt; shadowed

-&gt; allcaps

-&gt; smallcaps

&quot;fillcolor&quot; [optional], &quot;fillshade&quot; [optional] -&gt; specify fill options

&quot;strokecolor&quot; [optional], &quot;strokeshade&quot; [optional] -&gt; specify stroke options

baselineoffset [optional] -&gt; offset of the baseline

shadowxoffset [optional], shadowyoffset [optional] -&gt; offset of the shadow if used

outlinewidth [optional] -&gt; width of the outline if used

underlineoffset [optional], underlinewidth [optional] -&gt; underline options if used

strikethruoffset [optional], strikethruwidth [optional] -&gt; strikethru options if used

scaleh [optional], scalev [optional] -&gt; scale of the chars

tracking [optional] -&gt; tracking of the text

&quot;language&quot; [optional] -&gt; language code

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="17"/>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="29"/>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="41"/>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="51"/>
        <source>getTextLines([&quot;name&quot;]) -&gt; integer

Returns the number of lines of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="61"/>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="73"/>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="85"/>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="95"/>
        <source>getTextDistances([&quot;name&quot;]) -&gt; tuple

Returns the text distances of the text frame &quot;name&quot; expressed in points. The
distances are returned as a tuple like (left, right, top, bottom). If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="106"/>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="116"/>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="126"/>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="138"/>
        <source>insertText(&quot;text&quot;, pos, [&quot;name&quot;])

Inserts the text &quot;text&quot; at the position &quot;pos&quot; into the text frame &quot;name&quot;.
Text must be UTF encoded (see setText() as reference) The first character has an
index of 0. Inserting text at position -1 appends it to the frame. If &quot;name&quot; is
not given the currently selected Item is used.

May throw IndexError for an insertion out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="152"/>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="165"/>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="179"/>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="192"/>
        <source>setTextDistances(left, right, top, bottom, [&quot;name&quot;])

Sets the text distances of the text frame &quot;name&quot; to the values &quot;left&quot;
&quot;right&quot;, &quot;top&quot; and &quot;bottom&quot;. If &quot;name&quot; is not given the currently
selected item is used.

May throw ValueError if any of the distances are out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="205"/>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="217"/>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="229"/>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="242"/>
        <source>selectText(start, count, [&quot;name&quot;])

Selects &quot;count&quot; characters of text in the text frame &quot;name&quot; starting from the
character &quot;start&quot;. Character counting starts at 0. If &quot;count&quot; is zero, any
text selection will be cleared.  If &quot;name&quot; is not given the currently
selected item is used.

May throw IndexError if the selection is outside the bounds of the text.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="256"/>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="267"/>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="278"/>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="308"/>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="321"/>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="338"/>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="355"/>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="366"/>
        <source>textOverflows([&quot;name&quot;, nolinks]) -&gt; integer

Returns the actual number of overflowing characters in text frame &quot;name&quot;.
If is nolinks set to non zero value it takes only one frame - it doesn&apos;t
use text frame linking. Without this parameter it search all linking chain.

May raise WrongFrameTypeError if the target frame is not an text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="379"/>
        <source>hyphenateText([&quot;name&quot;]) -&gt; bool

Does hyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="393"/>
        <source>dehyphenateText([&quot;name&quot;]) -&gt; bool

Does dehyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="408"/>
        <source>setPDFBookmark(&quot;toggle&quot;, [&quot;name&quot;])

Sets whether (toggle = 1) the text frame &quot;name&quot; is a bookmark nor not.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="420"/>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="17"/>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="30"/>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="43"/>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="52"/>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="66"/>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="78"/>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="91"/>
        <source>zoomDocument(double)

Zoom the document in main GUI window. Actions have whole number
values like 20.0, 100.0, etc. Zoom to Fit uses -100 as a marker.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/guiapp.h" line="103"/>
        <source>scrollDocument(x,y)

Scroll the document in main GUI window by x and y.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/svgimport.h" line="15"/>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/svgimport.h" line="27"/>
        <source>placeEPS(&quot;filename&quot;, x, y)

Places the EPS &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the EPS placed on the page

If loading was successful, the selection contains the imported EPS
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/svgimport.h" line="39"/>
        <source>placeSXD(&quot;filename&quot;, x, y)

Places the SXD &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SXD placed on the page

If loading was successful, the selection contains the imported SXD
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/svgimport.h" line="51"/>
        <source>placeODG(&quot;filename&quot;, x, y)

Places the ODG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the ODG placed on the page

If loading was successful, the selection contains the imported ODG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="113"/>
        <source>isSpotColor(&quot;name&quot;) -&gt; bool

Returns True if the color &quot;name&quot; is a spot color.
See also setSpotColor()

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdcolor.h" line="128"/>
        <source>setSpotColor(&quot;name&quot;, spot)

Set the color &quot;name&quot; as a spot color if spot parameter is True.
See also isSpotColor()

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="159"/>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the internal scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %. Internal scaling factors are different from the values shown on 
properties palette. Note : deprecated, use setImageScale() instead.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdmani.h" line="173"/>
        <source>setImageScale(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %. Scaling factors are equal to the values shown on properties palette.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdsetprop.h" line="28"/>
        <source>setGradientStop(&quot;color&quot;, shade, opacity, ramppoint, [&quot;name&quot;])

Set or add a gradient stop to the gradient fill of the object &quot;name&quot; at position ramppoint.
Color descriptions are the same as for setFillColor() and setFillShade(). setGradientFill()
must have been called previously for the gradient fill to be visible.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="288"/>
        <source>setTextScalingV(scale, [&quot;name&quot;])

Sets the vertical character scaling of the object &quot;name&quot; to &quot;scale&quot; in percent.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.h" line="298"/>
        <source>setTextScalingH(scale, [&quot;name&quot;])

Sets the horizontal character scaling of the object &quot;name&quot; to &quot;scale&quot; in percent.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>@default</name>
    <message>
        <source>Copy #%1 of </source>
        <translation type="obsolete">Kopie #%1 van</translation>
    </message>
</context>
<context>
    <name>AIPlug</name>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importai.cpp" line="125"/>
        <source>Importing: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importai.cpp" line="128"/>
        <source>Analyzing File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importai.cpp" line="265"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importai.cpp" line="2479"/>
        <source>Generating Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>About</name>
    <message>
        <source>%1. %2 %3 </source>
        <translation type="obsolete">%1. %2 %3 </translation>
    </message>
    <message>
        <source>Scribus Version %1
%2 %3</source>
        <translation type="obsolete">Scribus weergawe %1
%2 %3</translation>
    </message>
    <message>
        <source>Build-ID:</source>
        <translation type="obsolete">Bou-ID:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="188"/>
        <source>&amp;About</source>
        <translation>&amp;Oor</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="305"/>
        <source>Contributions from:</source>
        <translation>Bydraes vanaf:</translation>
    </message>
    <message>
        <source>Windows port:</source>
        <translation type="obsolete">Windows-weergawe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="201"/>
        <source>A&amp;uthors</source>
        <translation>O&amp;uteurs</translation>
    </message>
    <message>
        <source>German:</source>
        <translation type="obsolete">Duits:</translation>
    </message>
    <message>
        <source>French:</source>
        <translation type="obsolete">Frans:</translation>
    </message>
    <message>
        <source>Italian:</source>
        <translation type="obsolete">Italiaans:</translation>
    </message>
    <message>
        <source>Hungarian:</source>
        <translation type="obsolete">Hongaars:</translation>
    </message>
    <message>
        <source>Ukrainian:</source>
        <translation type="obsolete">Ukraïnies:</translation>
    </message>
    <message>
        <source>Bulgarian:</source>
        <translation type="obsolete">Bulgaars:</translation>
    </message>
    <message>
        <source>Galician:</source>
        <translation type="obsolete">Galisiaans:</translation>
    </message>
    <message>
        <source>Turkish:</source>
        <translation type="obsolete">Turks:</translation>
    </message>
    <message>
        <source>Lithuanian:</source>
        <translation type="obsolete">Litous:</translation>
    </message>
    <message>
        <source>Polish:</source>
        <translation type="obsolete">Pools:</translation>
    </message>
    <message>
        <source>Czech:</source>
        <translation type="obsolete">Tsjegies:</translation>
    </message>
    <message>
        <source>Slovak:</source>
        <translation type="obsolete">Slovaaks:</translation>
    </message>
    <message>
        <source>Danish:</source>
        <translation type="obsolete">Deens:</translation>
    </message>
    <message>
        <source>Norwegian:</source>
        <translation type="obsolete">Noors:</translation>
    </message>
    <message>
        <source>Welsh:</source>
        <translation type="obsolete">Wallies:</translation>
    </message>
    <message>
        <source>Russian:</source>
        <translation type="obsolete">Russies:</translation>
    </message>
    <message>
        <source>Brazilian:</source>
        <translation type="obsolete">Brasiliaans:</translation>
    </message>
    <message>
        <source>Finnish:</source>
        <translation type="obsolete">Fins:</translation>
    </message>
    <message>
        <source>Slovenian:</source>
        <translation type="obsolete">Sloveens:</translation>
    </message>
    <message>
        <source>Basque:</source>
        <translation type="obsolete">Baskies:</translation>
    </message>
    <message>
        <source>Swedish:</source>
        <translation type="obsolete">Sweeds:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="215"/>
        <source>&amp;Translations</source>
        <translation>Ver&amp;talings</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="226"/>
        <source>&amp;Online</source>
        <translation>&amp;Aanlyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="265"/>
        <source>&amp;Close</source>
        <translation>&amp;Sluit</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="297"/>
        <source>Development Team:</source>
        <translation>Ontwikkelingspan:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="307"/>
        <source>Official Documentation:</source>
        <translation>Offisiële dokumentasie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="311"/>
        <source>Other Documentation:</source>
        <translation>Ander dokumentasie:</translation>
    </message>
    <message>
        <source>English (British):</source>
        <translation type="obsolete">Engels (Brits):</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="345"/>
        <source>Homepage</source>
        <translation>Tuisblad</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="347"/>
        <source>Online Reference</source>
        <translation>Aanlyn handleiding</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="351"/>
        <source>Bugs and Feature Requests</source>
        <translation>Foute en funksiewense</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="355"/>
        <source>Mailing List</source>
        <translation>Poslys</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="97"/>
        <source>About Scribus %1</source>
        <translation>Oor Scribus %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="329"/>
        <source>Official Translations and Translators:</source>
        <translation>Amptelike vertalings en vertalers:</translation>
    </message>
    <message>
        <source>Catalan:</source>
        <translation type="obsolete">Katelaans:</translation>
    </message>
    <message>
        <source>Esperanto:</source>
        <translation type="obsolete">Esperanto:</translation>
    </message>
    <message>
        <source>Korean:</source>
        <translation type="obsolete">Koreaans:</translation>
    </message>
    <message>
        <source>Serbian:</source>
        <translation type="obsolete">Servies:</translation>
    </message>
    <message>
        <source>Spanish:</source>
        <translation type="obsolete">Spaans:</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="331"/>
        <source>Previous Translation Contributors:</source>
        <translation>Vorige vertalingsbydraers:</translation>
    </message>
    <message>
        <source>This panel shows the version, build date and
 compiled in library support in Scribus
The C-C-T equates to C=littlecms C=CUPS T=TIFF support.
Missing library support is indicated by a *</source>
        <translation type="obsolete">Die paneel wys die weergawe, vertaaldatum en die invertaalde biblioteke in Scribus 
Die C-C-T verwys na C=littlecms C=CUPS T=TIFF. 
Indien &apos;n biblioteek nie daar is nie, verskyn &apos;n *</translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="349"/>
        <source>Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="125"/>
        <source>%1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="133"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="183"/>
        <source>Using Ghostscript version %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="185"/>
        <source>No Ghostscript version available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="186"/>
        <source>Build ID:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="299"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="303"/>
        <source>Windows&amp;#174; Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="317"/>
        <source>Tango Project Icons:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="229"/>
        <source>&amp;Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="277"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="301"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="315"/>
        <source>Splash Screen:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="273"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="274"/>
        <source>The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support.Last Letter is the renderer C=cairo or Q=Qt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="275"/>
        <source>Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="276"/>
        <source>The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="186"/>
        <source>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="186"/>
        <source>Scribus Version</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="233"/>
        <location filename="../../../scribus/about.cpp" line="649"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="647"/>
        <source>Abort Update Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="353"/>
        <source>Developer Blog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="240"/>
        <source>&amp;Licence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="249"/>
        <source>Unable to open licence file. Please check your install directory or the Scribus website for licencing information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="309"/>
        <source>Doc Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="313"/>
        <source>Webmasters:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/about.cpp" line="447"/>
        <location filename="../../../scribus/about.cpp" line="559"/>
        <location filename="../../../scribus/about.cpp" line="625"/>
        <source>Unable to open %1 file. Please check your install directory or the Scribus website for %1 information.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPlugins</name>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <source>No</source>
        <translation type="obsolete">Nee</translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="68"/>
        <source>Filename:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="69"/>
        <source>Version:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="72"/>
        <source>Enabled:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="73"/>
        <source>Release Date:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="80"/>
        <source>Description:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="81"/>
        <source>Author(s):</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="82"/>
        <source>Copyright:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.cpp" line="83"/>
        <source>License:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aboutplugins.ui" line="13"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPluginsBase</name>
    <message>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>ActionManager</name>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1257"/>
        <source>&amp;New</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1259"/>
        <source>&amp;Open...</source>
        <translation type="unfinished">&amp;Maak oop...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1260"/>
        <source>&amp;Close</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1261"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1262"/>
        <source>Save &amp;As...</source>
        <translation type="unfinished">Stoor &amp;as...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1263"/>
        <source>Re&amp;vert to Saved</source>
        <translation type="unfinished">Gaa&amp;n terug na gestoorde</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1264"/>
        <source>Collect for O&amp;utput...</source>
        <translation type="unfinished">Versamel vir &amp;uitvoer...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1265"/>
        <source>Get Text...</source>
        <translation type="unfinished">Teks verkrygen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1266"/>
        <source>Append &amp;Text...</source>
        <translation type="unfinished">Voeg teks &amp;toe...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1267"/>
        <source>Get Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1270"/>
        <source>Save &amp;Text...</source>
        <translation type="unfinished">Stoor &amp;teks...</translation>
    </message>
    <message>
        <source>Save Page as &amp;EPS...</source>
        <translation type="obsolete">Bladsy stoor als &amp;EPS...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1272"/>
        <source>Save as P&amp;DF...</source>
        <translation type="unfinished">Stoor as P&amp;DF...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1273"/>
        <source>Document &amp;Setup...</source>
        <translation type="unfinished">Documentin&amp;stellingen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1275"/>
        <source>&amp;Print...</source>
        <translation type="unfinished">Afdru&amp;kken...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1277"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">A&amp;fsluiten</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1279"/>
        <source>&amp;Undo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1280"/>
        <source>&amp;Redo</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1281"/>
        <source>&amp;Item Action Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1282"/>
        <source>Cu&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1283"/>
        <location filename="../../../scribus/actionmanager.cpp" line="1285"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1284"/>
        <location filename="../../../scribus/actionmanager.cpp" line="1286"/>
        <source>&amp;Paste</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>C&amp;lear Contents</source>
        <translation type="obsolete">Maak Inhoud &amp;leeg</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1289"/>
        <source>Select &amp;All</source>
        <translation type="unfinished">&amp;Alles selecteren</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1291"/>
        <source>&amp;Deselect All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1292"/>
        <source>&amp;Search/Replace...</source>
        <translation type="unfinished">&amp;Zoeken/vervangen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1293"/>
        <source>Edit Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1295"/>
        <source>C&amp;olors...</source>
        <translation type="unfinished">Kle&amp;uren...</translation>
    </message>
    <message>
        <source>&amp;Paragraph Styles...</source>
        <translation type="obsolete">&amp;Alineastylen...</translation>
    </message>
    <message>
        <source>&amp;Line Styles...</source>
        <translation type="obsolete">&amp;Lynstylen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1299"/>
        <source>&amp;Master Pages...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;Javascripts...</source>
        <translation type="obsolete">&amp;Javascripts...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1274"/>
        <source>P&amp;references...</source>
        <translation type="unfinished">&amp;Voorkeuren...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1307"/>
        <source>%1 pt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1309"/>
        <source>&amp;Other...</source>
        <translation type="unfinished">&amp;Overig...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1310"/>
        <source>&amp;Left</source>
        <translation type="unfinished">&amp;Links</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1311"/>
        <source>&amp;Center</source>
        <translation type="unfinished">&amp;Midden</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1312"/>
        <source>&amp;Right</source>
        <translation type="unfinished">&amp;Regs</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1313"/>
        <source>&amp;Block</source>
        <translation type="unfinished">&amp;Blok</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1314"/>
        <source>&amp;Forced</source>
        <translation type="unfinished">Ge&amp;forceerd</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1325"/>
        <source>&amp;Normal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1326"/>
        <source>&amp;Underline</source>
        <translation type="unfinished">&amp;Onderstreep</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1327"/>
        <source>Underline &amp;Words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1328"/>
        <source>&amp;Strike Through</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1329"/>
        <source>&amp;All Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1330"/>
        <source>Small &amp;Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1331"/>
        <source>Su&amp;perscript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1332"/>
        <source>Su&amp;bscript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;Outline</source>
        <translation type="obsolete">&amp;Outline</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1334"/>
        <source>S&amp;hadow</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1336"/>
        <source>&amp;Image Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1337"/>
        <source>&amp;Tabulators...</source>
        <translation type="unfinished">&amp;Tabulators...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1340"/>
        <source>D&amp;uplicate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1341"/>
        <source>&amp;Multiple Duplicate</source>
        <translation type="unfinished">&amp;Meervoudig dupliceren</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1342"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1343"/>
        <source>&amp;Group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1344"/>
        <source>&amp;Ungroup</source>
        <translation type="unfinished">&amp;Groep losmaken</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1345"/>
        <source>Is &amp;Locked</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1346"/>
        <source>Si&amp;ze is Locked</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1350"/>
        <source>Lower to &amp;Bottom</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1351"/>
        <source>Raise to &amp;Top</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1352"/>
        <source>&amp;Lower</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1353"/>
        <source>&amp;Raise</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1354"/>
        <source>Send to S&amp;crapbook</source>
        <translation type="unfinished">Stuur na &amp;kladblok</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1356"/>
        <source>&amp;Attributes...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1358"/>
        <source>I&amp;mage Visible</source>
        <translation type="unfinished">P&amp;rent sigbaar</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1359"/>
        <source>&amp;Update Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1360"/>
        <source>Adjust Frame to Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1362"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1363"/>
        <source>&amp;Low Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1364"/>
        <source>&amp;Normal Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1365"/>
        <source>&amp;Full Resolution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1366"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation type="unfinished">Dit is &apos;n PDF-&amp;boekmerk</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1367"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation type="unfinished">Dit is &apos;n PDF-a&amp;nnotasie</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1368"/>
        <source>Annotation P&amp;roperties</source>
        <translation type="unfinished">&amp;Eienskappe van annotasie</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1369"/>
        <source>Field P&amp;roperties</source>
        <translation type="unfinished">&amp;Veldeienskappe</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1370"/>
        <source>&amp;Edit Shape...</source>
        <translation type="unfinished">&amp;Bewerk Vorm...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1371"/>
        <source>&amp;Attach Text to Path</source>
        <translation type="unfinished">Teks &amp;aan pad toevoegen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1372"/>
        <source>&amp;Detach Text from Path</source>
        <translation type="unfinished">Teks van &amp;pad losmaken</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1373"/>
        <source>&amp;Combine Polygons</source>
        <translation type="unfinished">Polygonen &amp;samenvoegen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1374"/>
        <source>Split &amp;Polygons</source>
        <translation type="unfinished">&amp;Polygonen opsplitsen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1375"/>
        <source>&amp;Bezier Curve</source>
        <translation type="unfinished">&amp;Bezierkurwe</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1376"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;Outlines</source>
        <translation type="obsolete">&amp;Buitelyne</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1378"/>
        <source>&amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1379"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished">&amp;Teksraam</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1383"/>
        <source>&amp;Glyph...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1384"/>
        <source>Sample Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1388"/>
        <source>&amp;Insert...</source>
        <translation type="unfinished">&amp;Invoegen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1389"/>
        <source>Im&amp;port...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1390"/>
        <source>&amp;Delete...</source>
        <translation type="unfinished">Verwy&amp;deren...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1391"/>
        <source>&amp;Copy...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1392"/>
        <source>&amp;Move...</source>
        <translation type="unfinished">&amp;Verplaatsen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1393"/>
        <source>&amp;Apply Master Page...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1395"/>
        <source>Manage &amp;Guides...</source>
        <translation type="unfinished">&amp;Hulplynen beheren...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1396"/>
        <source>Manage Page Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1401"/>
        <source>&amp;50%</source>
        <translation type="unfinished">&amp;50%</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1402"/>
        <source>&amp;75%</source>
        <translation type="unfinished">&amp;75%</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1403"/>
        <source>&amp;100%</source>
        <translation type="unfinished">&amp;100%</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1404"/>
        <source>&amp;200%</source>
        <translation type="unfinished">&amp;200%</translation>
    </message>
    <message>
        <source>&amp;Thumbnails</source>
        <translation type="obsolete">Minia&amp;turen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1407"/>
        <source>Show &amp;Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1409"/>
        <source>Show &amp;Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1411"/>
        <source>Show &amp;Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1412"/>
        <source>Show &amp;Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1413"/>
        <source>Show G&amp;uides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1415"/>
        <source>Show &amp;Baseline Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1416"/>
        <source>Show &amp;Text Chain</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1417"/>
        <source>Show Control Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1420"/>
        <source>Sn&amp;ap to Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1421"/>
        <source>Sna&amp;p to Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1426"/>
        <source>&amp;Properties</source>
        <translation type="unfinished">&amp;Eienskappe</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1428"/>
        <source>&amp;Scrapbook</source>
        <translation type="unfinished">&amp;Kladblok</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1429"/>
        <source>&amp;Layers</source>
        <translation type="unfinished">&amp;Lagen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1430"/>
        <source>&amp;Arrange Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1431"/>
        <source>&amp;Bookmarks</source>
        <translation type="unfinished">&amp;Bladwyzers</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1432"/>
        <source>&amp;Measurements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1433"/>
        <source>Action &amp;History</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1434"/>
        <source>Preflight &amp;Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1435"/>
        <source>&amp;Align and Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1436"/>
        <source>&amp;Tools</source>
        <translation type="unfinished">&amp;Gereedschappen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1437"/>
        <source>P&amp;DF Tools</source>
        <translation type="unfinished">P&amp;DF-gereedschappen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1440"/>
        <source>Select Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;Shape</source>
        <translation type="obsolete">&amp;Vorm</translation>
    </message>
    <message>
        <source>&amp;Line</source>
        <translation type="obsolete">&amp;Lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1441"/>
        <source>Rotate Item</source>
        <translation type="unfinished">Item roteren</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1442"/>
        <source>Zoom in or out</source>
        <translation type="unfinished">In- of uitzoomen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1443"/>
        <source>Zoom in</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1444"/>
        <source>Zoom out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1445"/>
        <source>Edit Contents of Frame</source>
        <translation type="unfinished">Inhoud van raam bewerken</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1446"/>
        <source>Edit Text...</source>
        <translation type="unfinished">Bewerk Teks...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1447"/>
        <source>Link Text Frames</source>
        <translation type="unfinished">Teksrame koppelen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1448"/>
        <source>Unlink Text Frames</source>
        <translation type="unfinished">Teksrame loskoppelen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1449"/>
        <source>&amp;Eye Dropper</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1450"/>
        <source>Copy Item Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Edit the text with the Story Editor</source>
        <translation type="obsolete">Teks met de story-editor bewerken</translation>
    </message>
    <message>
        <source>Insert Text Frame</source>
        <translation type="obsolete">Teksraam invoegen</translation>
    </message>
    <message>
        <source>Insert Freehand Line</source>
        <translation type="obsolete">Vryehand-curve invoegen</translation>
    </message>
    <message>
        <source>&amp;Manage Pictures</source>
        <translation type="obsolete">Prente &amp;beheren</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1473"/>
        <source>&amp;Hyphenate Text</source>
        <translation type="unfinished">Teks a&amp;fbreken</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1474"/>
        <source>Dehyphenate Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1475"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1482"/>
        <source>&amp;About Scribus</source>
        <translation type="unfinished">&amp;Info over Scribus</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1484"/>
        <source>About &amp;Qt</source>
        <translation type="unfinished">Info over &amp;Qt</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1485"/>
        <source>Toolti&amp;ps</source>
        <translation type="unfinished">Hul&amp;pballonnen</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1487"/>
        <source>Scribus &amp;Manual...</source>
        <translation type="unfinished">Scribus &amp;handboek...</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1505"/>
        <source>Smart &amp;Hyphen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1506"/>
        <source>Non Breaking Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1507"/>
        <source>Non Breaking &amp;Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1508"/>
        <source>Page &amp;Number</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1510"/>
        <source>New Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1511"/>
        <source>Frame Break</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1512"/>
        <source>Column Break</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1515"/>
        <source>Copyright</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1516"/>
        <source>Registered Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1517"/>
        <source>Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1519"/>
        <source>Bullet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1521"/>
        <source>Em Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1522"/>
        <source>En Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1523"/>
        <source>Figure Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1524"/>
        <source>Quotation Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1495"/>
        <source>Toggle Palettes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1496"/>
        <source>Toggle Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1276"/>
        <source>Print Previe&amp;w</source>
        <translation type="unfinished">Druk&amp;voorbeeld</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1300"/>
        <source>&amp;JavaScripts...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1394"/>
        <source>Convert to Master Page...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1478"/>
        <source>&amp;Cascade</source>
        <translation type="unfinished">&amp;Trapsgewys</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1479"/>
        <source>&amp;Tile</source>
        <translation type="unfinished">&amp;Tegels</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1357"/>
        <source>More Info...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1347"/>
        <source>&amp;Printing Enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1348"/>
        <source>&amp;Flip Horizontally</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1349"/>
        <source>&amp;Flip Vertically</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1418"/>
        <source>Show Rulers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1427"/>
        <source>&amp;Outline</source>
        <comment>Document Outline Palette</comment>
        <translation type="unfinished">&amp;Outline</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1518"/>
        <source>Solidus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1520"/>
        <source>Middle Dot</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1545"/>
        <source>En Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1546"/>
        <source>Em Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1547"/>
        <source>Thin Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1548"/>
        <source>Thick Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1549"/>
        <source>Mid Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1550"/>
        <source>Hair Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Insert Page Number</source>
        <translation type="obsolete">Voeg bladsynommer in</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1562"/>
        <source>ff</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1563"/>
        <source>fi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1564"/>
        <source>fl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1565"/>
        <source>ffi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1566"/>
        <source>ffl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1567"/>
        <source>ft</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1568"/>
        <source>st</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1298"/>
        <source>S&amp;tyles...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1333"/>
        <source>&amp;Outline</source>
        <comment>type effect</comment>
        <translation type="unfinished">&amp;Outline</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1377"/>
        <source>&amp;Outlines</source>
        <comment>Convert to oulines</comment>
        <translation type="unfinished">&amp;Buitelyne</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1287"/>
        <source>Paste (&amp;Absolute)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1288"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1462"/>
        <source>Insert PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1463"/>
        <source>Insert PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1464"/>
        <source>Insert PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1465"/>
        <source>Insert PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1466"/>
        <source>Insert PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1467"/>
        <source>Insert Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1468"/>
        <source>Insert Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1271"/>
        <source>Save as &amp;EPS...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1414"/>
        <source>Show Text Frame Columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1382"/>
        <source>&amp;Frame...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1406"/>
        <source>Preview Mode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1410"/>
        <source>Show Layer Indicators</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1297"/>
        <source>Patterns...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1355"/>
        <source>Send to Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1385"/>
        <source>Sticky Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1399"/>
        <source>&amp;Fit to Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1400"/>
        <source>Fit to Width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1408"/>
        <source>Show Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1513"/>
        <source>&amp;Zero Width Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1514"/>
        <source>Zero Width NB Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1526"/>
        <source>Apostrophe</source>
        <comment>Unicode 0x0027</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1527"/>
        <source>Straight Double</source>
        <comment>Unicode 0x0022</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1528"/>
        <source>Single Left</source>
        <comment>Unicode 0x2018</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1529"/>
        <source>Single Right</source>
        <comment>Unicode 0x2019</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1530"/>
        <source>Double Left</source>
        <comment>Unicode 0x201C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1531"/>
        <source>Double Right</source>
        <comment>Unicode 0x201D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1532"/>
        <source>Single Reversed</source>
        <comment>Unicode 0x201B</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1533"/>
        <source>Double Reversed</source>
        <comment>Unicode 0x201F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1534"/>
        <source>Single Left Guillemet</source>
        <comment>Unicode 0x2039</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1535"/>
        <source>Single Right Guillemet</source>
        <comment>Unicode 0x203A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1536"/>
        <source>Double Left Guillemet</source>
        <comment>Unicode 0x00AB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1537"/>
        <source>Double Right Guillemet</source>
        <comment>Unicode 0x00BB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1538"/>
        <source>Low Single Comma</source>
        <comment>Unicode 0x201A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1539"/>
        <source>Low Double Comma</source>
        <comment>Unicode 0x201E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1540"/>
        <source>CJK Single Left</source>
        <comment>Unicode 0x300C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1541"/>
        <source>CJK Single Right</source>
        <comment>Unicode 0x300D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1542"/>
        <source>CJK Double Left</source>
        <comment>Unicode 0x300E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1543"/>
        <source>CJK Double Right</source>
        <comment>Unicode 0x300F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1405"/>
        <source>&amp;400%</source>
        <translation type="unfinished">&amp;200% {400%?}</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1452"/>
        <source>Insert &amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1453"/>
        <source>Insert &amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1455"/>
        <source>Insert T&amp;able</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1456"/>
        <source>Insert &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1457"/>
        <source>Insert &amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1458"/>
        <source>Insert &amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1459"/>
        <source>Insert &amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1460"/>
        <source>Insert &amp;Freehand Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1488"/>
        <source>Scribus Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1489"/>
        <source>Scribus Online Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1490"/>
        <source>Scribus Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1491"/>
        <source>Getting Started with Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1422"/>
        <source>Show Context Menu</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1472"/>
        <source>&amp;Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1483"/>
        <source>&amp;About Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1497"/>
        <source>Insert Unicode Character Begin Sequence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1268"/>
        <source>Get Vector File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1290"/>
        <source>Advanced Select All...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1294"/>
        <source>Edit Source...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1296"/>
        <source>Replace Colors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1419"/>
        <source>Rulers Relative to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1454"/>
        <source>Insert &amp;Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1492"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1509"/>
        <source>Number of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1361"/>
        <source>Adjust Image to Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1690"/>
        <source>File</source>
        <translation type="unfinished">Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1690"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1692"/>
        <source>Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1692"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1694"/>
        <source>Style</source>
        <translation type="unfinished">Styl</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1694"/>
        <source>&amp;Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1696"/>
        <source>Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1696"/>
        <source>&amp;Item</source>
        <translation type="unfinished">&amp;Item</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1698"/>
        <source>Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1698"/>
        <source>I&amp;nsert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1700"/>
        <source>Page</source>
        <translation type="unfinished">Bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1700"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1702"/>
        <source>View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1702"/>
        <source>&amp;View</source>
        <translation type="unfinished">Beel&amp;d</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1704"/>
        <source>Extras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1704"/>
        <source>E&amp;xtras</source>
        <translation type="unfinished">E&amp;xtra</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1706"/>
        <source>Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1706"/>
        <source>&amp;Windows</source>
        <translation type="unfinished">&amp;Venster</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1708"/>
        <source>Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1708"/>
        <source>&amp;Help</source>
        <translation type="unfinished">&amp;Help</translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1876"/>
        <source>Plugin Menu Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1878"/>
        <source>Others</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1880"/>
        <source>Unicode Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1486"/>
        <source>Move/Resize Value Indicator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/actionmanager.cpp" line="1258"/>
        <source>New &amp;from Template...</source>
        <translation type="unfinished">Nuut van &amp;templaat...</translation>
    </message>
</context>
<context>
    <name>AdjustCmsDialog</name>
    <message>
        <location filename="../../../scribus/adjustcmsdialog.cpp" line="16"/>
        <source>CMS Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AdvOptions</name>
    <message>
        <source>Advanced Options</source>
        <translation type="obsolete">Gevorderde opsies</translation>
    </message>
    <message>
        <source>Mirror Page(s) &amp;Horizontal</source>
        <translation type="obsolete">Bladsy(e) &amp;horisontaal spielbeeld</translation>
    </message>
    <message>
        <source>Mirror Page(s) &amp;Vertical</source>
        <translation type="obsolete">Bladsy(e) &amp;verticaal spielbeeld</translation>
    </message>
    <message>
        <source>Apply Under Color &amp;Removal</source>
        <translation type="obsolete">Onde&amp;rliggende kleurverwydering</translation>
    </message>
    <message>
        <source>Apply &amp;ICC Profiles</source>
        <translation type="obsolete">&amp;ICC-profiel toepassing</translation>
    </message>
    <message>
        <source>PostScript Level &amp;1</source>
        <translation type="obsolete">PostScript Vlak &amp;1</translation>
    </message>
    <message>
        <source>PostScript Level &amp;2</source>
        <translation type="obsolete">PostScript vlak &amp;2</translation>
    </message>
    <message>
        <source>PostScript Level &amp;3</source>
        <translation type="obsolete">PostScript vlak &amp;3</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Creates PostScript Level 3</source>
        <translation type="obsolete">Maak PostScript vlak 3</translation>
    </message>
    <message>
        <source>Creates PostScript Level 2 only, beware,
this can create huge files</source>
        <translation type="obsolete">Maak PostScript vlak 2, dit kan baie 
groot lêers tot gevolg hê.</translation>
    </message>
    <message>
        <source>Creates PostScript Level 1 only, beware,
this can create huge files</source>
        <translation type="obsolete">Maak PostScript vlak 1, dit kan baie 
groot lêers tot gevolg hê.</translation>
    </message>
    <message>
        <source>A way of switching off some of the gray shades which are composed
of cyan, yellow and magenta and using black instead.
UCR most affects parts of images which are neutral and/or dark tones
which are close to the gray. Use of this may improve printing some images
and some experimentation and testing is need on a case by case basis.
UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">n&apos; Methode om grys skadu&apos;s saamgestel uit cyan, geel en magenta
te vervang met swart gebaseerde grys.
UCR (Under Color Removal) het meeste invloed op beeld dele waar neutrale en/of donker tone naby aan grys is. Die gebruik hiervan kan sekere beelde beter laat druk, maar eksperimenteer daarmee. UCR verminder die kans vir CMY ink oorbodigheid.</translation>
    </message>
</context>
<context>
    <name>Align</name>
    <message>
        <source>Distribute/Align</source>
        <translation type="obsolete">Verdeel/Skouer</translation>
    </message>
    <message>
        <source>Align</source>
        <translation type="obsolete">Skouer</translation>
    </message>
    <message>
        <source>Horizontal</source>
        <translation type="obsolete">Horisontaal</translation>
    </message>
    <message>
        <source>Left Sides</source>
        <translation type="obsolete">Links</translation>
    </message>
    <message>
        <source>Middles</source>
        <translation type="obsolete">Middel</translation>
    </message>
    <message>
        <source>Right Sides</source>
        <translation type="obsolete">Regs</translation>
    </message>
    <message>
        <source>&amp;Between:</source>
        <translation type="obsolete">&amp;Tussen:</translation>
    </message>
    <message>
        <source>&amp;Do Not Change</source>
        <translation type="obsolete">Moenie veran&amp;der nie</translation>
    </message>
    <message>
        <source>A&amp;lign</source>
        <translation type="obsolete">&amp;Skouer</translation>
    </message>
    <message>
        <source>Di&amp;splacement</source>
        <translation type="obsolete">Verpla&amp;sing</translation>
    </message>
    <message>
        <source>Distribute &amp;Evenly</source>
        <translation type="obsolete">Verdeel g&amp;elyk</translation>
    </message>
    <message>
        <source>Vertical</source>
        <translation type="obsolete">Vertikaal</translation>
    </message>
    <message>
        <source>Top Sides</source>
        <translation type="obsolete">Bokant</translation>
    </message>
    <message>
        <source>Bottom Sides</source>
        <translation type="obsolete">Onderkant</translation>
    </message>
    <message>
        <source>Bet&amp;ween:</source>
        <translation type="obsolete">T&amp;ussen:</translation>
    </message>
    <message>
        <source>Do &amp;Not Change</source>
        <translation type="obsolete">Moe&amp;nie verander nie</translation>
    </message>
    <message>
        <source>Al&amp;ign</source>
        <translation type="obsolete">&amp;Skouer</translation>
    </message>
    <message>
        <source>Dis&amp;placement</source>
        <translation type="obsolete">Ver&amp;plasing</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source>Distribute E&amp;venly</source>
        <translation type="obsolete">&amp;Verdeel gelyk</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Apply</source>
        <translation type="obsolete">Toe&amp;pas</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
</context>
<context>
    <name>AlignDistribute</name>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="35"/>
        <source>Align</source>
        <translation type="unfinished">Skouer</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="79"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="92"/>
        <source>&amp;Relative To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="163"/>
        <location filename="../../../scribus/aligndistribute.ui" line="170"/>
        <location filename="../../../scribus/aligndistribute.ui" line="177"/>
        <location filename="../../../scribus/aligndistribute.ui" line="184"/>
        <location filename="../../../scribus/aligndistribute.ui" line="191"/>
        <location filename="../../../scribus/aligndistribute.ui" line="198"/>
        <location filename="../../../scribus/aligndistribute.ui" line="205"/>
        <location filename="../../../scribus/aligndistribute.ui" line="212"/>
        <location filename="../../../scribus/aligndistribute.ui" line="219"/>
        <location filename="../../../scribus/aligndistribute.ui" line="226"/>
        <location filename="../../../scribus/aligndistribute.ui" line="314"/>
        <location filename="../../../scribus/aligndistribute.ui" line="321"/>
        <location filename="../../../scribus/aligndistribute.ui" line="328"/>
        <location filename="../../../scribus/aligndistribute.ui" line="335"/>
        <location filename="../../../scribus/aligndistribute.ui" line="342"/>
        <location filename="../../../scribus/aligndistribute.ui" line="352"/>
        <location filename="../../../scribus/aligndistribute.ui" line="359"/>
        <location filename="../../../scribus/aligndistribute.ui" line="369"/>
        <location filename="../../../scribus/aligndistribute.ui" line="376"/>
        <location filename="../../../scribus/aligndistribute.ui" line="386"/>
        <location filename="../../../scribus/aligndistribute.ui" line="393"/>
        <location filename="../../../scribus/aligndistribute.ui" line="400"/>
        <location filename="../../../scribus/aligndistribute.ui" line="410"/>
        <location filename="../../../scribus/aligndistribute.ui" line="417"/>
        <location filename="../../../scribus/aligndistribute.ui" line="424"/>
        <location filename="../../../scribus/aligndistribute.ui" line="431"/>
        <source>...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="270"/>
        <source>Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.ui" line="490"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistributeBase</name>
    <message>
        <source>Align</source>
        <translation type="obsolete">Skouer</translation>
    </message>
</context>
<context>
    <name>AlignDistributePalette</name>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="90"/>
        <source>Align and Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="91"/>
        <source>Align</source>
        <translation type="unfinished">Skouer</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="93"/>
        <source>&amp;Relative to:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="96"/>
        <source>First Selected</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="97"/>
        <source>Last Selected</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="98"/>
        <source>Page</source>
        <translation type="unfinished">Bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="99"/>
        <source>Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="100"/>
        <source>Guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="101"/>
        <source>Selection</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="111"/>
        <source>Align bottoms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="113"/>
        <source>Align right sides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="117"/>
        <source>Center on vertical axis</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="119"/>
        <source>Align left sides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="121"/>
        <source>Center on horizontal axis</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="125"/>
        <source>Align tops</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="127"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="135"/>
        <source>Distribute right sides equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="137"/>
        <source>Distribute bottoms equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="139"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="145"/>
        <source>Distribute left sides equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="147"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="149"/>
        <source>Distribute tops equidistantly</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="159"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="160"/>
        <source>Distribute the items with the distance specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="162"/>
        <source>None Selected</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="440"/>
        <source>Y: %1%2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="448"/>
        <source>X: %1%2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="107"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="109"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="115"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="123"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="130"/>
        <source>Make horizontal gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="132"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="141"/>
        <source>Make vertical gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="143"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="151"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="157"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="155"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="153"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="92"/>
        <source>Distribute</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="103"/>
        <source>&lt;qt&gt;Align relative to the:&lt;ul&gt;&lt;li&gt;First selected item&lt;/li&gt;&lt;li&gt;Second Selected Item&lt;/li&gt;&lt;li&gt;The current page&lt;/li&gt;&lt;li&gt;The margins of the current page&lt;/li&gt;&lt;li&gt;A Guide&lt;/li&gt;&lt;li&gt;The selection&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/aligndistribute.cpp" line="105"/>
        <source>The location of the selected guide to align to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignSelect</name>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="110"/>
        <source>Align Text Left</source>
        <translation>Teks links skouer</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="111"/>
        <source>Align Text Right</source>
        <translation>Teks regs skouer</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="112"/>
        <source>Align Text Center</source>
        <translation>Teks sentreer</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="113"/>
        <source>Align Text Justified</source>
        <translation>Teks dubbelskouer</translation>
    </message>
    <message>
        <location filename="../../../scribus/alignselect.cpp" line="114"/>
        <source>Align Text Forced Justified</source>
        <translation>Teks geforseerd dubbelskouer</translation>
    </message>
</context>
<context>
    <name>Annot</name>
    <message>
        <location filename="../../../scribus/annot.cpp" line="61"/>
        <source>Field Properties</source>
        <translation>Veldeienskappe</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="92"/>
        <location filename="../../../scribus/annot.cpp" line="533"/>
        <source>Type:</source>
        <translation>Tipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Button</source>
        <translation>Knop</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Text Field</source>
        <translation>Teksveld</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Check Box</source>
        <translation>Keusevakkie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>Combo Box</source>
        <translation>Komboboks</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="96"/>
        <source>List Box</source>
        <translation>Lys</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="111"/>
        <source>Properties</source>
        <translation>Eienskappe</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="121"/>
        <source>Name:</source>
        <translation>Naam:</translation>
    </message>
    <message>
        <source>Tool-Tip:</source>
        <translation type="obsolete">Hulpballon:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="146"/>
        <location filename="../../../scribus/annot.cpp" line="274"/>
        <source>Text</source>
        <translation>Teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="152"/>
        <source>Font for use with PDF 1.3:</source>
        <translation>Lettertipe vir PDF 1.3:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="176"/>
        <source>Border</source>
        <translation>Rand</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="182"/>
        <source>Color:</source>
        <translation>Kleur:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="2110"/>
        <source>None</source>
        <translation>Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="197"/>
        <source>Width:</source>
        <translation>Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="201"/>
        <source>Thin</source>
        <translation>Smal</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="201"/>
        <location filename="../../../scribus/annot.cpp" line="311"/>
        <source>Normal</source>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="201"/>
        <source>Wide</source>
        <translation>Breed</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="209"/>
        <source>Style:</source>
        <translation>Styl:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="213"/>
        <source>Solid</source>
        <translation>Solied</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="213"/>
        <source>Dashed</source>
        <translation>Gestreep</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="213"/>
        <source>Underline</source>
        <translation>Onderstreep</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="214"/>
        <source>Beveled</source>
        <translation>Afgeskuins</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="214"/>
        <source>Inset</source>
        <translation>Inlêend</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="224"/>
        <source>Other</source>
        <translation>Ander</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="230"/>
        <source>Read Only</source>
        <translation>Lees-alleen</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="236"/>
        <source>Required</source>
        <translation>Vereis</translation>
    </message>
    <message>
        <source>Don&apos;t Export Value</source>
        <translation type="obsolete">Waarde nie uitvoer nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="248"/>
        <source>Visibility:</source>
        <translation>Sigbaarheid:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="252"/>
        <source>Visible</source>
        <translation>Sigbaar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="252"/>
        <source>Hidden</source>
        <translation>Onsigbaar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="252"/>
        <source>No Print</source>
        <translation>Nie druk</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="253"/>
        <source>No View</source>
        <translation>Nie weergee nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="262"/>
        <source>Appearance</source>
        <translation>Voorkoms</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="280"/>
        <source>Text for Button Down</source>
        <translation>Teks vir gedrukte knop</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="283"/>
        <source>Text for Roll Over</source>
        <translation>Teks vir muis-oor</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="294"/>
        <source>Icons</source>
        <translation>Ikone</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="300"/>
        <source>Use Icons</source>
        <translation>Gebruik Ikone</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="321"/>
        <location filename="../../../scribus/annot.cpp" line="339"/>
        <location filename="../../../scribus/annot.cpp" line="357"/>
        <source>Remove</source>
        <translation>Verwyder</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="329"/>
        <source>Pressed</source>
        <translation>Ingedruk</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="347"/>
        <source>Roll Over</source>
        <translation>Muis-oor</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="366"/>
        <source>Icon Placement...</source>
        <translation>Plaatsing van ikoon...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="414"/>
        <source>Highlight</source>
        <translation>Beklemtoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>Invert</source>
        <translation>Keerom</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>Outlined</source>
        <translation>Buitelyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>Push</source>
        <translation>Druk</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="438"/>
        <source>Multi-Line</source>
        <translation>Meerlynig</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="442"/>
        <source>Password</source>
        <translation>Wagwoord</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="449"/>
        <source>Limit of</source>
        <translation>Limiet van</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="460"/>
        <source>Characters</source>
        <translation>Karakters</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="466"/>
        <source>Do Not Scroll</source>
        <translation>Moenie skuif nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="470"/>
        <source>Do Not Spell Check</source>
        <translation>Geen spellingkontrole</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="485"/>
        <source>Check Style:</source>
        <translation>Kontroleer styl:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Check</source>
        <translation>Kontroleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Cross</source>
        <translation>Kruis</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Diamond</source>
        <translation>Diamant</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Circle</source>
        <translation>Sirkel</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Star</source>
        <translation>Ster</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="488"/>
        <source>Square</source>
        <translation>Vierkant</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="502"/>
        <source>Default is Checked</source>
        <translation>Verstek is gekeis</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="514"/>
        <source>Editable</source>
        <translation>Bewerkbaar</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="521"/>
        <source>Options</source>
        <translation>Opsies</translation>
    </message>
    <message>
        <source>Java Script</source>
        <translation type="obsolete">Javascript</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="537"/>
        <location filename="../../../scribus/annot.cpp" line="2073"/>
        <source>Go To</source>
        <translation>Gaan na</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="538"/>
        <location filename="../../../scribus/annot.cpp" line="2074"/>
        <source>Submit Form</source>
        <translation>Stuur vorm</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="538"/>
        <location filename="../../../scribus/annot.cpp" line="2074"/>
        <source>Reset Form</source>
        <translation>Maak vorm skoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="538"/>
        <location filename="../../../scribus/annot.cpp" line="2074"/>
        <source>Import Data</source>
        <translation>Voer data in</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="570"/>
        <source>Event:</source>
        <translation>Gebeurtenis:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="573"/>
        <location filename="../../../scribus/annot.cpp" line="2053"/>
        <source>Mouse Up</source>
        <translation>Muisknop hoog</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="573"/>
        <location filename="../../../scribus/annot.cpp" line="2053"/>
        <source>Mouse Down</source>
        <translation>Muisknop laag</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="573"/>
        <location filename="../../../scribus/annot.cpp" line="2053"/>
        <source>Mouse Enter</source>
        <translation>Muis kom oor</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="574"/>
        <location filename="../../../scribus/annot.cpp" line="2054"/>
        <source>Mouse Exit</source>
        <translation>Muis gaan weg</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="574"/>
        <location filename="../../../scribus/annot.cpp" line="2054"/>
        <source>On Focus</source>
        <translation>Met fokus</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="574"/>
        <location filename="../../../scribus/annot.cpp" line="2054"/>
        <source>On Blur</source>
        <translation>Met verlaat van fokus</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="585"/>
        <source>Script:</source>
        <translation>Script:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="604"/>
        <location filename="../../../scribus/annot.cpp" line="933"/>
        <location filename="../../../scribus/annot.cpp" line="959"/>
        <location filename="../../../scribus/annot.cpp" line="1036"/>
        <location filename="../../../scribus/annot.cpp" line="1111"/>
        <source>Edit...</source>
        <translation>Bewerk...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="670"/>
        <source>Submit to URL:</source>
        <translation>Stuur na URL:</translation>
    </message>
    <message>
        <source>Submit Data as HTML</source>
        <translation type="obsolete">Stuur data as HTML</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="707"/>
        <source>Import Data from:</source>
        <translation>Voer data in vanaf:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="610"/>
        <source>Destination</source>
        <translation>Bestemming</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="616"/>
        <source>To File:</source>
        <translation>Na lêer:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="623"/>
        <source>Change...</source>
        <translation>Wysig...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="632"/>
        <source>Page:</source>
        <translation>Bladsy:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="646"/>
        <source>X-Pos:</source>
        <translation>X-posisie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="649"/>
        <location filename="../../../scribus/annot.cpp" line="658"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="654"/>
        <source>Y-Pos:</source>
        <translation>Y-posisie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="716"/>
        <source>Action</source>
        <translation>Aksie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="747"/>
        <source>Field is formatted as:</source>
        <translation>Veld is geformatteer as:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Plain</source>
        <translation>Eenvoudig</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Number</source>
        <translation>Nommer</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Percentage</source>
        <translation>Persentasie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Date</source>
        <translation>Datum</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Time</source>
        <translation>Tyd</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="750"/>
        <source>Custom</source>
        <translation>Aangepas</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="768"/>
        <source>Number Format</source>
        <translation>Nommerformaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="777"/>
        <location filename="../../../scribus/annot.cpp" line="836"/>
        <source>Decimals:</source>
        <translation>Desimale:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="791"/>
        <source>Use Currency Symbol</source>
        <translation>Gebruik geldeenheid-simbool</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="800"/>
        <source>Prepend Currency Symbol</source>
        <translation>plaas geldeenheid simbool vooraan</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="804"/>
        <location filename="../../../scribus/annot.cpp" line="847"/>
        <source>Formatting</source>
        <translation>Formattering</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="827"/>
        <source>Percent Format</source>
        <translation>Persentasieformaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="870"/>
        <source>Date Format</source>
        <translation>Datumformaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="896"/>
        <source>Time Format</source>
        <translation>Tydformaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="918"/>
        <source>Custom Scripts</source>
        <translation>Eie scripts</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="930"/>
        <source>Format:</source>
        <translation>Formaat:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="956"/>
        <source>Keystroke:</source>
        <translation>Sleuteldruk:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="980"/>
        <source>Format</source>
        <translation>Formaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="996"/>
        <source>Value is not validated</source>
        <translation>Waarde is nie gevalideer nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1005"/>
        <source>Value must be greater than or equal to:</source>
        <translation>Waarde moet groter of gelyk aan wees:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1009"/>
        <source>and less or equal to:</source>
        <translation>en kleiner of gelyk aan:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1020"/>
        <source>Custom validate script:</source>
        <translation>Eie validasiescript:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1041"/>
        <source>Validate</source>
        <translation>Valideer</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1058"/>
        <source>Value is not calculated</source>
        <translation>Waarde is niee berekend nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1067"/>
        <source>Value is the</source>
        <translation>Waarde is</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>sum</source>
        <translation>die som</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>product</source>
        <translation>produk</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>average</source>
        <translation>gemiddeld</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1072"/>
        <source>minimum</source>
        <translation>minimum</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1073"/>
        <source>maximum</source>
        <translation>maksimum</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1080"/>
        <source>of the following fields:</source>
        <translation>van die volgende velde:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1090"/>
        <source>Pick...</source>
        <translation>Kies...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1095"/>
        <source>Custom calculation script:</source>
        <translation>Eie berekeningscript:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1115"/>
        <source>Calculate</source>
        <translation>Bereken</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1134"/>
        <source>OK</source>
        <translation>Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1138"/>
        <source>Cancel</source>
        <translation>Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1189"/>
        <location filename="../../../scribus/annot.cpp" line="1190"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation>Hierdie vlag word genegeer in PDF 1.3</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1191"/>
        <source>Enter a comma separated list of fields here</source>
        <translation>Voer &apos;n komma geskeide lys van velde hier in</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1192"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation>U het tenminste &apos;n ikoon vir Normaal nodig om ikone vir knoppe te kan gebruik</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1302"/>
        <location filename="../../../scribus/annot.cpp" line="1333"/>
        <location filename="../../../scribus/annot.cpp" line="1357"/>
        <location filename="../../../scribus/annot.cpp" line="2268"/>
        <source>Open</source>
        <translation>Maak oop</translation>
    </message>
    <message>
        <source>Images (*.tif *.png *.jpg *.xpm);;Postscript (*.eps);;All Files (*)</source>
        <translation type="obsolete">Beelde (*.tif *.png *.jpg *.xpm);;Postscript (*.eps);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1475"/>
        <source>Example:</source>
        <translation>Voorbeeld:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="2102"/>
        <source>Selection Change</source>
        <translation>Keuse verandering</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="2268"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>PDF-lêers (*.pdf);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="537"/>
        <location filename="../../../scribus/annot.cpp" line="2073"/>
        <location filename="../../../scribus/annot.cpp" line="2111"/>
        <source>JavaScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="421"/>
        <source>None</source>
        <comment>highlight</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="537"/>
        <location filename="../../../scribus/annot.cpp" line="2073"/>
        <source>None</source>
        <comment>action</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="134"/>
        <source>Tooltip:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="242"/>
        <source>Do Not Export Value</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1334"/>
        <location filename="../../../scribus/annot.cpp" line="1358"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="1303"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="625"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="682"/>
        <source>Submit format:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>FDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>HTML</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>XFDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annot.cpp" line="685"/>
        <source>PDF</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Annota</name>
    <message>
        <location filename="../../../scribus/annota.cpp" line="47"/>
        <source>Annotation Properties</source>
        <translation>Annotasie-eienskappe</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="77"/>
        <source>Text</source>
        <translation>Teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="78"/>
        <source>Link</source>
        <translation>Skakel</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="79"/>
        <source>External Link</source>
        <translation>Eksterne skakel</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="80"/>
        <source>External Web-Link</source>
        <translation>Eksterne webskakel</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="118"/>
        <source>Destination</source>
        <translation>Bestemming</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="168"/>
        <location filename="../../../scribus/annota.cpp" line="177"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="409"/>
        <source>Open</source>
        <translation>Maak oop</translation>
    </message>
    <message>
        <source>PDF-Documents (*.pdf);;All Files (*)</source>
        <translation type="obsolete">PDF-lêers (*.pdf);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="82"/>
        <source>&amp;Type:</source>
        <translation>&amp;Tipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="129"/>
        <source>C&amp;hange...</source>
        <translation>V&amp;erander...</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="147"/>
        <source>&amp;Page:</source>
        <translation>&amp;Bladsy:</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="171"/>
        <source>&amp;X-Pos</source>
        <translation>&amp;X-Pos</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="179"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-pos:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="409"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/annota.cpp" line="131"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyMasterPageDialog</name>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="267"/>
        <source>Apply Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="268"/>
        <source>&amp;Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="271"/>
        <source>Alt+P</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="273"/>
        <source>Alt+E</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="275"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;All pages</source>
        <translation type="obsolete">Alle &amp;bladsy(e)</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="277"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="279"/>
        <source>Alt+W</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="281"/>
        <source>to</source>
        <translation type="unfinished">aan</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="283"/>
        <source>Alt+O</source>
        <translation type="unfinished">Atl+O</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="285"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="280"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="52"/>
        <source>Possible Hyphenation</source>
        <translation type="unfinished">Moontlike afkapping</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All Pages</source>
        <translation type="unfinished">&amp;Alle bladsye</translation>
    </message>
    <message>
        <location filename="../../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within Range</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyT</name>
    <message>
        <source>Apply Template</source>
        <translation type="obsolete">Pas templaat toe</translation>
    </message>
    <message>
        <source>&amp;Template:</source>
        <translation type="obsolete">&amp;Templaat:</translation>
    </message>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <source>Apply to &amp;Current Page</source>
        <translation type="obsolete">Pas op &amp;huidige bladsy toe</translation>
    </message>
    <message>
        <source>Apply to all &amp;even Pages</source>
        <translation type="obsolete">Pas op &amp;ewe bladsye toe</translation>
    </message>
    <message>
        <source>Apply to all &amp;odd Pages</source>
        <translation type="obsolete">Pas op &amp;onewe bladsye toe</translation>
    </message>
    <message>
        <source>Apply from &amp;Page:</source>
        <translation type="obsolete">Pas toe vanaf &amp;bladsy:</translation>
    </message>
    <message>
        <source>To:</source>
        <translation type="obsolete">Tot:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
</context>
<context>
    <name>ArrowChooser</name>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
</context>
<context>
    <name>AspellPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="64"/>
        <source>Spell-checking support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="66"/>
        <source>Adds support for spell-checking via aspell. Languages can be chosen from among the installed aspell dictionaries, and spell-checking can be done on the fly, or on selected text.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="70"/>
        <source>0.1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="32"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="95"/>
        <source>Aspell Plugin Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPluginBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="13"/>
        <source>Spell Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="118"/>
        <source>Replacement:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="278"/>
        <source>&amp;Add Word</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="306"/>
        <source>&amp;Change</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="45"/>
        <source>Not in Dictionary:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="70"/>
        <source>Word that was not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="125"/>
        <source>Replacement text for the current word that was not found in the dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="181"/>
        <source>Active Dictionary: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="194"/>
        <source>The currently active dictionary. Scribus uses aspell for dictionary support.&lt;br /&gt;If you require updated or more dictionaries, you should install them via your system&apos;s installation system or package manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="225"/>
        <source>Ignore the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="228"/>
        <source>&amp;Ignore</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="247"/>
        <source>Ignore all occurrences of the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="250"/>
        <source>I&amp;gnore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="275"/>
        <source>Add the current word to the your personal spelling dictionary for future use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="303"/>
        <source>Change the current word that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="331"/>
        <source>Change all occurrences of the current word in the text that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="334"/>
        <source>Change A&amp;ll</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="372"/>
        <source>Close</source>
        <translation type="unfinished">Maak toe</translation>
    </message>
</context>
<context>
    <name>AspellPluginImpl</name>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="37"/>
        <source>Loaded </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="37"/>
        <source>default </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="37"/>
        <source> aspell dictionary.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="82"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in aspell speller configuration.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="89"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in creating aspell speller.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="358"/>
        <source>AspellPluginImpl::on_fskipAllBtn_clicked(): Unable to skip all instances of &quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="360"/>
        <source> by adding it to the session list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="381"/>
        <source>AspellPluginImpl::on_faddWordBtn_clicked(): Unable to add word to personal list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="235"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="236"/>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="427"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="62"/>
        <source>No available Aspell dictionaries found. Install some, please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="428"/>
        <source>Do you want start from the beginning of the selection with new language selected?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AutoformButtonGroup</name>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="36"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1280"/>
        <source>Arrows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="44"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1281"/>
        <source>Flow Chart</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="53"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1282"/>
        <source>Jigsaw</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="66"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1283"/>
        <source>Specials</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="21"/>
        <location filename="../../../scribus/autoformbuttongroup.cpp" line="1279"/>
        <source>Default Shapes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Barcode</name>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure PostScript Barcode Writer</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGenerator</name>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="315"/>
        <source>Error opening file: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="41"/>
        <source>12 or 13 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="43"/>
        <source>8 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="45"/>
        <source>11 or 12 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="47"/>
        <source>7 or 8 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="49"/>
        <source>5 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="51"/>
        <source>2 digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="58"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="63"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="67"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="70"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="78"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="74"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="82"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="85"/>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="93"/>
        <source>Variable number of digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="89"/>
        <source>Variable number of digits and capital letters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="98"/>
        <source>Variable number of hexadecimal characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="349"/>
        <source>Barcode incomplete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="54"/>
        <source>12 or 13 digits with dashes. The legacy ISBN-10 format accepts 9 or 10 digits with dashes, but this standard was depreciated for public use after 1st January 2007. (Note: To convert an old ISBN-10 to a new ISBN-13, prefix 978- to the first 9 digits, e.g. 1-56592-479-7 -&gt; 978-1-56592-479. The final check-digit will be calculated automatically.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="105"/>
        <source>Select Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="145"/>
        <source>Select Barcode Type</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGeneratorBase</name>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="140"/>
        <source>&amp;Type:</source>
        <translation type="unfinished">&amp;Tipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="133"/>
        <source>Select one of the available barcode type here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="113"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="103"/>
        <source>Reset the barcode samples</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="81"/>
        <source>Alt+I</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="75"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="68"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="62"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="156"/>
        <source>Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="184"/>
        <source>&amp;Background</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="187"/>
        <source>Alt+B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="181"/>
        <source>Background color - under the code lines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="216"/>
        <source>&amp;Lines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="219"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="213"/>
        <source>Color of the lines in barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="248"/>
        <source>&amp;Text</source>
        <translation type="unfinished">&amp;Teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="251"/>
        <source>Alt+T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="245"/>
        <source>Color of the text and numbers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="280"/>
        <source>Hints and help is shown here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="290"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="120"/>
        <source>Co&amp;de:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="55"/>
        <source>Alt+N</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="49"/>
        <source>Generate and include a checksum in barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="42"/>
        <source>Alt+U</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="36"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Insert Barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="24"/>
        <source>Format</source>
        <translation type="unfinished">Formaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="39"/>
        <source>Incl&amp;ude Checksum Digit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="52"/>
        <source>I&amp;nclude Checksum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="65"/>
        <source>&amp;Guard Whitespace</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="78"/>
        <source>&amp;Include Text in Barcode</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Biblio</name>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1444"/>
        <source>Scrapbook</source>
        <translation>Kladblok</translation>
    </message>
    <message>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Nuut</translation>
    </message>
    <message>
        <source>&amp;Load...</source>
        <translation type="obsolete">&amp;Laai...</translation>
    </message>
    <message>
        <source>&amp;Save</source>
        <translation type="obsolete">&amp;Stoor</translation>
    </message>
    <message>
        <source>Save &amp;As...</source>
        <translation type="obsolete">Stoor &amp;as...</translation>
    </message>
    <message>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Sluit</translation>
    </message>
    <message>
        <source>&amp;Small</source>
        <translation type="obsolete">&amp;Klein</translation>
    </message>
    <message>
        <source>&amp;Medium</source>
        <translation type="obsolete">&amp;Middel</translation>
    </message>
    <message>
        <source>&amp;Large</source>
        <translation type="obsolete">&amp;Groot</translation>
    </message>
    <message>
        <source>&amp;File</source>
        <translation type="obsolete">&amp;Lêer</translation>
    </message>
    <message>
        <source>&amp;Preview</source>
        <translation type="obsolete">&amp;Voorbeeld</translation>
    </message>
    <message>
        <source>Scrapbooks (*.scs);;All Files (*)</source>
        <translation type="obsolete">Kladbloklêers (*.scs);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="837"/>
        <source>Rename</source>
        <translation>Herbenoem</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="839"/>
        <source>Delete</source>
        <translation>Verwyder</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>Name &quot;%1&quot; isn&apos;t unique.
Please choose another.</source>
        <translation type="obsolete">Die naam &quot;%1&quot; is nie uniek nie.
Kies &apos;n ander naam.</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1244"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1252"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1344"/>
        <source>Object</source>
        <translation>Objek</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="914"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1113"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>&amp;Name:</source>
        <translation>&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="914"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>New Entry</source>
        <translation>Nuwe inskrywing</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1120"/>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="668"/>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="698"/>
        <source>Choose a Scrapbook Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="759"/>
        <source>Choose a Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="737"/>
        <source>Choose a scrapbook file to import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1445"/>
        <source>Create a new scrapbook page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1446"/>
        <source>Load an existing scrapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1447"/>
        <source>Save the selected scrapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1448"/>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1449"/>
        <source>Close the selected scrapbook</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="844"/>
        <source>Copy To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="845"/>
        <source>Move To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="560"/>
        <source>Main</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="562"/>
        <source>Copied Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1113"/>
        <source>New Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="739"/>
        <source>Scrapbook (*.scs *.SCS)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="833"/>
        <source>Paste to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="889"/>
        <source>Save as...</source>
        <translation type="unfinished">Stoor as...</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="892"/>
        <source>Close</source>
        <translation type="unfinished">Maak toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="895"/>
        <source>Delete Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/scrapbookpalette.cpp" line="1068"/>
        <source>Do you really want to delete all entries?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BookMView</name>
    <message>
        <source>Bookmarks</source>
        <translation type="obsolete">Bladwysers</translation>
    </message>
    <message>
        <source>Move Bookmark</source>
        <translation type="obsolete">Skuif Bladwyser</translation>
    </message>
    <message>
        <source>Insert Bookmark</source>
        <translation type="obsolete">Voeg Bladwyser in</translation>
    </message>
    <message>
        <source>Cancel</source>
        <translation type="obsolete">Kanselleer</translation>
    </message>
</context>
<context>
    <name>BookPalette</name>
    <message>
        <location filename="../../../scribus/bookmarkpalette.cpp" line="51"/>
        <source>Bookmarks</source>
        <translation>Bladwysers</translation>
    </message>
</context>
<context>
    <name>ButtonIcon</name>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="29"/>
        <source>Icon Placement</source>
        <translation>Plasing van ikone</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="38"/>
        <source>Layout:</source>
        <translation>Uitleg:</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption only</source>
        <translation>Slegs opskrif</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Icon only</source>
        <translation>Slegs ikoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption below Icon</source>
        <translation>Opskrif onder ikoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption above Icon</source>
        <translation>Opskrif bo ikoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption right to Icon</source>
        <translation>Opskrif regs van ikoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption left to Icon</source>
        <translation>Opskrif links van ikoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption overlays Icon</source>
        <translation>Opskrif dwarsoor ikoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="50"/>
        <source>Scale:</source>
        <translation>Skaal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="55"/>
        <source>Always</source>
        <translation>Altyd</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="55"/>
        <source>When Icon is too small</source>
        <translation>As ikoon te klein is</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="56"/>
        <source>When Icon is too big</source>
        <translation>As ikoon te groot is</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="56"/>
        <source>Never</source>
        <translation>Nooit</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="63"/>
        <source>Scale How:</source>
        <translation>Skaalmetode:</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="66"/>
        <source>Proportional</source>
        <translation>Proporsioneel</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="67"/>
        <source>Non Proportional</source>
        <translation>Nie proporsioneel nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="90"/>
        <source>Icon</source>
        <translation>Ikoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="117"/>
        <source>OK</source>
        <translation>Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="121"/>
        <source>Cancel</source>
        <translation>Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/buttonicon.cpp" line="124"/>
        <source>Reset</source>
        <translation>Begin oor</translation>
    </message>
</context>
<context>
    <name>CMSPrefs</name>
    <message>
        <source>Color Management Settings</source>
        <translation type="obsolete">Instelling van kleurbeheer</translation>
    </message>
    <message>
        <source>&amp;Activate Color Management</source>
        <translation type="obsolete">Kleurbeheer &amp;aktiveer</translation>
    </message>
    <message>
        <source>System Profiles</source>
        <translation type="obsolete">Stelselprofiele</translation>
    </message>
    <message>
        <source>&amp;Pictures:</source>
        <translation type="obsolete">&amp;Prentjies:</translation>
    </message>
    <message>
        <source>&amp;Solid Colors:</source>
        <translation type="obsolete">&amp;Soliede kleure:</translation>
    </message>
    <message>
        <source>&amp;Monitor:</source>
        <translation type="obsolete">&amp;Skerm:</translation>
    </message>
    <message>
        <source>P&amp;rinter:</source>
        <translation type="obsolete">&amp;Drukker:</translation>
    </message>
    <message>
        <source>Rendering Intents</source>
        <translation type="obsolete">Rendering intents</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="69"/>
        <source>Perceptual</source>
        <translation>Perseptueel</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="69"/>
        <source>Relative Colorimetric</source>
        <translation>Relatief Kleurmeetries</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="70"/>
        <source>Saturation</source>
        <translation>Versadiging</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefs.cpp" line="70"/>
        <source>Absolute Colorimetric</source>
        <translation>Absoluut kleurmeetries</translation>
    </message>
    <message>
        <source>M&amp;onitor:</source>
        <translation type="obsolete">S&amp;kerm:</translation>
    </message>
    <message>
        <source>Pr&amp;inter:</source>
        <translation type="obsolete">D&amp;rukker:</translation>
    </message>
    <message>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="obsolete">Sim&amp;uleer drukker op skerm</translation>
    </message>
    <message>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="obsolete">Merk kleure buite &amp;gamut</translation>
    </message>
    <message>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="obsolete">Gebruiken &amp;Swartpuntkompensasie</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Default color profile for imported images</source>
        <translation type="obsolete">Standaard kleurprofiel vir geïmporteerde prente</translation>
    </message>
    <message>
        <source>Default color profile for solid colors on the page</source>
        <translation type="obsolete">Standaard kleurprofiel vir effen kleuren op de bladsy</translation>
    </message>
    <message>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Door uzelf aangemaakt of via fabrikant verkregen kleurprofiel.
Dit profiel is specifiek vir uw beeldscherm en niet algemeen (zoals byv. sRGB).</translation>
    </message>
    <message>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Kleurprofiel vir uw printer van de printerfabrikant.
Dit profiel is specifiek vir uw printer en niet algemeen (zoals byv. sRGB).</translation>
    </message>
    <message>
        <source>Default rendering intent for your monitor. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Standaard rendering intent vir uw beeldscherm. Kies, tenzy u precies weet
wat u doet, vir Relatief colorimetrisch of Perceptueel.</translation>
    </message>
    <message>
        <source>Default rendering intent for your printer. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Standaard rendering intent vir uw printer. Kies, tenzy u precies weet
wat u doet, vir Relatief colorimetrisch of Perceptueel.</translation>
    </message>
    <message>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="obsolete">Laat een weergave op uw scherm zien, gebaseerd
op het gekozen printerprofiel.</translation>
    </message>
    <message>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="obsolete">Hiermee kunnen kleurgebieden gemarkeerd worden die niet correct zouden worden
afgedrukt. Dit vereist zeer accurate profielen en dient enkel als waarschuwing.</translation>
    </message>
    <message>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="obsolete">Zwartpuntcompensatie is een methode om het contrast in foto&apos;s te verbeteren.
Als uw dokument foto&apos;s bevat wordt deze instelling aangeraden.</translation>
    </message>
    <message>
        <source>Images:</source>
        <translation type="obsolete">Prente:</translation>
    </message>
</context>
<context>
    <name>CMSPrefsBase</name>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="40"/>
        <source>&amp;Activate Color Management</source>
        <translation type="unfinished">Kleurbeheer &amp;aktiveer</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="50"/>
        <source>System Profiles</source>
        <translation type="unfinished">Stelselprofiele</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="74"/>
        <source>&amp;RGB Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="90"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="97"/>
        <source>&amp;CMYK Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="113"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="120"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="136"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="143"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="159"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="166"/>
        <source>&amp;Monitor:</source>
        <translation type="unfinished">&amp;Skerm:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="182"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Door uzelf aangemaakt of via fabrikant verkregen kleurprofiel.
Dit profiel is specifiek vir uw beeldscherm en niet algemeen (zoals byv. sRGB).</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="190"/>
        <source>P&amp;rinter:</source>
        <translation type="unfinished">&amp;Drukker:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="206"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Kleurprofiel vir uw printer van de printerfabrikant.
Dit profiel is specifiek vir uw printer en niet algemeen (zoals byv. sRGB).</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="220"/>
        <source>Rendering Intents</source>
        <translation type="unfinished">Rendering intents</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="244"/>
        <source>Images:</source>
        <translation type="unfinished">Prente:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="260"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="268"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="284"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="298"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="unfinished">Laat een weergave op uw scherm zien, gebaseerd
op het gekozen printerprofiel.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="302"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="unfinished">Sim&amp;uleer drukker op skerm</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="329"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="333"/>
        <source>Convert all colors to printer space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="340"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="unfinished">Hiermee kunnen kleurgebieden gemarkeerd worden die niet correct zouden worden
afgedrukt. Dit vereist zeer accurate profielen en dient enkel als waarschuwing.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="344"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="unfinished">Merk kleure buite &amp;gamut</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="357"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="unfinished">Zwartpuntcompensatie is een methode om het contrast in foto&apos;s te verbeteren.
Als uw dokument foto&apos;s bevat wordt deze instelling aangeraden.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmsprefsbase.ui" line="361"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="unfinished">Gebruiken &amp;Swartpuntkompensasie</translation>
    </message>
</context>
<context>
    <name>CMYKChoose</name>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="92"/>
        <source>Edit Color</source>
        <translation>Bewerk kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="101"/>
        <source>&amp;Name:</source>
        <translation>&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="111"/>
        <source>Color &amp;Model</source>
        <translation>Kleur&amp;model</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="116"/>
        <location filename="../../../scribus/cmykfw.cpp" line="661"/>
        <location filename="../../../scribus/cmykfw.cpp" line="680"/>
        <location filename="../../../scribus/cmykfw.cpp" line="899"/>
        <location filename="../../../scribus/cmykfw.cpp" line="906"/>
        <source>CMYK</source>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="117"/>
        <location filename="../../../scribus/cmykfw.cpp" line="414"/>
        <location filename="../../../scribus/cmykfw.cpp" line="911"/>
        <source>RGB</source>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="118"/>
        <location filename="../../../scribus/cmykfw.cpp" line="764"/>
        <source>Web Safe RGB</source>
        <translation>RGB vir web</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="141"/>
        <source>New</source>
        <translation>Nuut</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="158"/>
        <source>Old</source>
        <translation>Oud</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>HSV-Colormap</source>
        <translation type="obsolete">HSV-kleurkaart</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="266"/>
        <location filename="../../../scribus/cmykfw.cpp" line="705"/>
        <source>C:</source>
        <translation>C:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="288"/>
        <location filename="../../../scribus/cmykfw.cpp" line="315"/>
        <location filename="../../../scribus/cmykfw.cpp" line="342"/>
        <location filename="../../../scribus/cmykfw.cpp" line="369"/>
        <location filename="../../../scribus/cmykfw.cpp" line="702"/>
        <location filename="../../../scribus/cmykfw.cpp" line="703"/>
        <location filename="../../../scribus/cmykfw.cpp" line="704"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="293"/>
        <location filename="../../../scribus/cmykfw.cpp" line="706"/>
        <source>M:</source>
        <translation>M:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="320"/>
        <location filename="../../../scribus/cmykfw.cpp" line="707"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="347"/>
        <source>K:</source>
        <translation>K:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="444"/>
        <source>Dynamic Color Bars</source>
        <translation>Dinamiese kleurbalke</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="442"/>
        <source>Static Color Bars</source>
        <translation>Statiese kleurbalke</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="749"/>
        <source>R:</source>
        <translation>R:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="750"/>
        <source>G:</source>
        <translation>G:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="751"/>
        <source>B:</source>
        <translation>B:</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>Name of the Color is not unique</source>
        <translation type="obsolete">Kleurnaam is nie uniek nie</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">Reg</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>You cannot create a color named &quot;%1&quot;.
It&apos;s a reserved name for transparent color</source>
        <translation type="obsolete">Jy kan nie &apos;n kleur &quot;%1&quot; noem nie.
Dit dien as plekhouer vir deursigtig.</translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="125"/>
        <source>Is Spot Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="1002"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="1011"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="390"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="784"/>
        <location filename="../../../scribus/cmykfw.cpp" line="785"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="995"/>
        <source>You cannot create a color without a name
Please give it a name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cmykfw.cpp" line="196"/>
        <source>HSV Color Map</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CWDialog</name>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="319"/>
        <source>Merging colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Error: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Color %1 exists already!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="330"/>
        <source>Color %1 appended.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="334"/>
        <source>Now opening the color manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="337"/>
        <source>Color Merging</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.cpp" line="486"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="15"/>
        <source>Color Wheel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="45"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="52"/>
        <source>Result Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="77"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="322"/>
        <source>CMYK</source>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="82"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="543"/>
        <source>RGB</source>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="87"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="729"/>
        <source>HSV</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="106"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="116"/>
        <source>Color Scheme Method</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="142"/>
        <source>Angle:</source>
        <translation type="unfinished">Hoek:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="152"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="167"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="201"/>
        <source>Merge created colors into the document colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="204"/>
        <source>&amp;Merge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="207"/>
        <source>Alt+M</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="214"/>
        <source>Replace created colors in the document colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="217"/>
        <source>&amp;Replace</source>
        <translation type="unfinished">&amp;Vervangen</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="220"/>
        <source>Alt+R</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="227"/>
        <source>Leave colors untouched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="230"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="233"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="242"/>
        <source>Preview:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="266"/>
        <source>Sample color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="285"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="292"/>
        <source>Vision Defect Type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="342"/>
        <source>C:</source>
        <translation type="unfinished">C:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="352"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="382"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="412"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="442"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="372"/>
        <source>M:</source>
        <translation type="unfinished">M:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="402"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="432"/>
        <source>K:</source>
        <translation type="unfinished">K:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="462"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="838"/>
        <source>RGB:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="498"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="685"/>
        <source>HSV:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="571"/>
        <source>R:</source>
        <translation type="unfinished">R:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="598"/>
        <source>G:</source>
        <translation type="unfinished">G:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="625"/>
        <source>B:</source>
        <translation type="unfinished">B:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="652"/>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="874"/>
        <source>CMYK:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="757"/>
        <source>H:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="784"/>
        <source>S:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="811"/>
        <source>V:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/cwdialog.ui" line="918"/>
        <source>Document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CWDialogBase</name>
    <message>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
    <message>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <source>Angle:</source>
        <translation type="obsolete">Hoek:</translation>
    </message>
    <message>
        <source>&amp;Replace</source>
        <translation type="obsolete">&amp;Vervangen</translation>
    </message>
    <message>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>Canvas</name>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2218"/>
        <location filename="../../../scribus/canvas.cpp" line="2246"/>
        <source>X: %1
Y: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2231"/>
        <source>X: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2238"/>
        <source>Y: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2254"/>
        <source>Length: %1
Angle: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2256"/>
        <source>Width: %1
Height: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvas.cpp" line="2268"/>
        <source>Angle: %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_EyeDropper</name>
    <message>
        <location filename="../../../scribus/canvasmode_eyedropper.cpp" line="166"/>
        <source>The selected color does not exist in the document&apos;s color set. Please enter a name for this new color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_eyedropper.cpp" line="169"/>
        <source>Color Not Found</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_eyedropper.cpp" line="173"/>
        <source>The name you have selected already exists. Please enter a different name for this new color.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_Normal</name>
    <message>
        <location filename="../../../scribus/canvasmode_normal.cpp" line="1334"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_normal.cpp" line="1365"/>
        <source>Open</source>
        <translation type="unfinished">Maak oop</translation>
    </message>
</context>
<context>
    <name>CharSelect</name>
    <message>
        <source>Select Character:</source>
        <translation type="obsolete">Karakter selecteren:</translation>
    </message>
    <message>
        <source>Font:</source>
        <translation type="obsolete">Lettertype:</translation>
    </message>
    <message>
        <source>&amp;Insert</source>
        <translation type="obsolete">&amp;Invoegen</translation>
    </message>
    <message>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="obsolete">Voegt de tekens in op de huidige cursorpositie</translation>
    </message>
    <message>
        <source>Delete the current selection(s).</source>
        <translation type="obsolete">Verwydert de huidige selectie(s).</translation>
    </message>
    <message>
        <source>Close this dialog and return to text editing.</source>
        <translation type="obsolete">Sluit deze dialoog om verder te werken aan de teks.</translation>
    </message>
    <message>
        <source>Greek</source>
        <translation type="obsolete">Grieks</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="31"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="226"/>
        <source>Choose a filename to open</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="255"/>
        <location filename="../../../scribus/charselect.cpp" line="297"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="256"/>
        <source>Error reading file %1 - file is corrupted propably.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="298"/>
        <source>Cannot write file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="13"/>
        <source>Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="306"/>
        <source>Empty the Palette?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="307"/>
        <source>You will remove all characters from this palette. Are you sure?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.ui" line="24"/>
        <source>Hide/Show Enhanced Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselect.cpp" line="272"/>
        <source>Save Quick Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharSelectEnhanced</name>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="205"/>
        <source>Full Character Set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="210"/>
        <source>Basic Latin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="216"/>
        <source>Latin-1 Supplement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="222"/>
        <source>Latin Extended-A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="228"/>
        <source>Latin Extended-B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="234"/>
        <source>General Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="240"/>
        <source>Super- and Subscripts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="246"/>
        <source>Currency Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="252"/>
        <source>Letterlike Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="258"/>
        <source>Number Forms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="264"/>
        <source>Arrows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="270"/>
        <source>Mathematical Operators</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="276"/>
        <source>Box Drawing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="282"/>
        <source>Block Elements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="288"/>
        <source>Geometric Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="294"/>
        <source>Miscellaneous Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="300"/>
        <source>Dingbats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="306"/>
        <source>Small Form Variants</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="312"/>
        <source>Ligatures</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="318"/>
        <source>Specials</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="324"/>
        <source>Greek</source>
        <translation type="unfinished">Grieks</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="330"/>
        <source>Greek Extended</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="336"/>
        <source>Cyrillic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="342"/>
        <source>Cyrillic Supplement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="348"/>
        <source>Arabic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="354"/>
        <source>Arabic Extended A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="360"/>
        <source>Arabic Extended B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.cpp" line="366"/>
        <source>Hebrew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="13"/>
        <source>Enhanced Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="19"/>
        <source>&amp;Font:</source>
        <translation type="unfinished">&amp;Lettertipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="45"/>
        <source>C&amp;haracter Class:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="77"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button.
The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="96"/>
        <source>Insert &amp;Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="131"/>
        <source>Glyphs to Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="171"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="unfinished">Voegt de tekens in op de huidige cursorpositie</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="174"/>
        <source>&amp;Insert</source>
        <translation type="unfinished">&amp;Invoegen</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="184"/>
        <source>Delete the current selection(s).</source>
        <translation type="unfinished">Verwydert de huidige selectie(s).</translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="187"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/charselectenhanced.ui" line="106"/>
        <source>Type in a four digit Unicode value directly here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharStyleComboBox</name>
    <message>
        <location filename="../../../scribus/spalette.cpp" line="94"/>
        <location filename="../../../scribus/spalette.cpp" line="107"/>
        <location filename="../../../scribus/spalette.cpp" line="118"/>
        <source>No Style</source>
        <translation type="unfinished">Geen styl</translation>
    </message>
</context>
<context>
    <name>CharTableView</name>
    <message>
        <location filename="../../../scribus/chartableview.cpp" line="22"/>
        <source>Delete</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CheckDocument</name>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="665"/>
        <source>Current Profile:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="660"/>
        <source>Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="423"/>
        <source>Print/Visible Mismatch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="660"/>
        <source>Problems</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="673"/>
        <source>Glyphs missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="674"/>
        <source>Text overflow</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="675"/>
        <source>Object is not on a Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="676"/>
        <source>Missing Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="680"/>
        <source>Object has transparency</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="682"/>
        <source>Object is a placed PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="379"/>
        <source>Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="381"/>
        <source>No Problems found</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="561"/>
        <source>Page </source>
        <translation type="unfinished">Bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="625"/>
        <source>Free Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="658"/>
        <source>Preflight Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="681"/>
        <source>Object is a PDF Annotation or Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="635"/>
        <location filename="../../../scribus/checkDocument.cpp" line="666"/>
        <source>&amp;Ignore Errors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="667"/>
        <source>Check again</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="683"/>
        <source>Image is GIF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="382"/>
        <source>OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="413"/>
        <source>Transparency used</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="418"/>
        <source>Blendmode used</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="431"/>
        <source>Layer &quot;%1&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="684"/>
        <source>Annotation uses a non TrueType font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="669"/>
        <source>Preflight profile to base the report generation on. Options can be set in Document Setup or Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="670"/>
        <source>Ignore found errors and continue to export or print. Be sure to understand the errors you are ignoring before continuing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="671"/>
        <source>Rerun the document scan to check corrections you may have made</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="677"/>
        <source>Empty Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="394"/>
        <source>Layers</source>
        <translation type="unfinished">Lae</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="437"/>
        <location filename="../../../scribus/checkDocument.cpp" line="506"/>
        <source>Issue(s): %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="448"/>
        <source>Master Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="661"/>
        <source>Layer</source>
        <translation type="unfinished">Laag</translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="678"/>
        <source>Image resolution below %1 DPI,
currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/checkDocument.cpp" line="679"/>
        <source>Image resolution above %1 DPI,
currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CheckerPrefsList</name>
    <message>
        <source>Postscript</source>
        <translation type="obsolete">Postscript</translation>
    </message>
</context>
<context>
    <name>ChooseStyles</name>
    <message>
        <source>Cancel</source>
        <translation type="obsolete">Kanselleer</translation>
    </message>
</context>
<context>
    <name>CollectForOutput</name>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="52"/>
        <source>Choose a Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="65"/>
        <source>Cannot create directory:
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="80"/>
        <source>Collecting...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="85"/>
        <source>Cannot collect all files for output for file:
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/collect4output.cpp" line="99"/>
        <source>Cannot collect the file: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorManager</name>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="54"/>
        <source>Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="80"/>
        <source>&amp;Import</source>
        <translation type="unfinished">&amp;Voer in</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="82"/>
        <source>&amp;New</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="84"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="88"/>
        <source>D&amp;uplicate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="91"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="96"/>
        <source>&amp;Remove Unused</source>
        <translation type="unfinished">Ve&amp;rwyder ongebruikte</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="103"/>
        <source>Color Sets</source>
        <translation type="unfinished">Kleurstelle</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="109"/>
        <source>Current Color Set:</source>
        <translation type="unfinished">Huidige kleurstel:</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="140"/>
        <source>&amp;Save Color Set</source>
        <translation type="unfinished">&amp;Stoor kleurstel</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="159"/>
        <source>Choose a color set to load</source>
        <translation type="unfinished">Kies kleurstel om te laai</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="160"/>
        <source>Save the current color set</source>
        <translation type="unfinished">Stoor huidige kleurstel</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="165"/>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation type="unfinished">Verwyder ongebruikte kleure uit dokument se kleurstel</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="167"/>
        <source>Import colors to the current set from an existing document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="168"/>
        <source>Create a new color within the current set</source>
        <translation type="unfinished">Maak &apos;n nuwe kleur in huidige kleurstel</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="169"/>
        <source>Edit the currently selected color</source>
        <translation type="unfinished">Verander gekiesde kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="170"/>
        <source>Make a copy of the currently selected color</source>
        <translation type="unfinished">Maak &apos;n kopie van huidiglik gekiesde kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="171"/>
        <source>Delete the currently selected color</source>
        <translation type="unfinished">Verwyder huidig gekiesde kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="172"/>
        <source>Make the current colorset the default color set</source>
        <translation type="unfinished">Maak huidige kleurstel die verstek</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="190"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="190"/>
        <source>Choose a Name</source>
        <translation type="unfinished">Kies &apos;n naam</translation>
    </message>
    <message>
        <source>Open</source>
        <translation type="obsolete">Maak oop</translation>
    </message>
    <message>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Dokumente (*.sla *.sla.gz *.scd *.scd.gz);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Dokumente (*.sla *.scd);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="353"/>
        <source>Copy of %1</source>
        <translation type="unfinished">Kopie van %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="364"/>
        <source>New Color</source>
        <translation type="unfinished">Nuwe kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="321"/>
        <source>Information</source>
        <translation type="unfinished">Info</translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="321"/>
        <source>The file %1 does not contain colors which can be imported.
If the file was a PostScript-based, try to import it with File -&amp;gt; Import. 
Not all files have DSC conformant comments where the color descriptions are located.
 This prevents importing colors from some files.
See the Edit Colors section of the documentation for more details.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="173"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. More hints about gamut warnings are in the online help under Color Management. Registration colors will have a registration mark next to the color. Use Registration only for printers marks and crop marks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="311"/>
        <source>All Supported Formats (%1);;Documents (%2);;Other Files (%3);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/colorm.cpp" line="312"/>
        <source>Import Colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheel</name>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="139"/>
        <source>Monochromatic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="140"/>
        <source>Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="141"/>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="224"/>
        <source>Complementary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="142"/>
        <source>Split Complementary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="143"/>
        <source>Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="144"/>
        <source>Tetradic (Double Complementary)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="44"/>
        <source>Base Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="206"/>
        <source>Monochromatic Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="209"/>
        <source>Monochromatic Dark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="216"/>
        <source>1st. Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="217"/>
        <source>2nd. Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="231"/>
        <source>1st. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="232"/>
        <source>2nd. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="233"/>
        <source>3rd. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="234"/>
        <source>4th. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="241"/>
        <source>1st. Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="242"/>
        <source>2nd. Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="249"/>
        <source>1st. Tetradic (base opposite)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="250"/>
        <source>2nd. Tetradic (angle)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="251"/>
        <source>3rd. Tetradic (angle opposite)</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheelDialog</name>
    <message>
        <source>Color</source>
        <translation type="obsolete">Kleur</translation>
    </message>
    <message>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <source>C&amp;olor</source>
        <translation type="obsolete">&amp;Kleur</translation>
    </message>
    <message>
        <source>New Color</source>
        <translation type="obsolete">Nuwe kleur</translation>
    </message>
</context>
<context>
    <name>ColorWheelPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheel.cpp" line="47"/>
        <source>&amp;Color Wheel...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheel.cpp" line="64"/>
        <source>Color setting helper</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/colorwheel/colorwheel.cpp" line="65"/>
        <source>Color selector with color theory included.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CommonStrings</name>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="244"/>
        <source>&amp;Apply</source>
        <translation type="unfinished">Toe&amp;pas</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="247"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="250"/>
        <source>None</source>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="254"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="257"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="260"/>
        <source>Warning</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="251"/>
        <source>None</source>
        <comment>color name</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="285"/>
        <source>Custom</source>
        <comment>CommonStrings, custom page size</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="291"/>
        <source>Single Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="292"/>
        <source>Double Sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="293"/>
        <source>3-Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="294"/>
        <source>4-Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Left Page</source>
        <translation type="obsolete">Linker bladsy</translation>
    </message>
    <message>
        <source>Right Page</source>
        <translation type="obsolete">Regter bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="330"/>
        <source>Monday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="331"/>
        <source>Tuesday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="332"/>
        <source>Wednesday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="333"/>
        <source>Thursday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="334"/>
        <source>Friday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="335"/>
        <source>Saturday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="336"/>
        <source>Sunday</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="337"/>
        <source>January</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="338"/>
        <source>February</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="339"/>
        <source>March</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="340"/>
        <source>April</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="341"/>
        <source>May</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="342"/>
        <source>June</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="343"/>
        <source>July</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="344"/>
        <source>August</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="345"/>
        <source>September</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="346"/>
        <source>October</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="347"/>
        <source>November</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="348"/>
        <source>December</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="262"/>
        <source>Yes</source>
        <translation type="unfinished">Ja</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="263"/>
        <source>No</source>
        <translation type="unfinished">Nee</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="264"/>
        <source>&amp;Yes</source>
        <translation type="unfinished">&amp;Ja</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="265"/>
        <source>&amp;No</source>
        <translation type="unfinished">&amp;Nee</translation>
    </message>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="301"/>
        <source>Left Page</source>
        <comment>Left page location</comment>
        <translation type="unfinished">Linker bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="302"/>
        <source>Middle</source>
        <comment>Middle page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="303"/>
        <source>Middle Left</source>
        <comment>Middle Left page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="304"/>
        <source>Middle Right</source>
        <comment>Middle Right page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="305"/>
        <source>Right Page</source>
        <comment>Right page location</comment>
        <translation type="unfinished">Regter bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="308"/>
        <source>Normal</source>
        <comment>Default single master page</comment>
        <translation type="unfinished">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="310"/>
        <source>Normal Left</source>
        <comment>Default left master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="312"/>
        <source>Normal Middle</source>
        <comment>Default middle master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="314"/>
        <source>Normal Right</source>
        <comment>Default right master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="356"/>
        <source>Normal Vision</source>
        <comment>Color Blindness - Normal Vision</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="357"/>
        <source>Protanopia (Red)</source>
        <comment>Color Blindness - Red Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="358"/>
        <source>Deuteranopia (Green)</source>
        <comment>Color Blindness - Greed Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="359"/>
        <source>Tritanopia (Blue)</source>
        <comment>Color Blindness - Blue Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="360"/>
        <source>Full Color Blindness</source>
        <comment>Color Blindness - Full Color Blindness</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="362"/>
        <source>Custom: </source>
        <comment>Custom Tab Fill Option</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="316"/>
        <source>Solid Line</source>
        <translation type="unfinished">Soliede lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="317"/>
        <source>Dashed Line</source>
        <translation type="unfinished">Gestreepte lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="318"/>
        <source>Dotted Line</source>
        <translation type="unfinished">Stippellyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="319"/>
        <source>Dash Dot Line</source>
        <translation type="unfinished">Streep-stip lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="320"/>
        <source>Dash Dot Dot Line</source>
        <translation type="unfinished">Streep-stip-stip lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="364"/>
        <source>None</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="365"/>
        <source>Left Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="366"/>
        <source>Right Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="367"/>
        <source>Left Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="368"/>
        <source>Right Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="369"/>
        <source>Default</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="372"/>
        <source>Min. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="373"/>
        <source>Max. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="376"/>
        <source>Min. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="377"/>
        <source>Max. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="350"/>
        <source>RGB</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="351"/>
        <source>CMYK</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="352"/>
        <source>Grayscale</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="353"/>
        <source>Duotone</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="354"/>
        <source>Unknown</source>
        <comment>Colorspace (Unknown)</comment>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="381"/>
        <source>PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="267"/>
        <source>Text Frame</source>
        <translation type="unfinished">Teksraam</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="268"/>
        <source>Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="269"/>
        <source>Line</source>
        <translation type="unfinished">Lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="270"/>
        <source>Polygon</source>
        <translation type="unfinished">Polygoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="271"/>
        <source>Polyline</source>
        <translation type="unfinished">Polylyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="272"/>
        <source>Text on a Path</source>
        <translation type="unfinished">Teks op &apos;n pad</translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="274"/>
        <source>Multiple</source>
        <comment>Multiple frame types</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="275"/>
        <source>PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="276"/>
        <source>PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="277"/>
        <source>PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="278"/>
        <source>PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="279"/>
        <source>PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="280"/>
        <source>PDF Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="281"/>
        <source>PDF Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="388"/>
        <source>PostScript Level 1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="390"/>
        <source>PostScript Level 2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="392"/>
        <source>PostScript Level 3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="394"/>
        <source>Windows GDI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="273"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="325"/>
        <source>Default Paragraph Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="326"/>
        <source>Default Character Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/commonstrings.cpp" line="327"/>
        <source>Default Line Style</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ContextMenu</name>
    <message>
        <location filename="../../../scribus/contextmenu.cpp" line="210"/>
        <source>Preview Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/contextmenu.cpp" line="421"/>
        <source>Paste File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/contextmenu.cpp" line="454"/>
        <source>Delete Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/contextmenu.cpp" line="182"/>
        <source>Paste Image from Clipboard</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageBase</name>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpage.ui" line="16"/>
        <source>Convert Page to Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpage.ui" line="24"/>
        <source>Name:</source>
        <translation type="unfinished">Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpage.ui" line="39"/>
        <source>Copy Applied Master Page Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageDialog</name>
    <message>
        <location filename="../../../scribus/ui/copypagetomasterpagedialog.cpp" line="18"/>
        <source>New Master Page %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Cpalette</name>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1001"/>
        <source>Shade:</source>
        <translation>Skadu:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="985"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1002"/>
        <source>Opacity:</source>
        <translation>Ondeursigtigheid:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1007"/>
        <location filename="../../../scribus/cpalette.cpp" line="1020"/>
        <source>Normal</source>
        <translation>Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1008"/>
        <source>Horizontal Gradient</source>
        <translation>Horisontale gradiënt</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1009"/>
        <source>Vertical Gradient</source>
        <translation>Vertikale gradiënt</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1010"/>
        <source>Diagonal Gradient</source>
        <translation>Diagonale gradiënt</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1011"/>
        <source>Cross Diagonal Gradient</source>
        <translation>Kruisdiagonale gradiënt</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1012"/>
        <source>Radial Gradient</source>
        <translation>Straalgradiënt</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1013"/>
        <source>Free linear Gradient</source>
        <translation>Vry liniêre gradiënt</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1014"/>
        <source>Free radial Gradient</source>
        <translation>Vry straalgradiënt</translation>
    </message>
    <message>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="984"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1038"/>
        <source>Edit Line Color Properties</source>
        <translation>Kies lynkleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1039"/>
        <source>Edit Fill Color Properties</source>
        <translation>Kies vulkleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1040"/>
        <source>Saturation of color</source>
        <translation>Kleurversadiging</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1041"/>
        <source>Normal or gradient fill method</source>
        <translation>Vulmetode: normaal of gradiënt</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1042"/>
        <source>Set the transparency for the color selected</source>
        <translation>Kies deursigtigheid van gekose kleur</translation>
    </message>
    <message>
        <source>Color of selected object</source>
        <translation type="obsolete">Kleur van gekiesde objek</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1003"/>
        <source>Move Vector</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1043"/>
        <source>Move the start of the gradient vector with the left mouse button pressed and move the end of the gradient vector with the right mouse button pressed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1017"/>
        <source>Transparency Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1018"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1021"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1022"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1023"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1024"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1025"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1026"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1027"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1028"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1030"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1031"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1032"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1033"/>
        <source>Saturation</source>
        <translation type="unfinished">Versadiging</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1034"/>
        <source>Color</source>
        <translation type="unfinished">Kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1035"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="988"/>
        <source>Offsets</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="989"/>
        <source>X:</source>
        <translation type="unfinished">X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="991"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="993"/>
        <source>Scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="998"/>
        <source>Rotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="999"/>
        <source>Angle</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="405"/>
        <location filename="../../../scribus/cpalette.cpp" line="518"/>
        <location filename="../../../scribus/cpalette.cpp" line="1015"/>
        <source>Pattern</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1029"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="994"/>
        <source>X-Scale:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="996"/>
        <source>Y-Scale:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="229"/>
        <location filename="../../../scribus/cpalette.cpp" line="1036"/>
        <source>Display only used Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="1044"/>
        <source>Display all colors from the document color list, or only the already used colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CreateRange</name>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="13"/>
        <source>Create Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="54"/>
        <source>Number of Pages in Document:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="64"/>
        <source>Doc Page Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="112"/>
        <source>Basic Range Selection</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="136"/>
        <source>Range of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="160"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">Ve&amp;rwyder</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="163"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="186"/>
        <source>Move &amp;Down</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="189"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="196"/>
        <source>Move &amp;Up</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="199"/>
        <source>Alt+U</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="218"/>
        <source>Add a Range of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="242"/>
        <source>Consecutive Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="252"/>
        <source>Even Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="259"/>
        <source>From:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="291"/>
        <source>To:</source>
        <translation type="unfinished">Tot:</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="334"/>
        <source>&amp;Add To Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="337"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="362"/>
        <source>Odd Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="372"/>
        <source>Comma Separated List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="383"/>
        <source>Advanced Reordering</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="439"/>
        <source>Page Order</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="449"/>
        <source>Sample Page Order:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="478"/>
        <source>Page Group Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="525"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="528"/>
        <source>Alt+O</source>
        <translation type="unfinished">Atl+O</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="535"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/createrange.ui" line="538"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
</context>
<context>
    <name>CreateRangeBase</name>
    <message>
        <source>To:</source>
        <translation type="obsolete">Tot:</translation>
    </message>
    <message>
        <source>De&amp;lete</source>
        <translation type="obsolete">Ve&amp;rwyder</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>Alt+O</source>
        <translation type="obsolete">Atl+O</translation>
    </message>
    <message>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>CsvDialog</name>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="27"/>
        <source>CSV Importer Options</source>
        <translation>Opsies vir CSV invoerder</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="37"/>
        <source>Field delimiter:</source>
        <translation>Veldskeidingsteken:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="44"/>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="89"/>
        <source>(TAB)</source>
        <translation>(TAB)</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="53"/>
        <source>Value delimiter:</source>
        <translation>Waardeskeidingsteken:</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="68"/>
        <source>First row is a header</source>
        <translation>Eerste lyn is &apos;n opskrif</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="76"/>
        <source>OK</source>
        <translation>REG</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="79"/>
        <source>Cancel</source>
        <translation>Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvdia.cpp" line="59"/>
        <source>None</source>
        <comment>delimiter</comment>
        <translation type="unfinished">Geen</translation>
    </message>
</context>
<context>
    <name>CupsOptions</name>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="52"/>
        <source>Printer Options</source>
        <translation>Drukkeropsies</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="133"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="143"/>
        <source>Page Set</source>
        <translation>Bladsy Bereik</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="140"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="147"/>
        <source>All Pages</source>
        <translation>Alle bladsye</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="141"/>
        <source>Even Pages only</source>
        <translation>Ewe bladsye</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="142"/>
        <source>Odd Pages only</source>
        <translation>Onewe bladsye</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="150"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="160"/>
        <source>Mirror</source>
        <translation>Spieëlbeeld</translation>
    </message>
    <message>
        <source>No</source>
        <translation type="obsolete">Nee</translation>
    </message>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="167"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="177"/>
        <source>Orientation</source>
        <translation>Oriëntasie</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="174"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="181"/>
        <source>Portrait</source>
        <translation>Staande</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="175"/>
        <source>Landscape</source>
        <translation>Lêend</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="184"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="197"/>
        <source>N-Up Printing</source>
        <translation>N-Op Druk</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="191"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="201"/>
        <source>Page per Sheet</source>
        <translation>Bladsy per vel</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="192"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="193"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="194"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="195"/>
        <location filename="../../../scribus/cupsoptions.cpp" line="196"/>
        <source>Pages per Sheet</source>
        <translation>Bladsye per vel</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="63"/>
        <source>Option</source>
        <translation>Opsie</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="64"/>
        <source>Value</source>
        <translation>Waarde</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>This panel displays various CUPS options when printing. 
The exact parameters available will depend on your printer driver.
You can confirm CUPS support by selecting Help &gt; About.
Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support.
Missing library support is indicated by a *</source>
        <translation type="obsolete">Dit paneel toont verschillende CUPS-opties vir het afdrukken.
Welke instellingen precies mogelyk zyn hangt van uw printerdriver af.
Onder &quot;Help &gt; Info over&quot; kunt u kyken of CUPS-ondersteuning is ingebouwd.
Kyk vir de tekens C-C-T, welke staan vir C=CUPS, C=littlecms, T=TIFF-ondersteuning.
Een * geeft aan welke bibliotheken ontbreken</translation>
    </message>
    <message>
        <location filename="../../../scribus/cupsoptions.cpp" line="224"/>
        <source>This panel displays various CUPS options when printing. The exact parameters available will depend on your printer driver. You can confirm CUPS support by selecting Help &gt; About. Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support. Missing library support is indicated by a *</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CurveWidget</name>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="415"/>
        <source>Open</source>
        <translation type="unfinished">Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="415"/>
        <source>Curve Files (*.scu *.SCU);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="453"/>
        <source>Save as</source>
        <translation type="unfinished">Stoor as</translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="453"/>
        <source>Curve Files (*.scu *.scu);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="487"/>
        <source>Cannot write the file: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="513"/>
        <source>Inverts the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="514"/>
        <source>Resets the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="515"/>
        <source>Switches between linear and cubic interpolation of the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="516"/>
        <source>Loads a curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/curvewidget.cpp" line="517"/>
        <source>Saves this curve</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CustomFDialog</name>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="297"/>
        <location filename="../../../scribus/customfdialog.cpp" line="327"/>
        <source>&amp;Compress File</source>
        <translation>&amp;Krimp lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="306"/>
        <source>&amp;Include Fonts</source>
        <translation>&amp;Sluit lettertipes in</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="355"/>
        <source>Encoding:</source>
        <translation>Enkodering:</translation>
    </message>
    <message>
        <source>Moves to your Document Directory.
This can be set in the Preferences.</source>
        <translation type="obsolete">Gaat na uw dokumentenmap.
Deze kan worden ingesteld in de voorkeuren.</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="274"/>
        <source>Show Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="308"/>
        <source>&amp;Include Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="275"/>
        <source>Show a preview and information for the selected file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="342"/>
        <source>Compress the Scribus document on save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="344"/>
        <source>Include fonts when collecting files for the document. Be sure to know and understand licensing information for any fonts you collect and possibly redistribute.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="346"/>
        <source>Include color profiles when collecting files for the document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CwSetColor</name>
    <message>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
</context>
<context>
    <name>DashEditor</name>
    <message>
        <location filename="../../../scribus/dasheditor.cpp" line="363"/>
        <source>Value:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/dasheditor.cpp" line="364"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DeferredTask</name>
    <message>
        <location filename="../../../scribus/deferredtask.cpp" line="82"/>
        <source>Cancelled by user</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DelColor</name>
    <message>
        <location filename="../../../scribus/dcolor.cpp" line="28"/>
        <source>Delete Color</source>
        <translation>Verwyder kleur</translation>
    </message>
    <message>
        <source>Delete color:</source>
        <translation type="obsolete">Verwyder kleur:</translation>
    </message>
    <message>
        <source>?</source>
        <translation type="obsolete">?</translation>
    </message>
    <message>
        <source>Replace it with:</source>
        <translation type="obsolete">Vervang met:</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/dcolor.cpp" line="36"/>
        <source>Delete Color:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/dcolor.cpp" line="45"/>
        <source>Replace With:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DelPages</name>
    <message>
        <location filename="../../../scribus/delpages.cpp" line="17"/>
        <source>Delete Pages</source>
        <translation>Verwyder bladsye</translation>
    </message>
    <message>
        <source>Delete from:</source>
        <translation type="obsolete">Verwyder vorm:</translation>
    </message>
    <message>
        <location filename="../../../scribus/delpages.cpp" line="34"/>
        <source>to:</source>
        <translation>tot:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer
</translation>
    </message>
    <message>
        <location filename="../../../scribus/delpages.cpp" line="26"/>
        <source>Delete From:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DelStyle</name>
    <message>
        <source>No Style</source>
        <translation type="obsolete">Geen styl</translation>
    </message>
</context>
<context>
    <name>DmF</name>
    <message>
        <source>Missing Font</source>
        <translation type="obsolete">Ontbrekende lettertipe</translation>
    </message>
    <message>
        <source>The Font %1 is not installed.</source>
        <translation type="obsolete">Die lettertipe %1 is nie geinstalleer nie.</translation>
    </message>
    <message>
        <source>Use</source>
        <translation type="obsolete">Gebruik</translation>
    </message>
    <message>
        <source>instead</source>
        <translation type="obsolete">in plaas daarvan</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">REG</translation>
    </message>
</context>
<context>
    <name>DocIm</name>
    <message>
        <location filename="../../../scribus/plugins/gettext/docim/docim.cpp" line="160"/>
        <source>Importing failed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/docim/docim.cpp" line="161"/>
        <source>Importing Word document failed 
%1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocInfos</name>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="30"/>
        <source>Document Information</source>
        <translation>Dokumentinformasie</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="39"/>
        <source>&amp;Title:</source>
        <translation>&amp;Titel:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="46"/>
        <source>&amp;Author:</source>
        <translation>&amp;Outeur:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="53"/>
        <source>&amp;Keywords:</source>
        <translation>&amp;Sleutelwoorde:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="61"/>
        <source>Descri&amp;ption:</source>
        <translation>&amp;Beskrywing:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="74"/>
        <source>P&amp;ublisher:</source>
        <translation>&amp;Uitgewer:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="81"/>
        <source>&amp;Contributors:</source>
        <translation>&amp;Medewerkers:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="89"/>
        <source>Dat&amp;e:</source>
        <translation>&amp;Datum:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="96"/>
        <source>T&amp;ype:</source>
        <translation>T&amp;ipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="103"/>
        <source>F&amp;ormat:</source>
        <translation>&amp;Formaat:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="110"/>
        <source>Identi&amp;fier:</source>
        <translation>&amp;Identifiseerder:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="117"/>
        <source>&amp;Source:</source>
        <translation>Br&amp;on:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="124"/>
        <source>&amp;Language:</source>
        <translation>T&amp;aal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="131"/>
        <source>&amp;Relation:</source>
        <translation>R&amp;elasie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="138"/>
        <source>Co&amp;verage:</source>
        <translation>&amp;Dekking:</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="145"/>
        <source>Ri&amp;ghts:</source>
        <translation>Reg&amp;te:</translation>
    </message>
    <message>
        <source>&amp;Document</source>
        <translation type="obsolete">Doku&amp;ment</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="153"/>
        <source>Further &amp;Information</source>
        <translation>Meer &amp;informasie</translation>
    </message>
    <message>
        <source>The person or organisation primarily responsible for making the content of the document.
This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="obsolete">De persoon of organisatie die de hoofdverantwoordelyke is vir het aanmaken van de inhoud van dit dokument.
Dit veld kan worden ingebed in het Scribus dokument, maar ook in de metadata van een PDF-lêer</translation>
    </message>
    <message>
        <source>A name given to the document.
This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="obsolete">Een naam vir dit dokument.
Dit veld kan worden ingebed in het Scribus dokument, maar ook in de metadata van een PDF-lêer</translation>
    </message>
    <message>
        <source>An account of the content of the document.
This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation type="obsolete">Een korte weergave van de inhoud van het dokument.
Dit wordt ook ingebed in PDF-lêers by exporteren</translation>
    </message>
    <message>
        <source>The topic of the content of the document.
This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation type="obsolete">De onderwerpen van het dokument.
Deze sleutelwoorden worden ingebed in de PDF om zoeken en indexeren van PDF-lêers mogelyk te maken</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="163"/>
        <source>A person or organisation responsible for making the document available</source>
        <translation>De persoon of organisatie die dit dokument beschikbaar maakt</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="164"/>
        <source>A person or organisation responsible for making contributions to the content of the document</source>
        <translation>Personen of organisaties die hebben bygedragen aan dit dokument</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="165"/>
        <source>A date associated with an event in the life cycle of the document, in YYYY-MM-DD format, as per ISO 8601</source>
        <translation>Datum die by het dokument hoort, byv. de aanmaakdatum, in JJJJ-MM-DD formaat, zoals in ISO 8601</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="166"/>
        <source>The nature or genre of the content of the document, eg. categories, functions, genres, etc</source>
        <translation>Genre, categorie of type van dit dokument</translation>
    </message>
    <message>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting.
RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation type="obsolete">De fysieke of digitale gestalte van het dokument, zoals mediatype en afmetingen.
RFC2045, RFC2046 vir MIME-lêerstypen zyn ook bruikbaar hier</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="168"/>
        <source>An unambiguous reference to the document within a given context such as ISBN or URI</source>
        <translation>Een exacte referentie na dit dokument, zoals een ISBN-nummer of een URI</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="169"/>
        <source>A reference to a document from which the present document is derived, eg. ISBN or URI</source>
        <translation>Een verwyzing na een dokument waar dit dokument van is afgelyk, byv. ISBN of een URI</translation>
    </message>
    <message>
        <source>The language in which the content of the document is written, usually a ISO-639 language code
optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation type="obsolete">De taal waarin het dokument is geschreven, normaal gesproken een ISO-639 taalcode,
optioneel gevolgd door een koppelteken en een ISO-3166 landcode, byv. en-GB, nl-BE</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="171"/>
        <source>A reference to a related document, possibly using a formal identifier such as a ISBN or URI</source>
        <translation>Een verwyzing na een gerelateerd dokument, mogelyk via een ISBN-nummer of URI</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="172"/>
        <source>The extent or scope of the content of the document, possibly including location, time and jurisdiction ranges</source>
        <translation>Het bereik dat door het dokument wordt omvat, byvoorbeeld in plaats, tyd of jurisdictie</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="173"/>
        <source>Information about rights held in and over the document, eg. copyright, patent or trademark</source>
        <translation>Informatie over rechten die vir dit dokument gelden, zoals copyright, patenten of handelsmerken</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="152"/>
        <source>Documen&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="159"/>
        <source>The person or organisation primarily responsible for making the content of the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="160"/>
        <source>A name given to the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="161"/>
        <source>An account of the content of the document. This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="162"/>
        <source>The topic of the content of the document. This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="167"/>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting. RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docinfo.cpp" line="170"/>
        <source>The language in which the content of the document is written, usually a ISO-639 language code optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocSections</name>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="72"/>
        <source>Add a page numbering section to the document. The new section will be added after the currently selected section.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="73"/>
        <source>Delete the currently selected section.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>1, 2, 3, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>i, ii, iii, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>I, II, III, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>a, b, c, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="87"/>
        <source>A, B, C, ...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="74"/>
        <source>&lt;b&gt;Name:&lt;/b&gt; Optional name for section eg. Index&lt;br/&gt;&lt;b&gt;Shown:&lt;/b&gt; Select to show the page numbers in this section if there is one or more text frames setup to do so.&lt;br/&gt;&lt;b&gt;From:&lt;/b&gt; The page index for this section to start at.&lt;br/&gt;&lt;b&gt;To:&lt;/b&gt; The page index for this section to stop at.&lt;br/&gt;&lt;b&gt;Style:&lt;/b&gt; Select the page number style to be used.&lt;br/&gt;&lt;b&gt;Start:&lt;/b&gt; The index within the Style&apos;s range to star at. Eg. If Start=2 and Style=a,b,c, ..., the numbers will begin at b. For the first section in the document this replaces the older First Page Number in the new file window.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="201"/>
        <source>Page Number Out Of Bounds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.cpp" line="201"/>
        <source>The value you have entered is outside the range of page numbers in the current document (%1-%2).</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="13"/>
        <source>Document Sections</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="83"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoeg</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="86"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="93"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="96"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="32"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="37"/>
        <source>Shown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="42"/>
        <source>From</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="47"/>
        <source>To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="52"/>
        <source>Style</source>
        <translation type="unfinished">Styl</translation>
    </message>
    <message>
        <location filename="../../../scribus/docsections.ui" line="57"/>
        <source>Start</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocSectionsBase</name>
    <message>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <source>Style</source>
        <translation type="obsolete">Styl</translation>
    </message>
    <message>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoeg</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributes</name>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Relates To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Parent Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Child Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Text Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Image Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Boolean</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Integer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>String</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="26"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="36"/>
        <source>Value</source>
        <translation type="unfinished">Waarde</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="82"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoeg</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="95"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>None</source>
        <comment>auto add</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>None</source>
        <comment>types</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Real Number</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="13"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="85"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="92"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="102"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="105"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="112"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="115"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="31"/>
        <source>Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="41"/>
        <source>Parameter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="46"/>
        <source>Relationship</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="51"/>
        <source>Relationship To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/docitemattrprefs.ui" line="56"/>
        <source>Auto Add To</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributesBase</name>
    <message>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <source>Value</source>
        <translation type="obsolete">Waarde</translation>
    </message>
    <message>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoeg</translation>
    </message>
    <message>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>EPSPlug</name>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="480"/>
        <source>Importing File:
%1
failed!</source>
        <translation>Invoer van lêer
%1
het misluk!</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="481"/>
        <source>Fatal Error</source>
        <translation>Fatale fout</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="879"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="85"/>
        <source>Analyzing PostScript:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="486"/>
        <source>Generating Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="878"/>
        <source>Converting of %1 images failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="282"/>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="709"/>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="745"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importps.cpp" line="82"/>
        <source>Importing: %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EditMacroDialog</name>
    <message>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <source>Alt+O</source>
        <translation type="obsolete">Atl+O</translation>
    </message>
</context>
<context>
    <name>EditStyle</name>
    <message>
        <source>Edit Style</source>
        <translation type="obsolete">Bewerk styl</translation>
    </message>
    <message>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Naam:</translation>
    </message>
    <message>
        <source>Character</source>
        <translation type="obsolete">Karakter</translation>
    </message>
    <message>
        <source>&amp;Font:</source>
        <translation type="obsolete">&amp;Lettertipe:</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source>Si&amp;ze:</source>
        <translation type="obsolete">&amp;Grootte:</translation>
    </message>
    <message>
        <source>Effect:</source>
        <translation type="obsolete">Effek:</translation>
    </message>
    <message>
        <source>&amp;Alignment:</source>
        <translation type="obsolete">&amp;Skouering:</translation>
    </message>
    <message>
        <source>&amp;Drop Caps</source>
        <translation type="obsolete">&amp;GrootHoof</translation>
    </message>
    <message>
        <source>&amp;Lines:</source>
        <translation type="obsolete">&amp;Lyne:</translation>
    </message>
    <message>
        <source>F&amp;ill Color:</source>
        <translation type="obsolete">&amp;Vulkleur:</translation>
    </message>
    <message>
        <source>St&amp;roke Color:</source>
        <translation type="obsolete">&amp;Lynkleur:</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>Vertical Spaces</source>
        <translation type="obsolete">Vertikale tussenruimtes</translation>
    </message>
    <message>
        <source>Adjust to Baseline &amp;Grid</source>
        <translation type="obsolete">Aanpas by basislyn &amp;rooster</translation>
    </message>
    <message>
        <source>Line &amp;Spacing:</source>
        <translation type="obsolete">Lyn&amp;spasiëring:</translation>
    </message>
    <message>
        <source>Abo&amp;ve:</source>
        <translation type="obsolete">&amp;Bo:</translation>
    </message>
    <message>
        <source>&amp;Below:</source>
        <translation type="obsolete">On&amp;der:</translation>
    </message>
    <message>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabs en induiking</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Name of your paragraph style</source>
        <translation type="obsolete">Naam van uw paragraafstyl</translation>
    </message>
    <message>
        <source>Font of selected text or object</source>
        <translation type="obsolete">Lettertype van object of geselecteerde teks</translation>
    </message>
    <message>
        <source>Font Size</source>
        <translation type="obsolete">Tekengrootte</translation>
    </message>
    <message>
        <source>Color of text fill</source>
        <translation type="obsolete">Kleur van de teksvulling</translation>
    </message>
    <message>
        <source>Color of text stroke</source>
        <translation type="obsolete">Kleur van de tekslynen</translation>
    </message>
    <message>
        <source>Provides an oversized first letter for a paragraph. Used for stylistic effect</source>
        <translation type="obsolete">Maakt de eerste letter van een paragraaf groter aan de bovenkant uitgelynd met het vervolg van een regel</translation>
    </message>
    <message>
        <source>Determines the overall height, in line numbers, of the Drop Caps</source>
        <translation type="obsolete">Geeft de hoogte van de kapitaal aan in het aantal regels dat deze beslaat</translation>
    </message>
    <message>
        <source>Align text to baseline grid</source>
        <translation type="obsolete">Teks aan de basislyn van het raster uitlynen</translation>
    </message>
    <message>
        <source>Spacing above the paragraph</source>
        <translation type="obsolete">Witruimte boven de paragraaf</translation>
    </message>
    <message>
        <source>Spacing below the paragraph</source>
        <translation type="obsolete">Witruimte onder de paragraaf</translation>
    </message>
    <message>
        <source>Line Spacing</source>
        <translation type="obsolete">Tussenruimte tussen die reëls</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>Name of the Style is not unique</source>
        <translation type="obsolete">Die stylnaam is nie uniek nie</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">Reg</translation>
    </message>
    <message>
        <source>Distances</source>
        <translation type="obsolete">Afstande</translation>
    </message>
    <message>
        <source>Background</source>
        <translation type="obsolete">Agtergrond</translation>
    </message>
</context>
<context>
    <name>EditToolBar</name>
    <message>
        <location filename="../../../scribus/ui/edittoolbar.cpp" line="29"/>
        <source>Edit</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Editor</name>
    <message>
        <location filename="../../../scribus/editor.cpp" line="30"/>
        <source>Editor</source>
        <translation>Bewerker</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="36"/>
        <source>&amp;New</source>
        <translation>&amp;Nuwe</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="39"/>
        <source>&amp;Open...</source>
        <translation>&amp;Maak oop...</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="41"/>
        <source>Save &amp;As...</source>
        <translation>Stoor &amp;as...</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="43"/>
        <source>&amp;Save and Exit</source>
        <translation>&amp;Stoor en gaan uit</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="45"/>
        <source>&amp;Exit without Saving</source>
        <translation>&amp;Gaan uit sonder om te stoor</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="47"/>
        <source>&amp;Undo</source>
        <translation>&amp;Ongedaanmaak</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="50"/>
        <source>&amp;Redo</source>
        <translation>&amp;Weer gedaanmaak</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="52"/>
        <source>Cu&amp;t</source>
        <translation>Kni&amp;p</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="55"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopiër</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="58"/>
        <source>&amp;Paste</source>
        <translation>P&amp;lak</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="61"/>
        <source>C&amp;lear</source>
        <translation>W&amp;is</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="63"/>
        <source>&amp;Get Field Names</source>
        <translation>&amp;Kry Veldname</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="65"/>
        <source>&amp;File</source>
        <translation>&amp;Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="72"/>
        <source>&amp;Edit</source>
        <translation>Be&amp;werk</translation>
    </message>
    <message>
        <source>Javascripts (*.js);;All Files (*)</source>
        <translation type="obsolete">Javascripts (*.js);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="111"/>
        <location filename="../../../scribus/editor.cpp" line="127"/>
        <source>JavaScripts (*.js);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="37"/>
        <source>Ctrl+N</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="48"/>
        <source>Ctrl+Z</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="53"/>
        <source>Ctrl+X</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="56"/>
        <source>Ctrl+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/editor.cpp" line="59"/>
        <source>Ctrl-V</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EffectsDialog</name>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="45"/>
        <source>Image Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="82"/>
        <source>Options:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="99"/>
        <source>Color:</source>
        <translation type="unfinished">Kleur:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="110"/>
        <source>Shade:</source>
        <translation type="unfinished">Skadu:</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="126"/>
        <source>Brightness:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="148"/>
        <source>Contrast:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="170"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="199"/>
        <source>Radius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="181"/>
        <source>Value:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="217"/>
        <source>Posterize:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="456"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="473"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="501"/>
        <source>Available Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="460"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="542"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="779"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="841"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1296"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1418"/>
        <source>Blur</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="461"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="527"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="764"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="835"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1247"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1396"/>
        <source>Brightness</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="462"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="518"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="759"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="845"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="987"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1387"/>
        <source>Colorize</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="466"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="532"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="769"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="837"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1263"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1402"/>
        <source>Contrast</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="467"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="513"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="754"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="833"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="983"/>
        <source>Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="469"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="508"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="749"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="831"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="985"/>
        <source>Invert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="470"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="552"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="787"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="843"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1308"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1431"/>
        <source>Posterize</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="471"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="537"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="774"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="839"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1279"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1408"/>
        <source>Sharpen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="483"/>
        <source>&gt;&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="487"/>
        <source>&lt;&lt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="498"/>
        <source>Effects in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="617"/>
        <source>OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="621"/>
        <source>Cancel</source>
        <translation type="unfinished">Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="236"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="286"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="352"/>
        <source>Color 1:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="257"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="306"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="372"/>
        <source>Color 2:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="326"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="392"/>
        <source>Color 3:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="412"/>
        <source>Color 4:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="463"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="557"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="792"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="856"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1004"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1437"/>
        <source>Duotone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="464"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="566"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="797"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="867"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1062"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1473"/>
        <source>Tritone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="465"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="575"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="802"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="878"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="900"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1143"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1524"/>
        <source>Quadtone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/effectsdialog.cpp" line="468"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="584"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="807"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="889"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1324"/>
        <location filename="../../../scribus/effectsdialog.cpp" line="1590"/>
        <source>Curves</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ExportBitmap</name>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="204"/>
        <source>File exists. Overwrite?</source>
        <translation type="unfinished">Lêer bestaan. Oorskryf?</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="205"/>
        <source>exists already. Overwrite?</source>
        <translation type="unfinished">bestaat alreeds. Oorskryf?</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="191"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="218"/>
        <source>Save as Image</source>
        <translation type="unfinished">Stoor as prent</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="191"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="192"/>
        <source>Insufficient memory for this image size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="218"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="219"/>
        <source>Error writing the output file(s).</source>
        <translation type="unfinished">Fout tydens het skryf na uitvoerlêer(s).</translation>
    </message>
</context>
<context>
    <name>ExportForm</name>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="80"/>
        <source>Choose a Export Directory</source>
        <translation>Kies uitvoer gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="13"/>
        <source>Export as Image(s)</source>
        <translation>Voer as beeld(e) uit</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="153"/>
        <source>&amp;Export to Directory:</source>
        <translation>&amp;Voer na gids uit</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="166"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Wyzigen...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="25"/>
        <source>Options</source>
        <translation>Opties</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="54"/>
        <source>Image &amp;Type:</source>
        <translation>Afbeeldings&amp;type:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="64"/>
        <source>&amp;Quality:</source>
        <translation>&amp;Kwaliteit:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="74"/>
        <source>&amp;Resolution:</source>
        <translation>&amp;Resolusie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="94"/>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="126"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="110"/>
        <source> dpi</source>
        <translation>dpi</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="175"/>
        <source>Range</source>
        <translation>Bereik</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="197"/>
        <source>&amp;Current page</source>
        <translation>Huidige bl&amp;adsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="224"/>
        <source>&amp;All pages</source>
        <translation>Alle &amp;bladsy(e)</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="217"/>
        <source>&amp;Range</source>
        <translation>&amp;Bereik</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="117"/>
        <source>Export a range of pages</source>
        <translation>Voer bereik van bladsye uit</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="118"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation>Kies bladsy nommers. 1,3,4,6 of 1-4 vir 1 tot 4 
of * vir almal.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="119"/>
        <source>Export all pages</source>
        <translation>Voer alle bladsye uit</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="120"/>
        <source>Export only the current page</source>
        <translation>Voer net huidige bladsy uit</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="121"/>
        <source>Resolution of the Images
Use 72 dpi for Images intended for the Screen</source>
        <translation>Resolusie van beelde. 
Gebruik 72dpi vir beelde bedoel vir skerms</translation>
    </message>
    <message>
        <source>The quality of your images - 100% is the best, 1% the lowest quality</source>
        <translation type="obsolete">Beeldkwaliteit: 100% vir beste, 1% vir swakste kwaliteit</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="125"/>
        <source>Available export formats</source>
        <translation>Beskikbare uitvoerformate</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="126"/>
        <source>The output directory - the place to store your images.
Name of the export file will be &apos;documentname-pagenumber.filetype&apos;</source>
        <translation>Uitvoergids - die plek om beelde te stoor. 
Uitvoerlêernaam gaan &apos;dokumentnaam-bladsynommer.lêertipe&apos; wees</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="127"/>
        <source>Change the output directory</source>
        <translation>Wysig uitvoergids</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="84"/>
        <source>&amp;Size:</source>
        <translation>&amp;Grootte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="122"/>
        <source>Size of the images. 100% for no changes, 200% for two times larger etc.</source>
        <translation>Beeldgrootte. 100% geen verandering, 200% twee maal groter.</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="44"/>
        <source>Image size in Pixels</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/exportform.ui" line="37"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="123"/>
        <source>The compression ratio of your images - 100% is no compression, 0% highest compression. If in doubt, use &apos;Automatic&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/dialog.cpp" line="124"/>
        <source>Automatic</source>
        <translation type="unfinished">Outomaties</translation>
    </message>
</context>
<context>
    <name>ExtImageProps</name>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="39"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="50"/>
        <location filename="../../../scribus/extimageprops.cpp" line="68"/>
        <location filename="../../../scribus/extimageprops.cpp" line="102"/>
        <source>Normal</source>
        <translation type="unfinished">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="51"/>
        <location filename="../../../scribus/extimageprops.cpp" line="69"/>
        <location filename="../../../scribus/extimageprops.cpp" line="103"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="52"/>
        <location filename="../../../scribus/extimageprops.cpp" line="70"/>
        <location filename="../../../scribus/extimageprops.cpp" line="104"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="53"/>
        <location filename="../../../scribus/extimageprops.cpp" line="71"/>
        <location filename="../../../scribus/extimageprops.cpp" line="105"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="54"/>
        <location filename="../../../scribus/extimageprops.cpp" line="72"/>
        <location filename="../../../scribus/extimageprops.cpp" line="106"/>
        <source>Saturation</source>
        <translation type="unfinished">Versadiging</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="55"/>
        <location filename="../../../scribus/extimageprops.cpp" line="73"/>
        <location filename="../../../scribus/extimageprops.cpp" line="107"/>
        <source>Color</source>
        <translation type="unfinished">Kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="56"/>
        <location filename="../../../scribus/extimageprops.cpp" line="74"/>
        <location filename="../../../scribus/extimageprops.cpp" line="108"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="57"/>
        <location filename="../../../scribus/extimageprops.cpp" line="75"/>
        <location filename="../../../scribus/extimageprops.cpp" line="109"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="58"/>
        <location filename="../../../scribus/extimageprops.cpp" line="76"/>
        <location filename="../../../scribus/extimageprops.cpp" line="110"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="59"/>
        <location filename="../../../scribus/extimageprops.cpp" line="77"/>
        <location filename="../../../scribus/extimageprops.cpp" line="111"/>
        <source>Dissolve</source>
        <translation type="unfinished">Oplos</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="60"/>
        <location filename="../../../scribus/extimageprops.cpp" line="78"/>
        <location filename="../../../scribus/extimageprops.cpp" line="112"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="61"/>
        <location filename="../../../scribus/extimageprops.cpp" line="79"/>
        <location filename="../../../scribus/extimageprops.cpp" line="113"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="62"/>
        <location filename="../../../scribus/extimageprops.cpp" line="80"/>
        <location filename="../../../scribus/extimageprops.cpp" line="114"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="63"/>
        <location filename="../../../scribus/extimageprops.cpp" line="81"/>
        <location filename="../../../scribus/extimageprops.cpp" line="115"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="64"/>
        <location filename="../../../scribus/extimageprops.cpp" line="82"/>
        <location filename="../../../scribus/extimageprops.cpp" line="116"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="65"/>
        <location filename="../../../scribus/extimageprops.cpp" line="83"/>
        <location filename="../../../scribus/extimageprops.cpp" line="117"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="66"/>
        <location filename="../../../scribus/extimageprops.cpp" line="84"/>
        <location filename="../../../scribus/extimageprops.cpp" line="118"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="98"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="121"/>
        <source>Opacity:</source>
        <translation type="unfinished">Ondeursigtigheid:</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="127"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="133"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <source>Background</source>
        <translation type="obsolete">Agtergrond</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="214"/>
        <source>Layers</source>
        <translation type="unfinished">Lae</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="267"/>
        <source>Don&apos;t use any Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="269"/>
        <source>Paths</source>
        <translation type="unfinished">Paaie</translation>
    </message>
    <message>
        <location filename="../../../scribus/extimageprops.cpp" line="276"/>
        <source>Live Preview</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FDialogPreview</name>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="198"/>
        <source>Size:</source>
        <translation>Grootte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="216"/>
        <source>Title:</source>
        <translation>Titel:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="219"/>
        <source>No Title</source>
        <translation>Geen titel</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="221"/>
        <source>Author:</source>
        <translation>Outeur:</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="202"/>
        <location filename="../../../scribus/customfdialog.cpp" line="224"/>
        <location filename="../../../scribus/customfdialog.cpp" line="229"/>
        <source>Unknown</source>
        <translation>Onbekend</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="231"/>
        <source>Scribus Document</source>
        <translation>Scribus dokument</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="199"/>
        <source>Resolution:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="199"/>
        <source>DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="205"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/customfdialog.cpp" line="226"/>
        <source>File Format:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Farbmanager</name>
    <message>
        <source>Colors</source>
        <translation type="obsolete">Kleure</translation>
    </message>
    <message>
        <source>&amp;Append</source>
        <translation type="obsolete">Toe&amp;voeg</translation>
    </message>
    <message>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Nuwe</translation>
    </message>
    <message>
        <source>&amp;Edit</source>
        <translation type="obsolete">Be&amp;werk</translation>
    </message>
    <message>
        <source>D&amp;uplicate</source>
        <translation type="obsolete">D&amp;upliseer</translation>
    </message>
    <message>
        <source>&amp;Delete</source>
        <translation type="obsolete">Verwy&amp;der</translation>
    </message>
    <message>
        <source>&amp;Remove Unused</source>
        <translation type="obsolete">Ve&amp;rwyder ongebruikte</translation>
    </message>
    <message>
        <source>Color Sets</source>
        <translation type="obsolete">Kleurstelle</translation>
    </message>
    <message>
        <source>Current Color Set:</source>
        <translation type="obsolete">Huidige kleurstel:</translation>
    </message>
    <message>
        <source>&amp;Save Color Set</source>
        <translation type="obsolete">&amp;Stoor kleurstel</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Choose a color set to load</source>
        <translation type="obsolete">Kies kleurstel om te laai</translation>
    </message>
    <message>
        <source>Save the current color set</source>
        <translation type="obsolete">Stoor huidige kleurstel</translation>
    </message>
    <message>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation type="obsolete">Verwyder ongebruikte kleure uit dokument se kleurstel</translation>
    </message>
    <message>
        <source>Append colors to the current set from an existing document</source>
        <translation type="obsolete">Voeg van &apos;n ander dokument se kleure by huidige dokument sin</translation>
    </message>
    <message>
        <source>Create a new color within the current set</source>
        <translation type="obsolete">Maak &apos;n nuwe kleur in huidige kleurstel</translation>
    </message>
    <message>
        <source>Edit the currently selected color</source>
        <translation type="obsolete">Verander gekiesde kleur</translation>
    </message>
    <message>
        <source>Make a copy of the currently selected color</source>
        <translation type="obsolete">Maak &apos;n kopie van huidiglik gekiesde kleur</translation>
    </message>
    <message>
        <source>Delete the currently selected color</source>
        <translation type="obsolete">Verwyder huidig gekiesde kleur</translation>
    </message>
    <message>
        <source>Make the current colorset the default color set</source>
        <translation type="obsolete">Maak huidige kleurstel die verstek</translation>
    </message>
    <message>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Naam:</translation>
    </message>
    <message>
        <source>Choose a Name</source>
        <translation type="obsolete">Kies &apos;n naam</translation>
    </message>
    <message>
        <source>Open</source>
        <translation type="obsolete">Maak oop</translation>
    </message>
    <message>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Dokumente (*.sla *.sla.gz *.scd *.scd.gz);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Dokumente (*.sla *.scd);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Copy of %1</source>
        <translation type="obsolete">Kopie van %1</translation>
    </message>
    <message>
        <source>New Color</source>
        <translation type="obsolete">Nuwe kleur</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Voer in</translation>
    </message>
</context>
<context>
    <name>FileLoader</name>
    <message>
        <location filename="../../../scribus/fileloader.cpp" line="594"/>
        <source>Some fonts used by this document have been substituted:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fileloader.cpp" line="598"/>
        <source> was replaced by: </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FileToolBar</name>
    <message>
        <location filename="../../../scribus/ui/filetoolbar.cpp" line="31"/>
        <source>File</source>
        <translation type="unfinished">Lêer</translation>
    </message>
</context>
<context>
    <name>FontComboH</name>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="148"/>
        <source>Family:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="149"/>
        <source>Style:</source>
        <translation type="unfinished">Styl:</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="151"/>
        <source>Font Family of Selected Text or Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontcombo.cpp" line="152"/>
        <source>Font Style of Selected Text or Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontListModel</name>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="63"/>
        <source>Font Name</source>
        <translation type="unfinished">Lettertipe Naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="65"/>
        <source>Use Font</source>
        <translation type="unfinished">Gebruik Lettertipe</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="67"/>
        <source>Family</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="69"/>
        <source>Style</source>
        <translation type="unfinished">Styl</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="71"/>
        <source>Variant</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="73"/>
        <source>Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="75"/>
        <source>Format</source>
        <translation type="unfinished">Formaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="77"/>
        <source>Embed in PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="79"/>
        <source>Subset</source>
        <translation type="unfinished">Substel</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="81"/>
        <source>Access</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="83"/>
        <source>Used in Doc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="85"/>
        <source>Path to Font File</source>
        <translation type="unfinished">Pad na lettertipelêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="144"/>
        <source>Unknown</source>
        <comment>font type</comment>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="157"/>
        <source>Unknown</source>
        <comment>font format</comment>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="164"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="165"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontlistmodel.cpp" line="190"/>
        <source>Click to change the value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPrefs</name>
    <message>
        <source>Global Font Settings</source>
        <translation type="obsolete">Programwye lettertipe-instellings</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="48"/>
        <source>Available Fonts</source>
        <translation>Beskikbare lettertipes</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="48"/>
        <source>Font Substitutions</source>
        <translation>Lettertipe-vervangings</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="48"/>
        <source>Additional Paths</source>
        <translation>Additionele lokasies</translation>
    </message>
    <message>
        <source>Postscript</source>
        <translation type="obsolete">Postscript</translation>
    </message>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="66"/>
        <source>Font Name</source>
        <translation>Lettertipe Naam</translation>
    </message>
    <message>
        <source>Use Font</source>
        <translation type="obsolete">Gebruik Lettertipe</translation>
    </message>
    <message>
        <source>Embed in:</source>
        <translation type="obsolete">Inbed in:</translation>
    </message>
    <message>
        <source>Subset</source>
        <translation type="obsolete">Substel</translation>
    </message>
    <message>
        <source>Type</source>
        <translation type="obsolete">Tipe</translation>
    </message>
    <message>
        <source>Path to Font File</source>
        <translation type="obsolete">Pad na lettertipelêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="58"/>
        <source>&amp;Available Fonts</source>
        <translation>Beskikbare &amp;lettertipes</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="67"/>
        <source>Replacement</source>
        <translation>Vervanging</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="82"/>
        <source>&amp;Delete</source>
        <translation>Verwy&amp;der</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="88"/>
        <source>Font &amp;Substitutions</source>
        <translation>Lettertipe-&amp;vervanging</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="107"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Wysig...</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="109"/>
        <source>A&amp;dd...</source>
        <translation>&amp;Toevoeg...</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="111"/>
        <source>&amp;Remove</source>
        <translation>Ve&amp;rwyder</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="135"/>
        <source>Additional &amp;Paths</source>
        <translation>Additionele &amp;paaie</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="222"/>
        <location filename="../../../scribus/fontprefs.cpp" line="247"/>
        <source>Choose a Directory</source>
        <translation>Kies &apos;n gids</translation>
    </message>
    <message>
        <source>Font Name</source>
        <comment>font preview</comment>
        <translation type="obsolete">Lettertipe Naam</translation>
    </message>
    <message>
        <source>Use Font</source>
        <comment>font preview</comment>
        <translation type="obsolete">Gebruik Lettertipe</translation>
    </message>
    <message>
        <source>Embed in:</source>
        <comment>font preview</comment>
        <translation type="obsolete">Inbed in:</translation>
    </message>
    <message>
        <source>Subset</source>
        <comment>font preview</comment>
        <translation type="obsolete">Substel</translation>
    </message>
    <message>
        <source>Path to Font File</source>
        <comment>font preview</comment>
        <translation type="obsolete">Pad na lettertipelêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/fontprefs.cpp" line="128"/>
        <source>Font search paths can only be set in File &gt; Preferences, and only when there is no document currently open. Close any open documents, then use File &gt; Preferences &gt; Fonts to change the font search path.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreview</name>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="13"/>
        <source>Fonts Preview</source>
        <translation type="unfinished">Lettertipe voorbeeld</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>Alt+O</source>
        <translation type="obsolete">Atl+O</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="170"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <translation type="obsolete">Filmquiz bracht knappe ex-yogi van de wys</translation>
    </message>
    <message>
        <source>Append selected font into Style, Font menu</source>
        <translation type="obsolete">Voeg gekose lettertipe in styl, Lettertipe kieskaart in</translation>
    </message>
    <message>
        <source>Leave preview</source>
        <translation type="obsolete">Verlaat voorbeeld</translation>
    </message>
    <message>
        <source>Font Name</source>
        <comment>font preview</comment>
        <translation type="obsolete">Lettertipe Naam</translation>
    </message>
    <message>
        <source>Subset</source>
        <comment>font preview</comment>
        <translation type="obsolete">Substel</translation>
    </message>
    <message>
        <source>Fonts Preview</source>
        <comment>font preview</comment>
        <translation type="obsolete">Lettertipe voorbeeld</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <comment>font preview</comment>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>Alt+O</source>
        <comment>font preview</comment>
        <translation type="obsolete">Atl+O</translation>
    </message>
    <message>
        <source>Alt+C</source>
        <comment>font preview</comment>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <source>Append selected font into Style, Font menu</source>
        <comment>font preview</comment>
        <translation type="obsolete">Voeg gekose lettertipe in styl, Lettertipe kieskaart in</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="111"/>
        <source>Leave preview</source>
        <comment>font preview</comment>
        <translation type="unfinished">Verlaat voorbeeld</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <comment>font preview</comment>
        <translation type="unfinished">Filmquiz bracht knappe ex-yogi van de wys</translation>
    </message>
    <message>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="113"/>
        <source>Size of the selected font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Font Name</source>
        <translation type="obsolete">Lettertipe Naam</translation>
    </message>
    <message>
        <source>Subset</source>
        <translation type="obsolete">Substel</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="19"/>
        <source>&amp;Quick Search:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="80"/>
        <source>&amp;Font Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="103"/>
        <source>Text</source>
        <translation type="unfinished">Teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="113"/>
        <source>Sample text to display</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="123"/>
        <source>Se&amp;t</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="126"/>
        <source>Alt+T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="133"/>
        <source>Reset the text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="167"/>
        <source>&amp;Close</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.cpp" line="112"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. The given text is taken as substring.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="136"/>
        <source>&amp;Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>Show Extended Font Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreview.ui" line="120"/>
        <source>Set the preview text</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreviewBase</name>
    <message>
        <source>Fonts Preview</source>
        <translation type="obsolete">Lettertipe voorbeeld</translation>
    </message>
    <message>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
    <message>
        <source>Font Name</source>
        <translation type="obsolete">Lettertipe Naam</translation>
    </message>
    <message>
        <source>Subset</source>
        <translation type="obsolete">Substel</translation>
    </message>
    <message>
        <source>Text</source>
        <translation type="obsolete">Teks</translation>
    </message>
    <message>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>FontPreviewPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="49"/>
        <source>&amp;Font Preview...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="66"/>
        <source>Font Preview dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="67"/>
        <source>Sorting, searching and browsing available fonts.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontReplaceDialog</name>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="30"/>
        <source>Font Substitution</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="45"/>
        <source>Original Font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="46"/>
        <source>Substitution Font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="72"/>
        <source>Make these substitutions permanent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="40"/>
        <source>This document contains some fonts that are not installed on your system, please choose a suitable replacement for them. Cancel will stop the document from loading.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="83"/>
        <source>Cancels these font substitutions and stops loading the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="84"/>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in Edit &gt; Preferences &gt; Fonts.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/fontreplacedialog.cpp" line="85"/>
        <source>If you select OK, then save, these substitutions are made permanent in the document.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GradientEditor</name>
    <message>
        <location filename="../../../scribus/gradienteditor.cpp" line="327"/>
        <source>Position:</source>
        <translation>Posisie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/gradienteditor.cpp" line="328"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <source>Here you can add, change or remove Color-Stops.</source>
        <translation type="obsolete">Hier kan u kleur-stops toevoeg, bewerk of verwyder.</translation>
    </message>
    <message>
        <location filename="../../../scribus/gradienteditor.cpp" line="336"/>
        <source>Add, change or remove color stops here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GradientVectorDialog</name>
    <message>
        <location filename="../../../scribus/cpalette.cpp" line="100"/>
        <source>Gradient Vector</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManager</name>
    <message>
        <source>Manage Guides</source>
        <translation type="obsolete">Bestuur hulplyne</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source>Horizontal Guides</source>
        <translation type="obsolete">Horisontale hulplyne</translation>
    </message>
    <message>
        <source>&amp;Y-Pos:</source>
        <translation type="obsolete">&amp;Y-pos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="229"/>
        <location filename="../../../scribus/guidemanager.ui" line="55"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoeg</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="230"/>
        <location filename="../../../scribus/guidemanager.ui" line="65"/>
        <source>D&amp;elete</source>
        <translation type="unfinished">V&amp;erwyder</translation>
    </message>
    <message>
        <source>Vertical Guides</source>
        <translation type="obsolete">Vertikale hulplyne</translation>
    </message>
    <message>
        <source>&amp;X-Pos:</source>
        <translation type="obsolete">&amp;X-pos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="231"/>
        <location filename="../../../scribus/guidemanager.ui" line="94"/>
        <source>A&amp;dd</source>
        <translation type="unfinished">Toe&amp;voeg</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="232"/>
        <location filename="../../../scribus/guidemanager.ui" line="104"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">Ve&amp;rwyder</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="233"/>
        <location filename="../../../scribus/guidemanager.ui" line="119"/>
        <source>&amp;Lock Guides</source>
        <translation type="unfinished">S&amp;luit Hulplyne</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="243"/>
        <location filename="../../../scribus/guidemanager.cpp" line="246"/>
        <location filename="../../../scribus/guidemanager.ui" line="194"/>
        <location filename="../../../scribus/guidemanager.ui" line="281"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Bladsy</translation>
    </message>
    <message>
        <source>Preview</source>
        <translation type="obsolete">Voorbeeld</translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="224"/>
        <location filename="../../../scribus/guidemanager.ui" line="31"/>
        <source>&amp;Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="227"/>
        <location filename="../../../scribus/guidemanager.cpp" line="235"/>
        <location filename="../../../scribus/guidemanager.ui" line="39"/>
        <location filename="../../../scribus/guidemanager.ui" line="146"/>
        <source>Horizontals</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="58"/>
        <location filename="../../../scribus/guidemanager.ui" line="210"/>
        <location filename="../../../scribus/guidemanager.ui" line="297"/>
        <location filename="../../../scribus/guidemanager.ui" line="356"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="68"/>
        <location filename="../../../scribus/guidemanager.ui" line="220"/>
        <location filename="../../../scribus/guidemanager.ui" line="307"/>
        <source>Alt+E</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="228"/>
        <location filename="../../../scribus/guidemanager.cpp" line="236"/>
        <location filename="../../../scribus/guidemanager.ui" line="78"/>
        <location filename="../../../scribus/guidemanager.ui" line="233"/>
        <source>Verticals</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="97"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="107"/>
        <location filename="../../../scribus/guidemanager.ui" line="122"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="234"/>
        <location filename="../../../scribus/guidemanager.cpp" line="249"/>
        <location filename="../../../scribus/guidemanager.ui" line="129"/>
        <location filename="../../../scribus/guidemanager.ui" line="320"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="132"/>
        <location filename="../../../scribus/guidemanager.ui" line="323"/>
        <source>Alt+Y</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="225"/>
        <location filename="../../../scribus/guidemanager.ui" line="140"/>
        <source>&amp;Column/Row</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="237"/>
        <location filename="../../../scribus/guidemanager.ui" line="152"/>
        <source>&amp;Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="239"/>
        <location filename="../../../scribus/guidemanager.ui" line="175"/>
        <source>U&amp;se Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="178"/>
        <source>Alt+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="197"/>
        <location filename="../../../scribus/guidemanager.ui" line="284"/>
        <location filename="../../../scribus/guidemanager.ui" line="343"/>
        <source>Alt+P</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="244"/>
        <location filename="../../../scribus/guidemanager.cpp" line="247"/>
        <location filename="../../../scribus/guidemanager.ui" line="207"/>
        <location filename="../../../scribus/guidemanager.ui" line="294"/>
        <source>M&amp;argins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="245"/>
        <location filename="../../../scribus/guidemanager.cpp" line="248"/>
        <location filename="../../../scribus/guidemanager.ui" line="217"/>
        <location filename="../../../scribus/guidemanager.ui" line="304"/>
        <source>S&amp;election</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="238"/>
        <location filename="../../../scribus/guidemanager.ui" line="239"/>
        <source>Nu&amp;mber:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="240"/>
        <location filename="../../../scribus/guidemanager.ui" line="262"/>
        <source>Use &amp;Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="265"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="226"/>
        <location filename="../../../scribus/guidemanager.ui" line="331"/>
        <source>&amp;Misc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="337"/>
        <source>Delete all guides from the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="250"/>
        <location filename="../../../scribus/guidemanager.ui" line="340"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.ui" line="350"/>
        <source>Delete all guides from the current document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="251"/>
        <location filename="../../../scribus/guidemanager.ui" line="353"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="223"/>
        <location filename="../../../scribus/guidemanager.ui" line="15"/>
        <source>Guide Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="253"/>
        <source>Add a new horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="254"/>
        <source>Delete the selected horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="255"/>
        <source>Add a new vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="256"/>
        <source>Delete the selected vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="257"/>
        <source>Lock the guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="258"/>
        <source>Apply to all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="259"/>
        <source>Number of horizontal guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="260"/>
        <source>Number of vertical guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="261"/>
        <source>Create rows with guides, with an additional gap between the rows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="262"/>
        <source>Create columns with guides, with an additional gap between the columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="263"/>
        <source>Create the selected number of horizontal guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="264"/>
        <source>Create the selected number of horizontal guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="265"/>
        <source>Create the selected number of horizontal guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="266"/>
        <source>Create the selected number of vertical guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="267"/>
        <source>Create the selected number of vertical guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="268"/>
        <source>Create the selected number of vertical guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="269"/>
        <source>Apply the shown guides to all pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="270"/>
        <source>Delete all guides shown on the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="271"/>
        <source>Delete all guides from all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/guidemanager.cpp" line="241"/>
        <location filename="../../../scribus/guidemanager.cpp" line="242"/>
        <location filename="../../../scribus/guidemanager.ui" line="188"/>
        <location filename="../../../scribus/guidemanager.ui" line="275"/>
        <source>Refer to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManagerBase</name>
    <message>
        <source>Manage Guides</source>
        <translation type="obsolete">Bestuur hulplyne</translation>
    </message>
    <message>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoeg</translation>
    </message>
    <message>
        <source>D&amp;elete</source>
        <translation type="obsolete">V&amp;erwyder</translation>
    </message>
    <message>
        <source>A&amp;dd</source>
        <translation type="obsolete">Toe&amp;voeg</translation>
    </message>
    <message>
        <source>De&amp;lete</source>
        <translation type="obsolete">Ve&amp;rwyder</translation>
    </message>
    <message>
        <source>&amp;Lock Guides</source>
        <translation type="obsolete">S&amp;luit Hulplyne</translation>
    </message>
    <message>
        <source>&amp;Page</source>
        <translation type="obsolete">&amp;Bladsy</translation>
    </message>
</context>
<context>
    <name>HelpBrowser</name>
    <message>
        <source>Sorry, no manual available! Please see: http://docs.scribus.net for updated docs
and www.scribus.net for downloads.</source>
        <translation type="obsolete">Helaas, geen handleiding beskikbaar! Kyk op http://docs.scribus.net/ vir bygewerkte dokumentasie en op http://www.scribus.net/ vir downloads.</translation>
    </message>
    <message>
        <source>Contents</source>
        <translation type="obsolete">Inhoud</translation>
    </message>
    <message>
        <source>Link</source>
        <translation type="obsolete">Skakel</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="287"/>
        <source>Scribus Online Help</source>
        <translation>Scribus aanlyn hulp</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="31"/>
        <source>&amp;Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="60"/>
        <source>&amp;Search</source>
        <translation type="unfinished">&amp;Zoeken</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="45"/>
        <source>Se&amp;arch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="96"/>
        <source>&amp;New</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="299"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="103"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="178"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="79"/>
        <source>Book&amp;marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="293"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="148"/>
        <source>&amp;Print...</source>
        <translation type="unfinished">Afdru&amp;kken...</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="378"/>
        <source>Find</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="378"/>
        <source>Search Term:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="410"/>
        <source>New Bookmark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="410"/>
        <source>New Bookmark&apos;s Title:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="289"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="295"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="158"/>
        <source>&amp;Find...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="296"/>
        <source>Find &amp;Next</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="297"/>
        <source>Find &amp;Previous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="290"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="298"/>
        <source>&amp;Add Bookmark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="300"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="110"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="183"/>
        <source>D&amp;elete All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="291"/>
        <source>&amp;Bookmarks</source>
        <translation type="unfinished">&amp;Bladwyzers</translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="13"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="137"/>
        <source>Scribus Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="53"/>
        <source>Searching is case insensitive</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="70"/>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="86"/>
        <source>1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="153"/>
        <source>&amp;Exit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="163"/>
        <source>Find &amp;Next...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="168"/>
        <source>Find &amp;Previous...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/helpbrowser.ui" line="173"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoeg</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="294"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">A&amp;fsluiten</translation>
    </message>
    <message>
        <location filename="../../../scribus/helpbrowser.cpp" line="715"/>
        <source>&lt;h2&gt;&lt;p&gt;Sorry, no manual is installed!&lt;/p&gt;&lt;p&gt;Please see:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;http://docs.scribus.net for updated documentation&lt;/li&gt;&lt;li&gt;http://www.scribus.net for downloads&lt;/li&gt;&lt;/ul&gt;&lt;/h2&gt;</source>
        <comment>HTML message for no documentation available to show</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HelpBrowser2</name>
    <message>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Zoeken</translation>
    </message>
</context>
<context>
    <name>HyAsk</name>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="48"/>
        <source>Possible Hyphenation</source>
        <translation>Moontlike afkapping</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="68"/>
        <source>Accept</source>
        <translation>Aanvaar</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="89"/>
        <source>Skip</source>
        <translation>Oorslaan</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="107"/>
        <source>Cancel</source>
        <translation>Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="77"/>
        <source>Add to the
Exception List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/hyask.cpp" line="97"/>
        <source>Add to the
Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HySettings</name>
    <message>
        <source>Hyphenator Settings</source>
        <translation type="obsolete">Afkapinstellings</translation>
    </message>
    <message>
        <source>&amp;Language:</source>
        <translation type="obsolete">&amp;Taal:</translation>
    </message>
    <message>
        <source>&amp;Smallest Word:</source>
        <translation type="obsolete">&amp;Kleinste woord:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Length of the smallest word to be hyphenated.</source>
        <translation type="obsolete">Lengte van korste afkapbare woord.</translation>
    </message>
    <message>
        <source>Maximum number of Hyphenations following each other.
A value of 0 means unlimited hyphenations.</source>
        <translation type="obsolete">Maksimum aantal opeenvolgende afkappings.
0 beteken onbeperk.</translation>
    </message>
    <message>
        <source>&amp;Hyphenation Suggestions</source>
        <translation type="obsolete">A&amp;fkapvoorstelle</translation>
    </message>
    <message>
        <source>Hyphenate Text Automatically &amp;During Typing</source>
        <translation type="obsolete">Kap woorde ty&amp;dens tik af</translation>
    </message>
    <message>
        <source>A dialog box showing all possible hyphens for each word will show up when you use the Extras, Hyphenate Text option.</source>
        <translation type="obsolete">Met opsie Ekstra, Teksafkap kry u n dialoogvenster met alle afkapmoontlikhede vir elke woord.</translation>
    </message>
    <message>
        <source>Enables automatic hyphenation of your text while typing.</source>
        <translation type="obsolete">Sit intydse -terwyl jy tik- afkapping aan.</translation>
    </message>
    <message>
        <source>Consecutive Hyphenations &amp;Allowed:</source>
        <translation type="obsolete">Opeenvolgende &amp;afkappings toegelaat:</translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="80"/>
        <location filename="../../../scribus/hysettings.cpp" line="92"/>
        <source>Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="80"/>
        <location filename="../../../scribus/hysettings.cpp" line="121"/>
        <source>Add a new Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="92"/>
        <location filename="../../../scribus/hysettings.cpp" line="133"/>
        <source>Edit Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/hysettings.cpp" line="121"/>
        <location filename="../../../scribus/hysettings.cpp" line="133"/>
        <source>Exception List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImageInfoDialog</name>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="23"/>
        <source>Image Info</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="30"/>
        <source>General Info</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="34"/>
        <source>Date / Time:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="38"/>
        <source>Has Embedded Profile:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <source>No</source>
        <translation type="obsolete">Nee</translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="46"/>
        <source>Profile Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="50"/>
        <source>Has Embedded Paths:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="58"/>
        <source>Has Layers:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="69"/>
        <source>EXIF Info</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="84"/>
        <source>Artist:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="126"/>
        <source>Comment:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="127"/>
        <source>User Comment:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="128"/>
        <source>Camera Model:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="129"/>
        <source>Camera Manufacturer:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="135"/>
        <source>Description:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="136"/>
        <source>Copyright:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="137"/>
        <source>Scanner Model:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="138"/>
        <source>Scanner Manufacturer:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="130"/>
        <source>Exposure time</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="131"/>
        <source>Aperture:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/imageinfodialog.cpp" line="132"/>
        <source>ISO equiv.:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportAIPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="58"/>
        <source>Import AI...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="79"/>
        <source>Imports Illustrator Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="80"/>
        <source>Imports most Illustrator files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="162"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportPSPlugin</name>
    <message>
        <source>Import &amp;EPS/PS...</source>
        <translation type="obsolete">Voer &amp;EPS/PS in...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import PostScript...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports PostScript Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most PostScript files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportXfigPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="58"/>
        <source>Import Xfig...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="79"/>
        <source>Imports Xfig Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="80"/>
        <source>Imports most Xfig files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="126"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Imposition</name>
    <message>
        <location filename="../../../scribus/plugins/imposition/imposition.cpp" line="72"/>
        <source>Portrait</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/imposition.cpp" line="73"/>
        <source>Landscape</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImpositionBase</name>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="19"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="44"/>
        <source>Gri&amp;d</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="102"/>
        <source>Copies</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="157"/>
        <source>Do&amp;uble sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="160"/>
        <source>Alt+U</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="186"/>
        <source>Front side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="218"/>
        <source>Back side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="253"/>
        <source>&amp;Booklet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="285"/>
        <source>Pages per sheet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="296"/>
        <source>4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="301"/>
        <source>8</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="306"/>
        <source>16</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="318"/>
        <source>Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="325"/>
        <source>&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:&apos;Sans Serif&apos;; font-size:9pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Separate pages with a comma, ranges with a hyphen, e.g. 1,4,9-11 to get pages 1,4,9,10,11.&lt;/p&gt;&lt;/body&gt;&lt;/html&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="339"/>
        <source>Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="349"/>
        <source>Front page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="376"/>
        <source>Double sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="387"/>
        <source>Back page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="415"/>
        <source>Destination page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="455"/>
        <source>Size</source>
        <translation type="unfinished">Grootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="487"/>
        <source>Orientation</source>
        <translation type="unfinished">Oriëntasie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="519"/>
        <source>Width</source>
        <translation type="unfinished">Breedte</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="564"/>
        <source>Height</source>
        <translation type="unfinished">Hoogte</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="620"/>
        <source>Preview</source>
        <translation type="unfinished">Voorbeeld</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="627"/>
        <source>Refresh preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="671"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="674"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="681"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionbase.ui" line="684"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
</context>
<context>
    <name>ImpositionPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionplugin.cpp" line="37"/>
        <source>&amp;Imposition...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionplugin.cpp" line="69"/>
        <source>Imposition dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/imposition/impositionplugin.cpp" line="70"/>
        <source>Imposition on grids, booklets and folds</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsPage</name>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="30"/>
        <source>Insert Page</source>
        <translation>Voeg Bladsy in</translation>
    </message>
    <message>
        <source>&amp;Inserting</source>
        <translation type="obsolete">&amp;Invoeging</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="46"/>
        <source>Page(s)</source>
        <translation>Bladsy(e)</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="50"/>
        <source>before Page</source>
        <translation>voor bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="51"/>
        <source>after Page</source>
        <translation>na bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="52"/>
        <source>at End</source>
        <translation>aan die einde</translation>
    </message>
    <message>
        <source>Inserting</source>
        <translation type="obsolete">Invoeging</translation>
    </message>
    <message>
        <source>&amp;Template (Left Page):</source>
        <translation type="obsolete">&amp;Templaat (linker bladsy):</translation>
    </message>
    <message>
        <source>&amp;Template:</source>
        <translation type="obsolete">&amp;Templaat:</translation>
    </message>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <source>Template (Right Page):</source>
        <translation type="obsolete">Templaat (regter bladsy):</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="42"/>
        <location filename="../../../scribus/inspage.cpp" line="63"/>
        <source>&amp;Insert</source>
        <translation type="unfinished">&amp;Invoegen</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="67"/>
        <source>Master Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="79"/>
        <source>&amp;Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="207"/>
        <source>Page Size</source>
        <translation type="unfinished">Bladsygrootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="211"/>
        <source>&amp;Size:</source>
        <translation type="unfinished">&amp;Grootte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="226"/>
        <source>Orie&amp;ntation:</source>
        <translation type="unfinished">Orië&amp;ntasie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="229"/>
        <source>Portrait</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="230"/>
        <source>Landscape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="235"/>
        <source>&amp;Width:</source>
        <translation type="unfinished">&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="242"/>
        <source>&amp;Height:</source>
        <translation type="unfinished">&amp;Hoogte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/inspage.cpp" line="247"/>
        <source>Move Objects with their Page</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertAFrame</name>
    <message>
        <location filename="../../../scribus/insertaframe.cpp" line="237"/>
        <source>Open</source>
        <translation type="unfinished">Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="13"/>
        <source>Insert A Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="37"/>
        <source>T&amp;ype</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="75"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished">&amp;Teksraam</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="85"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Polygon</source>
        <translation type="obsolete">Polygoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="122"/>
        <source>&amp;Location</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="137"/>
        <source>Page Placement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="152"/>
        <source>Current Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="162"/>
        <source>All Pages</source>
        <translation type="unfinished">Alle bladsye</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="197"/>
        <location filename="../../../scribus/insertaframe.ui" line="711"/>
        <location filename="../../../scribus/insertaframe.ui" line="773"/>
        <source>...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="225"/>
        <source>Position of Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="240"/>
        <source>Top Left of Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="250"/>
        <source>Top Left of Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="260"/>
        <source>Top Left of Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="316"/>
        <source>X:</source>
        <translation type="unfinished">X:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="309"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="379"/>
        <source>&amp;Size</source>
        <translation type="unfinished">&amp;Grootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="409"/>
        <source>Same as the Page Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="419"/>
        <source>Same as the Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="429"/>
        <source>Same as the Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="439"/>
        <source>Same as the Imported Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="488"/>
        <source>Height:</source>
        <translation type="unfinished">Hoogte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="495"/>
        <source>Width:</source>
        <translation type="unfinished">Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="558"/>
        <source>&amp;Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="759"/>
        <source>Source Image:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="813"/>
        <source>There are no options for this type of frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="625"/>
        <source>Columns:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="611"/>
        <source>Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="697"/>
        <source>Source Document:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="172"/>
        <source>Range of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="270"/>
        <source>Custom Position</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="449"/>
        <source>Custom Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.cpp" line="133"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable formats from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the Story Editor.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.cpp" line="137"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, and posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="72"/>
        <source>Insert one or more text frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="82"/>
        <source>Insert one or more image frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="134"/>
        <source>Place the new frames on the current page, on all pages or on a selected range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="149"/>
        <source>Insert the frame on the current page only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="159"/>
        <source>Insert one frame for each existing page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="169"/>
        <source>Insert frames on a range of pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="187"/>
        <source>Range of pages to insert frames on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="222"/>
        <source>Position the new frame in relation to the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="237"/>
        <source>Insert the frame at the top left of the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="247"/>
        <source>Insert the frame at the top left of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="257"/>
        <source>Insert the frame at the top left of the page bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="267"/>
        <source>Insert the frame at a custom position on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="323"/>
        <source>Top position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="330"/>
        <source>Left position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="406"/>
        <source>Insert the new frame with the same dimensions as the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="416"/>
        <source>Insert the new frame with the same dimensions as the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="426"/>
        <source>Insert the new frame with the same dimensions as the bleed area outside the boundary of the page itself</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="436"/>
        <source>Insert the new frame with the same dimensions as the image that will be imported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="446"/>
        <source>Insert the new frame with a custom size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="502"/>
        <source>Width of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="509"/>
        <source>Height of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="601"/>
        <source>Number of columns for the inserted text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="618"/>
        <source>Distance between the columns in the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="649"/>
        <source>Link the inserted text frames together to form a chain of frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="652"/>
        <source>Link Inserted Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="661"/>
        <source>Link the first inserted frame to a preexisting text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="664"/>
        <source>Link to Existing Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="680"/>
        <source>Name of existing text frame to link to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="704"/>
        <source>Source document to load into the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertaframe.ui" line="766"/>
        <source>Source image to load into the inserted image frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertAFrameBase</name>
    <message>
        <source>&amp;Text Frame</source>
        <translation type="obsolete">&amp;Teksraam</translation>
    </message>
    <message>
        <source>Polygon</source>
        <translation type="obsolete">Polygoon</translation>
    </message>
    <message>
        <source>X:</source>
        <translation type="obsolete">X:</translation>
    </message>
    <message>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <source>&amp;Size</source>
        <translation type="obsolete">&amp;Grootte</translation>
    </message>
    <message>
        <source>Height:</source>
        <translation type="obsolete">Hoogte:</translation>
    </message>
    <message>
        <source>Width:</source>
        <translation type="obsolete">Breedte:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>All Pages</source>
        <translation type="obsolete">Alle bladsye</translation>
    </message>
</context>
<context>
    <name>InsertTable</name>
    <message>
        <location filename="../../../scribus/insertTable.cpp" line="15"/>
        <source>Insert Table</source>
        <translation>Voeg Tabel in</translation>
    </message>
    <message>
        <source>Number of Rows:</source>
        <translation type="obsolete">Aantal rye:</translation>
    </message>
    <message>
        <source>Number of Columns:</source>
        <translation type="obsolete">Aantal kolomme:</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">Reg</translation>
    </message>
    <message>
        <source>Cancel</source>
        <translation type="obsolete">Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/insertTable.cpp" line="28"/>
        <source>Number of rows:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/insertTable.cpp" line="29"/>
        <source>Number of columns:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>JavaDocs</name>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="27"/>
        <source>Edit JavaScripts</source>
        <translation>Verander JavaScripts</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="46"/>
        <source>&amp;Edit...</source>
        <translation>B&amp;ewerk...</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="49"/>
        <source>&amp;Add...</source>
        <translation>&amp;Toevoeg...</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="52"/>
        <source>&amp;Delete</source>
        <translation>Verwy&amp;der</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="57"/>
        <source>&amp;Close</source>
        <translation>&amp;Maak toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="77"/>
        <source>&amp;New Script:</source>
        <translation>&amp;Nuwe script:</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="77"/>
        <location filename="../../../scribus/javadocs.cpp" line="78"/>
        <source>New Script</source>
        <translation>Nuwe script</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Nee</translation>
    </message>
    <message>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Ja</translation>
    </message>
    <message>
        <source>Do you really want to delete this Script?</source>
        <translation type="obsolete">Wil u die script werklik verwyder?</translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="123"/>
        <source>Do you really want to delete this script?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/javadocs.cpp" line="71"/>
        <source>Adds a new Script, predefines a function with the same name. If you want to use this script as an &quot;Open Action&quot; script be sure not to change the name of the function.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>KeyManager</name>
    <message>
        <source>Manage Keyboard Shortcuts</source>
        <translation type="obsolete">Bestuur sleutelbord kortpaaie</translation>
    </message>
    <message>
        <source>Action</source>
        <translation type="obsolete">Aksie</translation>
    </message>
    <message>
        <source>Current Key</source>
        <translation type="obsolete">Huidige sleutel</translation>
    </message>
    <message>
        <source>Select a Key for this Action</source>
        <translation type="obsolete">Kies sleutel vir die aksie</translation>
    </message>
    <message>
        <source>&amp;No Key</source>
        <translation type="obsolete">&amp;Geen sleutel</translation>
    </message>
    <message>
        <source>&amp;User Defined Key</source>
        <translation type="obsolete">Gebr&amp;uikersgedefiniëerd</translation>
    </message>
    <message>
        <source>ALT+SHIFT+T</source>
        <translation type="obsolete">Alt+Shift+T</translation>
    </message>
    <message>
        <source>Set &amp;Key</source>
        <translation type="obsolete">Stel &amp;sleutel</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Alt</source>
        <translation type="obsolete">Alt</translation>
    </message>
    <message>
        <source>Ctrl</source>
        <translation type="obsolete">Ctrl</translation>
    </message>
    <message>
        <source>Shift</source>
        <translation type="obsolete">Shift</translation>
    </message>
    <message>
        <source>Shift+</source>
        <translation type="obsolete">Shift+</translation>
    </message>
    <message>
        <source>Alt+</source>
        <translation type="obsolete">Alt+</translation>
    </message>
    <message>
        <source>Ctrl+</source>
        <translation type="obsolete">Ctrl+</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>This Key Sequence is already in use</source>
        <translation type="obsolete">Die sleutel word reeds gebruik</translation>
    </message>
</context>
<context>
    <name>LatexEditor</name>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="33"/>
        <source>Enter Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="45"/>
        <source>Update</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="52"/>
        <source>Revert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="123"/>
        <source>Program Messages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="174"/>
        <source>Status: Unknown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="158"/>
        <source>Kill Program</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="66"/>
        <source>Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="74"/>
        <source>Resolution:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="81"/>
        <source>Automatic</source>
        <translation type="unfinished">Outomaties</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="84"/>
        <source> DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="97"/>
        <source>Program:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="109"/>
        <source>Use Preamble</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="338"/>
        <source>Status: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="165"/>
        <location filename="../../../scribus/latexeditor.cpp" line="206"/>
        <location filename="../../../scribus/latexeditor.cpp" line="223"/>
        <location filename="../../../scribus/latexeditor.cpp" line="342"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="344"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="347"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="528"/>
        <source>No item selected!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.ui" line="14"/>
        <source>Editor</source>
        <translation type="unfinished">Bewerker</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="122"/>
        <location filename="../../../scribus/latexeditor.cpp" line="130"/>
        <source>Information</source>
        <translation type="unfinished">Info</translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="123"/>
        <source>An editor for this frame is already running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="150"/>
        <source>Editor running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="131"/>
        <source>Please specify an editor in the preferences!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="166"/>
        <source>Could not create a temporary file to run the external editor!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="202"/>
        <location filename="../../../scribus/latexeditor.cpp" line="222"/>
        <location filename="../../../scribus/latexeditor.ui" line="148"/>
        <source>Run External Editor...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="207"/>
        <source>Running the editor failed with exitcode %d!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="224"/>
        <source>Running the editor &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/latexeditor.cpp" line="529"/>
        <source>Insert Symbol</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LayerPalette</name>
    <message>
        <location filename="../../../scribus/layers.cpp" line="567"/>
        <source>Layers</source>
        <translation>Lae</translation>
    </message>
    <message>
        <source>Add a new Layer</source>
        <translation type="obsolete">Voeg Nuwe laag by</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="290"/>
        <location filename="../../../scribus/layers.cpp" line="598"/>
        <source>Delete Layer</source>
        <translation>Verwyder Laag</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="599"/>
        <source>Raise Layer</source>
        <translation type="unfinished">Verhoog Laag</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="600"/>
        <source>Lower Layer</source>
        <translation type="unfinished">Laatsak Laag</translation>
    </message>
    <message>
        <source>New Layer</source>
        <translation type="obsolete">Nuwe laag</translation>
    </message>
    <message>
        <source>Do you want to delete all Objects on this Layer too?</source>
        <translation type="obsolete">Wil jy alle objekte in hierdie laag ook uitvee?</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="72"/>
        <location filename="../../../scribus/layers.cpp" line="588"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="291"/>
        <source>Do you want to delete all objects on this layer too?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="54"/>
        <location filename="../../../scribus/layers.cpp" line="586"/>
        <source>Opacity:</source>
        <translation type="unfinished">Ondeursigtigheid:</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="60"/>
        <location filename="../../../scribus/layers.cpp" line="587"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="568"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="570"/>
        <source>Normal</source>
        <translation type="unfinished">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="571"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="572"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="573"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="574"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="575"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="576"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="577"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="578"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="580"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="581"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="579"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="582"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="583"/>
        <source>Saturation</source>
        <translation type="unfinished">Versadiging</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="584"/>
        <source>Color</source>
        <translation type="unfinished">Kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="585"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="603"/>
        <source>Color of the Layer Indicator - Each layer has a color assigned to display on the canvas when layer indicators are enabled. You can double click to edit the color. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="604"/>
        <source>Make Layer Visible - Uncheck to hide the layer from the display </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="605"/>
        <source>Print Layer - Uncheck to disable printing. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="606"/>
        <source>Lock or Unlock Layer - Unchecked is unlocked </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="607"/>
        <source>Text flows around objects in lower Layers - Enabling this forces text frames to flow around other objects, even in layers below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="608"/>
        <source>Outline Mode - Toggles the &apos;wireframe&apos; display of objects to speed the display of very complex objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="601"/>
        <source>Selects the Blendmode, works only in PDF 1.4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="602"/>
        <source>Layer Transparency, works only in PDF 1.4 and SVG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="596"/>
        <source>Add a New Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="597"/>
        <source>Duplicate the Current Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/layers.cpp" line="609"/>
        <source>Name of the Layer - Double click on the name of a layer to edit the name</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LegacyMode</name>
    <message>
        <source>All Files (*)</source>
        <translation type="obsolete">Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_legacy.cpp" line="4997"/>
        <source>Open</source>
        <translation type="unfinished">Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/canvasmode_legacy.cpp" line="4967"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensDialogBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="13"/>
        <source>Optical Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="98"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="108"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="126"/>
        <source>Lens Parameters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="55"/>
        <source>Add a new lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="58"/>
        <source>&amp;Add Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="65"/>
        <source>Remove selected lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="68"/>
        <source>&amp;Remove Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="95"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="105"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="138"/>
        <source>&amp;X Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="148"/>
        <source>Horizontal position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="161"/>
        <source>&amp;Y Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="171"/>
        <source>Vertical position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="184"/>
        <source>The selected lens acts like a magnification lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="187"/>
        <source>&amp;Magnification Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="197"/>
        <source>The selected lens acts like a fish eye lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="200"/>
        <source>&amp;Fish Eye Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="207"/>
        <source>Ra&amp;dius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="217"/>
        <source>Radius of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="230"/>
        <source>&amp;Strength:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="240"/>
        <source>Strength of the lens</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensEffectsPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="66"/>
        <source>Lens Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="70"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="90"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="91"/>
        <source>Apply fancy lens effects</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LineFormate</name>
    <message>
        <source>Edit Line Styles</source>
        <translation type="obsolete">Verander Lynstyl</translation>
    </message>
    <message>
        <source>&amp;Append</source>
        <translation type="obsolete">&amp;Toevoeg</translation>
    </message>
    <message>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Nuwe</translation>
    </message>
    <message>
        <source>&amp;Edit</source>
        <translation type="obsolete">B&amp;ewerk</translation>
    </message>
    <message>
        <source>D&amp;uplicate</source>
        <translation type="obsolete">D&amp;upliseer</translation>
    </message>
    <message>
        <source>&amp;Delete</source>
        <translation type="obsolete">Verwy&amp;der</translation>
    </message>
    <message>
        <source>&amp;Save</source>
        <translation type="obsolete">Op&amp;slaan</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Copy of %1</source>
        <translation type="obsolete">Kopie van %1</translation>
    </message>
    <message>
        <source>New Style</source>
        <translation type="obsolete">Nuwe styl</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Nee</translation>
    </message>
    <message>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Ja</translation>
    </message>
    <message>
        <source>Open</source>
        <translation type="obsolete">Maak oop</translation>
    </message>
    <message>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Dokumente (*.sla *.sla.gz *.scd *.scd.gz);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Dokumente (*.sla *.scd);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Do you really want to delete this Style?</source>
        <translation type="obsolete">Wil U werklik hierdie styl verwyder?</translation>
    </message>
    <message>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Voer in</translation>
    </message>
</context>
<context>
    <name>LineStyleW</name>
    <message>
        <source>Line Width:</source>
        <translation type="obsolete">Lyndikte:</translation>
    </message>
</context>
<context>
    <name>LineStyleWBase</name>
    <message>
        <source>Line Width:</source>
        <translation type="obsolete">Lyndikte:</translation>
    </message>
</context>
<context>
    <name>LineStyleWidget</name>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source>Miter Join</source>
        <translation type="obsolete">Miter koppel</translation>
    </message>
    <message>
        <source>Bevel Join</source>
        <translation type="obsolete">Bevel koppel</translation>
    </message>
    <message>
        <source>Round Join</source>
        <translation type="obsolete">Ronde koppel</translation>
    </message>
    <message>
        <source>Solid Line</source>
        <translation type="obsolete">Soliede lyn</translation>
    </message>
    <message>
        <source>Dashed Line</source>
        <translation type="obsolete">Gestreepte lyn</translation>
    </message>
    <message>
        <source>Dotted Line</source>
        <translation type="obsolete">Stippellyn</translation>
    </message>
    <message>
        <source>Dash Dot Line</source>
        <translation type="obsolete">Streep-stip lyn</translation>
    </message>
    <message>
        <source>Dash Dot Dot Line</source>
        <translation type="obsolete">Streep-stip-stip lyn</translation>
    </message>
</context>
<context>
    <name>LoadSavePlugin</name>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="81"/>
        <source>All Files (*)</source>
        <translation type="unfinished">Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="93"/>
        <source>An error occured while opening file or file is damaged</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="98"/>
        <source>An error occured while parsing file at line %1, column %2 :
%3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loadsaveplugin.cpp" line="80"/>
        <source>No File Loader Plugins Found</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LoremManager</name>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="152"/>
        <source>Select Lorem Ipsum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="220"/>
        <source>Author:</source>
        <translation type="unfinished">Outeur:</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="222"/>
        <source>Get More:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="224"/>
        <source>XML File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="139"/>
        <location filename="../../../scribus/loremipsum.cpp" line="264"/>
        <source>Lorem Ipsum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="265"/>
        <source>Paragraphs:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="268"/>
        <source>Alt+O</source>
        <translation type="unfinished">Atl+O</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="270"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="271"/>
        <source>Standard Lorem Ipsum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="266"/>
        <source>Random Paragraphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="272"/>
        <source>Number of paragraphs of selected sample text to insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/loremipsum.cpp" line="273"/>
        <source>List of languages available to insert sample text in</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MSpinBox</name>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source>mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source>in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source>p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
</context>
<context>
    <name>ManageMacrosDialog</name>
    <message>
        <source>Alt+O</source>
        <translation type="obsolete">Atl+O</translation>
    </message>
    <message>
        <source>Description</source>
        <translation type="obsolete">Omschryving</translation>
    </message>
    <message>
        <source>&amp;Edit...</source>
        <translation type="obsolete">B&amp;ewerk...</translation>
    </message>
    <message>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Voer in</translation>
    </message>
</context>
<context>
    <name>MarginDialog</name>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="31"/>
        <source>Manage Page Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="39"/>
        <source>Page Size</source>
        <translation type="unfinished">Bladsygrootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="44"/>
        <source>&amp;Size:</source>
        <translation type="unfinished">&amp;Grootte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="60"/>
        <source>Orie&amp;ntation:</source>
        <translation type="unfinished">Orië&amp;ntasie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="63"/>
        <source>Portrait</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="64"/>
        <source>Landscape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="71"/>
        <source>&amp;Width:</source>
        <translation type="unfinished">&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="78"/>
        <source>&amp;Height:</source>
        <translation type="unfinished">&amp;Hoogte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="83"/>
        <source>Move Objects with their Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="89"/>
        <source>Type:</source>
        <translation type="unfinished">Tipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="109"/>
        <source>Margin Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="116"/>
        <source>Other Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="121"/>
        <source>Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="175"/>
        <source>Size of the inserted pages, either a standard or custom size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="176"/>
        <source>Orientation of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="177"/>
        <source>Width of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="178"/>
        <source>Height of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/margindialog.cpp" line="179"/>
        <source>When inserting a new page between others, move objects with their current pages. This is the default action.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginWidget</name>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="43"/>
        <source>&amp;Bottom:</source>
        <translation type="unfinished">On&amp;der:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="45"/>
        <source>&amp;Top:</source>
        <translation type="unfinished">&amp;Bo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="47"/>
        <location filename="../../../scribus/marginwidget.cpp" line="212"/>
        <source>&amp;Right:</source>
        <translation type="unfinished">&amp;Regs:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="49"/>
        <location filename="../../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Left:</source>
        <translation type="unfinished">&amp;Links:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="156"/>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="157"/>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Inside:</source>
        <translation type="unfinished">B&amp;innenkant:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="212"/>
        <source>O&amp;utside:</source>
        <translation type="unfinished">B&amp;uitenkant:</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="33"/>
        <source>Preset Layouts:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="90"/>
        <source>Apply the margin changes to all existing pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="102"/>
        <source>Printer Margins...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="104"/>
        <source>Import the margins for the selected page size from the available printers.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="79"/>
        <source>Apply settings to:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="82"/>
        <source>All Document Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="86"/>
        <source>All Master Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="91"/>
        <source>Apply the margin changes to all existing master pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="108"/>
        <source>Margin Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="126"/>
        <source>Top:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="131"/>
        <source>Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="143"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die bokant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="144"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die onderkant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="145"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die linkerkant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="146"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die regterkant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="152"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="217"/>
        <source>Inside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="218"/>
        <source>Outside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="222"/>
        <source>Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="223"/>
        <source>Right:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="158"/>
        <source>Distance between the left margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="159"/>
        <source>Distance between the right margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MasterPagesPalette</name>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="97"/>
        <source>Edit Master Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Nee</translation>
    </message>
    <message>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Ja</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="177"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="177"/>
        <source>New Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Copy of %1</source>
        <translation type="obsolete">Kopie van %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="303"/>
        <source>Name:</source>
        <translation type="unfinished">Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="303"/>
        <source>New MasterPage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="372"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished">Kopie #%1 van</translation>
    </message>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="98"/>
        <source>Duplicate the selected master page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="99"/>
        <source>Delete the selected master page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="100"/>
        <source>Add a new master page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="101"/>
        <source>Import master pages from another document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="303"/>
        <source>New Master Page %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="462"/>
        <source>Unable to Rename Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="462"/>
        <source>The Normal page is not allowed to be renamed.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="466"/>
        <source>Rename Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="466"/>
        <source>New Name:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="175"/>
        <source>Copy #%1 of %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="139"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/masterpagepalette.cpp" line="143"/>
        <source>Do you really want to delete master page &quot;%1&quot;?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Mdup</name>
    <message>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Meervoudig dupliseer</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">Aa&amp;ntal kopieë:</translation>
    </message>
    <message>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">&amp;Horisontale verplasing:</translation>
    </message>
    <message>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Vertikale verplasing:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
</context>
<context>
    <name>Measurements</name>
    <message>
        <source>Distances</source>
        <translation type="obsolete">Afstande</translation>
    </message>
    <message>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <source>DX:</source>
        <translation type="obsolete">DX:</translation>
    </message>
    <message>
        <source>DY:</source>
        <translation type="obsolete">DY:</translation>
    </message>
    <message>
        <source>Angle:</source>
        <translation type="obsolete">Hoek:</translation>
    </message>
    <message>
        <source>Length:</source>
        <translation type="obsolete">Lengte:</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/measurements.cpp" line="51"/>
        <source> °</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeasurementsBase</name>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="13"/>
        <source>Distances</source>
        <translation type="unfinished">Afstande</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="19"/>
        <source>X1:</source>
        <translation type="unfinished">X1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="26"/>
        <location filename="../../../scribus/measurementsbase.ui" line="43"/>
        <location filename="../../../scribus/measurementsbase.ui" line="60"/>
        <location filename="../../../scribus/measurementsbase.ui" line="77"/>
        <location filename="../../../scribus/measurementsbase.ui" line="94"/>
        <location filename="../../../scribus/measurementsbase.ui" line="111"/>
        <location filename="../../../scribus/measurementsbase.ui" line="128"/>
        <location filename="../../../scribus/measurementsbase.ui" line="145"/>
        <source>10000.0000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="36"/>
        <source>Y1:</source>
        <translation type="unfinished">Y1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="53"/>
        <source>X2:</source>
        <translation type="unfinished">X2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="70"/>
        <source>Y2:</source>
        <translation type="unfinished">Y2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="87"/>
        <source>Length:</source>
        <translation type="unfinished">Lengte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="104"/>
        <source>DX:</source>
        <translation type="unfinished">DX:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="121"/>
        <source>DY:</source>
        <translation type="unfinished">DY:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="138"/>
        <source>Angle:</source>
        <translation type="unfinished">Hoek:</translation>
    </message>
    <message>
        <location filename="../../../scribus/measurementsbase.ui" line="155"/>
        <source>Unit:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MenuTest</name>
    <message>
        <source>Script error</source>
        <translation type="obsolete">Scriptfout</translation>
    </message>
    <message>
        <source>If you are running an official script report it at &lt;a href=&quot;http://bugs.scribus.net&quot;&gt;bugs.scribus.net&lt;/a&gt; please.</source>
        <translation type="obsolete">As dit &apos;n amptelike script is, gee hierdie fout asb. in by &lt;a href=&quot;http://bugs.scribus.net&quot;&gt; bugs.scribus.net&lt;/a&gt;.</translation>
    </message>
    <message>
        <source>This message is in your clipboard too. Use Ctrl+V to paste it into bug tracker.</source>
        <translation type="obsolete">Die is in die knip-en-plakbord. Met Ctrl+V kan u die fout in bugtracker gaan plak.</translation>
    </message>
    <message>
        <source>Show &amp;Console</source>
        <translation type="obsolete">Wys &amp;Konsole</translation>
    </message>
    <message>
        <source>Hide &amp;Console</source>
        <translation type="obsolete">Versteek &amp;Konsole</translation>
    </message>
</context>
<context>
    <name>MergeDoc</name>
    <message>
        <source>Import Template</source>
        <translation type="obsolete">Voer templaat in</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Page(s)</source>
        <translation>Voer bladsy(e) in</translation>
    </message>
    <message>
        <source>From Document:</source>
        <translation type="obsolete">Vanaf dokument:</translation>
    </message>
    <message>
        <source>Change...</source>
        <translation type="obsolete">Wysig...</translation>
    </message>
    <message>
        <source>Import Page(s):</source>
        <translation type="obsolete">Voer Bladsy(e) in:</translation>
    </message>
    <message>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Kies bladsy nommers. 1,3,4,6 of 1-4 vir 1 tot 4 
of * vir almal.</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="75"/>
        <source> from 0</source>
        <translation> vanaf 0</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="78"/>
        <source>Create Page(s)</source>
        <translation>Skep Bladsy(e)</translation>
    </message>
    <message>
        <source>before Page</source>
        <translation type="obsolete">voor bladsy</translation>
    </message>
    <message>
        <source>after Page</source>
        <translation type="obsolete">na bladsy</translation>
    </message>
    <message>
        <source>at End</source>
        <translation type="obsolete">aan die einde</translation>
    </message>
    <message>
        <source>Import</source>
        <translation type="obsolete">Invoer</translation>
    </message>
    <message>
        <source>Cancel</source>
        <translation type="obsolete">Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="135"/>
        <source>Open</source>
        <translation>Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="135"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation>Dokumente (*.sla *.sla.gz *.scd *.scd.gz);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Dokumente (*.sla *.scd);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="171"/>
        <location filename="../../../scribus/mergedoc.cpp" line="190"/>
        <source> from %1</source>
        <translation> vanaf %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="48"/>
        <source>&amp;From Document:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="55"/>
        <source>&amp;Import Page(s):</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="82"/>
        <source>Before Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="83"/>
        <source>After Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="84"/>
        <source>At End</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="101"/>
        <source>&amp;Import</source>
        <translation type="unfinished">&amp;Voer in</translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="59"/>
        <source>&amp;Import Master Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="70"/>
        <source>Insert a comma separated list of tokens import where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/mergedoc.cpp" line="52"/>
        <source>&amp;Select...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionDialog</name>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="44"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="54"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="13"/>
        <source>Mesh Distortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="27"/>
        <source>Drag the red handles with the mouse to distort the mesh</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="41"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="51"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="82"/>
        <source>Resets the selected handles to their initial position.
If no handle is selected all handles will be reset.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="86"/>
        <source>&amp;Reset</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="69"/>
        <source>Mesh Distortion...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="94"/>
        <location filename="../../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="95"/>
        <source>Mesh Distortion of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MissingFont</name>
    <message>
        <location filename="../../../scribus/missing.cpp" line="309"/>
        <source>Missing Font</source>
        <translation type="unfinished">Ontbrekende lettertipe</translation>
    </message>
    <message>
        <location filename="../../../scribus/missing.cpp" line="317"/>
        <source>The Font %1 is not installed.</source>
        <translation type="unfinished">Die lettertipe %1 is nie geinstalleer nie.</translation>
    </message>
    <message>
        <location filename="../../../scribus/missing.cpp" line="322"/>
        <source>Use</source>
        <translation type="unfinished">Gebruik</translation>
    </message>
    <message>
        <location filename="../../../scribus/missing.cpp" line="331"/>
        <source>instead</source>
        <translation type="unfinished">in plaas daarvan</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
</context>
<context>
    <name>ModeToolBar</name>
    <message>
        <location filename="../../../scribus/ui/modetoolbar.cpp" line="39"/>
        <source>Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/ui/modetoolbar.cpp" line="121"/>
        <source>Properties...</source>
        <translation type="unfinished">Eienskappe...</translation>
    </message>
</context>
<context>
    <name>MovePages</name>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="28"/>
        <source>Move Pages</source>
        <translation>skuif Bladsye</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="28"/>
        <location filename="../../../scribus/movepage.cpp" line="37"/>
        <source>Copy Page</source>
        <translation>Kopiër Bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="78"/>
        <source>Move Page(s):</source>
        <translation>Skuif Bladsy(e):</translation>
    </message>
    <message>
        <source>to:</source>
        <translation type="obsolete">na:</translation>
    </message>
    <message>
        <source>before Page</source>
        <translation type="obsolete">voor bladsy</translation>
    </message>
    <message>
        <source>after Page</source>
        <translation type="obsolete">na bladsy</translation>
    </message>
    <message>
        <source>at End</source>
        <translation type="obsolete">aan die einde</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="37"/>
        <source>Move Page(s)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="68"/>
        <source>Before Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="69"/>
        <source>After Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="70"/>
        <source>At End</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="48"/>
        <source>To:</source>
        <translation type="unfinished">Tot:</translation>
    </message>
    <message>
        <location filename="../../../scribus/movepage.cpp" line="58"/>
        <source>Number of Copies:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultiLine</name>
    <message>
        <source>Edit Style</source>
        <translation type="obsolete">Verander styl</translation>
    </message>
    <message>
        <source>Flat Cap</source>
        <translation type="obsolete">Plat einde</translation>
    </message>
    <message>
        <source>Square Cap</source>
        <translation type="obsolete">Vierkantige einde</translation>
    </message>
    <message>
        <source>Round Cap</source>
        <translation type="obsolete">Ronde einde</translation>
    </message>
    <message>
        <source>Miter Join</source>
        <translation type="obsolete">Miter koppel</translation>
    </message>
    <message>
        <source>Bevel Join</source>
        <translation type="obsolete">Bevel koppel</translation>
    </message>
    <message>
        <source>Round Join</source>
        <translation type="obsolete">Ronde koppel</translation>
    </message>
    <message>
        <source>Line Width:</source>
        <translation type="obsolete">Lyndikte:</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source> %</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source> pt </source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source>Solid Line</source>
        <translation type="obsolete">Soliede lyn</translation>
    </message>
    <message>
        <source>Dashed Line</source>
        <translation type="obsolete">Gestreepte lyn</translation>
    </message>
    <message>
        <source>Dotted Line</source>
        <translation type="obsolete">Stippellyn</translation>
    </message>
    <message>
        <source>Dash Dot Line</source>
        <translation type="obsolete">Streep-stip lyn</translation>
    </message>
    <message>
        <source>Dash Dot Dot Line</source>
        <translation type="obsolete">Streep-stip-stip lyn</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>Name &quot;%1&quot; isn&apos;t unique.
Please choose another.</source>
        <translation type="obsolete">Die naam &quot;%1&quot; is nie uniek nie.
Kies &apos;n ander naam.</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">Reg</translation>
    </message>
    <message>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
</context>
<context>
    <name>MultiProgressDialog</name>
    <message>
        <location filename="../../../scribus/multiprogressdialog.ui" line="13"/>
        <source>Progress</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multiprogressdialog.ui" line="24"/>
        <source>Overall Progress:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multiprogressdialog.ui" line="67"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multiprogressdialog.cpp" line="74"/>
        <source>%v of %m</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultipleDuplicate</name>
    <message>
        <location filename="../../../scribus/multipleduplicate.cpp" line="63"/>
        <location filename="../../../scribus/multipleduplicate.ui" line="112"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="unfinished">&amp;Horisontale verplasing:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.cpp" line="64"/>
        <location filename="../../../scribus/multipleduplicate.ui" line="165"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="unfinished">&amp;Vertikale verplasing:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.cpp" line="69"/>
        <source>&amp;Horizontal Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.cpp" line="70"/>
        <source>&amp;Vertical Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="13"/>
        <source>Multiple Duplicate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="32"/>
        <source>&amp;By Number of Copies</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="50"/>
        <source>&amp;Number of Copies:</source>
        <translation type="unfinished">Aa&amp;ntal kopieë:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="91"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="94"/>
        <source>Alt+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="81"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="84"/>
        <source>Alt+G</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="145"/>
        <source>Rotation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="217"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="245"/>
        <source>Vertical Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="272"/>
        <source>Horizontal Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="289"/>
        <source>Number of Rows:</source>
        <translation type="unfinished">Aantal rye:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="309"/>
        <source>Number of Columns:</source>
        <translation type="unfinished">Aantal kolomme:</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="383"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/multipleduplicate.ui" line="399"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultipleDuplicateBase</name>
    <message>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">Aa&amp;ntal kopieë:</translation>
    </message>
    <message>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">&amp;Horisontale verplasing:</translation>
    </message>
    <message>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Vertikale verplasing:</translation>
    </message>
    <message>
        <source>Number of Rows:</source>
        <translation type="obsolete">Aantal rye:</translation>
    </message>
    <message>
        <source>Number of Columns:</source>
        <translation type="obsolete">Aantal kolomme:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
</context>
<context>
    <name>MusterPages</name>
    <message>
        <source>Edit Templates</source>
        <translation type="obsolete">Verander templaat</translation>
    </message>
    <message>
        <source>Do you really want to delete this Template?</source>
        <translation type="obsolete">Wil u regtig hierdie templaat uitvee?</translation>
    </message>
    <message>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Nee</translation>
    </message>
    <message>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Ja</translation>
    </message>
    <message>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Naam:</translation>
    </message>
    <message>
        <source>New Template</source>
        <translation type="obsolete">Nuwe templaat</translation>
    </message>
    <message>
        <source>Copy of %1</source>
        <translation type="obsolete">Kopie van %1</translation>
    </message>
    <message>
        <source>Name:</source>
        <translation type="obsolete">Naam:</translation>
    </message>
    <message>
        <source>Copy #%1 of </source>
        <translation type="obsolete">Kopie #%1 van</translation>
    </message>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
</context>
<context>
    <name>MusterSeiten</name>
    <message>
        <source>Edit Templates</source>
        <translation type="obsolete">Verander templaat</translation>
    </message>
    <message>
        <source>&amp;Append</source>
        <translation type="obsolete">Toe&amp;voeg</translation>
    </message>
    <message>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Nuwe</translation>
    </message>
    <message>
        <source>D&amp;uplicate</source>
        <translation type="obsolete">D&amp;upliseer</translation>
    </message>
    <message>
        <source>&amp;Delete</source>
        <translation type="obsolete">Verwy&amp;der</translation>
    </message>
    <message>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Maak toe</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Nee</translation>
    </message>
    <message>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Ja</translation>
    </message>
    <message>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Naam:</translation>
    </message>
    <message>
        <source>New Template</source>
        <translation type="obsolete">Nuwe templaat</translation>
    </message>
    <message>
        <source>Copy of %1</source>
        <translation type="obsolete">Kopie van %1</translation>
    </message>
    <message>
        <source>Name:</source>
        <translation type="obsolete">Naam:</translation>
    </message>
    <message>
        <source>Copy #%1 of </source>
        <translation type="obsolete">Kopie #%1 van</translation>
    </message>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <source>Do you really want to delete this Template?</source>
        <translation type="obsolete">Wil u regtig hierdie templaat uitvee?</translation>
    </message>
</context>
<context>
    <name>MyPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/myplugin/myplugin.cpp" line="31"/>
        <source>My &amp;Plugin</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MyPluginImpl</name>
    <message>
        <location filename="../../../scribus/plugins/myplugin/mypluginimpl.cpp" line="23"/>
        <source>Scribus - My Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/myplugin/mypluginimpl.cpp" line="24"/>
        <source>The plugin worked!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewDoc</name>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="101"/>
        <source>New Document</source>
        <translation>Nuwe dokument</translation>
    </message>
    <message>
        <source>Page Size</source>
        <translation type="obsolete">Bladsygrootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="225"/>
        <source>&amp;Size:</source>
        <translation>&amp;Grootte:</translation>
    </message>
    <message>
        <source>Legal</source>
        <translation type="obsolete">Legal</translation>
    </message>
    <message>
        <source>Letter</source>
        <translation type="obsolete">Letter (US)</translation>
    </message>
    <message>
        <source>Tabloid</source>
        <translation type="obsolete">Ponie</translation>
    </message>
    <message>
        <source>Custom</source>
        <translation type="obsolete">Tuisgemaak</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="234"/>
        <source>Orie&amp;ntation:</source>
        <translation>Orië&amp;ntasie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="237"/>
        <source>Portrait</source>
        <translation>Regop</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="238"/>
        <source>Landscape</source>
        <translation>Gekantel</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="244"/>
        <source>&amp;Width:</source>
        <translation>&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="250"/>
        <source>&amp;Height:</source>
        <translation>&amp;Hoogte:</translation>
    </message>
    <message>
        <source>&amp;Facing Pages</source>
        <translation type="obsolete">&amp;Teenoorstaande bladsye</translation>
    </message>
    <message>
        <source>Left &amp;Page First</source>
        <translation type="obsolete">Linker&amp;bladsy eerste</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="266"/>
        <source>Margin Guides</source>
        <translation>Kant hulplyne</translation>
    </message>
    <message>
        <source>&amp;Left:</source>
        <translation type="obsolete">&amp;Links:</translation>
    </message>
    <message>
        <source>&amp;Right:</source>
        <translation type="obsolete">&amp;Regs:</translation>
    </message>
    <message>
        <source>&amp;Top:</source>
        <translation type="obsolete">&amp;Bo:</translation>
    </message>
    <message>
        <source>&amp;Bottom:</source>
        <translation type="obsolete">On&amp;der:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="285"/>
        <source>Options</source>
        <translation>Opsies</translation>
    </message>
    <message>
        <source>F&amp;irst Page Number:</source>
        <translation type="obsolete">&amp;Eerste bladsy nommer:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="298"/>
        <source>&amp;Default Unit:</source>
        <translation>&amp;Verstek eenheid:</translation>
    </message>
    <message>
        <source>Points (pts)</source>
        <translation type="obsolete">Punte (pt)</translation>
    </message>
    <message>
        <source>Millimetres (mm)</source>
        <translation type="obsolete">Millimeter (mm)</translation>
    </message>
    <message>
        <source>Inches (in)</source>
        <translation type="obsolete">Duim (in)</translation>
    </message>
    <message>
        <source>Picas (p)</source>
        <translation type="obsolete">Picas (p)</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="308"/>
        <source>&amp;Automatic Text Frames</source>
        <translation>&amp;Outomatise teksrame</translation>
    </message>
    <message>
        <source>Column Guides</source>
        <translation type="obsolete">Kolom hulplyne</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="318"/>
        <source>&amp;Gap:</source>
        <translation>&amp;Ruimte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="310"/>
        <source>Colu&amp;mns:</source>
        <translation>Kolo&amp;mme:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="144"/>
        <source>Document page size, either a standard size or a custom size</source>
        <translation>Bladsygrootte, standaard of aangepas</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="145"/>
        <source>Orientation of the document&apos;s pages</source>
        <translation>Oriëntatie van dokumentbladsye</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="146"/>
        <source>Width of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Breedte van dokumentbladsye, kies &apos;Tuisgemaak&apos; om self &apos;n waarde te kan insit</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="147"/>
        <source>Height of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Hoogte van dokumentbladsye, kies &apos;Tuisgemaak&apos; om self &apos;n waarde te kan insit</translation>
    </message>
    <message>
        <source>Enable single or spread based layout</source>
        <translation type="obsolete">Bladsye is almal eenders of daar is linker en regter bladsye</translation>
    </message>
    <message>
        <source>Make the first page the left page of the document</source>
        <translation type="obsolete">Laat dokument met n&apos; linker bladsy begin</translation>
    </message>
    <message>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation type="obsolete">Afstand tussen boënste kantlyn en papierrand</translation>
    </message>
    <message>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation type="obsolete">Afstand tussen onderste kantlyn en papierrand</translation>
    </message>
    <message>
        <source>Distance between the left margin guide and the edge of the page.
If Facing Pages is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Afstand tussen linkerkantlyn en papierrand.
As &apos;Teenoorstaande bladsye&apos; gekies is, word die breedte gebruik vir korrekte binding</translation>
    </message>
    <message>
        <source>Distance between the right margin guide and the edge of the page.
If Facing Pages is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Afstand tussen regterkantlyn en papierrand.
As &apos;Teenoorstaande bladsye&apos; gekies is, word die breedte gebruik vir korrekte binding</translation>
    </message>
    <message>
        <source>First page number of the document</source>
        <translation type="obsolete">Eerste bladsynommer van dokument</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="149"/>
        <source>Default unit of measurement for document editing</source>
        <translation>Verstek meeteenheid vir dokumentbewerking</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="150"/>
        <source>Create text frames automatically when new pages are added</source>
        <translation>Maak outomaties teksrame saammet bladsy byvoeging</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="151"/>
        <source>Number of columns to create in automatically created text frames</source>
        <translation>Aantal kolomme in outomaties geskepte teksrame</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="152"/>
        <source>Distance between automatically created columns</source>
        <translation>Afstand tussen outomaties geskepte kolomme</translation>
    </message>
    <message>
        <source>&amp;Inside:</source>
        <translation type="obsolete">B&amp;innenkant:</translation>
    </message>
    <message>
        <source>O&amp;utside:</source>
        <translation type="obsolete">B&amp;uitenkant:</translation>
    </message>
    <message>
        <source>Executive</source>
        <translation type="obsolete">Bestuurs</translation>
    </message>
    <message>
        <source>Folio</source>
        <translation type="obsolete">Folio</translation>
    </message>
    <message>
        <source>Ledger</source>
        <translation type="obsolete">Grootboek</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="130"/>
        <source>Do not show this dialog again</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="148"/>
        <source>Initial number of pages of the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="292"/>
        <source>N&amp;umber of Pages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>All Files (*)</source>
        <translation type="obsolete">Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="366"/>
        <location filename="../../../scribus/newfile.cpp" line="371"/>
        <source>Open</source>
        <translation type="unfinished">Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="111"/>
        <source>&amp;New Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="116"/>
        <source>Open &amp;Existing Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="119"/>
        <source>Open Recent &amp;Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="257"/>
        <source>First Page is:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="330"/>
        <source>Show Document Settings After Creation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="182"/>
        <source>Document Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/newfile.cpp" line="114"/>
        <source>New &amp;from Template</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewFromTemplatePlugin</name>
    <message>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="59"/>
        <source>New &amp;from Template...</source>
        <translation type="unfinished">Nuut van &amp;templaat...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="79"/>
        <source>Load documents with predefined layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="80"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewTm</name>
    <message>
        <source>Left Page</source>
        <translation type="obsolete">Linker bladsy</translation>
    </message>
    <message>
        <source>Right Page</source>
        <translation type="obsolete">Regter bladsy</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
</context>
<context>
    <name>NodePalette</name>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="897"/>
        <source>Nodes</source>
        <translation>Nodes</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="900"/>
        <source>&amp;Absolute Coordinates</source>
        <translation>&amp;Absolute koördinate</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="903"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X-pos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="904"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-pos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="905"/>
        <source>Edit &amp;Contour Line</source>
        <translation>Verander &amp;Kontoerlyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="906"/>
        <source>&amp;Reset Contour Line</source>
        <translation>Herstel Kontoe&amp;rlyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="909"/>
        <source>&amp;End Editing</source>
        <translation>&amp;Beëindigen bewerking</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="910"/>
        <source>Move Nodes</source>
        <translation>Skuif Nodes</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="911"/>
        <source>Move Control Points</source>
        <translation>Skuif Kontrolepunte</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="912"/>
        <source>Add Nodes</source>
        <translation>Voeg Nodes by</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="913"/>
        <source>Delete Nodes</source>
        <translation>Verwyder Nodes</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="914"/>
        <source>Move Control Points Independently</source>
        <translation>Skuif kontrolepunte onafhanklik</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="915"/>
        <source>Move Control Points Symmetrical</source>
        <translation>Skuif kontrolepunte simmetries</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="916"/>
        <source>Reset Control Points</source>
        <translation>Herstel kontrolepunte</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="917"/>
        <source>Reset this Control Point</source>
        <translation>Herstel hierdie kontrolepunt</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="918"/>
        <source>Open a Polygon or Cuts a Bezier Curve</source>
        <translation>Begin &apos;n Poligoon of sny &apos;n Bezierkurwe</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="919"/>
        <source>Close this Bezier Curve</source>
        <translation>Sluit hierdie Bezierkurwe</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="920"/>
        <source>Mirror the Path Horizontally</source>
        <translation>Spieël pad horisontaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="921"/>
        <source>Mirror the Path Vertically</source>
        <translation>Spieël pad vertikaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="922"/>
        <source>Shear the Path Horizontally to the Right</source>
        <translation>Trek pad horisontaal na regs skeef</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="923"/>
        <source>Shear the Path Horizontally to the Left</source>
        <translation>Trek pad horisontaal na links skeef</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="924"/>
        <source>Shear the Path Vertically Up</source>
        <translation>Trek pad vertikaal opwaarts skeef</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="925"/>
        <source>Shear the Path Vertically Down</source>
        <translation>Trek pad vertikaal afwaarts skeef</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="926"/>
        <source>Rotate the Path Counter-Clockwise</source>
        <translation>Roteer pad antikloksgewys</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="927"/>
        <source>Rotate the Path Clockwise</source>
        <translation>Roteer pad kloksgewys</translation>
    </message>
    <message>
        <source>Reduce the Size of the Path by shown %</source>
        <translation type="obsolete">Verklein padgrootte met getoonde %</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="929"/>
        <source>Enlarge the Size of the Path by shown %</source>
        <translation>Vergroot padgrootte met getoonde %</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="932"/>
        <source>Angle of Rotation</source>
        <translation>Rotasiehoek</translation>
    </message>
    <message>
        <source>% to Enlarge or Reduce By</source>
        <translation type="obsolete">% om mee te vergroot of verklein</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="935"/>
        <source>Activate Contour Line Editing Mode</source>
        <translation>Aktiveer Kontoerlyn bewerking modus</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="936"/>
        <source>Reset the Contour Line to the Original Shape of the Frame</source>
        <translation>Herstel kontoerlyn na oorspronklik raamgrootte</translation>
    </message>
    <message>
        <source>When checked use Coordinates relative to the Page,
otherwise Coordinates are relative to the Object.</source>
        <translation type="obsolete">Indien gekies word koördinate relatief tot die bladsy
gebruik, anders is koördinate relatief tot die objek.</translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="898"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="939"/>
        <source>When checked use coordinates relative to the page, otherwise coordinates are relative to the Object.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="928"/>
        <source>Shrink the Size of the Path by shown %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="930"/>
        <source>Reduce the Size of the Path by the shown value</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="931"/>
        <source>Enlarge the Size of the Path by the shown value</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="933"/>
        <source>% to Enlarge or Shrink By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="934"/>
        <source>Value to Enlarge or Shrink By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="907"/>
        <source>Set Contour to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="937"/>
        <source>Reset the Contour Line to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="241"/>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="901"/>
        <source>to Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="243"/>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="902"/>
        <source>to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="908"/>
        <source>Set Shape to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/nodeeditpalette.cpp" line="938"/>
        <source>Set the Shape to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODPlug</name>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="300"/>
        <source>This document does not seem to be an OpenOffice Draw file.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="471"/>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="621"/>
        <source>Group%1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODrawImportPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="97"/>
        <source>Import &amp;OpenOffice.org Draw...</source>
        <translation type="unfinished">Voer &amp;OpenOffice.org Draw in...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="112"/>
        <source>Imports OpenOffice.org Draw Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="113"/>
        <source>Imports most OpenOffice.org Draw files into the current document, converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="127"/>
        <source>OpenDocument 1.0 Draw</source>
        <comment>Import/export format name</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="139"/>
        <source>OpenOffice.org 1.x Draw</source>
        <comment>Import/export format name</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="211"/>
        <source>This file contains some unsupported features</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="209"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OdtDialog</name>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="43"/>
        <source>OpenDocument Importer Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="52"/>
        <source>Overwrite Paragraph Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="54"/>
        <source>Enabling this will overwrite existing styles in the current Scribus document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="61"/>
        <source>Merge Paragraph Styles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="63"/>
        <source>Merge paragraph styles by attributes. This will result in fewer similar paragraph styles, will retain style attributes, even if the original document&apos;s styles are named differently.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="70"/>
        <source>Use document name as a prefix for paragraph styles</source>
        <translation type="unfinished">Documentnaam als prefix vir alineastylen gebruiken</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="72"/>
        <source>Prepend the document name to the paragraph style name in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="79"/>
        <source>Do not ask again</source>
        <translation type="unfinished">Deze vraag niet meer stellen</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="81"/>
        <source>Make these settings the default and do not prompt again when importing an OASIS OpenDocument.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="90"/>
        <source>OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/odtim/odtdia.cpp" line="92"/>
        <source>Cancel</source>
        <translation type="unfinished">Kanselleer</translation>
    </message>
</context>
<context>
    <name>OldScribusFormat</name>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="59"/>
        <source>Scribus Document</source>
        <translation type="unfinished">Scribus dokument</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="70"/>
        <source>Scribus 1.2.x Document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OneClick</name>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="37"/>
        <source>Origin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="54"/>
        <source>Size</source>
        <translation type="unfinished">Grootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="59"/>
        <source>Width:</source>
        <translation type="unfinished">Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="61"/>
        <source>Length:</source>
        <translation type="unfinished">Lengte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="69"/>
        <source>Height:</source>
        <translation type="unfinished">Hoogte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="71"/>
        <source>Angle:</source>
        <translation type="unfinished">Hoek:</translation>
    </message>
    <message>
        <location filename="../../../scribus/oneclick.cpp" line="101"/>
        <source>Remember Values</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlinePalette</name>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="165"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="924"/>
        <source>Element</source>
        <translation type="unfinished">Element</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="301"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="702"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="752"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="807"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="892"/>
        <source>Group </source>
        <translation type="unfinished">Groep</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="767"/>
        <source>Page </source>
        <translation type="unfinished">Bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="822"/>
        <source>Free Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="923"/>
        <source>Outline</source>
        <translation type="unfinished">Outline</translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="154"/>
        <source>Enter a keyword or regular expression to filter the outline.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="156"/>
        <location filename="../../../scribus/outlinepalette.cpp" line="925"/>
        <source>Filter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/outlinepalette.cpp" line="155"/>
        <source>Ctrl+F</source>
        <comment>Filter the Outline using a keyword</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlineValues</name>
    <message>
        <location filename="../../../scribus/styleselect.cpp" line="97"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/styleselect.cpp" line="98"/>
        <source>Linewidth</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PConsole</name>
    <message>
        <source>Script Console</source>
        <translation type="obsolete">Scriptkonsole</translation>
    </message>
</context>
<context>
    <name>PDFExportDialog</name>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="59"/>
        <location filename="../../../scribus/pdfopts.cpp" line="152"/>
        <source>Save as PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="65"/>
        <source>O&amp;utput to File:</source>
        <translation type="unfinished">Voer &amp;uit na lêer:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="94"/>
        <source>Cha&amp;nge...</source>
        <translation type="unfinished">Wysi&amp;g...</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="97"/>
        <source>Output one file for eac&amp;h page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="110"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Save as</source>
        <translation type="obsolete">Stoor as</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="204"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation type="unfinished">PDF-lêers (*.pdf);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="122"/>
        <source>This enables exporting one individually named PDF file for each page in the document. Page numbers are added automatically. This is most useful for imposing PDF for commercial printing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="123"/>
        <source>The save button will be disabled if you are trying to export PDF/X-3 and the info string is missing from the PDF/X-3 tab.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="153"/>
        <source>%1 does not exists and will be created, continue?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="170"/>
        <source>Cannot create directory: 
%1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdfopts.cpp" line="204"/>
        <source>Save As</source>
        <translation type="unfinished">Stoor as</translation>
    </message>
</context>
<context>
    <name>PDFLibCore</name>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="136"/>
        <source>Saving PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="140"/>
        <source>Exporting Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="140"/>
        <source>Exporting Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="140"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="2443"/>
        <source>Page:</source>
        <translation type="unfinished">Bladsy:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="2456"/>
        <source>Date:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7738"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7743"/>
        <source>Failed to write an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7748"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7753"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pdflib_core.cpp" line="7733"/>
        <source>A write error occurred, please check available disk space</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFToolBar</name>
    <message>
        <location filename="../../../scribus/ui/pdftoolbar.cpp" line="29"/>
        <source>PDF Tools</source>
        <translation type="unfinished">PDF-gereedschappen</translation>
    </message>
</context>
<context>
    <name>PDF_Opts</name>
    <message>
        <source>Create PDF File</source>
        <translation type="obsolete">Maak PDF-lêer</translation>
    </message>
    <message>
        <source>O&amp;utput to File:</source>
        <translation type="obsolete">Voer &amp;uit na lêer:</translation>
    </message>
    <message>
        <source>Cha&amp;nge...</source>
        <translation type="obsolete">Wysi&amp;g...</translation>
    </message>
    <message>
        <source>Export Range</source>
        <translation type="obsolete">Uitvoerbereik</translation>
    </message>
    <message>
        <source>&amp;All Pages</source>
        <translation type="obsolete">&amp;Alle bladsye</translation>
    </message>
    <message>
        <source>C&amp;hoose Pages</source>
        <translation type="obsolete">Kies &amp;Bladsye</translation>
    </message>
    <message>
        <source>File Options</source>
        <translation type="obsolete">Lêersopsies</translation>
    </message>
    <message>
        <source>Compatibilit&amp;y:</source>
        <translation type="obsolete">&amp;Aanpasbaarheid:</translation>
    </message>
    <message>
        <source>&amp;Binding:</source>
        <translation type="obsolete">&amp;Binding:</translation>
    </message>
    <message>
        <source>Left Margin</source>
        <translation type="obsolete">Linkerkantlyn</translation>
    </message>
    <message>
        <source>Right Margin</source>
        <translation type="obsolete">Regterkantlyn</translation>
    </message>
    <message>
        <source>Generate &amp;Thumbnails</source>
        <translation type="obsolete">Minia&amp;tuur prentjies</translation>
    </message>
    <message>
        <source>Save &amp;Linked Text Frames as PDF Articles</source>
        <translation type="obsolete">Stoor geskake&amp;lde teksrame as PDF-artikels</translation>
    </message>
    <message>
        <source>&amp;Include Bookmarks</source>
        <translation type="obsolete">&amp;Voeg Boekmerke in</translation>
    </message>
    <message>
        <source> dpi</source>
        <translation type="obsolete">dpi</translation>
    </message>
    <message>
        <source>&amp;Resolution:</source>
        <translation type="obsolete">&amp;Resolusie:</translation>
    </message>
    <message>
        <source>Image Settings</source>
        <translation type="obsolete">Prentinstellings</translation>
    </message>
    <message>
        <source>Automatic</source>
        <translation type="obsolete">Outomaties</translation>
    </message>
    <message>
        <source>JPEG</source>
        <translation type="obsolete">JPEG</translation>
    </message>
    <message>
        <source>Zip</source>
        <translation type="obsolete">Zip</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>&amp;Method:</source>
        <translation type="obsolete">&amp;Metode:</translation>
    </message>
    <message>
        <source>&amp;Quality:</source>
        <translation type="obsolete">&amp;Kwaliteit:</translation>
    </message>
    <message>
        <source>Maximum</source>
        <translation type="obsolete">Maksimum</translation>
    </message>
    <message>
        <source>High</source>
        <translation type="obsolete">Hoog</translation>
    </message>
    <message>
        <source>Medium</source>
        <translation type="obsolete">Medium</translation>
    </message>
    <message>
        <source>Low</source>
        <translation type="obsolete">Laag</translation>
    </message>
    <message>
        <source>Minimum</source>
        <translation type="obsolete">Minimum</translation>
    </message>
    <message>
        <source>&amp;Downsample Images to:</source>
        <translation type="obsolete">&amp;Hermonster Prente af na:</translation>
    </message>
    <message>
        <source>&amp;General</source>
        <translation type="obsolete">Al&amp;gemeen</translation>
    </message>
    <message>
        <source>&amp;Embed all Fonts</source>
        <translation type="obsolete">Inbed alle l&amp;ettertipes</translation>
    </message>
    <message>
        <source>Embedding</source>
        <translation type="obsolete">Inbedding</translation>
    </message>
    <message>
        <source>Available Fonts:</source>
        <translation type="obsolete">Beskikbare lettertipes:</translation>
    </message>
    <message>
        <source>&amp;&gt;&gt;</source>
        <translation type="obsolete">&amp;&gt;&gt;</translation>
    </message>
    <message>
        <source>&amp;&lt;&lt;</source>
        <translation type="obsolete">&amp;&lt;&lt;</translation>
    </message>
    <message>
        <source>Fonts to embed:</source>
        <translation type="obsolete">Lettertipes om in te bed:</translation>
    </message>
    <message>
        <source>&amp;Fonts</source>
        <translation type="obsolete">&amp;Lettertipes</translation>
    </message>
    <message>
        <source>Page</source>
        <translation type="obsolete">Bladsy</translation>
    </message>
    <message>
        <source>Show Page Pre&amp;views</source>
        <translation type="obsolete">&amp;Vertoon Bladsyvoorbeeld</translation>
    </message>
    <message>
        <source>Effects</source>
        <translation type="obsolete">Effekte</translation>
    </message>
    <message>
        <source>&amp;Display Duration:</source>
        <translation type="obsolete">Verton ty&amp;dsduur:</translation>
    </message>
    <message>
        <source>Effec&amp;t Duration:</source>
        <translation type="obsolete">Effek &amp;tydsduur:</translation>
    </message>
    <message>
        <source>Effect T&amp;ype:</source>
        <translation type="obsolete">Effekt&amp;ipe:</translation>
    </message>
    <message>
        <source>&amp;Moving Lines:</source>
        <translation type="obsolete">&amp;Bewegende lyne:</translation>
    </message>
    <message>
        <source>F&amp;rom the:</source>
        <translation type="obsolete">&amp;Van die:</translation>
    </message>
    <message>
        <source>D&amp;irection:</source>
        <translation type="obsolete">R&amp;igting:</translation>
    </message>
    <message>
        <source> sec</source>
        <translation type="obsolete">sec</translation>
    </message>
    <message>
        <source>No Effect</source>
        <translation type="obsolete">Geen effek</translation>
    </message>
    <message>
        <source>Blinds</source>
        <translation type="obsolete">Blinders</translation>
    </message>
    <message>
        <source>Box</source>
        <translation type="obsolete">Boks</translation>
    </message>
    <message>
        <source>Dissolve</source>
        <translation type="obsolete">Oplos</translation>
    </message>
    <message>
        <source>Glitter</source>
        <translation type="obsolete">Glinster</translation>
    </message>
    <message>
        <source>Split</source>
        <translation type="obsolete">Deel</translation>
    </message>
    <message>
        <source>Wipe</source>
        <translation type="obsolete">Uitvee</translation>
    </message>
    <message>
        <source>Horizontal</source>
        <translation type="obsolete">Horisontaal</translation>
    </message>
    <message>
        <source>Vertical</source>
        <translation type="obsolete">Vertikaal</translation>
    </message>
    <message>
        <source>Inside</source>
        <translation type="obsolete">Binne</translation>
    </message>
    <message>
        <source>Outside</source>
        <translation type="obsolete">Buite</translation>
    </message>
    <message>
        <source>Left to Right</source>
        <translation type="obsolete">Links na regs</translation>
    </message>
    <message>
        <source>Top to Bottom</source>
        <translation type="obsolete">Bo na onder</translation>
    </message>
    <message>
        <source>Bottom to Top</source>
        <translation type="obsolete">Onder na bo</translation>
    </message>
    <message>
        <source>Right to Left</source>
        <translation type="obsolete">Regs na links</translation>
    </message>
    <message>
        <source>Top-left to Bottom-Right</source>
        <translation type="obsolete">Linksbo na regsonder</translation>
    </message>
    <message>
        <source>&amp;Apply Effect on all Pages</source>
        <translation type="obsolete">Pas Effek op &amp;alle bladsye toe</translation>
    </message>
    <message>
        <source>&amp;Use Encryption</source>
        <translation type="obsolete">Gebruik enkripsie</translation>
    </message>
    <message>
        <source>Passwords</source>
        <translation type="obsolete">Wagwoord</translation>
    </message>
    <message>
        <source>&amp;User:</source>
        <translation type="obsolete">Gebr&amp;uiker:</translation>
    </message>
    <message>
        <source>&amp;Owner:</source>
        <translation type="obsolete">&amp;Eienaar:</translation>
    </message>
    <message>
        <source>Settings</source>
        <translation type="obsolete">Instellings</translation>
    </message>
    <message>
        <source>Allow &amp;Printing the Document</source>
        <translation type="obsolete">Laat &amp;druk van dokument toe</translation>
    </message>
    <message>
        <source>Allow &amp;Changing the Document</source>
        <translation type="obsolete">Laat Wy&amp;siging van dokument toe</translation>
    </message>
    <message>
        <source>Allow Cop&amp;ying Text and Graphics</source>
        <translation type="obsolete">Laat &amp;Kopiëring van teks en prente toe</translation>
    </message>
    <message>
        <source>Allow Adding &amp;Annotations and Fields</source>
        <translation type="obsolete">Laat Toevoegen van &amp;annotasies en velde toe</translation>
    </message>
    <message>
        <source>S&amp;ecurity</source>
        <translation type="obsolete">V&amp;eiligheid</translation>
    </message>
    <message>
        <source>General</source>
        <translation type="obsolete">Algemeen</translation>
    </message>
    <message>
        <source>Output &amp;Intended For:</source>
        <translation type="obsolete">&amp;Uitvoer bestem vir:</translation>
    </message>
    <message>
        <source>Screen / Web</source>
        <translation type="obsolete">Skerm / web (RGB)</translation>
    </message>
    <message>
        <source>Printer</source>
        <translation type="obsolete">Drukker (CMYK)</translation>
    </message>
    <message>
        <source>&amp;Use Custom Rendering Settings</source>
        <translation type="obsolete">&amp;Gebruik tuisgemaakte rendering instellings</translation>
    </message>
    <message>
        <source>Rendering Settings</source>
        <translation type="obsolete">Rendering instellings</translation>
    </message>
    <message>
        <source>Fre&amp;quency:</source>
        <translation type="obsolete">Fre&amp;kwensie:</translation>
    </message>
    <message>
        <source>&amp;Angle:</source>
        <translation type="obsolete">&amp;Hoek:</translation>
    </message>
    <message>
        <source>S&amp;pot Function:</source>
        <translation type="obsolete">&amp;Punt-funksie:</translation>
    </message>
    <message>
        <source>Simple Dot</source>
        <translation type="obsolete">Enkele stip</translation>
    </message>
    <message>
        <source>Line</source>
        <translation type="obsolete">Lyn</translation>
    </message>
    <message>
        <source>Round</source>
        <translation type="obsolete">Rond</translation>
    </message>
    <message>
        <source>Ellipse</source>
        <translation type="obsolete">Ovaal</translation>
    </message>
    <message>
        <source>Solid Colors:</source>
        <translation type="obsolete">Soliede kleure:</translation>
    </message>
    <message>
        <source>Use ICC Profile</source>
        <translation type="obsolete">Gebruik ICC-profiel</translation>
    </message>
    <message>
        <source>Profile:</source>
        <translation type="obsolete">Profiel:</translation>
    </message>
    <message>
        <source>Rendering-Intent:</source>
        <translation type="obsolete">Rendering intent:</translation>
    </message>
    <message>
        <source>Perceptual</source>
        <translation type="obsolete">Perseptueel</translation>
    </message>
    <message>
        <source>Relative Colorimetric</source>
        <translation type="obsolete">Relatief kleurmetries</translation>
    </message>
    <message>
        <source>Saturation</source>
        <translation type="obsolete">Versadiging</translation>
    </message>
    <message>
        <source>Absolute Colorimetric</source>
        <translation type="obsolete">Absoluut kleurmetries</translation>
    </message>
    <message>
        <source>Images:</source>
        <translation type="obsolete">Prente:</translation>
    </message>
    <message>
        <source>Don&apos;t use embedded ICC profiles</source>
        <translation type="obsolete">Moenie ingebedde ICC-profiele gebruik nie</translation>
    </message>
    <message>
        <source>C&amp;olor</source>
        <translation type="obsolete">&amp;Kleur</translation>
    </message>
    <message>
        <source>PDF/X-3 Output Intent</source>
        <translation type="obsolete">PDF/X-3 uitvoer doel</translation>
    </message>
    <message>
        <source>&amp;Info String:</source>
        <translation type="obsolete">&amp;Inligting teks:</translation>
    </message>
    <message>
        <source>Output &amp;Profile:</source>
        <translation type="obsolete">Uitvoer&amp;profiel:</translation>
    </message>
    <message>
        <source>Trim Box</source>
        <translation type="obsolete">Reghoekknipboks</translation>
    </message>
    <message>
        <source>PDF/X-&amp;3</source>
        <translation type="obsolete">PDF/X-&amp;3</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source>&amp;Save</source>
        <translation type="obsolete">&amp;Stoor</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Export all pages to PDF</source>
        <translation type="obsolete">Voer alle bladsye na PDF uit</translation>
    </message>
    <message>
        <source>Export a range of pages to PDF</source>
        <translation type="obsolete">Voer bereik van bladsye na PDF uit</translation>
    </message>
    <message>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Skei bladsye met komme bv. 1,3,4,5 
of gebruik 1-4 wat als vanaf 1 tot en met 4 insluit 
of gebruik * vir alle bladsye</translation>
    </message>
    <message>
        <source>Determines the PDF compatibility. The default is Acrobat 4.0 which gives the widest compatibility.
Choose Acrobat 5.0 if your file has PDF 1.4 features such as transparency or you require 128 bit encryption.
PDF/X-3 is for exporting the PDF for commercial printing and is selectable when you have activated color management.</source>
        <translation type="obsolete">Bepaal PDF-anpasbaarheid. Verstek is &quot;Acrobat 4.0&quot;, dit bied die meeste aanpasbaarheid.
Gebruik Acrobat 5.0 as u funksies uit PDF 1.4 gebruik, soos deursigtigheid of 128-bis enkripsie.
PDF/X-3 is vir kommersiële drukkers en is kiesbaar as jy kleurbestuur aktiveer.</translation>
    </message>
    <message>
        <source>Determines the binding of pages in the PDF. Unless you know
you need to change it leave the default choice - Left.</source>
        <translation type="obsolete">Stel die bind van bladsye in die PDF. Los op verstek (links), tensy u weet wat u doen.</translation>
    </message>
    <message>
        <source>Generates thumbnails of each page in the PDF.
Some viewers can use the thumbnails for navigation.</source>
        <translation type="obsolete">Maak miniatuurbladsye van elke bladsy in die PDF.
So mmige blaaiers kan dit vir navigasie gebruik.</translation>
    </message>
    <message>
        <source>Generate PDF Articles, which is useful for navigating linked articles in a PDF.</source>
        <translation type="obsolete">Maak PDF-artikels, sodat gemakliker in geskakelde pdfs genavigeer kan word.</translation>
    </message>
    <message>
        <source>Embed the bookmarks you created in your document.
These are useful for navigating long PDF documents.</source>
        <translation type="obsolete">Inbed bladwysers in dokument, sodat lange
dokumente maklik deurblaai kan word.</translation>
    </message>
    <message>
        <source>Export resolution of text and vector graphics.
This does not affect the resolution of bitmap images like photos.</source>
        <translation type="obsolete">Uitvoer resolusie van teks en vektorgrafika.
Dit het geen invloed op prent resolusies (soos JPG&apos;s) nie.</translation>
    </message>
    <message>
        <source>Compression of text and graphics.
Unless you have a reason, leave this checked. This reduces PDF size.</source>
        <translation type="obsolete">Kompressie van text en grafika
Moenie sonder rede verander nie. Dit verklein PDF groottes.</translation>
    </message>
    <message>
        <source>Version of compression for images.
Automatic allows Scribus to choose the best method.
ZIP is good for images with solid colors.
JPEG is better at creating smaller PDF files which have many photos (with slight image loss possible).
Leave it set to automatic, unless you have a need for special compression options.</source>
        <translation type="obsolete">Kompressie metode vir prente.
Outomaties laat Scribus die beste metode kies.
ZIP is goed vir beelde met soliede kleure.
JPEG is veral effektief met baie prente (waarvoor &apos;n geringe verlies moontlik is).
Los op outomaties, tensy u &apos;n rede vir &apos;n bepaalde kompressie het.</translation>
    </message>
    <message>
        <source>Compression levels: Minimum (25%), Low (50%), Medium (75%), High (85%), Maximum (95%)</source>
        <translation type="obsolete">Kompressievlakke: Minimum (25%), laag (50%), medium (75%), hoog (85%), maksimum (95%)</translation>
    </message>
    <message>
        <source>Downsample your bitmap images to the selected DPI.
Leaving this unchecked will render them at their native resolution.</source>
        <translation type="obsolete">Monster bitmap prente af na gekose DPI.
As u hierdie los, word hulle in hulle huidige resolusies gestoor.</translation>
    </message>
    <message>
        <source>DPI (Dots Per Inch) for image export.</source>
        <translation type="obsolete">DPI (kolle per duim) vir prentjie uitvoer.</translation>
    </message>
    <message>
        <source>Embed fonts into the PDF. Embedding the fonts
will preserve the layout and appearance of your document.</source>
        <translation type="obsolete">In bed lettertipes in dIe PDF. Dit verseker dat dokument se voorkoms nie sal verander nie.</translation>
    </message>
    <message>
        <source>Enables presentation effects when using Acrobat Reader in full screen mode.</source>
        <translation type="obsolete">Skakel aanbieding effekte aan as Acrobat in volskerm modus is.</translation>
    </message>
    <message>
        <source>Show page previews of each page listed above.</source>
        <translation type="obsolete">Wys bladsyvoorbeelde van bogenoemde bladsye.</translation>
    </message>
    <message>
        <source>Length of time the page is shown before the presentation starts on the selected page.</source>
        <translation type="obsolete">Bladsy vertooning duurs voordat aanbieding effekte begin.</translation>
    </message>
    <message>
        <source>Length of time the effect runs.
A shorter time will speed up the effect, a longer one will slow it down.</source>
        <translation type="obsolete">Tydsduur van effek.
Korter tyd sal effek versnel, &apos;n langer sal dit vertraag.</translation>
    </message>
    <message>
        <source>Type of the display effect.</source>
        <translation type="obsolete">Tipe oorgangseffect.</translation>
    </message>
    <message>
        <source>Direction of the effect of moving lines for the split and blind effects.</source>
        <translation type="obsolete">Rigting van effek van bewegende lyne vir die split en verblind effekte.</translation>
    </message>
    <message>
        <source>Starting position for the box and split effects.</source>
        <translation type="obsolete">Beginposisie vir die regthoek en split-effekte.</translation>
    </message>
    <message>
        <source>Direction of the glitter or wipe effects.</source>
        <translation type="obsolete">Rigting vir die glinster of vee-effekte.</translation>
    </message>
    <message>
        <source>Apply the selected effect to all pages.</source>
        <translation type="obsolete">Pas gekose effek op alle bladsye toe.</translation>
    </message>
    <message>
        <source>Enable the security features in your exported PDF.
If you selected Acrobat 4.0, the PDF will be protected by 40 bit encryption.
If you selected Acrobat 5.0, the PDF will be protected by 128 bit encryption.
Disclaimer: PDF encryption is not as reliable as GPG or PGP encryption and does have some limitations.</source>
        <translation type="obsolete">Schakelt beveiligingsfuncties in uw PDF in.
Als u Acrobat 4.0 selecteerde, zal de PDF beschermd zyn met 40-bit versleuteling.
Als u Acrobat 5.0 selecteerde, zal de PDF beschermd zyn met 128-bit versleuteling.
Let op: PDF-versleuteling is niet zo veilig als GPG of PGP-versleuteling en heeft enkele andere beperkingen.</translation>
    </message>
    <message>
        <source>Choose a master password which enables or disables all the
security features in your exported PDF</source>
        <translation type="obsolete">Kies een master-wachtwoord om alle beveiligingsinstellingen
in of uit te schakelen in uw PDF</translation>
    </message>
    <message>
        <source>Choose a password for users to be able to read your PDF.</source>
        <translation type="obsolete">Kies een wachtwoord vir gebruikers om de PDF te kunnen lezen.</translation>
    </message>
    <message>
        <source>Allow printing of the PDF. If un-checked, printing is prevented. </source>
        <translation type="obsolete">Het afdrukken van de PDF toestaan. Indien niet geselecteerd is afdrukken onmogelyk.</translation>
    </message>
    <message>
        <source>Allow modifying of the PDF. If un-checked, modifying the PDF is prevented.</source>
        <translation type="obsolete">Wyzigen van de PDF toestaan. Indien niet geselecteerd is wyzigen onmogelyk.</translation>
    </message>
    <message>
        <source>Allow copying of text or graphics from the PDF. 
If un-checked, text and graphics cannot be copied.</source>
        <translation type="obsolete">Het kopiëren van teks of prente uit de PDF toestaan.
Indien niet geselecteerd is dit onmogelyk.</translation>
    </message>
    <message>
        <source>Allow adding annotations and fields to the PDF. 
If un-checked, editing annotations and fileds is prevented.</source>
        <translation type="obsolete">Het toevoegen van annotaties en velden aan de PDF toestaan.
Indien niet geselecteerd, is dit onmogelyk.</translation>
    </message>
    <message>
        <source>Color model for the output of your PDF.
Choose Screen/Web for PDFs which are used for screen display and for printing on typical inkjets.
Choose Printer when printing to a true 4 color CMYK printer.</source>
        <translation type="obsolete">Kleurmodel vir uitvoer van u PDF.
Kies Skerm/web (RGB) vir PDF&apos;s wat op skerms vertoon of tipiese Inkjet drukkers gedruk word.
Kies Printer (CMYK) as u na &apos;n egte vierkleur (CMYK) drukker druk.</translation>
    </message>
    <message>
        <source>This is an advanced setting which is not enabled by default. This should only be enabled
when specifically requested by your printer and they have given you the exact details needed.
Otherwise, your exported PDF may not print properly and is truly not portable across systems.</source>
        <translation type="obsolete">Hierdie is &apos;n gevorderde stelling wat net gebruik moet word as jou drukker vir jou sê om dit te stel. Raadpleeg die poslys vir u hiermee peuter.</translation>
    </message>
    <message>
        <source>Embed a color profile for solid colors</source>
        <translation type="obsolete">Inbed &apos;n kleurprofiel vir soliede kleure</translation>
    </message>
    <message>
        <source>Color profile for solid colors</source>
        <translation type="obsolete">Kleurprofiel vir soliede kleure</translation>
    </message>
    <message>
        <source>Rendering intent for solid colors</source>
        <translation type="obsolete">Rendering doel vir soliede kleure</translation>
    </message>
    <message>
        <source>Embed a color profile for images</source>
        <translation type="obsolete">Inbed van &apos;n kleurprofiel vir prente</translation>
    </message>
    <message>
        <source>Do not use color profiles that are embedded in source images</source>
        <translation type="obsolete">Kleurprofiele in prentjies moenie gebruik word nie</translation>
    </message>
    <message>
        <source>Color profile for images</source>
        <translation type="obsolete">Kleurprofiel vir prente</translation>
    </message>
    <message>
        <source>Rendering intent for images</source>
        <translation type="obsolete">Rendering doel vir prente</translation>
    </message>
    <message>
        <source>Output profile for printing. If possible, get some guidance from your printer on profile selection.</source>
        <translation type="obsolete">Uitvoerprofiel vir drukwerk. Indien moontlik, probeer leiding by u drukker te kry.</translation>
    </message>
    <message>
        <source>Mandatory string for PDF/X-3 or the PDF will fail
PDF/X-3 conformance. We recommend you use the title of the document.</source>
        <translation type="obsolete">Verpligte string vir PDF/X-3, anders voldoen PDF nie aan PDF/X-3 standaard nie. Ons beveel die dokument titel aan.</translation>
    </message>
    <message>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die bokant van die fisiese bladsy</translation>
    </message>
    <message>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die onderkant van die fisiese bladsy</translation>
    </message>
    <message>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die linkerkant van die fisiese bladsy</translation>
    </message>
    <message>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die regterkant van die fisiese bladsy</translation>
    </message>
    <message>
        <source>Save as</source>
        <translation type="obsolete">Stoor as</translation>
    </message>
    <message>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation type="obsolete">PDF-lêers (*.pdf);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Rotasie:</translation>
    </message>
    <message>
        <source>Compress Text and &amp;Vector Graphics</source>
        <translation type="obsolete">Krimp teks en vektorgrafika</translation>
    </message>
    <message>
        <source>&amp;Subset all Fonts</source>
        <translation type="obsolete">&amp;Substel alle lettertipes</translation>
    </message>
    <message>
        <source>Fonts to subset:</source>
        <translation type="obsolete">Lettertipes om te substel:</translation>
    </message>
    <message>
        <source>En&amp;able Presentation Effects</source>
        <translation type="obsolete">Sk&amp;akel aanbieding effekte aan</translation>
    </message>
    <message>
        <source>&amp;Presentation</source>
        <translation type="obsolete">&amp;Aanbieding</translation>
    </message>
    <message>
        <source>Mirror Page(s) horizontally</source>
        <translation type="obsolete">Spieëlbeeld bladsy(e) horisontaal</translation>
    </message>
    <message>
        <source>Mirror Page(s) vertically</source>
        <translation type="obsolete">Spieëlbeeld bladsy(e) vertikaal</translation>
    </message>
</context>
<context>
    <name>PDFlib</name>
    <message>
        <source>Page:</source>
        <translation type="obsolete">Bladsy:</translation>
    </message>
</context>
<context>
    <name>PPreview</name>
    <message>
        <location filename="../../../scribus/preview.cpp" line="82"/>
        <source>Print Preview</source>
        <translation>Drukvoorbeeld</translation>
    </message>
    <message>
        <source>Anti-alias &amp;Text</source>
        <translation type="obsolete">Anti-aliaseer &amp;teks</translation>
    </message>
    <message>
        <source>Anti-alias &amp;Graphics</source>
        <translation type="obsolete">Anti-aliaseer &amp;grafika</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="134"/>
        <source>Display Trans&amp;parency</source>
        <translation>Vertoon deursi&amp;gtigheid</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="278"/>
        <source>&amp;Under Color Removal</source>
        <translation>Onderleênde kle&amp;ur verwydering</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="139"/>
        <source>&amp;Display CMYK</source>
        <translation>&amp;Vertoon CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="236"/>
        <source>&amp;C</source>
        <translation>&amp;C</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="241"/>
        <source>&amp;M</source>
        <translation>&amp;M</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="246"/>
        <source>&amp;Y</source>
        <translation>&amp;Y</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="251"/>
        <source>&amp;K</source>
        <translation>&amp;K</translation>
    </message>
    <message>
        <source>Provides a more pleasant view of text items in the viewer, at the expense
of a slight slowdown in previewing. This only affects Type 1 fonts</source>
        <translation type="obsolete">Verskaf mooier teks in ruil vir spoed. Dit het net &apos;n effek op Tipe 1 lettertipes</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="356"/>
        <source>Shows transparency and transparent items in your document. Requires Ghostscript 7.07 or later</source>
        <translation>Vertoon deursigtigheid en deursigtige items in dokument. Vereis Ghostscript 7.07 of nuwer</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="357"/>
        <source>Gives a print preview using simulations of generic CMYK inks, instead of RGB colors</source>
        <translation>Gee &apos;n drukvoorbeeld weer met simulaties van CMYK-inke, ipv RGB-kleure</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="380"/>
        <source>Enable/disable the C (Cyan) ink plate</source>
        <translation>Skakel die C (Cyaan) inkplaat aan of af</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="381"/>
        <source>Enable/disable the M (Magenta) ink plate</source>
        <translation>Skakel die M (Magenta) inkplaat aan of af</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="382"/>
        <source>Enable/disable the Y (Yellow) ink plate</source>
        <translation>Skakel die Y (Yellow = geel) inkplaat aan of af</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="383"/>
        <source>Enable/disable the K (Black) ink plate</source>
        <translation>Skakel die K (blacK = swart) inkplaat aan of af</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="588"/>
        <location filename="../../../scribus/preview.cpp" line="691"/>
        <source>All</source>
        <translation>Alles</translation>
    </message>
    <message>
        <source>A way of switching off some of the gray shades which are composed
of cyan, yellow and magenta and using black instead.
UCR most affects parts of images which are neutral and/or dark tones
which are close to the gray. Use of this may improve printing some images
and some experimentation and testing is need on a case by case basis.
UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">I metode om CMY grys te vervang met swart grys.
UCR (Under Color Removal) het veral &apos;n invloed op donker en neutrale skadus naby grys. Sommige prente sal mooier druk met die, maar mens moet maar maarmee eksperimenteer.
UCR verklein die kans op overversadiging met CMY inke.</translation>
    </message>
    <message>
        <source>Provides a more pleasant view of TrueType Fonts, OpenType Fonts, EPS, PDF and
vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation type="obsolete">Verskaf mooier TrueType letters, Opentype letters, EPS, PDF en vektorgrafika vertoning, maar maak die proses effens stadiger.</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="152"/>
        <source>Separation Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="164"/>
        <source>Cyan</source>
        <translation type="unfinished">Cyaan</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="171"/>
        <source>Magenta</source>
        <translation type="unfinished">Magenta</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="178"/>
        <source>Yellow</source>
        <translation type="unfinished">Geel</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="185"/>
        <source>Black</source>
        <translation type="unfinished">Swart</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="299"/>
        <source>Scaling:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="327"/>
        <source>Print...</source>
        <translation type="unfinished">Afdrukken...</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="358"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="359"/>
        <source>Resize the scale of the page.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="324"/>
        <source>Close</source>
        <translation type="unfinished">Maak toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="1257"/>
        <source>File</source>
        <translation type="unfinished">Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="129"/>
        <source>Enable &amp;Antialiasing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="311"/>
        <source>Fit to Width</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="312"/>
        <source>Fit to Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="313"/>
        <source>Fit to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="355"/>
        <source>Provides a more pleasant view of Type 1 fonts, TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="123"/>
        <source>Display Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="260"/>
        <source>Print Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="266"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="269"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="275"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="281"/>
        <source>Convert Spot Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="360"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="284"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="361"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="272"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="206"/>
        <source>Display Ink Coverage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="214"/>
        <source>Threshold:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="217"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/preview.cpp" line="221"/>
        <source>None</source>
        <translation type="unfinished">Geen</translation>
    </message>
</context>
<context>
    <name>PSLib</name>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1843"/>
        <source>Processing Master Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1843"/>
        <source>Exporting Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1776"/>
        <source>Failed to write data for an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1781"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1786"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pslib.cpp" line="1791"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PStyleW</name>
    <message>
        <source>Properties</source>
        <translation type="obsolete">Eienskappe</translation>
    </message>
    <message>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabs en induiking</translation>
    </message>
</context>
<context>
    <name>PStyleWBase</name>
    <message>
        <source>Properties</source>
        <translation type="obsolete">Eienskappe</translation>
    </message>
    <message>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabs en induiking</translation>
    </message>
</context>
<context>
    <name>Page</name>
    <message>
        <source>Copy Here</source>
        <translation type="obsolete">Kopiër hierheen</translation>
    </message>
    <message>
        <source>Move Here</source>
        <translation type="obsolete">Skuif hierheen</translation>
    </message>
    <message>
        <source>Cancel</source>
        <translation type="obsolete">Kanselleer</translation>
    </message>
    <message>
        <source>&amp;Paste</source>
        <translation type="obsolete">&amp;Plak</translation>
    </message>
    <message>
        <source>Show &amp;Margins</source>
        <translation type="obsolete">Vertoon &amp;Kantlyne</translation>
    </message>
    <message>
        <source>Show &amp;Frames</source>
        <translation type="obsolete">Vertoon &amp;Rame</translation>
    </message>
    <message>
        <source>Show &amp;Images</source>
        <translation type="obsolete">Wys pren&amp;te</translation>
    </message>
    <message>
        <source>Show &amp;Grid</source>
        <translation type="obsolete">Wys R&amp;ooster</translation>
    </message>
    <message>
        <source>Show G&amp;uides</source>
        <translation type="obsolete">Wys H&amp;ulplyne</translation>
    </message>
    <message>
        <source>Show &amp;Baseline Grid</source>
        <translation type="obsolete">Wys &amp;Basislyn-rooster</translation>
    </message>
    <message>
        <source>Sn&amp;ap to Grid</source>
        <translation type="obsolete">Ma&amp;gnetise rooster</translation>
    </message>
    <message>
        <source>Sna&amp;p to Guides</source>
        <translation type="obsolete">Magnetise hul&amp;plyne</translation>
    </message>
    <message>
        <source>Picture</source>
        <translation type="obsolete">Prent</translation>
    </message>
    <message>
        <source>File: </source>
        <translation type="obsolete">Lêer: </translation>
    </message>
    <message>
        <source>Original PPI: </source>
        <translation type="obsolete">Oorspronklike PPI:</translation>
    </message>
    <message>
        <source>Actual PPI: </source>
        <translation type="obsolete">Werklike PPI:</translation>
    </message>
    <message>
        <source>Linked Text</source>
        <translation type="obsolete">Geskakelde teks</translation>
    </message>
    <message>
        <source>Text Frame</source>
        <translation type="obsolete">Teksraam</translation>
    </message>
    <message>
        <source>Text on a Path</source>
        <translation type="obsolete">Teks op &apos;n pad</translation>
    </message>
    <message>
        <source>Paragraphs: </source>
        <translation type="obsolete">Paragrawe: </translation>
    </message>
    <message>
        <source>Words: </source>
        <translation type="obsolete">Woorde:</translation>
    </message>
    <message>
        <source>Chars: </source>
        <translation type="obsolete">Letters:</translation>
    </message>
    <message>
        <source>Print: </source>
        <translation type="obsolete">Druk: </translation>
    </message>
    <message>
        <source>Enabled</source>
        <translation type="obsolete">Aan</translation>
    </message>
    <message>
        <source>Disabled</source>
        <translation type="obsolete">Af</translation>
    </message>
    <message>
        <source>In&amp;fo</source>
        <translation type="obsolete">In&amp;lig</translation>
    </message>
    <message>
        <source>&amp;Get Picture...</source>
        <translation type="obsolete">Kry &amp;Prent...</translation>
    </message>
    <message>
        <source>I&amp;mage Visible</source>
        <translation type="obsolete">P&amp;rent sigbaar</translation>
    </message>
    <message>
        <source>&amp;Update Picture</source>
        <translation type="obsolete">Opdatee&amp;r prent</translation>
    </message>
    <message>
        <source>&amp;Edit Picture</source>
        <translation type="obsolete">Bewerk pr&amp;ent</translation>
    </message>
    <message>
        <source>&amp;Adjust Frame to Picture</source>
        <translation type="obsolete">Pas raamgrootte by &amp;prent aan</translation>
    </message>
    <message>
        <source>&amp;Get Text...</source>
        <translation type="obsolete">Kr&amp;y Teks...</translation>
    </message>
    <message>
        <source>&amp;Append Text...</source>
        <translation type="obsolete">V&amp;oeg Teks agteraan...</translation>
    </message>
    <message>
        <source>&amp;Edit Text...</source>
        <translation type="obsolete">Bewerk T&amp;eks...</translation>
    </message>
    <message>
        <source>Is PDF &amp;Bookmark</source>
        <translation type="obsolete">Dit is &apos;n PDF-&amp;boekmerk</translation>
    </message>
    <message>
        <source>Is PDF A&amp;nnotation</source>
        <translation type="obsolete">Dit is &apos;n PDF-a&amp;nnotasie</translation>
    </message>
    <message>
        <source>Annotation P&amp;roperties</source>
        <translation type="obsolete">&amp;Eienskappe van annotasie</translation>
    </message>
    <message>
        <source>Field P&amp;roperties</source>
        <translation type="obsolete">&amp;Veldeienskappe</translation>
    </message>
    <message>
        <source>&amp;PDF Options</source>
        <translation type="obsolete">&amp;PDF-opsies</translation>
    </message>
    <message>
        <source>Edit Text...</source>
        <translation type="obsolete">Bewerk Teks...</translation>
    </message>
    <message>
        <source>&amp;Lock</source>
        <translation type="obsolete">S&amp;luit</translation>
    </message>
    <message>
        <source>Un&amp;lock</source>
        <translation type="obsolete">Onts&amp;luit</translation>
    </message>
    <message>
        <source>Lock Object &amp;Size</source>
        <translation type="obsolete">Sluit Objek&amp;grootte</translation>
    </message>
    <message>
        <source>Unlock Object &amp;Size</source>
        <translation type="obsolete">Ontsluit Objek&amp;grootte</translation>
    </message>
    <message>
        <source>Send to S&amp;crapbook</source>
        <translation type="obsolete">Stuur na &amp;kladblok</translation>
    </message>
    <message>
        <source>Send to La&amp;yer</source>
        <translation type="obsolete">Stuur na &amp;laag</translation>
    </message>
    <message>
        <source>&amp;Insert Sample Text</source>
        <translation type="obsolete">Voeg voorbeeldteks &amp;in</translation>
    </message>
    <message>
        <source>&amp;Group</source>
        <translation type="obsolete">&amp;Groepeer</translation>
    </message>
    <message>
        <source>Un&amp;group</source>
        <translation type="obsolete">Ont&amp;groepeer</translation>
    </message>
    <message>
        <source>Le&amp;vel</source>
        <translation type="obsolete">&amp;Vlak</translation>
    </message>
    <message>
        <source>Send to &amp;Back</source>
        <translation type="obsolete">Stuur na &amp;agtergrond</translation>
    </message>
    <message>
        <source>Bring to &amp;Front</source>
        <translation type="obsolete">Bring na &amp;voorgrond</translation>
    </message>
    <message>
        <source>&amp;Lower</source>
        <translation type="obsolete">&amp;Laatsak</translation>
    </message>
    <message>
        <source>&amp;Raise</source>
        <translation type="obsolete">&amp;Lig</translation>
    </message>
    <message>
        <source>&amp;Picture Frame</source>
        <translation type="obsolete">Prent&amp;raam</translation>
    </message>
    <message>
        <source>Pol&amp;ygon</source>
        <translation type="obsolete">Pol&amp;ygoon</translation>
    </message>
    <message>
        <source>&amp;Outlines</source>
        <translation type="obsolete">&amp;Buitelyne</translation>
    </message>
    <message>
        <source>&amp;Text Frame</source>
        <translation type="obsolete">&amp;Teksraam</translation>
    </message>
    <message>
        <source>&amp;Bezier Curve</source>
        <translation type="obsolete">&amp;Bezierkurwe</translation>
    </message>
    <message>
        <source>Conve&amp;rt to</source>
        <translation type="obsolete">Skakel om n&amp;a</translation>
    </message>
    <message>
        <source>Cu&amp;t</source>
        <translation type="obsolete">Kni&amp;p</translation>
    </message>
    <message>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Kopiër</translation>
    </message>
    <message>
        <source>&amp;Delete</source>
        <translation type="obsolete">Vee&amp;uit</translation>
    </message>
    <message>
        <source>C&amp;lear Contents</source>
        <translation type="obsolete">Maak Inhoud &amp;leeg</translation>
    </message>
    <message>
        <source>Show P&amp;roperties...</source>
        <translation type="obsolete">Toon &amp;Eienskappe...</translation>
    </message>
    <message>
        <source>Hide P&amp;roperties...</source>
        <translation type="obsolete">Versteek &amp;Eienskappe...</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>Do you really want to clear all your Text?</source>
        <translation type="obsolete">Wil u werklik al die teks uitvee?</translation>
    </message>
    <message>
        <source>The Program</source>
        <translation type="obsolete">Die program</translation>
    </message>
    <message>
        <source>is missing!</source>
        <translation type="obsolete">ontbreek op u masjien!</translation>
    </message>
    <message>
        <source>Copy of</source>
        <translation type="obsolete">Kopie van</translation>
    </message>
</context>
<context>
    <name>PageItem</name>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="390"/>
        <source>Image</source>
        <translation>Prent</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="394"/>
        <source>Text</source>
        <translation>Teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="398"/>
        <source>Line</source>
        <translation>Lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="402"/>
        <source>Polygon</source>
        <translation>Polygoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="406"/>
        <source>Polyline</source>
        <translation>Polylyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="410"/>
        <source>PathText</source>
        <translation>Tekspad</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem.cpp" line="3756"/>
        <location filename="../../../scribus/pageitem.cpp" line="3757"/>
        <source>Copy of</source>
        <translation type="unfinished">Kopie van</translation>
    </message>
</context>
<context>
    <name>PageItemAttributes</name>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Relates To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Parent Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Child Of</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="23"/>
        <source>Name</source>
        <translation type="unfinished">Naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="33"/>
        <source>Value</source>
        <translation type="unfinished">Waarde</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="58"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Toevoeg</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="71"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="114"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.cpp" line="21"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="61"/>
        <source>Alt+A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="68"/>
        <source>&amp;Copy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="78"/>
        <source>&amp;Delete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="81"/>
        <source>Alt+D</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="88"/>
        <source>C&amp;lear</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="91"/>
        <source>Alt+L</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="130"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="28"/>
        <source>Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="38"/>
        <source>Parameter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="43"/>
        <source>Relationship</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="48"/>
        <source>Relationship To</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitemattributes.ui" line="13"/>
        <source>Attributes</source>
        <translation type="unfinished">Attribute</translation>
    </message>
</context>
<context>
    <name>PageItemAttributesBase</name>
    <message>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <source>Value</source>
        <translation type="obsolete">Waarde</translation>
    </message>
    <message>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Toevoeg</translation>
    </message>
    <message>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
</context>
<context>
    <name>PageItem_ImageFrame</name>
    <message>
        <source>Picture</source>
        <translation type="obsolete">Prent</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="285"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="464"/>
        <source>Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="99"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="301"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="470"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="101"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="298"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="332"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="472"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="499"/>
        <source>File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="102"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="306"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="473"/>
        <source>Original PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="103"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="311"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="474"/>
        <source>Actual PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="104"/>
        <source>Size:</source>
        <translation type="unfinished">Grootte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="105"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="316"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="475"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="109"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="321"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="479"/>
        <source>Unknown</source>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="116"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="486"/>
        <source>Page:</source>
        <translation type="unfinished">Bladsy:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="118"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="488"/>
        <source>Pages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="336"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="497"/>
        <source>Embedded Image missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="338"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="499"/>
        <source>missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="343"/>
        <location filename="../../../scribus/pageitem_imageframe.cpp" line="502"/>
        <source>No Image Loaded</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_LatexFrame</name>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="249"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="270"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="418"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="423"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="581"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="163"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="181"/>
        <source>Running the external application failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="250"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="254"/>
        <source>Could not create a temporary file to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Information</source>
        <translation type="obsolete">Info</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="430"/>
        <source>Running the application &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="586"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="424"/>
        <source>The application &quot;%1&quot; crashed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="575"/>
        <source>Application</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="576"/>
        <source>DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="578"/>
        <source>State</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="583"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="44"/>
        <source>Render</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="164"/>
        <source>This is usually a problem with your input. Please check the program&apos;s output.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="166"/>
        <source>Do you want to open the editor to fix the problem?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="271"/>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="275"/>
        <source>The config file didn&apos;t specify a executable path!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="419"/>
        <source>The application &quot;%1&quot; failed to start! Please check the path: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="574"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="239"/>
        <source>No configuration defined to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="436"/>
        <source>No application defined</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="130"/>
        <source>Rendering...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_latexframe.cpp" line="139"/>
        <source>Render Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_PathText</name>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="321"/>
        <source>Paragraphs: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="329"/>
        <source>Lines: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="335"/>
        <source>Words: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_pathtext.cpp" line="343"/>
        <source>Chars: </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_TextFrame</name>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3568"/>
        <source>Linked Text</source>
        <translation type="unfinished">Geskakelde teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3570"/>
        <source>Text Frame</source>
        <translation type="unfinished">Teksraam</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3574"/>
        <source>Paragraphs: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3582"/>
        <source>Lines: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3588"/>
        <source>Words: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageitem_textframe.cpp" line="3596"/>
        <source>Chars: </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageLayouts</name>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="266"/>
        <source>First Page is:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="197"/>
        <source>Document Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="268"/>
        <source>Number of pages to show side-by-side on the canvas
Often used for allowing items to be placed across page spreads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagelayout.cpp" line="273"/>
        <source>Location on the canvas where the first page of the document is placed</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PagePalette</name>
    <message>
        <source>Normal</source>
        <translation type="obsolete">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="928"/>
        <source>Arrange Pages</source>
        <translation type="unfinished">Bladsye herschikken</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="929"/>
        <source>Available Master Pages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="930"/>
        <source>Document Pages:</source>
        <translation type="unfinished">Documentbladsye:</translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="933"/>
        <source>List of normal pages in the document, shown with the document layout. Pages may be dragged to rearrange or delete them.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="934"/>
        <source>Drag pages or master pages onto the trash to delete them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="932"/>
        <source>List of master pages in the document. Master page names may be dragged onto the page view below to apply master pages, or onto the empty space between pages to create new pages.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="636"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pagepalette.cpp" line="640"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageSelector</name>
    <message>
        <source>Page </source>
        <translation type="obsolete">Bladsy</translation>
    </message>
    <message>
        <source> of %1</source>
        <translation type="obsolete">van %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="267"/>
        <source>Go to the first page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="268"/>
        <source>Go to the previous page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="269"/>
        <source>Go to the next page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="270"/>
        <source>Go to the last page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="271"/>
        <source>Select the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pageselector.cpp" line="272"/>
        <source> of %1</source>
        <comment>number of pages in document</comment>
        <translation type="unfinished">van %1</translation>
    </message>
</context>
<context>
    <name>PageSize</name>
    <message>
        <source>Letter</source>
        <translation type="obsolete">Letter (US)</translation>
    </message>
    <message>
        <source>Legal</source>
        <translation type="obsolete">Legal</translation>
    </message>
    <message>
        <source>Ledger</source>
        <translation type="obsolete">Grootboek</translation>
    </message>
    <message>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
</context>
<context>
    <name>ParaStyleComboBox</name>
    <message>
        <location filename="../../../scribus/spalette.cpp" line="38"/>
        <location filename="../../../scribus/spalette.cpp" line="51"/>
        <location filename="../../../scribus/spalette.cpp" line="62"/>
        <source>No Style</source>
        <translation type="unfinished">Geen styl</translation>
    </message>
</context>
<context>
    <name>PathAlongPathPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="69"/>
        <source>Path Along Path...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="96"/>
        <source>Bends a Polygon along a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="97"/>
        <source>This plugin bends a Polygon with the help of a Polyline.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectDialogBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="13"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="27"/>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="48"/>
        <source>Starting Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="32"/>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="53"/>
        <source>End Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="69"/>
        <source>a straight Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="74"/>
        <source>Points moving</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="82"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="19"/>
        <source>Connect First Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="40"/>
        <source>with Second Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="61"/>
        <source>by using:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="65"/>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="90"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="69"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="91"/>
        <source>Connect 2 Polylines.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathCutPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="70"/>
        <source>Cut Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="76"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="99"/>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="100"/>
        <source>Cuts a Polygon by a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>Error</source>
        <translation type="unfinished">Fout</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>The cutting line must cross the polygon and
both end points must lie outside of the polygon</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathDialogBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="13"/>
        <source>Path along Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="21"/>
        <source>Effect Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="29"/>
        <source>Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="34"/>
        <source>Single, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="39"/>
        <source>Repeated</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="44"/>
        <source>Repeated, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="52"/>
        <source>Horizontal Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="62"/>
        <source>Vertical Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="103"/>
        <source>Gap between Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="113"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="72"/>
        <source>Rotate Objects by:</source>
        <translation type="unfinished"></translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="80"/>
        <source>0°</source>
        <translation type="unfinished"></translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="85"/>
        <source>90°</source>
        <translation type="unfinished"></translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="90"/>
        <source>180°</source>
        <translation type="unfinished"></translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="95"/>
        <source>270°</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderBase</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="13"/>
        <source>Boolean Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="97"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="195"/>
        <source>=</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="274"/>
        <source>Operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="289"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="308"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="324"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="340"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="357"/>
        <source>...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="381"/>
        <source>Swap Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="41"/>
        <source>First source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="139"/>
        <source>Second source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="234"/>
        <source>The resulting shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="286"/>
        <source>Unites the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="321"/>
        <source>Intersection of the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="337"/>
        <source>Result is the area where the two shapes do not intersect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="353"/>
        <source>Break apart,
The result is a combination of &quot;Intersection&quot; and &quot;Exclusion&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="450"/>
        <source>Custom Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="462"/>
        <source>Stroke:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="488"/>
        <source>Fill:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="60"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="158"/>
        <source>Keep a copy of the original item after applying the operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="63"/>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="161"/>
        <source>Keep</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="305"/>
        <source>Subtracts the second shape from the first shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="378"/>
        <source>Exchange the Source Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="424"/>
        <source>The resulting shape uses the color of the first source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="427"/>
        <source>First Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="437"/>
        <source>The resulting shape uses the color of the second source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="440"/>
        <source>Second Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="447"/>
        <source>The resulting shape uses the colors listed below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="478"/>
        <source>Stroke Color</source>
        <translation type="unfinished">Lynkleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="498"/>
        <source>Fill Color</source>
        <translation type="unfinished">Vulkleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="418"/>
        <source>Result Takes Color from:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderDialog</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="103"/>
        <source>Result gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="127"/>
        <source>Intersection gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="74"/>
        <source>Path Operations...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="78"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="103"/>
        <source>Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="104"/>
        <source>Apply fancy boolean operations to paths.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathStrokerPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="70"/>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="95"/>
        <source>Create Path from Stroke</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="74"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="96"/>
        <source>Converts the stroke of a Path to a filled Path.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PatternDialog</name>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="135"/>
        <source>Choose a Directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="163"/>
        <source>Loading Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="297"/>
        <source>All Files (*)</source>
        <translation type="unfinished">Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="311"/>
        <source>Open</source>
        <translation type="unfinished">Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="15"/>
        <source>Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="48"/>
        <source>Load File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="55"/>
        <source>Load Set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="69"/>
        <source>Remove</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="76"/>
        <source>Remove All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="99"/>
        <source>OK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="106"/>
        <source>Cancel</source>
        <translation type="unfinished">Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="85"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="85"/>
        <source>Rename Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.cpp" line="214"/>
        <source>All Supported Formats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/patterndialog.ui" line="62"/>
        <source>Rename</source>
        <translation type="unfinished">Herbenoem</translation>
    </message>
</context>
<context>
    <name>PicSearch</name>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="14"/>
        <source>Result</source>
        <translation type="unfinished">Resultaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="34"/>
        <source>Search Results for: </source>
        <translation type="unfinished">Soekresultate vir: </translation>
    </message>
    <message>
        <source>Preview</source>
        <translation type="obsolete">Voorbeeld</translation>
    </message>
    <message>
        <source>Select</source>
        <translation type="obsolete">Kies</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="128"/>
        <source>Cancel</source>
        <translation type="unfinished">Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="108"/>
        <source>Size:</source>
        <translation type="unfinished">Grootte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="109"/>
        <source>Resolution:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="109"/>
        <source>DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="112"/>
        <source>Unknown</source>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.cpp" line="115"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="86"/>
        <source>&amp;Preview</source>
        <translation type="unfinished">&amp;Voorbeeld</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="89"/>
        <source>Alt+P</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="115"/>
        <source>&amp;Select</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearch.ui" line="118"/>
        <source>Alt+S</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicSearchBase</name>
    <message>
        <source>Result</source>
        <translation type="obsolete">Resultaat</translation>
    </message>
    <message>
        <source>Search Results for: </source>
        <translation type="obsolete">Soekresultate vir: </translation>
    </message>
    <message>
        <source>&amp;Preview</source>
        <translation type="obsolete">&amp;Voorbeeld</translation>
    </message>
</context>
<context>
    <name>PicSearchOptions</name>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="51"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="58"/>
        <source>Cancel Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="67"/>
        <location filename="../../../scribus/picsearchoptions.ui" line="124"/>
        <source>Start Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="91"/>
        <source>Select a base directory for search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="103"/>
        <location filename="../../../scribus/picsearchoptions.cpp" line="140"/>
        <source>Scribus - Image Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="140"/>
        <source>The search failed: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="13"/>
        <source>Search Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="25"/>
        <source>Search for:</source>
        <translation type="unfinished">Zoeken na:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="38"/>
        <source>Start at:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="64"/>
        <source>Change...</source>
        <translation type="unfinished">Wysig...</translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="79"/>
        <source>Searching</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="141"/>
        <source>Case insensitive search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.ui" line="148"/>
        <source>Search recursively</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picsearchoptions.cpp" line="103"/>
        <source>Base directory for search does not exist.
Please choose another one.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicStatus</name>
    <message>
        <source>Pictures</source>
        <translation type="obsolete">Prente</translation>
    </message>
    <message>
        <source>Name</source>
        <translation type="obsolete">Naam</translation>
    </message>
    <message>
        <source>Path</source>
        <translation type="obsolete">Pad</translation>
    </message>
    <message>
        <source>Page</source>
        <translation type="obsolete">Bladsy</translation>
    </message>
    <message>
        <source>Print</source>
        <translation type="obsolete">Druk</translation>
    </message>
    <message>
        <source>Status</source>
        <translation type="obsolete">Status</translation>
    </message>
    <message>
        <source>Goto</source>
        <translation type="obsolete">Ga na</translation>
    </message>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">Reg</translation>
    </message>
    <message>
        <source>Missing</source>
        <translation type="obsolete">Ontbrekend</translation>
    </message>
    <message>
        <source>Search</source>
        <translation type="obsolete">Soek</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>Manage Pictures</source>
        <translation type="obsolete">Prente beheren</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="434"/>
        <source>Scribus - Image Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="434"/>
        <source>No images named &quot;%1&quot; were found.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="684"/>
        <source>Close</source>
        <translation type="unfinished">Maak toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="259"/>
        <source>Not on a Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="284"/>
        <source>JPG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="287"/>
        <source>TIFF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="290"/>
        <source>PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="293"/>
        <source>EPS/PS</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="296"/>
        <source>PDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="299"/>
        <source>JPG2000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="305"/>
        <source>emb. PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="311"/>
        <source>Unknown</source>
        <translation type="unfinished">Onbekend</translation>
    </message>
    <message>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="328"/>
        <source>n/a</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="83"/>
        <source>Information</source>
        <translation type="unfinished">Info</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="155"/>
        <source>Path:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="198"/>
        <source>Search...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="105"/>
        <source>Name:</source>
        <translation type="unfinished">Naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="215"/>
        <source>Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="288"/>
        <source>DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="221"/>
        <source>Format:</source>
        <translation type="unfinished">Formaat:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="256"/>
        <source>Colorspace:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="323"/>
        <source>Size</source>
        <translation type="unfinished">Grootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="329"/>
        <source>Pixels:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="358"/>
        <source>Scale:</source>
        <translation type="unfinished">Skaal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="387"/>
        <source>Printed:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="425"/>
        <source>Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="433"/>
        <source>On Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="546"/>
        <source>Select</source>
        <translation type="unfinished">Kies</translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="575"/>
        <source>Image Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="623"/>
        <source>Image Visible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="633"/>
        <source>Image Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="613"/>
        <source>Edit Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="600"/>
        <source>Extended Image Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="228"/>
        <source>Sort by Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="230"/>
        <source>Sort by Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="16"/>
        <source>Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="530"/>
        <source>Go to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="127"/>
        <source>Name of the image file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="177"/>
        <source>Location where the image file is stored</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="195"/>
        <source>Search for a missing image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="240"/>
        <source>Type of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="253"/>
        <source>The colorspace of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="275"/>
        <source>Colorspace used within the image, eg RGB or CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="307"/>
        <source>Native resolution of the image, in dots per inch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="345"/>
        <source>Height and width of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="374"/>
        <source>Horizontal and vertical scaling applied to the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="409"/>
        <source>Size of the image when printed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="449"/>
        <source>Page that the image is displayed on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="462"/>
        <source>Page Item:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="478"/>
        <source>Name of the page item that contains the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="491"/>
        <source>Effective DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="510"/>
        <source>Effective resolution of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="527"/>
        <source>Move to the page that the image is on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="543"/>
        <source>Move to the page that the item is on and select it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="587"/>
        <source>Enable or disable exporting of the item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="590"/>
        <source>Export/Print Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="597"/>
        <source>Set format specfic properties of certain image types, like clipping paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="610"/>
        <source>Edit the image in the default editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="620"/>
        <source>Make the image visible or invisible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.ui" line="630"/>
        <source>Apply non destructive effects to the image in its frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/picstatus.cpp" line="128"/>
        <location filename="../../../scribus/picstatus.cpp" line="143"/>
        <location filename="../../../scribus/picstatus.cpp" line="270"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PixmapExportPlugin</name>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="59"/>
        <source>Save as &amp;Image...</source>
        <translation type="unfinished">Stoor as &amp;prent...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="70"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="78"/>
        <source>Export As Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="79"/>
        <source>Exports selected pages as bitmap images.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="117"/>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="123"/>
        <source>Save as Image</source>
        <translation type="unfinished">Stoor as prent</translation>
    </message>
    <message>
        <source>Error writing the output file(s).</source>
        <translation type="obsolete">Fout tydens het skryf na uitvoerlêer(s).</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="145"/>
        <source>Export successful</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="118"/>
        <source>The target location %1 must be an existing directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/pixmapexport/export.cpp" line="124"/>
        <source>The target location %1 must be writable</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManager</name>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="60"/>
        <location filename="../../../scribus/pluginmanager.cpp" line="72"/>
        <source>Cannot find plugin</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="61"/>
        <source>unknown error</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="86"/>
        <location filename="../../../scribus/pluginmanager.cpp" line="92"/>
        <location filename="../../../scribus/pluginmanager.cpp" line="97"/>
        <source>Cannot find symbol (%1)</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Unknown</source>
        <comment>plugin manager</comment>
        <translation type="obsolete">Onbekend</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="157"/>
        <source>Plugin: loading %1</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="264"/>
        <source>init failed</source>
        <comment>plugin load error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="270"/>
        <source>unknown plugin type</source>
        <comment>plugin load error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="273"/>
        <source>Plugin: %1 loaded</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="277"/>
        <source>Plugin: %1 failed to load: %2</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="344"/>
        <source>Plugin: %1 initialized ok </source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="346"/>
        <source>Plugin: %1 failed post initialization</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanager.cpp" line="230"/>
        <source>There is a problem loading %1 of %2 plugins. %3 This is probably caused by some kind of dependency issue or old plugins existing in your install directory. If you clean out your install directory and reinstall and this still occurs, please report it on bugs.scribus.net.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManagerPrefsGui</name>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="20"/>
        <source>Plugin Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="36"/>
        <source>Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="41"/>
        <source>How to run</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="46"/>
        <source>Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="51"/>
        <source>Load it?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="56"/>
        <source>Plugin ID</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="61"/>
        <source>File</source>
        <translation type="unfinished">Lêer</translation>
    </message>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <source>No</source>
        <translation type="obsolete">Nee</translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="69"/>
        <source>You need to restart the application to apply the changes.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/pluginmanagerprefsgui.ui" line="14"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PolygonProps</name>
    <message>
        <location filename="../../../scribus/polyprops.cpp" line="20"/>
        <source>Polygon Properties</source>
        <translation>Polygoon-eienskappe</translation>
    </message>
    <message>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">Ho&amp;eke:</translation>
    </message>
    <message>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Rotasie:</translation>
    </message>
    <message>
        <source> %</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <source>&amp;Factor:</source>
        <translation type="obsolete">&amp;Faktor:</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Number of corners for polygons</source>
        <translation type="obsolete">Aantal hoeke vir polygoon</translation>
    </message>
    <message>
        <source>Degrees of rotation for polygons</source>
        <translation type="obsolete">Rotasie in grade vir polygoon</translation>
    </message>
    <message>
        <source>Sample Polygon</source>
        <translation type="obsolete">Voorbeeld polygoon</translation>
    </message>
    <message>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">Pas &amp;Faktor toe</translation>
    </message>
    <message>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="obsolete">Pas konveks/konkaaf-faktor toe om vorm van polygone te verander</translation>
    </message>
    <message>
        <source>A negative value will make the polygon concave (or star shaped),
 a positive value will make it convex</source>
        <translation type="obsolete">&apos;n Negatiewe waarde maak die polygoon konkaaf (stervormig), 
&apos;n positiewe waarde maak hom konveks</translation>
    </message>
</context>
<context>
    <name>PolygonWidget</name>
    <message>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">Ho&amp;eke:</translation>
    </message>
    <message>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Rotasie:</translation>
    </message>
    <message>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">Pas &amp;Faktor toe</translation>
    </message>
    <message>
        <source>&amp;Factor:</source>
        <translation type="obsolete">&amp;Faktor:</translation>
    </message>
    <message>
        <source>A negative value will make the polygon concave (or star shaped),
 a positive value will make it convex</source>
        <translation type="obsolete">&apos;n Negatiewe waarde maak die polygoon konkaaf (stervormig), 
&apos;n positiewe waarde maak hom konveks</translation>
    </message>
</context>
<context>
    <name>PolygonWidgetBase</name>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="30"/>
        <source>Corn&amp;ers:</source>
        <translation type="unfinished">Ho&amp;eke:</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="40"/>
        <source>Number of corners for polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="53"/>
        <source>&amp;Rotation:</source>
        <translation type="unfinished">&amp;Rotasie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="63"/>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="76"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="121"/>
        <source>Sample Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="146"/>
        <source>Apply &amp;Factor</source>
        <translation type="unfinished">Pas &amp;Faktor toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="161"/>
        <source>&amp;Factor:</source>
        <translation type="unfinished">&amp;Faktor:</translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="171"/>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="187"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="174"/>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="216"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/polygonwidgetbase.ui" line="206"/>
        <source>C&amp;urvature:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Preferences</name>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="73"/>
        <source>Preferences</source>
        <translation>Voorkeure</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="76"/>
        <source>General</source>
        <translation>Algemeen</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="79"/>
        <source>Document</source>
        <translation>Dokument</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="82"/>
        <source>Guides</source>
        <translation>Hulplyne</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="85"/>
        <source>Typography</source>
        <translation>Typografie</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="88"/>
        <source>Tools</source>
        <translation>Gereedskap</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="136"/>
        <source>Scrapbook</source>
        <translation type="unfinished">Kladblok</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="139"/>
        <source>Display</source>
        <translation>Vertoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="142"/>
        <source>External Tools</source>
        <translation type="unfinished">Eksterne hulpprogramme</translation>
    </message>
    <message>
        <source>Misc.</source>
        <translation type="obsolete">Verskei</translation>
    </message>
    <message>
        <source>GUI</source>
        <translation type="obsolete">GUI</translation>
    </message>
    <message>
        <source>&amp;Theme:</source>
        <translation type="obsolete">S&amp;tyl:</translation>
    </message>
    <message>
        <source> pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <source>&amp;Font Size:</source>
        <translation type="obsolete">&amp;Lettergrootte:</translation>
    </message>
    <message>
        <source>Units</source>
        <translation type="obsolete">Eenhede</translation>
    </message>
    <message>
        <source>Points (pt)</source>
        <translation type="obsolete">Punte (pt)</translation>
    </message>
    <message>
        <source>Millimetres (mm)</source>
        <translation type="obsolete">Millimeter (mm)</translation>
    </message>
    <message>
        <source>Inches (in)</source>
        <translation type="obsolete">Duime (in)</translation>
    </message>
    <message>
        <source>Picas (p)</source>
        <translation type="obsolete">Pica&apos;s (p)</translation>
    </message>
    <message>
        <source>Mouse Settings</source>
        <translation type="obsolete">Muisinstelling</translation>
    </message>
    <message>
        <source>&amp;Wheel Jump:</source>
        <translation type="obsolete">&amp;Wiel sprong:</translation>
    </message>
    <message>
        <source> px</source>
        <translation type="obsolete">px</translation>
    </message>
    <message>
        <source>&amp;Grab Radius:</source>
        <translation type="obsolete">&amp;Gryp afstand:</translation>
    </message>
    <message>
        <source>Menus</source>
        <translation type="obsolete">Menu&apos;s</translation>
    </message>
    <message>
        <source>&amp;Recent Documents:</source>
        <translation type="obsolete">&amp;Onlangse dokumente:</translation>
    </message>
    <message>
        <source>Paths</source>
        <translation type="obsolete">Paaie</translation>
    </message>
    <message>
        <source>&amp;Documents:</source>
        <translation type="obsolete">&amp;Dokumente:</translation>
    </message>
    <message>
        <source>&amp;Change...</source>
        <translation type="obsolete">&amp;Wysig...</translation>
    </message>
    <message>
        <source>&amp;ICC Profiles:</source>
        <translation type="obsolete">&amp;ICC-profiele:</translation>
    </message>
    <message>
        <source>C&amp;hange...</source>
        <translation type="obsolete">Wys&amp;ig...</translation>
    </message>
    <message>
        <source>&amp;Scripts:</source>
        <translation type="obsolete">&amp;Scripts:</translation>
    </message>
    <message>
        <source>Ch&amp;ange...</source>
        <translation type="obsolete">Wy&amp;sig...</translation>
    </message>
    <message>
        <source>Page Size</source>
        <translation type="obsolete">Bladsygrootte</translation>
    </message>
    <message>
        <source>Custom</source>
        <translation type="obsolete">Tuisgemaak</translation>
    </message>
    <message>
        <source>&amp;Size:</source>
        <translation type="obsolete">&amp;Grootte:</translation>
    </message>
    <message>
        <source>Portrait</source>
        <translation type="obsolete">Regop</translation>
    </message>
    <message>
        <source>Landscape</source>
        <translation type="obsolete">Gekantel</translation>
    </message>
    <message>
        <source>Orie&amp;ntation:</source>
        <translation type="obsolete">Orië&amp;ntasie:</translation>
    </message>
    <message>
        <source>&amp;Width:</source>
        <translation type="obsolete">&amp;Breedte:</translation>
    </message>
    <message>
        <source>&amp;Height:</source>
        <translation type="obsolete">&amp;Hoogte:</translation>
    </message>
    <message>
        <source>&amp;Facing Pages</source>
        <translation type="obsolete">&amp;Ooreenstaande bladsye</translation>
    </message>
    <message>
        <source>Left &amp;Page First</source>
        <translation type="obsolete">Linker&amp;bladsy eerste</translation>
    </message>
    <message>
        <source>Margin Guides</source>
        <translation type="obsolete">Kantlyn hulplyne</translation>
    </message>
    <message>
        <source>&amp;Bottom:</source>
        <translation type="obsolete">On&amp;der:</translation>
    </message>
    <message>
        <source>&amp;Top:</source>
        <translation type="obsolete">&amp;Bo:</translation>
    </message>
    <message>
        <source>&amp;Right:</source>
        <translation type="obsolete">&amp;Regs:</translation>
    </message>
    <message>
        <source>&amp;Left:</source>
        <translation type="obsolete">&amp;Links:</translation>
    </message>
    <message>
        <source>Autosave</source>
        <translation type="obsolete">Outomaties stoor</translation>
    </message>
    <message>
        <source>&amp;Enabled</source>
        <translation type="obsolete">&amp;Aan</translation>
    </message>
    <message>
        <source>min</source>
        <translation type="obsolete">min</translation>
    </message>
    <message>
        <source>&amp;Interval:</source>
        <translation type="obsolete">&amp;Interval:</translation>
    </message>
    <message>
        <source>Grid Layout</source>
        <translation type="obsolete">Roosteruitleg</translation>
    </message>
    <message>
        <source>M&amp;inor Grid Spacing:</source>
        <translation type="obsolete">Kl&amp;einrooster spasiëring:</translation>
    </message>
    <message>
        <source>Ma&amp;jor Grid Spacing:</source>
        <translation type="obsolete">&amp;Grootrooster spasiëring:</translation>
    </message>
    <message>
        <source>Guide &amp;Snap Distance:</source>
        <translation type="obsolete">Hulplyn&amp;magnetisme afstand:</translation>
    </message>
    <message>
        <source>Grid Colors</source>
        <translation type="obsolete">Roosterkleuren</translation>
    </message>
    <message>
        <source>Min&amp;or Grid Color:</source>
        <translation type="obsolete">&amp;Kleinrooster kleur:</translation>
    </message>
    <message>
        <source>Majo&amp;r Grid Color:</source>
        <translation type="obsolete">&amp;Grootrooster kleur:</translation>
    </message>
    <message>
        <source>&amp;User Guides Color:</source>
        <translation type="obsolete">H&amp;ulplyne se kleur:</translation>
    </message>
    <message>
        <source>Base&amp;line Grid Color:</source>
        <translation type="obsolete">Basis&amp;lyn-rooster kleur:</translation>
    </message>
    <message>
        <source>Placing</source>
        <translation type="obsolete">Plasing</translation>
    </message>
    <message>
        <source>In the &amp;Background</source>
        <translation type="obsolete">In die &amp;Agtergrond</translation>
    </message>
    <message>
        <source>In the Fore&amp;ground</source>
        <translation type="obsolete">In die &amp;Voorgrond</translation>
    </message>
    <message>
        <source>Baseline Grid</source>
        <translation type="obsolete">Basislyn-rooster</translation>
    </message>
    <message>
        <source>O&amp;n</source>
        <translation type="obsolete">&amp;Aan</translation>
    </message>
    <message>
        <source>O&amp;ff</source>
        <translation type="obsolete">&amp;Af</translation>
    </message>
    <message>
        <source>Subscript</source>
        <translation type="obsolete">Onderskrif</translation>
    </message>
    <message>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <source>&amp;Displacement:</source>
        <translation type="obsolete">Ver&amp;plasing:</translation>
    </message>
    <message>
        <source>&amp;Scaling:</source>
        <translation type="obsolete">&amp;Skaalering:</translation>
    </message>
    <message>
        <source>Superscript</source>
        <translation type="obsolete">Boskrif</translation>
    </message>
    <message>
        <source>D&amp;isplacement:</source>
        <translation type="obsolete">Verpla&amp;sing:</translation>
    </message>
    <message>
        <source>S&amp;caling:</source>
        <translation type="obsolete">S&amp;kaalering:</translation>
    </message>
    <message>
        <source>Small Caps</source>
        <translation type="obsolete">Kleinhoofletters</translation>
    </message>
    <message>
        <source>Sc&amp;aling:</source>
        <translation type="obsolete">Sk&amp;aalering:</translation>
    </message>
    <message>
        <source>Other</source>
        <translation type="obsolete">Ander</translation>
    </message>
    <message>
        <source>Baseline &amp;Grid:</source>
        <translation type="obsolete">Basislyn &amp;rooster:</translation>
    </message>
    <message>
        <source>Baseline &amp;Offset:</source>
        <translation type="obsolete">Basislyn &amp;beginafstand:</translation>
    </message>
    <message>
        <source>Automatic &amp;Line Spacing:</source>
        <translation type="obsolete">Outomatise &amp;lynspasiëring:</translation>
    </message>
    <message>
        <source>Default &amp;Font:</source>
        <translation type="obsolete">Ver&amp;stek lettertipe:</translation>
    </message>
    <message>
        <source>Default &amp;Size:</source>
        <translation type="obsolete">Verstek&amp;grootte:</translation>
    </message>
    <message>
        <source>&amp;Text Color:</source>
        <translation type="obsolete">&amp;Tekskleur:</translation>
    </message>
    <message>
        <source>Colu&amp;mns:</source>
        <translation type="obsolete">Kolo&amp;mme:</translation>
    </message>
    <message>
        <source>&amp;Gap:</source>
        <translation type="obsolete">Tussen&amp;ruimte:</translation>
    </message>
    <message>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <translation type="obsolete">Filmquiz bracht knappe ex-yogi van de wys</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>&amp;Line Color:</source>
        <translation type="obsolete">&amp;Lynkleur:</translation>
    </message>
    <message>
        <source>&amp;Shading:</source>
        <translation type="obsolete">&amp;Skadu:</translation>
    </message>
    <message>
        <source>&amp;Fill Color:</source>
        <translation type="obsolete">&amp;Vulkleur:</translation>
    </message>
    <message>
        <source>S&amp;hading:</source>
        <translation type="obsolete">S&amp;kadu:</translation>
    </message>
    <message>
        <source>&amp;Type of Line:</source>
        <translation type="obsolete">Lynt&amp;ipe:</translation>
    </message>
    <message>
        <source>Line &amp;Width:</source>
        <translation type="obsolete">Lyndi&amp;kte:</translation>
    </message>
    <message>
        <source>Mi&amp;nimum:</source>
        <translation type="obsolete">Mi&amp;nimum:</translation>
    </message>
    <message>
        <source>Ma&amp;ximum:</source>
        <translation type="obsolete">Ma&amp;ksimum:</translation>
    </message>
    <message>
        <source>&amp;Stepping:</source>
        <translation type="obsolete">&amp;Stappe van:</translation>
    </message>
    <message>
        <source>&amp;Free Scaling</source>
        <translation type="obsolete">&amp;Vry skalerend</translation>
    </message>
    <message>
        <source>&amp;Horizontal Scaling:</source>
        <translation type="obsolete">&amp;Horisontale skaal:</translation>
    </message>
    <message>
        <source>&amp;Vertical Scaling:</source>
        <translation type="obsolete">&amp;Vertikale skaal:</translation>
    </message>
    <message>
        <source>&amp;Scale Picture to Frame Size</source>
        <translation type="obsolete">&amp;Skaleer prent na raamgrootte</translation>
    </message>
    <message>
        <source>Keep Aspect &amp;Ratio</source>
        <translation type="obsolete">Behou Prentve&amp;rhouding</translation>
    </message>
    <message>
        <source>F&amp;ill Color:</source>
        <translation type="obsolete">V&amp;ulkleur:</translation>
    </message>
    <message>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">Ho&amp;eke:</translation>
    </message>
    <message>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Rotasie:</translation>
    </message>
    <message>
        <source>&amp;Factor:</source>
        <translation type="obsolete">&amp;Faktor:</translation>
    </message>
    <message>
        <source>Other Options</source>
        <translation type="obsolete">Ander opsies</translation>
    </message>
    <message>
        <source>Sa&amp;ve Contents on Changes</source>
        <translation type="obsolete">&amp;Stoor inhoud met wysigen</translation>
    </message>
    <message>
        <source>Preview</source>
        <translation type="obsolete">Voorbeeld</translation>
    </message>
    <message>
        <source>Small</source>
        <translation type="obsolete">Klein</translation>
    </message>
    <message>
        <source>Medium</source>
        <translation type="obsolete">Middel</translation>
    </message>
    <message>
        <source>Large</source>
        <translation type="obsolete">Groot</translation>
    </message>
    <message>
        <source>Display Pages &amp;Side by Side</source>
        <translation type="obsolete">Vertoon Bladsye lang&amp;s mekaar</translation>
    </message>
    <message>
        <source>Page Colors</source>
        <translation type="obsolete">Bladsykleure</translation>
    </message>
    <message>
        <source>&amp;Background:</source>
        <translation type="obsolete">&amp;Agtergrond:</translation>
    </message>
    <message>
        <source>&amp;Margins:</source>
        <translation type="obsolete">&amp;Kantlyne:</translation>
    </message>
    <message>
        <source>Display &amp;Unprintable Area in Margin Color</source>
        <translation type="obsolete">Vertoon &amp;Nie-drukbare gebiede in kantlynkleur</translation>
    </message>
    <message>
        <source>Use PDF 1.4 &amp;Transparency Features</source>
        <translation type="obsolete">Gebruik PDF-1.4 se &amp;Deursigtigheidsfunksies</translation>
    </message>
    <message>
        <source>&amp;Adjust Display Size</source>
        <translation type="obsolete">Pas Vertoongrootte &amp;aan</translation>
    </message>
    <message>
        <source>To adjust the display drag the ruler below with the Slider.</source>
        <translation type="obsolete">Om aan te pas sleep die skuifknop op die lineaal hieronder.</translation>
    </message>
    <message>
        <source>Postscript Interpreter</source>
        <translation type="obsolete">PostScript-interpreter</translation>
    </message>
    <message>
        <source>&amp;Name of Executable:</source>
        <translation type="obsolete">&amp;Naam van uitvoerbare program:</translation>
    </message>
    <message>
        <source>Antialias &amp;Text</source>
        <translation type="obsolete">Anti-aliaseer &amp;teks</translation>
    </message>
    <message>
        <source>Antialias &amp;Graphics</source>
        <translation type="obsolete">Anti-aliaseer &amp;grafika</translation>
    </message>
    <message>
        <source>Image Processing Tool</source>
        <translation type="obsolete">Program vir prentverwerking</translation>
    </message>
    <message>
        <source>Name of &amp;Executable:</source>
        <translation type="obsolete">Naam van uitvoerbare &amp;program:</translation>
    </message>
    <message>
        <source>Printing</source>
        <translation type="obsolete">Druk</translation>
    </message>
    <message>
        <source>Clip to Page &amp;Margins</source>
        <translation type="obsolete">Knip als buite bladsy&amp;kantlyne af</translation>
    </message>
    <message>
        <source>Apply &amp;Under Color Removal</source>
        <translation type="obsolete">Verwyder Onde&amp;rlêende kleur</translation>
    </message>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Choose the default window decoration and looks.
Scribus inherits any available KDE or Qt themes</source>
        <translation type="obsolete">Kies die verstek vensterdekorasie en styl.
Scribus kan elke beskikbare KDE- of Qt-styl oorneem</translation>
    </message>
    <message>
        <source>Default font size for the menus and windows</source>
        <translation type="obsolete">Verstek lettergrootte vir menu&apos;s en vensters</translation>
    </message>
    <message>
        <source>Default unit of measurement for document editing</source>
        <translation type="obsolete">Verstek meeteenheid vir dokumentbewerking</translation>
    </message>
    <message>
        <source>Number of lines Scribus will scroll for each move of the mouse wheel</source>
        <translation type="obsolete">Aantal lyntjies wat Scribus deurskuif vir elke muiswiel rol</translation>
    </message>
    <message>
        <source>Radius of the area where Scribus will allow you to grab an objects handles</source>
        <translation type="obsolete">Gee die straal aan van die gebied waar Scribus u toelaat om &apos;n object se muisvatsels te gryp</translation>
    </message>
    <message>
        <source>Number of recently edited documents to show in the File menu</source>
        <translation type="obsolete">Aantal onlangs geopende dokumenten wat Scribus in Lêer menu moet vertoon</translation>
    </message>
    <message>
        <source>Default documents directory</source>
        <translation type="obsolete">Verstekgids vir dokumente</translation>
    </message>
    <message>
        <source>Default ICC profiles directory</source>
        <translation type="obsolete">Verstekgids vir ICC-profiele</translation>
    </message>
    <message>
        <source>Default Scripter scripts directory</source>
        <translation type="obsolete">Verstekgids vir Scripts</translation>
    </message>
    <message>
        <source>Default page size, either a standard size or a custom size</source>
        <translation type="obsolete">Verstek bladsygrootte</translation>
    </message>
    <message>
        <source>Default orientation of document pages</source>
        <translation type="obsolete">Verstekoriëntasie van dokumentbladsye</translation>
    </message>
    <message>
        <source>Width of document pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Breedte van bladsye, kies Tuisgemaak om u eie waardes in te vul</translation>
    </message>
    <message>
        <source>Height of document pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Hoogte van bladsye, kies Tuisgemaak om u eie waardes in te vul</translation>
    </message>
    <message>
        <source>Enable single or spread based layout</source>
        <translation type="obsolete">Sit enkel of spreibasis uileg aan</translation>
    </message>
    <message>
        <source>Make the first page the left page of a document</source>
        <translation type="obsolete">Laat dokument met &apos;n linker bladsy begin</translation>
    </message>
    <message>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation type="obsolete">Afstand tussen die bokant van die kantlyn en die papierrand</translation>
    </message>
    <message>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation type="obsolete">Afstand tussen die onderkant van die kantlyn en die papierrand</translation>
    </message>
    <message>
        <source>Distance between the left margin guide and the edge of the page.
If Facing Pages is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Afstand tussen die linkerkant van die kantlyn en die papierrand
As teenoorstaande bladsy gekies is, word die breedte gebruikt aan die rugkant van die dokument</translation>
    </message>
    <message>
        <source>Distance between the right margin guide and the edge of the page.
If Facing Pages is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Afstand tussen die regterkant van die kantlyn en die papierrand
As teenoorstaande bladsy gekies is, word die breedte gebruikt aan die buitekant van die dokument</translation>
    </message>
    <message>
        <source>When enabled, Scribus saves a backup copy of your file with the .bak extension
each time the time period elapses</source>
        <translation type="obsolete">Indien aan, sal Scibus op elke tydsinterval &apos;n rugsteunkopie
van u dokument stoor met &apos;n .bak-uitbreiding</translation>
    </message>
    <message>
        <source>Time period between saving automatically</source>
        <translation type="obsolete">Tydsinterval vir outomaties stoor</translation>
    </message>
    <message>
        <source>Distance between the minor grid lines</source>
        <translation type="obsolete">Afstand tussen kleinroosterlyne</translation>
    </message>
    <message>
        <source>Distance between the major grid lines</source>
        <translation type="obsolete">Afstand tussen grootroosterlyne</translation>
    </message>
    <message>
        <source>Distance within which an object will snap to your placed guides</source>
        <translation type="obsolete">Afstand waarvandaan &apos;n objek na jou geplaasde hulplyne sal spring</translation>
    </message>
    <message>
        <source>Color of the minor grid lines</source>
        <translation type="obsolete">Kleur van kleinroosterlyne</translation>
    </message>
    <message>
        <source>Color of the major grid lines</source>
        <translation type="obsolete">Kleur van grootroosterlyne</translation>
    </message>
    <message>
        <source>Color of the guide lines you insert</source>
        <translation type="obsolete">Kleur van u eiehulplyne</translation>
    </message>
    <message>
        <source>Place the grid behind your page objects</source>
        <translation type="obsolete">Plaas rooster onder u andere objekte</translation>
    </message>
    <message>
        <source>Place the grid in front of your page objects</source>
        <translation type="obsolete">Plaas rooster vir u andere objekte</translation>
    </message>
    <message>
        <source>Turns on the basegrid</source>
        <translation type="obsolete">Skakel Basisrooster aan</translation>
    </message>
    <message>
        <source>Turns off the basegrid</source>
        <translation type="obsolete">Skakel Basisraster af</translation>
    </message>
    <message>
        <source>Displacement above the baseline of the font on a line</source>
        <translation type="obsolete">Verplasing bo basislyn van &apos;n lettertipe op &apos;n lyn</translation>
    </message>
    <message>
        <source>Relative size of the superscript compared to the normal font</source>
        <translation type="obsolete">Relatiewe grootte van boskrif tov normale teks</translation>
    </message>
    <message>
        <source>Displacement below the baseline of the normal font on a line</source>
        <translation type="obsolete">Verplasing onder basislyn van &apos;n lettertipe op &apos;n lyn</translation>
    </message>
    <message>
        <source>Relative size of the subscript compared to the normal font</source>
        <translation type="obsolete">Relatiewe grootte van onderskrif tov normale teks</translation>
    </message>
    <message>
        <source>Relative size of the small caps font compared to the normal font</source>
        <translation type="obsolete">Relatiewe grootte van kleinhoofletters tov normale teks</translation>
    </message>
    <message>
        <source>Percentage increase over the font size for the line spacing</source>
        <translation type="obsolete">Persentasie toename van lyn hoogte tov lettergrootte</translation>
    </message>
    <message>
        <source>Text Frame Properties</source>
        <translation type="obsolete">Eienskappe van teksraam</translation>
    </message>
    <message>
        <source>Picture Frame Properties</source>
        <translation type="obsolete">Eienskappe van prentraam</translation>
    </message>
    <message>
        <source>Shape Drawing Properties</source>
        <translation type="obsolete">Eienskappe van vormsteken</translation>
    </message>
    <message>
        <source>Magnification Level Defaults</source>
        <translation type="obsolete">Verstek vergroottingsvlakke</translation>
    </message>
    <message>
        <source>Line Drawing Properties</source>
        <translation type="obsolete">Lyneienskappe</translation>
    </message>
    <message>
        <source>Polygon Drawing Properties</source>
        <translation type="obsolete">Polygooneienskappe</translation>
    </message>
    <message>
        <source>Font for new text frames</source>
        <translation type="obsolete">Lettertipe vir nuwe teksrame</translation>
    </message>
    <message>
        <source>Size of font for new text frames</source>
        <translation type="obsolete">Lettergrootte vir nuwe teksrame</translation>
    </message>
    <message>
        <source>Color of font</source>
        <translation type="obsolete">Letterkleur</translation>
    </message>
    <message>
        <source>Number of columns in a text frame</source>
        <translation type="obsolete">Aantal kolomme in &apos;n teksraam</translation>
    </message>
    <message>
        <source>Gap between text frame columns</source>
        <translation type="obsolete">Tussenruimte tussen kolomme</translation>
    </message>
    <message>
        <source>Sample of your font</source>
        <translation type="obsolete">Voorbeeld van u lettertipe</translation>
    </message>
    <message>
        <source>Picture frames allow pictures to scale to any size</source>
        <translation type="obsolete">Prentrame laat prente na enige grootte skaleer</translation>
    </message>
    <message>
        <source>Horizontal scaling of images</source>
        <translation type="obsolete">Horisontale skaal vir prente</translation>
    </message>
    <message>
        <source>Vertical scaling of images</source>
        <translation type="obsolete">Vertikale skaal vir prente</translation>
    </message>
    <message>
        <source>Keep horizontal and vertical scaling the same</source>
        <translation type="obsolete">Hou horisontale en vertikaleskaal gelyk</translation>
    </message>
    <message>
        <source>Pictures in picture frames are scaled to the size of the frame</source>
        <translation type="obsolete">Prente in prentrame word altyd na grootte van hul raam geskaleer</translation>
    </message>
    <message>
        <source>Automatically scaled pictures keep their original proportions</source>
        <translation type="obsolete">Outomaties geskaalde prente houd hul oorspronklike prentverhouding</translation>
    </message>
    <message>
        <source>Fill color of picture frames</source>
        <translation type="obsolete">Vulkleur vir prentrame</translation>
    </message>
    <message>
        <source>Saturation of color of fill</source>
        <translation type="obsolete">Versadiging van die vulkleur</translation>
    </message>
    <message>
        <source>Line color of shapes</source>
        <translation type="obsolete">Lynkleur van vorms</translation>
    </message>
    <message>
        <source>Saturation of color of lines</source>
        <translation type="obsolete">Versadiging van die lynkleur</translation>
    </message>
    <message>
        <source>Fill color of shapes</source>
        <translation type="obsolete">Vulkleur van vorms</translation>
    </message>
    <message>
        <source>Line style of shapes</source>
        <translation type="obsolete">Lynstyl van vorms</translation>
    </message>
    <message>
        <source>Line width of shapes</source>
        <translation type="obsolete">Lyndikte van vorms</translation>
    </message>
    <message>
        <source>Minimum magnification allowed</source>
        <translation type="obsolete">Minimum toegelate vergroting</translation>
    </message>
    <message>
        <source>Maximum magnification allowed</source>
        <translation type="obsolete">Maksimum toegelate vergroting</translation>
    </message>
    <message>
        <source>Change in magnification for each zoom operation</source>
        <translation type="obsolete">Verandering in grootte vir elke zoom-stap</translation>
    </message>
    <message>
        <source>Color of lines</source>
        <translation type="obsolete">Lynkleur</translation>
    </message>
    <message>
        <source>Saturation of color</source>
        <translation type="obsolete">Kleurversadiging</translation>
    </message>
    <message>
        <source>Style of lines</source>
        <translation type="obsolete">Lynstyl</translation>
    </message>
    <message>
        <source>Width of lines</source>
        <translation type="obsolete">Dikte van lyne</translation>
    </message>
    <message>
        <source>Number of corners for polygons</source>
        <translation type="obsolete">Aantal hoeke van polygone (veelhoeke)</translation>
    </message>
    <message>
        <source>Degrees of rotation for polygons</source>
        <translation type="obsolete">Grade in rotasie van polygone</translation>
    </message>
    <message>
        <source>Sample Polygon</source>
        <translation type="obsolete">Voorbeeldpolygoon</translation>
    </message>
    <message>
        <source>Choose the size of the preview in the scrapbook palette</source>
        <translation type="obsolete">Kies die grootte van die voorbeeld in die kladblok-palet</translation>
    </message>
    <message>
        <source>Save the scrapbook contents everytime after a change</source>
        <translation type="obsolete">Stoor kladblok telkens na &apos;n wysiging</translation>
    </message>
    <message>
        <source>When using facing pages, show the two pages side by side</source>
        <translation type="obsolete">Wanneer u teenoorstaande bladsye gebruik, toon die twee bladsye lanks mekaar</translation>
    </message>
    <message>
        <source>Color for paper</source>
        <translation type="obsolete">Papierkleur</translation>
    </message>
    <message>
        <source>Color for the margin lines</source>
        <translation type="obsolete">Kleur vir die kantlyne</translation>
    </message>
    <message>
        <source>Mask the area outside the margins in the margin color</source>
        <translation type="obsolete">Maskeer gebied buite die kantlyne in die kantlynkleur</translation>
    </message>
    <message>
        <source>Enable transparency features within PDF 1.4 export</source>
        <translation type="obsolete">Skakel deursigtigheidsfunksie van PDF-1.4 aan</translation>
    </message>
    <message>
        <source>Set the default zoom level</source>
        <translation type="obsolete">Stel die verstekvergroottingsvlak</translation>
    </message>
    <message>
        <source>Filesystem location for the Ghostscript interpreter</source>
        <translation type="obsolete">Ghostscript-interpreter pad</translation>
    </message>
    <message>
        <source>Antialias text for EPS and PDF onscreen rendering</source>
        <translation type="obsolete">Antialiseer Teks vir EPS en PDF op skerm</translation>
    </message>
    <message>
        <source>Antialias graphics for EPS and PDF onscreen rendering</source>
        <translation type="obsolete">Antialiseer Grafieka vir EPS en PDF op skerm</translation>
    </message>
    <message>
        <source>Filesystem location for graphics editor</source>
        <translation type="obsolete">Pad na prentbewerker</translation>
    </message>
    <message>
        <source>Do not show objects outside the margins on the printed page or exported file</source>
        <translation type="obsolete">Moenie objekte buite die kantlyne op gedrukte of uitgevoerde lêers wys nie</translation>
    </message>
    <message>
        <source>Choose a Directory</source>
        <translation type="obsolete">Kies gids</translation>
    </message>
    <message>
        <source>&amp;Inside:</source>
        <translation type="obsolete">B&amp;innenkant:</translation>
    </message>
    <message>
        <source>O&amp;utside:</source>
        <translation type="obsolete">B&amp;uitenkant:</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <source>T&amp;emplates:</source>
        <translation type="obsolete">T&amp;emplate:</translation>
    </message>
    <message>
        <source>Cha&amp;nge...</source>
        <translation type="obsolete">Wysi&amp;g...</translation>
    </message>
    <message>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">Pas &amp;Faktor toe</translation>
    </message>
    <message>
        <source>Additional Directory for Document Templates</source>
        <translation type="obsolete">Ander gids vir dokument-template</translation>
    </message>
    <message>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="obsolete">Pas konveks/konkaaf-faktor toe op die vorm van polygone</translation>
    </message>
    <message>
        <source>A negative value will make the polygon concave (or star shaped),
 a positive value will make it convex</source>
        <translation type="obsolete">&apos;n Negatiewe waarde maak die polygoon konkaaf (stervormig), 
&apos;n positiewe waarde maak hom konveks</translation>
    </message>
    <message>
        <source>A way of switching off some of the gray shades which are composed
of cyan, yellow and magenta and using black instead.
UCR most affects parts of images which are neutral and/or dark tones
which are close to the gray. Use of this may improve printing some images
and some experimentation and testing is need on a case by case basis.
UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">I metode om CMY grys te vervang met swart grys.
UCR (Under Color Removal) het veral &apos;n invloed op donker en neutrale skadus naby grys. Sommige prente sal mooier druk met die, maar mens moet maar maarmee eksperimenteer.
UCR verklein die kans op overversadiging met CMY inke.</translation>
    </message>
    <message>
        <source>Executive</source>
        <translation type="obsolete">Uitvoerend</translation>
    </message>
    <message>
        <source>Folio</source>
        <translation type="obsolete">Folio</translation>
    </message>
    <message>
        <source>Ledger</source>
        <translation type="obsolete">Grootboek</translation>
    </message>
    <message>
        <source>Legal</source>
        <translation type="obsolete">Legal</translation>
    </message>
    <message>
        <source>Letter</source>
        <translation type="obsolete">Letter (US)</translation>
    </message>
    <message>
        <source>Tabloid</source>
        <translation type="obsolete">Ponie</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="91"/>
        <source>Hyphenator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="94"/>
        <source>Fonts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="105"/>
        <source>Color Management</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="120"/>
        <source>PDF Export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="133"/>
        <source>Keyboard Shortcuts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Color:</source>
        <translation type="obsolete">Kleur:</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="149"/>
        <source>Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="100"/>
        <source>Preflight Verifier</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="125"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="130"/>
        <source>Table of Contents and Indexes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="145"/>
        <source>Miscellaneous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>File</source>
        <translation type="obsolete">Lêer</translation>
    </message>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <source>No</source>
        <translation type="obsolete">Nee</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefs.cpp" line="97"/>
        <source>Printer</source>
        <translation type="unfinished">Drukker (CMYK)</translation>
    </message>
</context>
<context>
    <name>PrefsDialogBase</name>
    <message>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="198"/>
        <source>&amp;Defaults</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="207"/>
        <source>Save Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="197"/>
        <source>Export...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="199"/>
        <source>&amp;Apply</source>
        <translation type="unfinished">Toe&amp;pas</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="200"/>
        <source>All preferences can be reset here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="201"/>
        <source>Apply all changes without closing the dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsdialogbase.cpp" line="202"/>
        <source>Export current preferences into file</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrefsManager</name>
    <message>
        <source>Left Page</source>
        <translation type="obsolete">Linker bladsy</translation>
    </message>
    <message>
        <source>Right Page</source>
        <translation type="obsolete">Regter bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2072"/>
        <location filename="../../../scribus/prefsmanager.cpp" line="2081"/>
        <source>Postscript</source>
        <translation type="unfinished">Postscript</translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="817"/>
        <source>Migrate Old Scribus Settings?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="818"/>
        <source>Scribus has detected existing Scribus 1.2 preferences files.
Do you want to migrate them to the new Scribus version?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2072"/>
        <location filename="../../../scribus/prefsmanager.cpp" line="2081"/>
        <source>PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1701"/>
        <source>Could not open preferences file &quot;%1&quot; for writing: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1712"/>
        <source>Writing to preferences file &quot;%1&quot; failed: QIODevice status code %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1727"/>
        <source>Failed to open prefs file &quot;%1&quot;: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="1737"/>
        <source>Failed to read prefs XML from &quot;%1&quot;: %2 at line %3, col %4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2430"/>
        <source>Error Writing Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2432"/>
        <source>Scribus was not able to save its preferences:&lt;br&gt;%1&lt;br&gt;Please check file and directory permissions and available disk space.</source>
        <comment>scribus app error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2449"/>
        <source>Error Loading Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2451"/>
        <source>Scribus was not able to load its preferences:&lt;br&gt;%1&lt;br&gt;Default settings will be loaded.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/prefsmanager.cpp" line="2153"/>
        <source>No valid renderframe config found. Using defaults!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PresetLayout</name>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="555"/>
        <source>Magazine</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="556"/>
        <source>Fibonacci</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="557"/>
        <source>Golden Mean</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="558"/>
        <source>Nine Parts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="554"/>
        <source>Gutenberg</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="553"/>
        <source>None</source>
        <comment>layout type</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/marginwidget.cpp" line="561"/>
        <source>When you have selected a Document Layout other than Single Page, you can select a predefined page layout here. &apos;None&apos; leaves margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins to the same value. Leading is Left/Inside value.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrintDialog</name>
    <message>
        <source>Setup Printer</source>
        <translation type="obsolete">Drukker instelling</translation>
    </message>
    <message>
        <source>Print Destination</source>
        <translation type="obsolete">Druk na</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="88"/>
        <location filename="../../../scribus/printdialog.cpp" line="110"/>
        <location filename="../../../scribus/printdialog.cpp" line="273"/>
        <location filename="../../../scribus/printdialog.cpp" line="305"/>
        <location filename="../../../scribus/printdialog.cpp" line="496"/>
        <location filename="../../../scribus/printdialog.cpp" line="578"/>
        <source>File</source>
        <translation>Lêer</translation>
    </message>
    <message>
        <source>&amp;Options...</source>
        <translation type="obsolete">&amp;Opsies...</translation>
    </message>
    <message>
        <source>&amp;File:</source>
        <translation type="obsolete">&amp;Lêer:</translation>
    </message>
    <message>
        <source>C&amp;hange...</source>
        <translation type="obsolete">&amp;Wysiging...</translation>
    </message>
    <message>
        <source>A&amp;lternative Printer Command</source>
        <translation type="obsolete">A&amp;lternatiewe drukopdrag</translation>
    </message>
    <message>
        <source>Use an alternative print manager, such as kprinter or gtklp,
to utilize additional printing options</source>
        <translation type="obsolete">Gebruik een alternatief printcommando, zoals kprinter of gtklp,
om extra printopties te kunnen gebruiken</translation>
    </message>
    <message>
        <source>Co&amp;mmand:</source>
        <translation type="obsolete">O&amp;pdrag:</translation>
    </message>
    <message>
        <source>Range</source>
        <translation type="obsolete">Bereik</translation>
    </message>
    <message>
        <source>Print &amp;All</source>
        <translation type="obsolete">Druk &amp;Alles</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="386"/>
        <source>Print Current Pa&amp;ge</source>
        <translation>Druk huidige bla&amp;dsy</translation>
    </message>
    <message>
        <source>Print &amp;Range</source>
        <translation type="obsolete">Druk Be&amp;reik</translation>
    </message>
    <message>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Kies bladsy nommers. 1,3,4,6 of 1-4 vir 1 tot 4 
of * vir almal.</translation>
    </message>
    <message>
        <source>N&amp;umber of Copies:</source>
        <translation type="obsolete">Aantal &amp;kopieë:</translation>
    </message>
    <message>
        <source>Options</source>
        <translation type="obsolete">Opsies</translation>
    </message>
    <message>
        <source>Print &amp;Normal</source>
        <translation type="obsolete">Druk &amp;Normaal</translation>
    </message>
    <message>
        <source>Print &amp;Separations</source>
        <translation type="obsolete">Druk &amp;skydings</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="93"/>
        <location filename="../../../scribus/printdialog.cpp" line="295"/>
        <location filename="../../../scribus/printdialog.cpp" line="349"/>
        <location filename="../../../scribus/printdialog.cpp" line="460"/>
        <location filename="../../../scribus/printdialog.cpp" line="522"/>
        <source>All</source>
        <translation>Alles</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="93"/>
        <location filename="../../../scribus/printdialog.cpp" line="460"/>
        <location filename="../../../scribus/printdialog.cpp" line="521"/>
        <source>Cyan</source>
        <translation>Cyaan</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="93"/>
        <location filename="../../../scribus/printdialog.cpp" line="460"/>
        <location filename="../../../scribus/printdialog.cpp" line="520"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="93"/>
        <location filename="../../../scribus/printdialog.cpp" line="460"/>
        <location filename="../../../scribus/printdialog.cpp" line="519"/>
        <source>Yellow</source>
        <translation>Geel</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="94"/>
        <location filename="../../../scribus/printdialog.cpp" line="460"/>
        <location filename="../../../scribus/printdialog.cpp" line="518"/>
        <source>Black</source>
        <translation>Swart</translation>
    </message>
    <message>
        <source>Pr&amp;int In Color If Available</source>
        <translation type="obsolete">Druk &amp;in kleur indien beskikbaar</translation>
    </message>
    <message>
        <source>Print In Gra&amp;yscale</source>
        <translation type="obsolete">Druk in &amp;grys</translation>
    </message>
    <message>
        <source>Ad&amp;vanced Options...</source>
        <translation type="obsolete">Ge&amp;vorderde opsies...</translation>
    </message>
    <message>
        <source>&amp;Print</source>
        <translation type="obsolete">&amp;Druk</translation>
    </message>
    <message>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Kanselleer</translation>
    </message>
    <message>
        <source>Save as</source>
        <translation type="obsolete">Stoor as</translation>
    </message>
    <message>
        <source>Postscript-Files (*.ps);;All Files (*)</source>
        <translation type="obsolete">Postscriptlêers (*.ps);;Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="293"/>
        <location filename="../../../scribus/printdialog.cpp" line="347"/>
        <source>Print Normal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Page</source>
        <translation type="obsolete">Bladsy</translation>
    </message>
    <message>
        <source>Color</source>
        <translation type="obsolete">Kleur</translation>
    </message>
    <message>
        <source>Advanced Options</source>
        <translation type="obsolete">Gevorderde opsies</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="372"/>
        <source>PostScript Files (*.ps);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Do not show objects outside the margins on the printed page or exported file</source>
        <translation type="obsolete">Moenie objekte buite die kantlyne op gedrukte of uitgevoerde lêers wys nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="314"/>
        <source>Failed to retrieve printer settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="103"/>
        <source>Inside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="104"/>
        <source>Outside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die bokant van die fisiese bladsy</translation>
    </message>
    <message>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die onderkant van die fisiese bladsy</translation>
    </message>
    <message>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die linkerkant van die fisiese bladsy</translation>
    </message>
    <message>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="obsolete">Afloop-afstand vanaf die regterkant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialog.cpp" line="372"/>
        <source>Save As</source>
        <translation type="unfinished">Stoor as</translation>
    </message>
</context>
<context>
    <name>PrintDialogBase</name>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="14"/>
        <source>Setup Printer</source>
        <translation type="unfinished">Drukker instelling</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="23"/>
        <source>Print Destination</source>
        <translation type="unfinished">Druk na</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="50"/>
        <source>&amp;Options...</source>
        <translation type="unfinished">&amp;Opsies...</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="86"/>
        <source>&amp;File:</source>
        <translation type="unfinished">&amp;Lêer:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="102"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="117"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="120"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="unfinished">A&amp;lternatiewe drukopdrag</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="138"/>
        <source>Co&amp;mmand:</source>
        <translation type="unfinished">O&amp;pdrag:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="160"/>
        <source>Range</source>
        <translation type="unfinished">Bereik</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="172"/>
        <source>Print &amp;All</source>
        <translation type="unfinished">Druk &amp;Alles</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="192"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="unfinished">Aantal &amp;kopieë:</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="212"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="unfinished">Druk huidige bla&amp;dsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="219"/>
        <source>Print &amp;Range</source>
        <translation type="unfinished">Druk Be&amp;reik</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="229"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="274"/>
        <source>Options</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="281"/>
        <source>Print Normal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="286"/>
        <source>Print Separations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="295"/>
        <source>Print in Color if Available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="300"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="315"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="335"/>
        <source>Advanced Options</source>
        <translation type="unfinished">Gevorderde opsies</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="341"/>
        <source>Page</source>
        <translation type="unfinished">Bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="347"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="354"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="364"/>
        <source>Set Media Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="381"/>
        <source>Color</source>
        <translation type="unfinished">Kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="390"/>
        <source>Apply Under Color Removal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="397"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="400"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="407"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="410"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="437"/>
        <source>Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="443"/>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="446"/>
        <source>Crop Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="453"/>
        <source>Add registration marks which are added to each separation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="456"/>
        <source>Registration Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="463"/>
        <source>This creates bleed marks which are indicated by  _ . _ and show the bleed limit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="466"/>
        <source>Bleed Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="473"/>
        <source>Add color calibration bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="476"/>
        <source>Color Bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="485"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="492"/>
        <source>Indicate the distance offset for the registration marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="515"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="521"/>
        <source>Top:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="528"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die bokant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="535"/>
        <source>Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="542"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die regterkant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="549"/>
        <source>Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="556"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die onderkant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="563"/>
        <source>Right:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="570"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished">Afloop-afstand vanaf die linkerkant van die fisiese bladsy</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="577"/>
        <source>Use the existing bleed settings from the document preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="580"/>
        <source>Use Document Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="606"/>
        <source>Preview...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="616"/>
        <source>&amp;Print</source>
        <translation type="unfinished">&amp;Druk</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="626"/>
        <source>Cancel</source>
        <translation type="unfinished">Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="323"/>
        <source>Include PDF Annotations and Links into the output.
Note: PDF Forms will not be exported.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="327"/>
        <source>Include PDF Annotations and Links</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="361"/>
        <source>This enables you to explicitly set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="371"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/printdialogbase.ui" line="387"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PropertiesPalette</name>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5101"/>
        <source>Properties</source>
        <translation>Eienskappe</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5103"/>
        <source>X, Y, &amp;Z</source>
        <translation>X, Y, &amp;Z</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5106"/>
        <source>&amp;Shape</source>
        <translation>&amp;Vorm</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5104"/>
        <source>&amp;Text</source>
        <translation>&amp;Teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5105"/>
        <source>&amp;Image</source>
        <translation>&amp;Prent</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5107"/>
        <source>&amp;Line</source>
        <translation>&amp;Lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5108"/>
        <source>&amp;Colors</source>
        <translation>&amp;Kleure</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5111"/>
        <source>Name</source>
        <translation>Naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5112"/>
        <source>Geometry</source>
        <translation>Plasing</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5315"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1934"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2302"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2421"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2516"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4049"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5113"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5224"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X-pos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1936"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2304"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2423"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2518"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4051"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5114"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5225"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-pos:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1935"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2303"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2422"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2517"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4050"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5115"/>
        <source>&amp;Width:</source>
        <translation>&amp;Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1937"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2305"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2424"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="2519"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4052"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5116"/>
        <source>&amp;Height:</source>
        <translation>&amp;Hoogte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5117"/>
        <source>&amp;Rotation:</source>
        <translation>&amp;Rotasie:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5118"/>
        <source>Basepoint:</source>
        <translation>Basispunt:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5119"/>
        <source>Level</source>
        <translation>Vlak</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5120"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5125"/>
        <source>Shape:</source>
        <translation>Vorm:</translation>
    </message>
    <message>
        <source>&amp;Edit Shape...</source>
        <translation type="obsolete">&amp;Bewerk Vorm...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5147"/>
        <source>R&amp;ound
Corners:</source>
        <translation>R&amp;onde
hoeke:</translation>
    </message>
    <message>
        <source>Distance of Text</source>
        <translation type="obsolete">Afstand van teks</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5148"/>
        <source>Colu&amp;mns:</source>
        <translation>Kolo&amp;mme:</translation>
    </message>
    <message>
        <source>&amp;Gap:</source>
        <translation type="obsolete">Tussen&amp;ruimte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5155"/>
        <source>To&amp;p:</source>
        <translation>&amp;Bo:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5156"/>
        <source>&amp;Bottom:</source>
        <translation>On&amp;der:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5157"/>
        <source>&amp;Left:</source>
        <translation>&amp;Links:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5158"/>
        <source>&amp;Right:</source>
        <translation>&amp;Regs:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5159"/>
        <source>T&amp;abulators...</source>
        <translation>T&amp;abuleerders...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1054"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5219"/>
        <source>Path Text Properties</source>
        <translation>Tekspad-eienskappe</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5168"/>
        <source>Show Curve</source>
        <translation>Wys kurwe</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5170"/>
        <source>Start Offset:</source>
        <translation>Beginafstand:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5171"/>
        <source>Distance from Curve:</source>
        <translation>Afstand vanaf kurwe:</translation>
    </message>
    <message>
        <source>Text &amp;Flows Around Frame</source>
        <translation type="obsolete">Teks &amp;loop om raam</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5178"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5184"/>
        <source>Use &amp;Bounding Box</source>
        <translation>Gebruiken &amp;Bounding Box</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5179"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5185"/>
        <source>&amp;Use Contour Line</source>
        <translation>Gebr&amp;uik Kontourlyn</translation>
    </message>
    <message>
        <source>&amp;Font Size:</source>
        <translation type="obsolete">&amp;Lettertipe grootte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5301"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <source>Shade:</source>
        <translation type="obsolete">Skadu:</translation>
    </message>
    <message>
        <source>Custom Spacing</source>
        <translation type="obsolete">Aangepaste spasiëring</translation>
    </message>
    <message>
        <source>&amp;Kerning:</source>
        <translation type="obsolete">&amp;Letterspasiëring</translation>
    </message>
    <message>
        <source>L&amp;ine Spacing:</source>
        <translation type="obsolete">&amp;Lynspasiëring:</translation>
    </message>
    <message>
        <source>St&amp;yle:</source>
        <translation type="obsolete">St&amp;yl:</translation>
    </message>
    <message>
        <source>Lan&amp;guage:</source>
        <translation type="obsolete">&amp;Taal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5221"/>
        <source>&amp;Free Scaling</source>
        <translation>Skaleer &amp;Vrylik</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5226"/>
        <source>X-Sc&amp;ale:</source>
        <translation>&amp;X-skaal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5227"/>
        <source>Y-Scal&amp;e:</source>
        <translation>&amp;Y-skaal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5228"/>
        <source>Scale &amp;To Frame Size</source>
        <translation>Skaal na &amp;raamgrootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5229"/>
        <source>P&amp;roportional</source>
        <translation>&amp;Proporsioneel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5232"/>
        <source>Input Profile:</source>
        <translation>Voer profiel in:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5233"/>
        <source>Rendering Intent:</source>
        <translation>Rendering intent:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5246"/>
        <source>Perceptual</source>
        <translation>Perseptueel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5247"/>
        <source>Relative Colorimetric</source>
        <translation>Relatief kleurmetries</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5144"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5248"/>
        <source>Saturation</source>
        <translation>Versadiging</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5249"/>
        <source>Absolute Colorimetric</source>
        <translation>Absoluut kleurmetries</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5258"/>
        <source>Left Point</source>
        <translation>Linker punt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5259"/>
        <source>End Points</source>
        <translation>Eindpunt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5261"/>
        <source>&amp;Basepoint:</source>
        <translation>&amp;Basispunt:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5262"/>
        <source>T&amp;ype of Line:</source>
        <translation>Lynt&amp;ipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5274"/>
        <source>Line &amp;Width:</source>
        <translation>Lyndi&amp;kte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5278"/>
        <source>Miter Join</source>
        <translation>Miter koppel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5279"/>
        <source>Bevel Join</source>
        <translation>Bevel koppel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5280"/>
        <source>Round Join</source>
        <translation>Ronde koppel</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5275"/>
        <source>Ed&amp;ges:</source>
        <translation>&amp;Hoeke:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5285"/>
        <source>Flat Cap</source>
        <translation>Plat</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5286"/>
        <source>Square Cap</source>
        <translation>Vierkant</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5287"/>
        <source>Round Cap</source>
        <translation>Rond</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5289"/>
        <source>&amp;Endings:</source>
        <translation>&amp;Eindpunte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="4644"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5342"/>
        <source>No Style</source>
        <translation>Geen styl</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5291"/>
        <source>Cell Lines</source>
        <translation>Sellyne</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5292"/>
        <source>Line at Top</source>
        <translation>Bolyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5293"/>
        <source>Line at the Left</source>
        <translation>Linkerlyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5294"/>
        <source>Line at the Right </source>
        <translation>Regterlyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5295"/>
        <source>Line at Bottom</source>
        <translation>Onderlyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5437"/>
        <source>Name of selected object</source>
        <translation>Naam van gekose objek</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5438"/>
        <source>Horizontal position of current basepoint</source>
        <translation>Horisontale posisie van huidige basispunt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5439"/>
        <source>Vertical position of current basepoint</source>
        <translation>Vertikale posisie van het huidige basispunt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5440"/>
        <source>Width</source>
        <translation>Breedte</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5441"/>
        <source>Height</source>
        <translation>Hoogte</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5442"/>
        <source>Rotation of object at current basepoint</source>
        <translation>Rotasie van objek op huidige basispunt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5443"/>
        <source>Point from which measurements or rotation angles are referenced</source>
        <translation>Punt waarvandaan die rotasiehoek bereken word</translation>
    </message>
    <message>
        <source>Select top left for basepoint</source>
        <translation type="obsolete">Kies linksbo as basispunt</translation>
    </message>
    <message>
        <source>Select top right for basepoint</source>
        <translation type="obsolete">Kies regtsbo as basispunt</translation>
    </message>
    <message>
        <source>Select bottom left for basepoint</source>
        <translation type="obsolete">Kies linksonder as basispunt</translation>
    </message>
    <message>
        <source>Select bottom right for basepoint</source>
        <translation type="obsolete">Kies regtsonder as basispunt</translation>
    </message>
    <message>
        <source>Select center for basepoint</source>
        <translation type="obsolete">Kies middel as basispunt</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5451"/>
        <source>Flip Horizontal</source>
        <translation>Spieël Horisontaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5452"/>
        <source>Flip Vertical</source>
        <translation>Spieël Vertikaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5453"/>
        <source>Move one level up</source>
        <translation>Skuif een vlak op</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5454"/>
        <source>Move one level down</source>
        <translation>Skuif een vlak af</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5455"/>
        <source>Move to front</source>
        <translation>Bring na voorgrond</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5456"/>
        <source>Move to back</source>
        <translation>Stuur na agtergrond</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5457"/>
        <source>Indicates the level the object is on, 0 means the object is at the bottom</source>
        <translation>Dui vlak waarop objek is, 0 beteken onder</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5458"/>
        <source>Lock or unlock the object</source>
        <translation>Sluit of ontsluit objek</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5459"/>
        <source>Lock or unlock the size of the object</source>
        <translation>Sluit of ontsluit objekgrootte</translation>
    </message>
    <message>
        <source>Enable or disable printing of the object</source>
        <translation type="obsolete">Skakel druk van objek aan/af</translation>
    </message>
    <message>
        <source>Make text in lower frames flow around the object shape</source>
        <translation type="obsolete">Maak teks in laegeleëde rame om objek vloei</translation>
    </message>
    <message>
        <source>Use a surrounding box instead of the frame&apos;s shape for text flow</source>
        <translation type="obsolete">Gebruik &apos;n omliggende regthoek ipv die vorm van die raam vir die teksvloei</translation>
    </message>
    <message>
        <source>Use a second line originally based on the frame&apos;s shape for text flow</source>
        <translation type="obsolete">Gebruik &apos;n tweede lyn gebaseerd op die raamvorm vir teksvloei</translation>
    </message>
    <message>
        <source>Font of selected text or object</source>
        <translation type="obsolete">Lettertipe van geselekteerde teks of objek</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5474"/>
        <source>Font Size</source>
        <translation>Lettergrootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5476"/>
        <source>Scaling width of characters</source>
        <translation>Skaalbreedte van letters</translation>
    </message>
    <message>
        <source>Color of text stroke</source>
        <translation type="obsolete">Kleur van teks</translation>
    </message>
    <message>
        <source>Color of text fill</source>
        <translation type="obsolete">Kleur van teksagtergrond</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5480"/>
        <source>Saturation of color of text stroke</source>
        <translation>Versadiging van tekskleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5481"/>
        <source>Saturation of color of text fill</source>
        <translation>Versadiging van teksagtergrondkleur</translation>
    </message>
    <message>
        <source>Manual Kerning</source>
        <translation type="obsolete">Handgestelde letterspasiëring</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="834"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5484"/>
        <source>Line Spacing</source>
        <translation>Lynspasiëring</translation>
    </message>
    <message>
        <source>Style of current paragraph</source>
        <translation type="obsolete">Styl van huidige paragraaf</translation>
    </message>
    <message>
        <source>Hyphenation language of frame</source>
        <translation type="obsolete">Afkaptaalinstelling van raam</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5503"/>
        <source>Change settings for left or end points</source>
        <translation>Verander instellings vir linker of eindpunte</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5504"/>
        <source>Pattern of line</source>
        <translation>Lynpatroon</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5505"/>
        <source>Thickness of line</source>
        <translation>Lyndikte</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5506"/>
        <source>Type of line joins</source>
        <translation>Tipe lynverbindings</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5507"/>
        <source>Type of line end</source>
        <translation>Tipe lyneinde</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5508"/>
        <source>Line style of current object</source>
        <translation>Lynstyl van huidige objek</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5512"/>
        <source>Choose the shape of frame...</source>
        <translation>Kies raamvorm...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5513"/>
        <source>Edit shape of the frame...</source>
        <translation>Verander raamvorm...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5514"/>
        <source>Set radius of corner rounding</source>
        <translation>Stel straal van ronde hoeke</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5515"/>
        <source>Number of columns in text frame</source>
        <translation>Aantal kolomme in teksraam</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5516"/>
        <source>Switches between Gap or Column width</source>
        <translation>Skakel tussen Tussenruimte of Kolombreedte</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="3821"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5517"/>
        <source>Distance between columns</source>
        <translation>Afstand tussen kolomme</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5518"/>
        <source>Distance of text from top of frame</source>
        <translation>Afstand van teks tot raambokant</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5519"/>
        <source>Distance of text from bottom of frame</source>
        <translation>Afstand van teks tot raamonderkant</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5520"/>
        <source>Distance of text from left of frame</source>
        <translation>Afstand van teks tot raamlinkerkant</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5521"/>
        <source>Distance of text from right of frame</source>
        <translation>Afstand van teks tot raamregterkant</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5522"/>
        <source>Edit tab settings of text frame...</source>
        <translation>Verander Tabinstelling van teksraam...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5524"/>
        <source>Allow the image to be a different size to the frame</source>
        <translation>Laat prent en raam grootte verskille toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5525"/>
        <source>Horizontal offset of image within frame</source>
        <translation>Horisontale afstand van prente in raam</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5526"/>
        <source>Vertical offset of image within frame</source>
        <translation>Vertikale afstand van prente in raam</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5527"/>
        <source>Resize the image horizontally</source>
        <translation>Skaleer prent horisontaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5528"/>
        <source>Resize the image vertically</source>
        <translation>Skaleer prent vertikaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5529"/>
        <source>Keep the X and Y scaling the same</source>
        <translation>Hou X- en Y-skaal gelyk</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5530"/>
        <source>Keep the aspect ratio</source>
        <translation>Hoe prent in verhouding</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5531"/>
        <source>Make the image fit within the size of the frame</source>
        <translation>Maak prent presies in raam pas</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5534"/>
        <source>Use image proportions rather than those of the frame</source>
        <translation>Gebruik prent proporsies ipv raam proporsies</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5535"/>
        <source>Source profile of the image</source>
        <translation>Bronprofiel van prent</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5536"/>
        <source>Rendering intent for the image</source>
        <translation>Rendering intent van prent</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2294"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4059"/>
        <source>&amp;X1:</source>
        <translation>&amp;X1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2295"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4060"/>
        <source>X&amp;2:</source>
        <translation>X&amp;2:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2296"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4061"/>
        <source>Y&amp;1:</source>
        <translation>Y&amp;1:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="2297"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="4062"/>
        <source>&amp;Y2:</source>
        <translation>&amp;Y2:</translation>
    </message>
    <message>
        <source> mm</source>
        <translation type="obsolete">mm</translation>
    </message>
    <message>
        <source> in</source>
        <translation type="obsolete">in</translation>
    </message>
    <message>
        <source> p</source>
        <translation type="obsolete">p</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="3823"/>
        <source>Column width</source>
        <translation>Kolombreedte</translation>
    </message>
    <message>
        <source>None</source>
        <translation type="obsolete">Geen</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>Name &quot;%1&quot; isn&apos;t unique.
Please choose another.</source>
        <translation type="obsolete">Die naam &quot;%1&quot; is nie uniek nie.
Kies &apos;n ander naam.</translation>
    </message>
    <message>
        <source>OK</source>
        <translation type="obsolete">Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5482"/>
        <source>Right to Left Writing</source>
        <translation>Regs na Links Skryf</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5263"/>
        <source>Start Arrow:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5264"/>
        <source>End Arrow:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5240"/>
        <source>Fixed Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5241"/>
        <source>Automatic Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5242"/>
        <source>Align to Baseline Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5222"/>
        <source>Actual X-DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5223"/>
        <source>Actual Y-DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5475"/>
        <source>Offset to baseline of characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5477"/>
        <source>Scaling height of characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5483"/>
        <source>Manual Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="4977"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5172"/>
        <source>Fill Rule</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5173"/>
        <source>Even-Odd</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5174"/>
        <source>Non Zero</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5297"/>
        <source>Overprinting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5298"/>
        <source>Knockout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5299"/>
        <source>Overprint</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5478"/>
        <source>Color of text stroke and/or drop shadow, depending which is chosen.If both are chosen, then they share the same color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5479"/>
        <source>Color of selected text. If Outline text decoration is enabled, this color will be the fill color. If Drop Shadow Text is enabled, then this will be the top most color.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5151"/>
        <source>Gap:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5152"/>
        <source>Width:</source>
        <translation type="unfinished">Breedte:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5175"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5181"/>
        <source>Text &amp;Flow Around Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5176"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5182"/>
        <source>Disabled</source>
        <translation type="unfinished">Af</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5177"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5183"/>
        <source>Use Frame &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5230"/>
        <source>Image Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5231"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5462"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5467"/>
        <source>Disable text flow from lower frames around object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5463"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5468"/>
        <source>Use the frame shape for text flow of text frames below the object.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5464"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5469"/>
        <source>Use the bounding box, which is always rectangular, instead of the frame&apos;s shape for text flow of text frames below the object. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="669"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5126"/>
        <source>Transparency Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5109"/>
        <source>&amp;Group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5127"/>
        <source>Opacity:</source>
        <translation type="unfinished">Ondeursigtigheid:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5128"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5131"/>
        <source>Normal</source>
        <translation type="unfinished">Normaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5132"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5133"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5134"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5135"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5136"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5137"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5138"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5139"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5140"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5141"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5142"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5143"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5145"/>
        <source>Color</source>
        <translation type="unfinished">Kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5449"/>
        <source>Group the selected objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1265"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="3168"/>
        <source>Auto</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5465"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5470"/>
        <source>When chosen, the contour line can be edited with the Edit Shape Tool on the palette further above. When edited via the shape palette, this becomes a second separate line originally based on the frame&apos;s shape for text flow of text frames below the object. T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5163"/>
        <source>Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5164"/>
        <source>Stair Step</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5165"/>
        <source>Skew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5167"/>
        <source>Flip Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5169"/>
        <source>Type:</source>
        <translation type="unfinished">Tipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5180"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5186"/>
        <source>Use Image Clip Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5187"/>
        <source>Paragraph St&amp;yle:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5188"/>
        <source>Character St&amp;yle:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5208"/>
        <source>Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5209"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5212"/>
        <source>Min:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5210"/>
        <source>Norm:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5211"/>
        <source>Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5213"/>
        <source>Max:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5466"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5471"/>
        <source>Use the clipping path of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5487"/>
        <source>Paragraph style of currently selected text or paragraph</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5488"/>
        <source>Character style of currently selected text or paragraph</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5489"/>
        <source>Remove Direct Paragraph Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5490"/>
        <source>Remove Direct Character Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5497"/>
        <source>Minimal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5498"/>
        <source>Normal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5499"/>
        <source>Minimal shrinkage of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5500"/>
        <source>Maximal extension of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5460"/>
        <source>Enable or disable exporting of the object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1393"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5254"/>
        <source>Custom</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5123"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5124"/>
        <source>&amp;Edit...</source>
        <translation type="unfinished">B&amp;ewerk...</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="842"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5217"/>
        <source>First Line Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="832"/>
        <source>Maximum Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="833"/>
        <source>Font Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="794"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5214"/>
        <source>Color &amp; Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="1018"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5215"/>
        <source>Advanced Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="825"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5216"/>
        <source>Style Settings</source>
        <translation type="unfinished">Stylinstelling</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="3170"/>
        <source>Baseline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5450"/>
        <source>Ungroup the selected group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5486"/>
        <source>Select the line spacing mode.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5493"/>
        <source>Set the height of the first line of the text frame to use the tallest height of the included characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5494"/>
        <source>Set the height of the first line of text frame to use the full ascent of the font(s) in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5495"/>
        <source>Set the height of the first line of the text frame to the specified line height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5220"/>
        <source>&amp;Page Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="898"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5218"/>
        <source>Columns &amp; Text Distances</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="936"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5207"/>
        <source>Reset</source>
        <translation type="unfinished">Begin oor</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="945"/>
        <source>Optical Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5324"/>
        <source>Hairline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="932"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5203"/>
        <source>None</source>
        <comment>optical margins</comment>
        <translation type="unfinished">Geen</translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="933"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5204"/>
        <source>Both Sides</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="934"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5205"/>
        <source>Left Only</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="935"/>
        <location filename="../../../scribus/propertiespalette.cpp" line="5206"/>
        <source>Right Only</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5509"/>
        <source>Arrow head style for start of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5510"/>
        <source>Arrow head style for end of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5532"/>
        <source>Effective horizontal DPI of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/propertiespalette.cpp" line="5533"/>
        <source>Effective vertical DPI of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PythonConsole</name>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="93"/>
        <source>&amp;Open...</source>
        <translation type="unfinished">&amp;Maak oop...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="98"/>
        <source>&amp;Save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="103"/>
        <source>Save &amp;As...</source>
        <translation type="unfinished">Stoor &amp;as...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="71"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="113"/>
        <source>&amp;Run</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="118"/>
        <source>Run As &amp;Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="123"/>
        <source>&amp;Save Output...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="81"/>
        <source>&amp;Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="60"/>
        <source>Scribus Python Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="13"/>
        <source>Script Console</source>
        <translation type="unfinished">Scriptkonsole</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="117"/>
        <source>Write your commands here. A selection is processed as script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="118"/>
        <source>Output of your script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="195"/>
        <source>Save the Python Commands in File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="220"/>
        <source>Text Files (*.txt)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="218"/>
        <source>Save Current Output</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="161"/>
        <source>Open Python Script File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="163"/>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="197"/>
        <source>Python Scripts (*.py *.PY)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="33"/>
        <source>Col: %1 Row: %2/%3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="44"/>
        <source>Ctrl+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="45"/>
        <source>Ctrl+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.ui" line="108"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">A&amp;fsluiten</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/pconsole.cpp" line="62"/>
        <source>This is a standard Python console with some 
known limitations. Please consult the Scribus 
Scripter documentation for futher information. </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QColorDialog</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="130"/>
        <source>Hu&amp;e:</source>
        <translation>Tin&amp;t:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="131"/>
        <source>&amp;Sat:</source>
        <translation>&amp;Vers.:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="132"/>
        <source>&amp;Val:</source>
        <translation>&amp;Waarde:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="133"/>
        <source>&amp;Red:</source>
        <translation>&amp;Rooi:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="134"/>
        <source>&amp;Green:</source>
        <translation>&amp;Groen:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="135"/>
        <source>Bl&amp;ue:</source>
        <translation>&amp;Blou:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="136"/>
        <source>A&amp;lpha channel:</source>
        <translation>&amp;Alfakanaal:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="137"/>
        <source>&amp;Basic colors</source>
        <translation>&amp;Basiskleure</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="138"/>
        <source>&amp;Custom colors</source>
        <translation>&amp;Tuisgemaakte kleure</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="139"/>
        <source>&amp;Define Custom Colors &gt;&gt;</source>
        <translation>&amp;Definieer tuisgemaakte kleure &gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="140"/>
        <source>OK</source>
        <translation>Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="141"/>
        <source>Cancel</source>
        <translation>Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="142"/>
        <source>&amp;Add to Custom Colors</source>
        <translation>&amp;Voeg by tuisgemaakte kleure</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="143"/>
        <source>Select color</source>
        <translation>Kies Kleur</translation>
    </message>
</context>
<context>
    <name>QFileDialog</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="14"/>
        <source>Copy or Move a File</source>
        <translation>Skuif of kopiër &apos;n Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="15"/>
        <source>Read: %1</source>
        <translation>Lees: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="16"/>
        <source>Write: %1</source>
        <translation>Skryf: %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="17"/>
        <source>File &amp;name:</source>
        <translation>Lêer&amp;naam:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="18"/>
        <source>File &amp;type:</source>
        <translation>Lêer&amp;tipe:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="19"/>
        <source>One directory up</source>
        <translation>Een Gids op</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="20"/>
        <source>Cancel</source>
        <translation>Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="21"/>
        <source>All Files (*)</source>
        <translation>Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="22"/>
        <source>Name</source>
        <translation>Naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="23"/>
        <source>Size</source>
        <translation>Grootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="24"/>
        <source>Type</source>
        <translation>Tipe</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="25"/>
        <source>Date</source>
        <translation>Datum</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="26"/>
        <source>Attributes</source>
        <translation>Attribute</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="27"/>
        <source>OK</source>
        <translation>Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="28"/>
        <source>Look &amp;in:</source>
        <translation>Kyk &amp;in:</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="29"/>
        <source>Back</source>
        <translation>Terug</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="30"/>
        <source>Create New Folder</source>
        <translation>Nuwe gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="31"/>
        <source>List View</source>
        <translation>Lys aansig</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="32"/>
        <source>Detail View</source>
        <translation>Detail aansig</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="33"/>
        <source>Preview File Info</source>
        <translation>Vertoon Lêerinligting</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="34"/>
        <source>Preview File Contents</source>
        <translation>Vertoon Lêerinhoud</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="35"/>
        <source>Read-write</source>
        <translation>Lees-skryf</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="36"/>
        <source>Read-only</source>
        <translation>Leesalleen</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="37"/>
        <source>Write-only</source>
        <translation>Skryfalleen</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="38"/>
        <source>Inaccessible</source>
        <translation>ontoeganklik</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="39"/>
        <source>Symlink to File</source>
        <translation>Symlink na lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="40"/>
        <source>Symlink to Directory</source>
        <translation>Symlink na gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="41"/>
        <source>Symlink to Special</source>
        <translation>Symlink na spesiaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="42"/>
        <source>File</source>
        <translation>Lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="43"/>
        <source>Dir</source>
        <translation>Gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="44"/>
        <source>Special</source>
        <translation>Spesiaal</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="45"/>
        <source>Open</source>
        <translation>Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="46"/>
        <source>Save As</source>
        <translation>Stoor as</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="47"/>
        <source>&amp;Open</source>
        <translation>&amp;Maak oop</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="48"/>
        <source>&amp;Save</source>
        <translation>&amp;Stoor</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="49"/>
        <source>&amp;Rename</source>
        <translation>He&amp;rbenoem</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="50"/>
        <source>&amp;Delete</source>
        <translation>Uitv&amp;ee</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="51"/>
        <source>R&amp;eload</source>
        <translation>W&amp;eerlaai</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="52"/>
        <source>Sort by &amp;Name</source>
        <translation>Sorteer volgens &amp;naam</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="53"/>
        <source>Sort by &amp;Size</source>
        <translation>Sorteer volgens &amp;grootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="54"/>
        <source>Sort by &amp;Date</source>
        <translation>Sorteer volgens &amp;datum</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="55"/>
        <source>&amp;Unsorted</source>
        <translation>&amp;ongesorteer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="56"/>
        <source>Sort</source>
        <translation>Sorteer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="57"/>
        <source>Show &amp;hidden files</source>
        <translation>Ver&amp;toon versteekte lêers</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="58"/>
        <source>the file</source>
        <translation>die lêer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="59"/>
        <source>the directory</source>
        <translation>die gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="60"/>
        <source>the symlink</source>
        <translation>die symlink</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="61"/>
        <source>Delete %1</source>
        <translation>Vee %1 uit</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="62"/>
        <source>&lt;qt&gt;Are you sure you wish to delete %1 &quot;%2&quot;?&lt;/qt&gt;</source>
        <translation>&lt;qt&gt;Is u seker U wil %1 &quot;%2&quot; uitvee?&lt;/qt&gt;</translation>
    </message>
    <message>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Ja</translation>
    </message>
    <message>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Nee</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="65"/>
        <source>New Folder 1</source>
        <translation>Nuwe gids 1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="66"/>
        <source>New Folder</source>
        <translation>Nuwe gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="67"/>
        <source>New Folder %1</source>
        <translation>Nuwe gids %1</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="68"/>
        <source>Find Directory</source>
        <translation>Soek gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="69"/>
        <source>Directories</source>
        <translation>Gidse</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="70"/>
        <source>Save</source>
        <translation>Stoor</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="71"/>
        <source>Error</source>
        <translation>Fout</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="72"/>
        <source>%1
File not found.
Check path and filename.</source>
        <translation>%1
Lêer nie gevind nie.
Kontroleer pad en lêernaam.</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="73"/>
        <source>All Files (*.*)</source>
        <translation>Alle lêers (*.*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="74"/>
        <source>Select a Directory</source>
        <translation>Kies &apos;n gids</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="75"/>
        <source>Directory:</source>
        <translation>Gids:</translation>
    </message>
</context>
<context>
    <name>QFontDialog</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="147"/>
        <source>&amp;Font</source>
        <translation>&amp;Lettertipe</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="148"/>
        <source>Font st&amp;yle</source>
        <translation>St&amp;yl</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="149"/>
        <source>&amp;Size</source>
        <translation>&amp;Grootte</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="150"/>
        <source>Effects</source>
        <translation>Effekte</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="151"/>
        <source>Stri&amp;keout</source>
        <translation>Dood&amp;getrek</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="152"/>
        <source>&amp;Underline</source>
        <translation>&amp;Onderstreep</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="153"/>
        <source>&amp;Color</source>
        <translation>&amp;Kleur</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="154"/>
        <source>Sample</source>
        <translation>Voorbeeld</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="155"/>
        <source>Scr&amp;ipt</source>
        <translation>Scr&amp;ipt</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="156"/>
        <source>OK</source>
        <translation>Reg</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="157"/>
        <source>Apply</source>
        <translation>Pas toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="158"/>
        <source>Cancel</source>
        <translation>Kanselleer</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="159"/>
        <source>Close</source>
        <translation>Maak toe</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="160"/>
        <source>Select Font</source>
        <translation>Kies Lettertipe</translation>
    </message>
</context>
<context>
    <name>QLineEdit</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="79"/>
        <source>Clear</source>
        <translation>Maak skoon</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="80"/>
        <source>Select All</source>
        <translation>Kies Alles</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="81"/>
        <source>&amp;Undo</source>
        <translation>&amp;Ongedaanmaak</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="82"/>
        <source>&amp;Redo</source>
        <translation>&amp;Gedaanmaak</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="83"/>
        <source>Cu&amp;t</source>
        <translation>Kni&amp;p</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="84"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopiër</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="85"/>
        <source>&amp;Paste</source>
        <translation>P&amp;lak</translation>
    </message>
</context>
<context>
    <name>QMainWindow</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="99"/>
        <source>Line up</source>
        <translation>Kry in lyn</translation>
    </message>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="100"/>
        <source>Customize...</source>
        <translation>Pas self aan...</translation>
    </message>
</context>
<context>
    <name>QMessageBox</name>
    <message>
        <location filename="../../../scribus/translationdummy.cpp" line="9"/>
        <source>&lt;h3&gt;About Qt&lt;/h3&gt;&lt;p&gt;This program uses Qt version %1.&lt;/p&gt;&lt;p&gt;Qt is a C++ toolkit for multiplatform GUI &amp;amp; application development.&lt;/p&gt;&lt;p&gt;Qt provides single-source portability across MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, and all major commercial Unix variants.&lt;br&gt;Qt is also available for embedded devices.&lt;/p&gt;&lt;p&gt;Qt is a Trolltech product. See &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; for more information.&lt;/p&gt;</source>
        <translation>&lt;h3&gt;Inligting oor Qt&lt;/h3&gt;&lt;p&gt;Die program gebruik Qt weergawe %1.&lt;/p&gt;&lt;p&gt;Qt is &apos;n C++-toolkit vir die ontwikkeling van programme op verskillende platforms.&lt;/p&gt;&lt;p&gt;Qt bied bronkode-aanpasbaarheit tussen MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, en alle belangrike UNIX-variante.&lt;br&gt;Qt is ook beskikbaar vir ingebedde apparate.&lt;/p&gt;&lt;p&gt;Qt is &apos;n product van Trolltech. Sien &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; vir meer informasie.&lt;/p&gt;</translation>
    </message>
</context>
<context>
    <name>QObject</name>
    <message>
        <location filename="../../../scribus/gtaction.cpp" line="77"/>
        <source>Importing text</source>
        <translation>Teks word ingevoer</translation>
    </message>
    <message>
        <location filename="../../../scribus/gtgettext.cpp" line="155"/>
        <location filename="../../../scribus/scgtplugin.cpp" line="68"/>
        <location filename="../../../scribus/util_formats.cpp" line="195"/>
        <source>All Supported Formats</source>
        <translation>Alle ondersteunde formate</translation>
    </message>
    <message>
        <location filename="../../../scribus/gtgettext.cpp" line="183"/>
        <location filename="../../../scribus/scgtplugin.cpp" line="87"/>
        <location filename="../../../scribus/util_formats.cpp" line="242"/>
        <source>All Files (*)</source>
        <translation>Alle lêers (*)</translation>
    </message>
    <message>
        <location filename="../../../scribus/scribuscore.cpp" line="247"/>
        <source>Initializing...</source>
        <translation>Besig om te initialiseer...</translation>
    </message>
    <message>
        <source>Document</source>
        <translation type="obsolete">Dokument</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="730"/>
        <location filename="../../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="1537"/>
        <location filename="../../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="1124"/>
        <source>Background</source>
        <translation>Agtergrond</translation>
    </message>
    <message>
        <source>Warning</source>
        <translation type="obsolete">Waarskuwing</translation>
    </message>
    <message>
        <source>Do you really want to overwrite the File:
%1 ?</source>
        <translation type="obsolete">Wil u werklik %1 oorskryf?</translation>
    </message>
    <message>
        <source>&amp;Fonts Preview</source>
        <translation type="obsolete">&amp;Lettertipe voorbeeld</translation>
    </message>
    <message>
        <source>&amp;Insert Special</source>
        <translation type="obsolete">Voeg spesiale ding &amp;In</translation>
    </message>
    <message>
        <source>New &amp;from Template...</source>
        <translation type="obsolete">Nuut van &amp;templaat...</translation>
    </message>
    <message>
        <source>Template: </source>
        <translation type="obsolete">Templaat:</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="199"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="199"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="155"/>
        <source>Newsletters</source>
        <translation>Nuusbriewe</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="200"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="200"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="156"/>
        <source>Brochures</source>
        <translation>Brosjures</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="201"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="201"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="157"/>
        <source>Catalogs</source>
        <translation>Katalogusse</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="202"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="202"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="158"/>
        <source>Flyers</source>
        <translation>Pamflette</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="203"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="203"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="159"/>
        <source>Signs</source>
        <translation>Tekens</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="204"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="204"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="160"/>
        <source>Cards</source>
        <translation>Kaartjies</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="205"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="205"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="161"/>
        <source>Letterheads</source>
        <translation>Briefhoofde</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="206"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="206"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="162"/>
        <source>Envelopes</source>
        <translation>Briewe</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="207"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="207"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="163"/>
        <source>Business Cards</source>
        <translation>Visitekaartjies</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="208"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="208"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="164"/>
        <source>Calendars</source>
        <translation>Kalenders</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="209"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="209"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="165"/>
        <source>Advertisements</source>
        <translation>Advertenties</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="210"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="210"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="166"/>
        <source>Labels</source>
        <translation>Labels</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="211"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="211"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="167"/>
        <source>Menus</source>
        <translation>Spyskaarte</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="212"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="212"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="168"/>
        <source>Programs</source>
        <translation>Programme</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="213"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="213"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="169"/>
        <source>PDF Forms</source>
        <translation>PDF-vorms</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="214"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="214"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="170"/>
        <source>PDF Presentations</source>
        <translation>PDF-aanbiedings</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="215"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="215"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="171"/>
        <source>Magazines</source>
        <translation>Tydskrifte</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="216"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="216"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="172"/>
        <source>Posters</source>
        <translation>Plakkate</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="217"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="217"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="173"/>
        <source>Announcements</source>
        <translation>Aankondigings</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="218"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="218"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="174"/>
        <source>Text Documents</source>
        <translation>Teksdokumente</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="219"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="219"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="175"/>
        <source>Folds</source>
        <translation>Gevoude dokumente</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="221"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="221"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="177"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="261"/>
        <source>Own Templates</source>
        <translation>Eien Template</translation>
    </message>
    <message>
        <source>Save as &amp;Image...</source>
        <translation type="obsolete">Stoor as &amp;prent...</translation>
    </message>
    <message>
        <source>Save as Image</source>
        <translation type="obsolete">Stoor as prent</translation>
    </message>
    <message>
        <source>Error writting the output file(s).</source>
        <translation type="obsolete">Fout tydens het skryf na uitvoerlêer(s).</translation>
    </message>
    <message>
        <source>Error writing the output file(s).</source>
        <translation type="obsolete">Fout tydens het skryf na uitvoerlêer(s).</translation>
    </message>
    <message>
        <source>Export successful.</source>
        <translation type="obsolete">Uitvoer was suksesvol.</translation>
    </message>
    <message>
        <source>File exists. Overwrite?</source>
        <translation type="obsolete">Lêer bestaan. Oorskryf?</translation>
    </message>
    <message>
        <source>exists already. Overwrite?</source>
        <translation type="obsolete">bestaat alreeds. Oorskryf?</translation>
    </message>
    <message>
        <source>No</source>
        <translation type="obsolete">Nee</translation>
    </message>
    <message>
        <source>Yes</source>
        <translation type="obsolete">Ja</translation>
    </message>
    <message>
        <source>Yes all</source>
        <translation type="obsolete">Ja, alles</translation>
    </message>
    <message>
        <source>Print Preview</source>
        <translation type="obsolete">Drukvoorbeeld</translation>
    </message>
    <message>
        <source>Print Previe&amp;w</source>
        <translation type="obsolete">Druk&amp;voorbeeld</translation>
    </message>
    <message>
        <source>Import &amp;EPS/PS...</source>
        <translation type="obsolete">Voer &amp;EPS/PS in...</translation>
    </message>
    <message>
        <source>All Supported Formats (*.eps *.EPS *.ps *.PS);;</source>
        <translation type="obsolete">Alle ondersteunde formate (*.eps *.EPS *.ps *.PS);;</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="127"/>
        <location filename="../../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="173"/>
        <location filename="../../../scribus/plugins/psimport/importpsplugin.cpp" line="137"/>
        <location filename="../../../scribus/plugins/svgimplugin/svgplugin.cpp" line="159"/>
        <location filename="../../../scribus/plugins/wmfimplugin/wmfimportplugin.cpp" line="146"/>
        <location filename="../../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="126"/>
        <source>Open</source>
        <translation>Maak oop</translation>
    </message>
    <message>
        <source>Save as &amp;Template...</source>
        <translation type="obsolete">Stoor as &amp;templaat...</translation>
    </message>
    <message>
        <source>S&amp;cripter Manual...</source>
        <translation type="obsolete">Scripter &amp;handleiding...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="76"/>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="570"/>
        <source>&amp;Scribus Scripts</source>
        <translation type="unfinished">&amp;Scribus scripts</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="43"/>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="565"/>
        <source>&amp;Execute Script...</source>
        <translation type="unfinished">Voer Script &amp;uit...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="78"/>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="571"/>
        <source>&amp;Recent Scripts</source>
        <translation type="unfinished">&amp;Onlangse scripts</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="44"/>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="566"/>
        <source>Show &amp;Console</source>
        <translation type="unfinished">Wys &amp;Konsole</translation>
    </message>
    <message>
        <source>S&amp;cript</source>
        <translation type="obsolete">S&amp;cript</translation>
    </message>
    <message>
        <source>Online Reference</source>
        <translation type="obsolete">Aanlyn naslaan</translation>
    </message>
    <message>
        <source>Python Scripts (*.py);; All Files (*)</source>
        <translation type="obsolete">Python scripts (*.py);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Save Page as &amp;SVG...</source>
        <translation type="obsolete">Stoor bladsy as &amp;SVG...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>Save as</source>
        <translation>Stoor as</translation>
    </message>
    <message>
        <source>SVG-Images (*.svg *.svgz);;All Files (*)</source>
        <translation type="obsolete">SVG-prente (*.svg *.svgz);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>SVG-Images (*.svg);;All Files (*)</source>
        <translation type="obsolete">SVG-prente (*.svg);;Alle lêers (*)</translation>
    </message>
    <message>
        <source>Import &amp;SVG...</source>
        <translation type="obsolete">Voer &amp;SVG in...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvim.cpp" line="12"/>
        <source>Comma Separated Value Files</source>
        <translation>Lêers met kommageskeide-waardes (CSV)</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvim.cpp" line="58"/>
        <source>CSV_data</source>
        <translation>CSV_gegewens</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/csvim/csvim.cpp" line="62"/>
        <source>CSV_header</source>
        <translation>CSV_kopreel</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="43"/>
        <source>HTML Files</source>
        <translation>HTML-lêers</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="48"/>
        <source>html</source>
        <translation>html</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/htmlim/htmlreader.cpp" line="616"/>
        <source>
External Links
</source>
        <translation>
Eksterne skakelings
</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/txtim/txtim.cpp" line="21"/>
        <source>Text Files</source>
        <translation>Tekslêers</translation>
    </message>
    <message>
        <location filename="../../../scribus/scfonts.cpp" line="334"/>
        <source>Font %1 is broken, discarding it</source>
        <translation>Lettertype %1 is beskadig en word weggelaat</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/gettext/textfilter/textfilter.cpp" line="26"/>
        <source>Text Filters</source>
        <translation>Teksfilters</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="60"/>
        <source>Albanian</source>
        <translation>Albaanies</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="61"/>
        <source>Basque</source>
        <translation>Baskies</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="64"/>
        <source>Bulgarian</source>
        <translation>Bulgaars</translation>
    </message>
    <message>
        <source>Brazilian</source>
        <translation type="obsolete">Braziliaans</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="65"/>
        <source>Catalan</source>
        <translation>Catalaans</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="66"/>
        <source>Chinese</source>
        <translation>Sjinees</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="69"/>
        <location filename="../../../scribus/langmgr.cpp" line="70"/>
        <source>Czech</source>
        <translation>Tsjeggies</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="71"/>
        <location filename="../../../scribus/langmgr.cpp" line="72"/>
        <source>Danish</source>
        <translation>Deens</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="74"/>
        <source>Dutch</source>
        <translation>Nederlands</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="75"/>
        <location filename="../../../scribus/langmgr.cpp" line="173"/>
        <location filename="../../../scribus/langmgr.cpp" line="219"/>
        <location filename="../../../scribus/langmgr.cpp" line="240"/>
        <source>English</source>
        <translation>Engels</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="77"/>
        <source>English (British)</source>
        <translation>Engels (Brits)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="79"/>
        <source>Esperanto</source>
        <translation>Esperanto</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="81"/>
        <source>German</source>
        <translation>Duits</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="84"/>
        <source>Finnish</source>
        <translation>Fins</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="85"/>
        <source>French</source>
        <translation>Frans</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="86"/>
        <location filename="../../../scribus/langmgr.cpp" line="87"/>
        <location filename="../../../scribus/langmgr.cpp" line="88"/>
        <source>Galician</source>
        <translation>Galies</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="89"/>
        <source>Greek</source>
        <translation>Grieks</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="91"/>
        <source>Hungarian</source>
        <translation>Hongaars</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="94"/>
        <source>Indonesian</source>
        <translation>Indonisies</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="95"/>
        <source>Italian</source>
        <translation>Italiaans</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="98"/>
        <source>Korean</source>
        <translation>Koreaans</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="99"/>
        <source>Kurdish</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="102"/>
        <location filename="../../../scribus/langmgr.cpp" line="103"/>
        <source>Lithuanian</source>
        <translation>Litouws</translation>
    </message>
    <message>
        <source>Norwegian (Bokmaal)</source>
        <translation type="obsolete">Noors (Bokmal)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="108"/>
        <location filename="../../../scribus/langmgr.cpp" line="109"/>
        <source>Norwegian (Nnyorsk)</source>
        <translation>Noors (Nnyorsk)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="110"/>
        <location filename="../../../scribus/langmgr.cpp" line="111"/>
        <source>Norwegian</source>
        <translation>Noors</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="112"/>
        <location filename="../../../scribus/langmgr.cpp" line="113"/>
        <source>Polish</source>
        <translation>Pools</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="117"/>
        <source>Russian</source>
        <translation>Russisch</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="125"/>
        <source>Swedish</source>
        <translation>Zweeds</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="119"/>
        <location filename="../../../scribus/langmgr.cpp" line="120"/>
        <source>Spanish</source>
        <translation>Spaans</translation>
    </message>
    <message utf8="true">
        <location filename="../../../scribus/langmgr.cpp" line="106"/>
        <location filename="../../../scribus/langmgr.cpp" line="107"/>
        <source>Norwegian (BokmÃ¥l)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="121"/>
        <source>Spanish (Latin)</source>
        <translation>Spaans (Latyns)</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="122"/>
        <source>Slovak</source>
        <translation>Slovaaks</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="123"/>
        <source>Slovenian</source>
        <translation>Sloveens</translation>
    </message>
    <message>
        <location filename="../../../scribus/langmgr.cpp" line="124"/>
        <source>Serbian</source>
        <translation>Servies</translation>
    </message>
    <message>
        <location filename="../../../scribus/nftrcreader.cpp" line="220"/>
        <location filename="../../../scribus/plugins/newfromtemplateplugin/nftrcreader.cpp" line="220"/>
        <location filename="../../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="176"/>
        <source>Media Cases</source>
        <translation>Media gevalle</translation>
    </message>
    <message>
        <source>Tried to set progress &gt; maximum progress</source>
        <translation type="obsolete">Het vordering probeer stel &gt; maksimum vordering</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="45"/>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="567"/>
        <source>&amp;About Script...</source>
        <translation type="unfinished">&amp;Oor Script...</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/scriptercore.cpp" line="538"/>
        <source>About Script</source>
        <translation type="unfinished">Oor Script</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="28"/>
        <source>Cannot get font size of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie lettergrootte vir nie-teksraam kry nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="54"/>
        <source>Cannot get font of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie lettertipe vir nie-teksraam kry nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="80"/>
        <source>Cannot get text size of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie teksgrootte vir nie-kry nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="116"/>
        <source>Cannot get column count of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie kolomtelling vir nie-teksraam kry nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="134"/>
        <source>Cannot get line space of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie lynspasiëring vir nie-teksraam kry nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="174"/>
        <source>Cannot get column gap of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie kolomgaping vir nie-teksraam kry nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="193"/>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="224"/>
        <source>Cannot get text of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie teks vir nie-teksraam kry nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="257"/>
        <source>Cannot set text of non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie teks vir nie-teksraam stel nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="292"/>
        <source>Cannot insert text into non-text frame.</source>
        <comment>python error</comment>
        <translation>Kan nie teks in nie-teksraam invoeg nie</translation>
    </message>
    <message>
        <source>Insert index out of bounds</source>
        <comment>python error</comment>
        <translation type="obsolete">Ingevoeg indeks buite grense</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="330"/>
        <source>Alignment out of range. Use one of the scribus.ALIGN* constants.</source>
        <comment>python error</comment>
        <translation>Skoueropsie bestaan nie, gebruik scribus konstantes</translation>
    </message>
    <message>
        <source>Can&apos;t set text alignment on a non-text frame</source>
        <comment>python error</comment>
        <translation type="obsolete">Kan nie teks skouer op nie-teksraam nie</translation>
    </message>
    <message>
        <source>Font size out of bounds - must be 1 &lt;= size &lt;= 512</source>
        <comment>python error</comment>
        <translation type="obsolete">Lettergrootte buite grense - moet tussen 1 en 512 wees</translation>
    </message>
    <message>
        <source>Can&apos;t set font size on a non-text frame</source>
        <comment>python error</comment>
        <translation type="obsolete">Kan nie lettergrootte op nie-teksraam stel nie</translation>
    </message>
    <message>
        <source>Can&apos;t set font on a non-text frame</source>
        <comment>python error</comment>
        <translation type="obsolete">Kan nie lettertipe op &apos;n nie-teksraam stel nie</translation>
    </message>
    <message>
        <source>Font not found</source>
        <comment>python error</comment>
        <translation type="obsolete">Lettertipe nie gevind nie</translation>
    </message>
    <message>
        <source>Line space out of bounds, must be &gt;= 0.1</source>
        <comment>python error</comment>
        <translation type="obsolete">Lynspasiëring buite grense, moet &gt;=0,1 wees</translation>
    </message>
    <message>
        <source>Can&apos;t line spacing on a non-text frame</source>
        <comment>python error</comment>
        <translation type="obsolete">Kan e lynspasiëring op nie-teksraam doen nie</translation>
    </message>
    <message>
        <source>Column gap out of bounds, must be positive</source>
        <comment>python error</comment>
        <translation type="obsolete">Kolomgaping is buite grense, moet positief wees</translation>
    </message>
    <message>
        <source>Can&apos;t column gap on a non-text frame</source>
        <comment>python error</comment>
        <translation type="obsolete">Kan nie kolomgaping vir &apos;n nie-teksraam toeken nie</translation>
    </message>
    <message>
        <source>Column count out of bounds, must be &gt; 1</source>
        <comment>python error</comment>
        <translation type="obsolete">Aantal kolomme moet &gt;=1 wees</translation>
    </message>
    <message>
        <source>Can&apos;t number of columns on a non-text frame</source>
        <comment>python error</comment>
        <translation type="obsolete">Kan nie aantal kolomme stel in &apos;n nie-teksraam nie</translation>
    </message>
    <message>
        <location filename="../../../scribus/plugins/scriptplugin/cmdtext.cpp" line="565"/>
        <source>Selection index out of bounds</source>
        <comment>python error</comment>
        <translation>Keuse indeks buite grense</translation>
    </message>
    <message>
        <source>Can&apos;t select text in a non-text frame</source>
        <comment>python error</comment>
        <translation type="obsolete">Kan nie teks kies in &apos;n nie-teksraam nie</translation>
    </messag