/*
-- GC code for pSOS 2.5 using DIAB C/C++ compiler (v4.3p5) for MIPS3940 core
-- is adapted by Mingjui Liao <ray@liaofamily.org>.
-- It is based on generic.c written by SmartEiffel developers.
-- This is for use under embedded environment. I have only tested this under
-- 1 platform, so use it at your own risk. I will not be responsible for any
-- damages to your board.
*/

void mark_stack_and_registers(void) {

	/* correction for MIPS3940 on DIAB 4.3p5 C compiler for pSOS v2.5*/
	void**stack_pointer = stack_bottom + 0x5;
	jmp_buf stack_top; /* The jmp_buf buffer is in the C stack. */

	(void)setjmp(stack_top); /* To fill the C stack with registers. */
	stack_pointer=((void**)(&stack_top));

	/* stack address decreases as the stack grows in size */
	for ( ; stack_pointer <= stack_bottom; stack_pointer++) {
	  gc_mark(*stack_pointer);
	}
}
