/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_fstat.c) is automatically
  included when some external "SmartEiffel" basic_fstat_* feature is used.
*/

/* To switch from (or to) C to (from) Eiffel. */
#ifndef TIME_DOUBLE_UNION
#define TIME_DOUBLE_UNION 1
typedef union _time_double_union time_double_union;
union _time_double_union {
  time_t c_mapping;
  EIF_DOUBLE eiffel_mapping;
};
#endif

EIF_INTEGER basic_fstat_st_size(EIF_POINTER path) {
  struct stat buf;

  stat(path,&buf);
  return buf.st_size;
}

EIF_DOUBLE basic_fstat_st_mtime(EIF_POINTER path) {
  struct stat buf;
  time_double_union tdu;

  stat(path,&buf);
  tdu.c_mapping = buf.st_mtime;
  return tdu.eiffel_mapping;
}
