--          This file is part of SmartEiffel The GNU Eiffel Compiler.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
-- SmartEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmartEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmartEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class TYPE_FUNCTION
   --
   -- For agents of type FUNCTION and agents of type PREDICATE.
   --

inherit TYPE_OF_AGENT

creation make

feature

   is_type_procedure: BOOLEAN is false

   is_type_function: BOOLEAN is true

   is_type_predicate: BOOLEAN is
      do
	 Result := res.is_boolean
      end

   is_run_type: BOOLEAN is
      do
	 if base.is_run_type then
	    if open.is_run_type then
	       Result := res.is_run_type
	    end
	 end
      end

   run_type: like Current is
      do
	 if run_type_memory = Void then
	    if base.run_type = base then
	       if open.run_type = open then
		  if res.run_type = res then
		     run_type_memory := Current
		  end
	       end
	    end
	    if run_type_memory = Void then
	       create run_type_memory.make(start_position,
					   base.run_type,
					   open.run_type,
					   res.run_type)
	    end
	 end
	 Result := run_type_memory
      end

   to_runnable(ct: E_TYPE): like Current is
      local
	 b: like base; o: like open; r:like res
      do
	 b := base.to_runnable(ct)
	 o := open.to_runnable(ct)
	 r := res.to_runnable(ct)
	 if b = base and then o = open and then r = res then
	    Result := Current
	    load_builtin_features
	 else
	    create Result.make(start_position,b,o,r)
	    Result := Result.to_runnable(ct)
	 end
      end

   written_mark: STRING is
      local
	 base_wm, open_wm, res_wm: STRING; predicate: BOOLEAN
      do
	 Result := written_mark_memory
	 if Result = Void then
	    predicate := is_type_predicate
	    -- To force computation of components first:
	    base_wm := base.written_mark
	    open_wm := open.written_mark
	    if not predicate then
	       res_wm := res.written_mark
	    end
	    -- Then compute the `Result':
	    Result := tmp_mark
	    if predicate then
	       Result.copy(as_predicate)
	    else
	       Result.copy(as_function)
	    end
	    Result.extend('[')
	    Result.append(base_wm)
	    Result.extend(',')
	    Result.append(open_wm)
	    if not predicate then
	       Result.extend(',')
	       Result.append(res_wm)
	    end
	    Result.extend(']')
	    Result := string_aliaser.item(Result)
	    written_mark_memory := Result
	 end
      end

   run_time_mark: STRING is
      local
	 base_rtm, open_rtm, res_rtm: STRING; predicate: BOOLEAN
      do
	 Result := run_time_mark_memory
	 if Result = Void then
	    predicate := is_type_predicate
	    -- To force computation of components first:
	    base_rtm := base.run_time_mark
	    open_rtm := open.run_time_mark
	    if not predicate then
	       res_rtm := res.run_time_mark
	    end
	    -- Then compute the `Result':
	    Result := tmp_mark
	    if predicate then
	       Result.copy(as_predicate)
	    else
	       Result.copy(as_function)
	    end
	    Result.extend('[')
	    Result.append(base_rtm)
	    Result.extend(',')
	    Result.append(open_rtm)
	    if not predicate then
	       Result.extend(',')
	       Result.append(res_rtm)
	    end
	    Result.extend(']')
	    Result := string_aliaser.item(Result)
	    run_time_mark_memory := Result
	 end
      end

feature {E_TYPE}

   short_hook is
      local
	 predicate : BOOLEAN; bcn: like base_class_name
      do
	 predicate := is_type_predicate
	 bcn := base_class_name
	 if predicate then
	    create bcn.make(as_predicate,bcn.start_position)
	 end
	 short_print.a_face_class_name(bcn)
         short_print.hook_or("open_sb","[")
	 base.short_hook
	 short_print.hook_or("tm_sep",",")
	 open.short_hook
	 if not predicate then
	    short_print.hook_or("tm_sep",",")
	    res.short_hook
	 end
         short_print.hook_or("close_sb","]")
      end

feature {E_AGENT}

   load_builtin_features is
      do
	 base_class.load_feature_call(run_type)
	 base_class.load_feature_item(run_type,res.run_type)
      end
   
feature {NONE}

   make(sp: like start_position; b: like base; o: like open; r: like res) is
      require
	 not sp.is_unknown
	 b /= Void
	 o /= Void
      do
	 start_position := sp
	 base := b
	 open := o
	 if r /= Void then
	    res := r
	 else
	    create {TYPE_BOOLEAN} res.make(sp)
	 end
	 create base_class_name.make(as_function,sp)
      ensure
	 start_position = sp
	 base = b
	 open = o
	 res = r or else res.is_boolean
      end

   is_a_(other: TYPE_OF_AGENT): BOOLEAN is
      do
	 if base.is_a(other.base) then
	    if other.open.is_a(open) then
	       if other.res /= Void then
		  Result := res.is_a(other.res)
	       else
		  Result := true
	       end
	    end
	 end
      end

invariant

   res /= Void

end -- TYPE_FUNCTION
