--          This file is part of SmartEiffel The GNU Eiffel Compiler.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
-- SmartEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmartEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmartEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class DECLARATION_1
   --
   -- For a single declaration like :
   --             foo : BAR
   --

inherit DECLARATION

creation make

feature {NONE}

   name: LOCAL_ARGUMENT1
         -- Of the declared variable.

feature {NONE}

   make(n: like name; type: E_TYPE) is
      require
         n /= Void
      do
         name := n
         name.set_result_type(type)
      ensure
         name = n
      end

feature

   start_position: POSITION is
      do
         Result := name.start_position
      end

   pretty_print is
      do
         name.pretty_print
         pretty_printer.put_string(once ": ")
         name.result_type.pretty_print
      end

   short is
      do
         name.short
         short_print.hook_or("hook35",": ")
         name.result_type.short
      end

feature {DECLARATION_LIST}

   count: INTEGER is 1

feature {DECLARATION_LIST}

   append_in(dl: DECLARATION_LIST) is
      do
         dl.add_last(name)
      end

end -- DECLARATION_1
