/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HtmlUnitBrowserCompatCookieSpec;
import com.gargoylesoftware.htmlunit.HtmlUnitCookieStore;
import com.gargoylesoftware.htmlunit.HtmlUnitSSLSocketFactory;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.SocksSocketFactory;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpWebConnection
implements WebConnection {
    private static final String HACKED_COOKIE_POLICY = "mine";
    private AbstractHttpClient httpClient_;
    private final WebClient webClient_;
    private HttpContext httpContext_ = new BasicHttpContext();
    private String virtualHost_;
    private final CookieSpecFactory htmlUnitCookieSpecFactory_;
    private final WebClientOptions usedOptions_ = new WebClientOptions();
    private static final long MAX_IN_MEMORY = 512000L;

    public HttpWebConnection(WebClient webClient) {
        this.webClient_ = webClient;
        this.htmlUnitCookieSpecFactory_ = new CookieSpecFactory(){

            @Override
            public CookieSpec newInstance(HttpParams params) {
                return new HtmlUnitBrowserCompatCookieSpec(HttpWebConnection.this.webClient_.getIncorrectnessListener());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        URL url = request.getUrl();
        AbstractHttpClient httpClient = this.getHttpClient();
        HttpUriRequest httpMethod = null;
        try {
            try {
                httpMethod = this.makeHttpMethod(request);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to create URI from URL: " + url.toExternalForm() + " (reason: " + e.getMessage() + ")", e);
            }
            HttpHost hostConfiguration = HttpWebConnection.getHostConfiguration(request);
            HttpWebConnection.setProxy(httpMethod, request);
            long startTime = System.currentTimeMillis();
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = httpClient.execute(hostConfiguration, (HttpRequest)httpMethod, this.httpContext_);
            }
            catch (SSLPeerUnverifiedException s) {
                if (this.webClient_.getOptions().isUseInsecureSSL()) {
                    HtmlUnitSSLSocketFactory.setUseSSL3Only(this.getHttpClient().getParams(), true);
                    httpResponse = httpClient.execute(hostConfiguration, httpMethod);
                }
                throw s;
            }
            catch (Error e) {
                HttpWebConnection httpWebConnection = this;
                synchronized (httpWebConnection) {
                    this.httpClient_ = null;
                }
                throw e;
            }
            DownloadedContent downloadedBody = this.downloadResponseBody(httpResponse);
            long endTime = System.currentTimeMillis();
            WebResponse webResponse = this.makeWebResponse(httpResponse, request, downloadedBody, endTime - startTime);
            return webResponse;
        }
        finally {
            if (httpMethod != null) {
                this.onResponseGenerated(httpMethod);
            }
        }
    }

    protected void onResponseGenerated(HttpUriRequest httpMethod) {
    }

    private static HttpHost getHostConfiguration(WebRequest webRequest) {
        URL url = webRequest.getUrl();
        HttpHost hostConfiguration = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        return hostConfiguration;
    }

    private static void setProxy(HttpUriRequest httpUriRequest, WebRequest webRequest) {
        if (webRequest.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(webRequest.getProxyHost(), webRequest.getProxyPort());
            HttpParams httpRequestParams = httpUriRequest.getParams();
            if (webRequest.isSocksProxy()) {
                SocksSocketFactory.setSocksProxy(httpRequestParams, proxy);
            } else {
                httpRequestParams.setParameter("http.route.default-proxy", proxy);
            }
        }
    }

    private HttpUriRequest makeHttpMethod(WebRequest webRequest) throws IOException, URISyntaxException {
        Credentials requestCredentials;
        URL url = UrlUtils.encodeUrl(webRequest.getUrl(), false, webRequest.getCharset());
        String charset = webRequest.getCharset();
        URI uri = URIUtils.createURI(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), this.escapeQuery(url.getQuery()), null);
        HttpRequestBase httpMethod = HttpWebConnection.buildHttpMethod(webRequest.getHttpMethod(), uri);
        if (!(httpMethod instanceof HttpEntityEnclosingRequest)) {
            if (!webRequest.getRequestParameters().isEmpty()) {
                List<NameValuePair> pairs = webRequest.getRequestParameters();
                org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), charset);
                uri = URIUtils.createURI(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), query, null);
                httpMethod.setURI(uri);
            }
        } else {
            HttpEntityEnclosingRequest method = (HttpEntityEnclosingRequest)((Object)httpMethod);
            if (webRequest.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof HttpPost) {
                HttpPost postMethod = (HttpPost)method;
                if (webRequest.getRequestBody() == null) {
                    List<NameValuePair> pairs = webRequest.getRequestParameters();
                    org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                    String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), charset);
                    StringEntity urlEncodedEntity = new StringEntity(query, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity(urlEncodedEntity);
                } else {
                    String body = StringUtils.defaultString(webRequest.getRequestBody());
                    StringEntity urlEncodedEntity = new StringEntity(body, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity(urlEncodedEntity);
                }
            } else if (FormEncodingType.MULTIPART == webRequest.getEncodingType()) {
                Charset c = this.getCharset(charset, webRequest.getRequestParameters());
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setLaxMode();
                builder.setCharset(c);
                for (NameValuePair pair : webRequest.getRequestParameters()) {
                    if (pair instanceof KeyDataPair) {
                        this.buildFilePart((KeyDataPair)pair, builder);
                        continue;
                    }
                    builder.addTextBody(pair.getName(), pair.getValue());
                }
                method.setEntity(builder.build());
            } else {
                String body = webRequest.getRequestBody();
                if (body != null) {
                    method.setEntity(new StringEntity(body, charset));
                }
            }
        }
        if (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_HOST_FIRST)) {
            int port = webRequest.getUrl().getPort();
            StringBuilder host = new StringBuilder(webRequest.getUrl().getHost());
            if (port != 80 && port > 0) {
                host.append(':');
                host.append(Integer.toString(port));
            }
            httpMethod.setHeader(new BasicHeader("Host", host.toString()));
        }
        httpMethod.setHeader(new BasicHeader("User-Agent", this.webClient_.getBrowserVersion().getUserAgent()));
        if (this.webClient_.getOptions().isDoNotTrackEnabled()) {
            httpMethod.setHeader(new BasicHeader("DNT", "1"));
        }
        HttpWebConnection.writeRequestHeadersToHttpMethod(httpMethod, webRequest.getAdditionalHeaders());
        AbstractHttpClient httpClient = this.getHttpClient();
        this.reconfigureHttpClientIfNeeded(httpClient);
        CredentialsProvider credentialsProvider = this.webClient_.getCredentialsProvider();
        Credentials requestUrlCredentials = webRequest.getUrlCredentials();
        if (null != requestUrlCredentials && this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_AUTH_CREDENTIALS)) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestUrlCredentials);
        }
        if (null != (requestCredentials = webRequest.getCredentials())) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestCredentials);
        }
        httpClient.setCredentialsProvider(credentialsProvider);
        if (this.webClient_.getCookieManager().isCookiesEnabled()) {
            httpClient.getParams().setParameter("http.protocol.single-cookie-header", Boolean.TRUE);
            httpClient.getParams().setParameter("http.protocol.cookie-policy", HACKED_COOKIE_POLICY);
            httpClient.setCookieStore(new HtmlUnitCookieStore(this.webClient_.getCookieManager()));
        } else {
            httpClient.setCookieStore(new CookieStore(){

                @Override
                public void addCookie(Cookie cookie) {
                }

                @Override
                public void clear() {
                }

                @Override
                public boolean clearExpired(Date date) {
                    return false;
                }

                @Override
                public List<Cookie> getCookies() {
                    return Collections.emptyList();
                }
            });
        }
        return httpMethod;
    }

    private String escapeQuery(String query) {
        if (query == null) {
            return null;
        }
        return query.replace("%%", "%25%25");
    }

    private Charset getCharset(String charset, List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            KeyDataPair pairWithFile;
            if (!(pair instanceof KeyDataPair) || (pairWithFile = (KeyDataPair)pair).getData() != null || pairWithFile.getFile() == null) continue;
            String fileName = pairWithFile.getFile().getName();
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.codePointAt(i) <= 127) continue;
                return Charset.forName(charset);
            }
        }
        return null;
    }

    void buildFilePart(KeyDataPair pairWithFile, MultipartEntityBuilder builder) throws IOException {
        String mimeType = pairWithFile.getMimeType();
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ContentType contentType = ContentType.create(mimeType, pairWithFile.getCharset());
        File file = pairWithFile.getFile();
        if (pairWithFile.getData() != null) {
            String filename = file == null ? pairWithFile.getValue() : (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH) ? file.getAbsolutePath() : file.getName());
            builder.addBinaryBody(pairWithFile.getName(), new ByteArrayInputStream(pairWithFile.getData()), contentType, filename);
            return;
        }
        if (file == null) {
            builder.addPart(pairWithFile.getName(), new InputStreamBody(new ByteArrayInputStream(new byte[0]), contentType, pairWithFile.getValue()){

                @Override
                public long getContentLength() {
                    return 0L;
                }
            });
            return;
        }
        String filename = pairWithFile.getFile() == null ? pairWithFile.getValue() : (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH) ? pairWithFile.getFile().getAbsolutePath() : pairWithFile.getFile().getName());
        filename = new String(filename.getBytes(pairWithFile.getCharset()));
        builder.addBinaryBody(pairWithFile.getName(), pairWithFile.getFile(), contentType, filename);
    }

    private static HttpRequestBase buildHttpMethod(HttpMethod submitMethod, URI uri) {
        HttpRequestBase method;
        switch (submitMethod) {
            case GET: {
                method = new HttpGet(uri);
                break;
            }
            case POST: {
                method = new HttpPost(uri);
                break;
            }
            case PUT: {
                method = new HttpPut(uri);
                break;
            }
            case DELETE: {
                method = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                method = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                method = new HttpHead(uri);
                break;
            }
            case TRACE: {
                method = new HttpTrace(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Submit method not yet supported: " + (Object)((Object)submitMethod));
            }
        }
        return method;
    }

    protected synchronized AbstractHttpClient getHttpClient() {
        if (this.httpClient_ == null) {
            this.httpClient_ = this.createHttpClient();
            this.httpClient_.getCookieSpecs().register(HACKED_COOKIE_POLICY, this.htmlUnitCookieSpecFactory_);
        }
        return this.httpClient_;
    }

    protected int getTimeout() {
        return this.webClient_.getOptions().getTimeout();
    }

    protected AbstractHttpClient createHttpClient() {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpClientParams.setRedirecting(httpParams, false);
        this.configureTimeout(httpParams, this.webClient_.getOptions().getTimeout());
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, new SocksSocketFactory()));
        this.configureHttpsScheme(schemeRegistry);
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        connectionManager.setDefaultMaxPerRoute(6);
        DefaultHttpClient httpClient = new DefaultHttpClient(connectionManager, httpParams);
        httpClient.setCookieStore(new HtmlUnitCookieStore(this.webClient_.getCookieManager()));
        httpClient.setRedirectStrategy(new DefaultRedirectStrategy(){

            @Override
            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return super.isRedirected(request, response, context) && response.getFirstHeader("location") != null;
            }
        });
        if (this.getVirtualHost() != null) {
            httpClient.getParams().setParameter("http.virtual-host", this.virtualHost_);
        }
        return httpClient;
    }

    private void configureTimeout(HttpParams httpParams, int timeout) {
        httpParams.setParameter("http.socket.timeout", timeout);
        httpParams.setParameter("http.connection.timeout", timeout);
        this.usedOptions_.setTimeout(timeout);
    }

    private void reconfigureHttpClientIfNeeded(AbstractHttpClient httpClient) {
        WebClientOptions options = this.webClient_.getOptions();
        if (options.isUseInsecureSSL() != this.usedOptions_.isUseInsecureSSL() || options.getSSLClientCertificateUrl() != this.usedOptions_.getSSLClientCertificateUrl()) {
            this.configureHttpsScheme(httpClient.getConnectionManager().getSchemeRegistry());
        }
        if (options.getTimeout() != this.usedOptions_.getTimeout()) {
            this.configureTimeout(httpClient.getParams(), options.getTimeout());
        }
    }

    private void configureHttpsScheme(SchemeRegistry schemeRegistry) {
        WebClientOptions options = this.webClient_.getOptions();
        SSLSocketFactory socketFactory = HtmlUnitSSLSocketFactory.buildSSLSocketFactory(options);
        schemeRegistry.register(new Scheme("https", 443, socketFactory));
        this.usedOptions_.setUseInsecureSSL(options.isUseInsecureSSL());
        this.usedOptions_.setSSLClientCertificate(options.getSSLClientCertificateUrl(), options.getSSLClientCertificatePassword(), options.getSSLClientCertificateType());
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
        if (this.virtualHost_ != null) {
            this.getHttpClient().getParams().setParameter("http.virtual-host", this.virtualHost_);
        }
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    private WebResponse makeWebResponse(HttpResponse httpResponse, WebRequest request, DownloadedContent responseBody, long loadTime) {
        String statusMessage = httpResponse.getStatusLine().getReasonPhrase();
        if (statusMessage == null) {
            statusMessage = "Unknown status message";
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (Header header : httpResponse.getAllHeaders()) {
            headers.add(new NameValuePair(header.getName(), header.getValue()));
        }
        WebResponseData responseData = new WebResponseData(responseBody, statusCode, statusMessage, headers);
        return this.newWebResponseInstance(responseData, loadTime, request);
    }

    protected DownloadedContent downloadResponseBody(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        return HttpWebConnection.downloadContent(httpEntity.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadedContent downloadContent(InputStream is) throws IOException {
        if (is == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int nbRead;
            while ((nbRead = is.read(buffer)) != -1) {
                bos.write(buffer, 0, nbRead);
                if ((long)bos.size() <= 512000L) continue;
                File file = File.createTempFile("htmlunit", ".tmp");
                file.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(file);
                bos.writeTo(fos);
                IOUtils.copyLarge(is, fos);
                fos.close();
                DownloadedContent.OnFile onFile = new DownloadedContent.OnFile(file, true);
                return onFile;
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return new DownloadedContent.InMemory(bos.toByteArray());
    }

    protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
        return new WebResponse(responseData, request, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRequestHeadersToHttpMethod(HttpUriRequest httpMethod, Map<String, String> requestHeaders) {
        Map<String, String> map = requestHeaders;
        synchronized (map) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized void shutdown() {
        if (this.httpClient_ != null) {
            this.httpClient_.getConnectionManager().shutdown();
            this.httpClient_ = null;
        }
    }
}

