/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import java.util.Map;

public class HtmlTextInput
extends HtmlInput
implements SelectableTextInput {
    private final SelectionDelegate selectionDelegate_ = new SelectionDelegate(this);
    private final DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(){

        @Override
        void typeDone(String newValue, int newCursorPosition) {
            if (newValue.length() > HtmlTextInput.this.getMaxLength()) {
                return;
            }
            HtmlTextInput.this.setAttribute("value", newValue);
            HtmlTextInput.this.setSelectionStart(newCursorPosition);
            HtmlTextInput.this.setSelectionEnd(newCursorPosition);
        }
    };

    HtmlTextInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), this.getSelectionStart(), this.getSelectionEnd(), c, shiftKey, ctrlKey, altKey);
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public String getText() {
        return this.getValueAttribute();
    }

    @Override
    public void setText(String text) {
        this.setValueAttribute(text);
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        Page page;
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        if ("value".equals(qualifiedName) && (page = this.getPage()) != null && ((SgmlPage)page).isHtmlPage()) {
            this.setSelectionStart(attributeValue.length());
            this.setSelectionEnd(attributeValue.length());
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new HtmlTextInput(this.getNamespaceURI(), this.getQualifiedName(), (SgmlPage)this.getPage(), this.getAttributesMap());
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.hasFeature(BrowserVersionFeatures.HTMLINPUT_SET_DEFAULT_VALUE_UPDATES_VALUE);
        modifyValue = modifyValue && this.getValueAttribute().equals(this.getDefaultValue());
        this.setDefaultValue(defaultValue, modifyValue);
    }
}

