/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner;

import com.opera.core.systems.OperaBinary;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.arguments.OperaArgument;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.File;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;

public abstract class AbstractOperaRunner
implements OperaRunner {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final OperaSettings settings;

    public AbstractOperaRunner() {
        this(new OperaSettings());
    }

    public AbstractOperaRunner(OperaSettings s) {
        this.settings = s;
        if (this.settings.getBinary() == null) {
            File binary = OperaBinary.find(this.settings.getProduct());
            if (binary == null) {
                throw new OperaRunnerException(String.format("Unable to find executable for product %s", new Object[]{this.settings.getProduct()}));
            }
            this.settings.setBinary(binary);
        }
        if (this.settings.supportsPd()) {
            this.settings.arguments().add("-pd", this.settings.profile().getDirectory().getAbsolutePath());
        }
        if (this.settings.supportsDebugProxy()) {
            this.settings.arguments().add("debugproxy", this.settings.getHost() + ":" + this.settings.getPort());
        }
        this.settings.arguments().add("autotestmode");
        if (this.settings.getProduct().is(OperaProduct.DESKTOP) && Platform.getCurrent().is(Platform.MAC)) {
            OperaArgument fullscreen = new OperaArgument("fullscreen");
            this.settings.arguments().remove(fullscreen);
            this.settings.arguments().add(fullscreen);
        }
        this.logger.config("Opera arguments: " + this.settings.arguments().getArgumentsAsStringList());
    }

    public OperaSettings getSettings() {
        return this.settings;
    }

    protected void sleep(OperaIntervals interval) {
        try {
            Thread.sleep(interval.getMs());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

