/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum ScopeMessage implements Message
{
    CONNECT(3),
    DISCONNECT(4),
    ENABLE(5),
    DISABLE(6),
    INFO(7),
    QUIT(8),
    HOST_INFO(10),
    MESSAGE_INFO(11),
    DEFAULT(-1);

    private static final Map<Integer, ScopeMessage> lookup;
    private final int code;

    private ScopeMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "scope";
    }

    public static ScopeMessage get(int code) {
        ScopeMessage message = lookup.get(code);
        return message != null ? message : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex(ImmutableList.copyOf(ScopeMessage.values()), new Function<ScopeMessage, Integer>(){

            @Override
            public Integer apply(ScopeMessage message) {
                return message.getID();
            }
        });
    }
}

