/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.resolver.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Logger;
import mx4j.tools.remote.http.HTTPResolver;
import mx4j.tools.remote.soap.SOAPClientInvoker;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AdminClient;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.utils.Options;

public class Resolver
extends HTTPResolver {
    private static final String SERVER_DEPLOY_WSDD = "server-deploy.wsdd";
    private static final String SERVER_UNDEPLOY_WSDD = "server-undeploy.wsdd";
    private static final String CLIENT_WSDD = "client.wsdd";
    private static final String AXIS_DEPLOY_SERVICE = "AdminService";
    static /* synthetic */ Class class$org$apache$axis$transport$http$AxisServlet;

    public Object lookupClient(JMXServiceURL address, Map environment) throws IOException {
        String endpoint = this.getEndpoint(address, environment);
        InputStream wsdd = this.getClass().getResourceAsStream(CLIENT_WSDD);
        if (wsdd == null) {
            throw new IOException("Could not find AXIS deployment descriptor");
        }
        Service service = new Service((EngineConfiguration)new FileProvider(wsdd));
        service.setMaintainSession(true);
        return new SOAPClientInvoker(endpoint, service);
    }

    protected String getServletClassName() {
        return (class$org$apache$axis$transport$http$AxisServlet == null ? (class$org$apache$axis$transport$http$AxisServlet = Resolver.class$("org.apache.axis.transport.http.AxisServlet")) : class$org$apache$axis$transport$http$AxisServlet).getName();
    }

    protected void deploy(JMXServiceURL address, Map environment) throws IOException {
        String path = address.getURLPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String deployPath = path + AXIS_DEPLOY_SERVICE;
        JMXServiceURL temp = new JMXServiceURL(address.getProtocol(), address.getHost(), address.getPort(), deployPath);
        String deployEndpoint = this.getEndpoint(temp, environment);
        try {
            AdminClient deployer = new AdminClient();
            Options options = new Options(null);
            options.setDefaultURL(deployEndpoint);
            InputStream wsdd = this.getClass().getResourceAsStream(SERVER_DEPLOY_WSDD);
            if (wsdd == null) {
                throw new IOException("Could not find AXIS deployment descriptor");
            }
            deployer.process(options, wsdd);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            Logger logger = Resolver.getLogger();
            if (logger.isEnabledFor(20)) {
                logger.info("Exception while deploying AXIS service", x);
            }
            throw new IOException("Could not deploy connector server to AXIS " + x.toString());
        }
    }

    protected void undeploy(JMXServiceURL address, Map environment) throws IOException {
        String path = address.getURLPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String undeployPath = path + AXIS_DEPLOY_SERVICE;
        JMXServiceURL temp = new JMXServiceURL(address.getProtocol(), address.getHost(), address.getPort(), undeployPath);
        String undeployEndpoint = this.getEndpoint(temp, environment);
        try {
            AdminClient deployer = new AdminClient();
            Options options = new Options(null);
            options.setDefaultURL(undeployEndpoint);
            InputStream wsdd = this.getClass().getResourceAsStream(SERVER_UNDEPLOY_WSDD);
            if (wsdd == null) {
                throw new IOException("Could not find AXIS deployment descriptor server-undeploy.wsdd");
            }
            deployer.process(options, wsdd);
        }
        catch (Exception x) {
            Logger logger = Resolver.getLogger();
            if (logger.isEnabledFor(20)) {
                logger.info("Exception while undeploying AXIS service", x);
            }
            throw new IOException("Could not undeploy connector server " + x.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

