/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.grid.common.exception.GridConfigurationException;

public class CommandLineOptionHelper {
    private String[] args;

    private CommandLineOptionHelper() {
    }

    public CommandLineOptionHelper(String[] args) {
        this.args = args;
    }

    public boolean isParamPresent(String name) {
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (name.equalsIgnoreCase(arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getParamValue(String name) {
        int index = -1;
        int i = 0;
        while (i < this.args.length) {
            if (name.equals(this.args[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            throw new GridConfigurationException("The parameter " + name + " isn't specified.");
        }
        if (this.args.length == index) {
            throw new GridConfigurationException("The parameter " + name + " doesn't have a value specified.");
        }
        if (index + 1 < this.args.length && !this.args[index + 1].startsWith("-")) {
            return this.args[index + 1];
        }
        return "";
    }

    public List<String> getParamValues(String name) {
        if (this.isParamPresent(name)) {
            String value = this.getParamValue(name);
            return Arrays.asList(value.split(","));
        }
        return new ArrayList<String>();
    }

    public List<String> getAll(String name) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < this.args.length) {
            if (name.equals(this.args[i])) {
                res.add(this.args[i + 1]);
            }
            ++i;
        }
        return res;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-")) {
                keys.add(arg);
            }
            ++n2;
        }
        return keys;
    }
}

