/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.TimeZone;
import org.openqa.jetty.log.Frame;
import org.openqa.jetty.log.LogImpl;
import org.openqa.jetty.log.LogSink;
import org.openqa.jetty.log.LogStream;
import org.openqa.jetty.util.ByteArrayISO8859Writer;
import org.openqa.jetty.util.DateCache;
import org.openqa.jetty.util.MultiException;
import org.openqa.jetty.util.RolloverFileOutputStream;
import org.openqa.jetty.util.StringBufferWriter;
import org.openqa.jetty.util.StringUtil;

public class OutputStreamLogSink
implements LogSink {
    private static final String __lineSeparator = System.getProperty("line.separator");
    private int _retainDays = 31;
    protected DateCache _dateFormat = new DateCache("HH:mm:ss.SSS");
    protected String _logTimezone;
    protected boolean _logTimeStamps = true;
    protected boolean _logLabels = true;
    protected boolean _logTags = true;
    protected boolean _logStackSize = true;
    protected boolean _logStackTrace = false;
    protected boolean _logOneLine = false;
    protected boolean _suppressStack = false;
    private String _filename;
    private boolean _append = true;
    protected boolean _flushOn = true;
    protected int _bufferSize = 2048;
    protected boolean _reopen = false;
    protected transient LogImpl _logImpl = null;
    protected transient boolean _started;
    protected transient OutputStream _out;
    protected transient ByteArrayISO8859Writer _buffer;
    private static final Class[] __noArgs = new Class[0];
    private static final String[] __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
    private static StringBufferWriter __stringBufferWriter = new StringBufferWriter();
    private static PrintWriter __printWriter = new PrintWriter(__stringBufferWriter);

    public OutputStreamLogSink() throws IOException {
        this._filename = System.getProperty("LOG_FILE");
        if (this._filename == null) {
            this._out = LogStream.STDERR_STREAM;
        }
    }

    public OutputStreamLogSink(String filename) {
        this._filename = filename;
    }

    public String getLogDateFormat() {
        return this._dateFormat.getFormatString();
    }

    public void setLogDateFormat(String logDateFormat) {
        this._dateFormat = new DateCache(logDateFormat);
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimezone() {
        return this._logTimezone;
    }

    public void setLogTimezone(String logTimezone) {
        this._logTimezone = logTimezone;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimeZone() {
        return this._logTimezone;
    }

    public void setLogTimeZone(String logTimezone) {
        this._logTimezone = logTimezone;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public boolean isLogTimeStamps() {
        return this._logTimeStamps;
    }

    public void setLogTimeStamps(boolean logTimeStamps) {
        this._logTimeStamps = logTimeStamps;
    }

    public boolean isLogLabels() {
        return this._logLabels;
    }

    public void setLogLabels(boolean logLabels) {
        this._logLabels = logLabels;
    }

    public boolean isLogTags() {
        return this._logTags;
    }

    public void setLogTags(boolean logTags) {
        this._logTags = logTags;
    }

    public boolean isLogStackSize() {
        return this._logStackSize;
    }

    public void setLogStackSize(boolean logStackSize) {
        this._logStackSize = logStackSize;
    }

    public boolean isLogStackTrace() {
        return this._logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this._logStackTrace = logStackTrace;
    }

    public boolean isLogOneLine() {
        return this._logOneLine;
    }

    public void setLogOneLine(boolean logOneLine) {
        this._logOneLine = logOneLine;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean a) {
        this._append = a;
    }

    public boolean isSuppressStack() {
        return this._suppressStack;
    }

    public void setSuppressStack(boolean suppressStack) {
        this._suppressStack = suppressStack;
    }

    public synchronized void setOutputStream(OutputStream out) {
        this._reopen = this.isStarted() && this._out != out;
        this._filename = null;
        if (this._buffer != null) {
            this._buffer.resetWriter();
        }
        this._out = out;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public synchronized void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        if (this.isStarted() && this._filename != null && filename == null) {
            this._out = null;
        }
        this._reopen = this.isStarted() && (this._filename == null && filename != null || this._filename != null && !this._filename.equals(filename));
        this._filename = filename;
        if (!this.isStarted() && this._filename != null) {
            this._out = null;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._filename == null) {
            return null;
        }
        if (this._out == null || !(this._out instanceof RolloverFileOutputStream)) {
            return null;
        }
        return ((RolloverFileOutputStream)this._out).getDatedFilename();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int retainDays) {
        this._reopen = this.isStarted() && this._retainDays != retainDays;
        this._retainDays = retainDays;
    }

    public void setFlushOn(boolean on) {
        this._flushOn = on;
        if (on && this._out != null) {
            try {
                this._out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getFlushOn() {
        return this._flushOn;
    }

    @Override
    public synchronized void log(String tag, Object o, Frame frame, long time) {
        StringBuffer buf = new StringBuffer(160);
        if (this._logTimeStamps) {
            buf.append(this._dateFormat.format(time));
            buf.append(' ');
        }
        if (this._logTags) {
            buf.append(tag);
        }
        if (this._logLabels && frame != null) {
            buf.append(frame.toString());
        }
        if (this._logStackSize && frame != null) {
            buf.append(" >");
            if (frame.getDepth() < 10) {
                buf.append('0');
            }
            buf.append(Integer.toString(frame.getDepth()));
            buf.append("> ");
        }
        String nl = __lineSeparator;
        if (this._logLabels && !this._logOneLine && this._buffer.size() > 0) {
            buf.append(nl);
        }
        this.formatObject(buf, o);
        if (this._logStackTrace && frame != null) {
            buf.append(nl);
            buf.append(frame.getStack());
        }
        this.log(buf.toString());
    }

    @Override
    public synchronized void log(String formattedLog) {
        if (this._reopen || this._out == null) {
            this.stop();
            this.start();
        }
        try {
            this._buffer.write(formattedLog);
            this._buffer.write(StringUtil.__LINE_SEPARATOR);
            if (this._flushOn || this._buffer.size() > this._bufferSize) {
                this._buffer.writeTo(this._out);
                this._buffer.resetWriter();
                this._out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void start() {
        this._buffer = new ByteArrayISO8859Writer(this._bufferSize);
        this._reopen = false;
        if (this._started) {
            return;
        }
        if (this._out == null && this._filename != null) {
            try {
                RolloverFileOutputStream rfos = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
                this._out = rfos;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._out == null) {
            this._out = LogStream.STDERR_STREAM;
        }
        this._started = true;
    }

    @Override
    public synchronized void stop() {
        block9: {
            this._started = false;
            if (this._out != null) {
                block8: {
                    try {
                        if (this._buffer.size() > 0) {
                            this._buffer.writeTo(this._out);
                        }
                        this._out.flush();
                        this._buffer = null;
                    }
                    catch (Exception e) {
                        if (this._logImpl == null || !this._logImpl.getDebug()) break block8;
                        e.printStackTrace();
                    }
                }
                Thread.yield();
            }
            if (this._out != null && this._out != LogStream.STDERR_STREAM) {
                try {
                    this._out.close();
                }
                catch (Exception e) {
                    if (this._logImpl == null || !this._logImpl.getDebug()) break block9;
                    e.printStackTrace();
                }
            }
        }
        if (this._filename != null) {
            this._out = null;
        }
    }

    @Override
    public boolean isStarted() {
        return this._started;
    }

    @Override
    public void setLogImpl(LogImpl impl) {
        this._logImpl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void formatObject(StringBuffer buf, Object o) {
        int i2;
        int init_size = buf.length();
        if (o == null) {
            buf.append("null");
        } else if (o.getClass().isArray()) {
            int l = Array.getLength(o);
            i2 = 0;
            while (i2 < l) {
                this.formatObject(buf, Array.get(o, i2));
                ++i2;
            }
        } else if (o instanceof Throwable) {
            Throwable ex = (Throwable)o;
            buf.append('\n');
            if (this._suppressStack) {
                buf.append(ex.toString());
                buf.append("\nNo stack available\n--");
            } else {
                PrintWriter i2 = __printWriter;
                synchronized (i2) {
                    __stringBufferWriter.setStringBuffer(buf);
                    OutputStreamLogSink.expandThrowable(ex);
                    __printWriter.flush();
                }
            }
        } else {
            buf.append(o.toString());
        }
        int end_size = buf.length();
        if (this._logOneLine) {
            i2 = init_size;
            while (i2 < end_size) {
                char c = buf.charAt(i2);
                if (c == '\n') {
                    buf.setCharAt(i2, '|');
                } else if (c == '\r') {
                    buf.setCharAt(i2, '<');
                }
                ++i2;
            }
        }
    }

    private static void expandThrowable(Throwable ex) {
        ex.printStackTrace(__printWriter);
        if (ex instanceof MultiException) {
            MultiException mx = (MultiException)ex;
            int i = 0;
            while (i < mx.size()) {
                __printWriter.print("[" + i + "]=");
                Exception ex2 = mx.getException(i);
                OutputStreamLogSink.expandThrowable(ex2);
                ++i;
            }
        } else {
            int i = 0;
            while (i < __nestedEx.length) {
                try {
                    Method getTargetException = ex.getClass().getMethod(__nestedEx[i], __noArgs);
                    Throwable ex2 = (Throwable)getTargetException.invoke((Object)ex, null);
                    if (ex2 != null) {
                        __printWriter.println(String.valueOf(__nestedEx[i]) + "():");
                        OutputStreamLogSink.expandThrowable(ex2);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
    }
}

