/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.thoughtworks.selenium.SeleniumException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.seleniumemulation.GetEval;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

public class OpenWindow
extends SeleneseCommand<Void> {
    private final URL baseUrl;
    private final GetEval opener;

    public OpenWindow(String baseUrl, GetEval opener) {
        try {
            this.baseUrl = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new SeleniumException(e.getMessage(), e);
        }
        this.opener = opener;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String url, String windowID) {
        try {
            String urlToOpen = url.indexOf("://") == -1 ? new URL(this.baseUrl, url).toString() : url;
            String[] args = new String[]{String.format("window.open('%s', '%s'); null;", urlToOpen, windowID)};
            this.opener.apply(driver, args);
        }
        catch (MalformedURLException e) {
            throw new SeleniumException(e.getMessage(), e);
        }
        return null;
    }
}

