/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class NewSession
implements RestishHandler,
JsonParametersAware {
    private volatile DriverSessions allSessions;
    private volatile Capabilities desiredCapabilities;
    private volatile SessionId sessionId;
    private final Response response;

    public NewSession(DriverSessions allSession) {
        this.allSessions = allSession;
        this.response = new Response();
    }

    public Capabilities getCapabilities() {
        return this.desiredCapabilities;
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.desiredCapabilities = new DesiredCapabilities((Map)allParameters.get("desiredCapabilities"));
    }

    @Override
    public ResultType handle() throws Exception {
        this.sessionId = this.allSessions.newSession(this.desiredCapabilities != null ? this.desiredCapabilities : new DesiredCapabilities());
        HashMap<String, ?> capabilities = Maps.newHashMap(this.allSessions.get(this.sessionId).getCapabilities().asMap());
        capabilities.put("webdriver.remote.sessionid", this.sessionId.toString());
        this.response.setSessionId(this.sessionId.toString());
        this.response.setValue(capabilities);
        if (this.desiredCapabilities != null) {
            LoggingManager.perSessionLogHandler().configureLogging((LoggingPreferences)this.desiredCapabilities.getCapability("loggingPrefs"));
        }
        LoggingManager.perSessionLogHandler().attachToCurrentThread(this.sessionId);
        return ResultType.SUCCESS;
    }

    public String getSessionId() {
        return this.sessionId.toString();
    }

    public String toString() {
        HashMap<String, String> capabilities = Maps.newHashMap();
        if (this.desiredCapabilities != null) {
            for (Map.Entry<String, ?> entry : this.desiredCapabilities.asMap().entrySet()) {
                String value = String.valueOf(entry.getValue());
                if (value.length() > 32) {
                    value = String.valueOf(value.substring(0, 29)) + "...";
                }
                capabilities.put(entry.getKey(), value);
            }
        }
        return String.format("[new session: %s]", capabilities);
    }
}

