/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Preconditions;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;

class WebSocketConnection {
    private final Channel channel;

    public WebSocketConnection(Channel channel) {
        this.channel = channel;
    }

    private void checkChannel() {
        Preconditions.checkState(this.channel.isOpen() && this.channel.isConnected(), "The WebSocket connection has been closed");
    }

    public void send(String data) {
        this.checkChannel();
        TextWebSocketFrame frame = new TextWebSocketFrame(data);
        this.channel.write(frame);
    }

    public void close() {
        this.channel.close().addListener(ChannelFutureListener.CLOSE);
    }
}

