Summary: Personality setter
Name: setarch
Version: 2.0
Release: 1
Source0: %{name}-%{version}.tar.gz
License: GPL
Group: System Environment/Kernel
BuildRoot: %{_tmppath}/%{name}-root
%ifarch sparc sparc64
Obsoletes: sparc32
%endif

%description
This utility tells the kernel to report a different architecture than the 
current one, then runs a program in that environment. It can also set various
personality flags.

%prep
%setup -q

%build
%{__cc} -o setarch setarch.c $RPM_OPT_FLAGS -Wall

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir} $RPM_BUILD_ROOT%{_mandir}/man8
install -m444 setarch.8 $RPM_BUILD_ROOT%{_mandir}/man8
install -m555 setarch $RPM_BUILD_ROOT%{_bindir}

LINKS="linux32 linux64"
%ifarch s390 s390x
LINKS="$LINKS s390 s390x"
%endif
%ifarch x86_64 i386
LINKS="$LINKS i386 x86_64"
%endif
%ifarch ppc ppc64
LINKS="$LINKS ppc ppc64 ppc32"
%endif
%ifarch sparc sparc64
LINKS="$LINKS sparc sparc64 sparc32"
%endif
%ifarch mips mips64
LINKS="$LINKS mips mips64 mips32"
%endif
%ifarch ia64
LINKS="$LINKS i386 ia64"
%endif
for I in $LINKS; do 
	ln $RPM_BUILD_ROOT%{_bindir}/setarch $RPM_BUILD_ROOT%{_bindir}/$I
	echo ".so setarch.8" > $RPM_BUILD_ROOT%{_mandir}/man8/$I.8
done

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/*
%{_mandir}/man8/*.8*

%changelog
* Thu Apr  7 2006 Jindrich Novy <jnovy@redhat.com> 2.0-1
- better error handling, thanks to Dmitry V. Levin (#187322)
- understand --help

* Tue Feb 21 2006 Jindrich Novy <jnovy@redhat.com> 1.9-1
- applied some features proposed by Mike Frysinger (#182219)
- add mips arch support, add sparc32
- Obsoletes sparc32
- add '-h' option to display more comprehensive help
- add linux64 helper

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1.8-1.2.1
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 1.8-1.2
- rebuilt for new gcc4.1 snapshot and glibc changes

* Fri Dec 09 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt

* Thu Jun 30 2005 Jindrich Novy <jnovy@redhat.com> 1.8-1
- fix possible segfault when parsing unknown arguments (#161975)
- print wanings when unknown arguments are passed
- add FDPIC_FUNCPTRS personality

* Mon May  9 2005 Bill Nottingham <notting@redhat.com> 1.7-3
- don't strip binary, fixes debuginfo generation

* Mon Mar 07 2005 Jindrich Novy <jnovy@redhat.com> 1.7-2
- rebuilt with gcc4

* Fri Feb 04 2005 Jindrich Novy <jnovy@redhat.com> 1.7-1
- Add '-R' option for ADDR_NO_RANDOMIZE
  (patch from Arjan van de Ven)
- Minor code cleanup

* Wed Nov 03 2004 Elliot Lee <sopwith@redhat.com> 1.6-1
- More properly interpret the return value of SYS_personality

* Tue Oct 12 2004 Jindrich Novy <jnovy@redhat.com> 1.5-1
- Add various personality options #130511
- Update man page

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Feb 24 2004 Elliot Lee <sopwith@redhat.com> 1.4-1
- Fix man page - #115552

* Wed Jan 14 2004 Elliot Lee <sopwith@redhat.com> 1.3-2
- Rebuild

* Tue Sep 02 2003 Elliot Lee <sopwith@redhat.com> 1.3-1
- Add linux32 alias

* Tue Aug 26 2003 Elliot Lee <sopwith@redhat.com> 1.2-1
- Fix -3 option

* Wed Aug 13 2003 Elliot Lee <sopwith@redhat.com> 1.1-1
- Add -3 option

* Wed Jun 11 2003 Elliot Lee <sopwith@redhat.com>
- Initial build.
