% Generated by roxygen2 (4.0.2): do not edit by hand
\name{accounts}
\alias{accountInfo}
\alias{accounts}
\alias{removeAccount}
\alias{setAccountInfo}
\title{Account Management Functions}
\usage{
accounts()

setAccountInfo(name, token, secret)

accountInfo(name)

removeAccount(name)
}
\arguments{
\item{name}{Name of ShinyApps account to save or remove}

\item{token}{User token for the account}

\item{secret}{User secret for the account}
}
\value{
\code{accounts} returns a character vector with the names of all accounts
registered on the system. \code{accountInfo} returns a list with account
details.
}
\description{
Functions to add, enumerate, and remove ShinyApps accounts on the local
system. Prior to deploying applications you need to register
your ShinyApps account on the local system.
}
\details{
You register an account using the \code{setAccountInfo} function. You can
subsequently remove the account using the \code{removeAccount} function.

The \code{accounts} and \code{accountInfo} functions are provided for viewing
previously registered accounts.
}
\examples{
\dontrun{

# register an account
setAccountInfo("user", "token", "secret")

# remove the same account
removeAccount("user")
}
}

