% Generated by roxygen2 (4.0.2): do not edit by hand
\name{appDependencies}
\alias{appDependencies}
\title{Detect Application Dependencies}
\usage{
appDependencies(appDir = getwd())
}
\arguments{
\item{appDir}{Directory containing application. Defaults to current working
directory.}
}
\value{
Returns a data frame listing the package
  dependencies detected for the application: \tabular{ll}{ \code{package}
  \tab Name of package \cr \code{version} \tab Version of package\cr }
}
\description{
Recursively detect all package dependencies for an application. This function
parses all .R files in the applicaition directory to determine what packages
the application depends on; and for each of those packages what other
packages they depend on.
}
\details{
Dependencies are determined by parsing application source code and
  looking for calls to \code{library}, \code{require}, \code{::}, and
  \code{:::}.

  Recursive dependencies are detected by examining the \code{Depends},
  \code{Imports}, and \code{LinkingTo} fields of the packages immediately
  dependend on by the application.
}
\note{
Since the \code{Suggests} field is not included when determining
  recursive dependencies of packages, it's possible that not every package
  required to run your application will be detected.

  In this case, you can force a package to be included dependency by
  inserting call(s) to \code{require} within your source directory. This code
  need not actually execute, for example you could create a standalone file
  named \code{dependencies.R} with the following code: \cr \cr
  \code{require(xts)} \cr \code{require(colorspace)} \cr

  This will force the \code{xts} and \code{colorspace} packages to be
  installed along with the rest of your application when it is deployed.
}
\examples{
\dontrun{

# dependencies for the app in the current working dir
appDependencies()

# dependencies for an app in another directory
appDependencies("~/projects/shiny/app1")
}
}
\seealso{
\link[shinyapps:shinyappsPackages]{Using Packages with ShinyApps}
}

