/* $XFree86: xc/programs/Xserver/hw/xfree86/drivers/sis/init.h,v 1.4 2000/12/02 01:16:17 dawes Exp $ */
/*
 * Prototypes for init.c
 *
 * Copyright 2002, 2003 by Thomas Winischhofer, Vienna, Austria
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holder not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holder makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: 	Thomas Winischhofer <thomas@winischhofer.net>
 */
 
#ifndef _INIT_
#define _INIT_

#include "osdef.h"

#include "initdef.h"
#include "vgatypes.h"
#include "vstruct.h"

#ifdef LINUX_XF86
#include "xf86.h"
#include "xf86Pci.h"
#include "xf86PciInfo.h"
#include "xf86_OSproc.h"
#include "sis.h"
#include "sis_regs.h"
#endif

#ifdef LINUX_KERNEL
#ifdef SIS_CP
#undef SIS_CP
#endif
#include <linux/config.h>
#include <linux/version.h>
#include <linux/types.h>
#include <asm/io.h>
#include <linux/fb.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
#include <linux/sisfb.h>
#else
#include <video/sisfb.h>
#endif
#endif

const USHORT SiS_DRAMType[17][5]={
	{0x0C,0x0A,0x02,0x40,0x39},
	{0x0D,0x0A,0x01,0x40,0x48},
	{0x0C,0x09,0x02,0x20,0x35},
	{0x0D,0x09,0x01,0x20,0x44},
	{0x0C,0x08,0x02,0x10,0x31},
	{0x0D,0x08,0x01,0x10,0x40},
	{0x0C,0x0A,0x01,0x20,0x34},
	{0x0C,0x09,0x01,0x08,0x32},
	{0x0B,0x08,0x02,0x08,0x21},
	{0x0C,0x08,0x01,0x08,0x30},
	{0x0A,0x08,0x02,0x04,0x11},
	{0x0B,0x0A,0x01,0x10,0x28},
	{0x09,0x08,0x02,0x02,0x01},
	{0x0B,0x09,0x01,0x08,0x24},
	{0x0B,0x08,0x01,0x04,0x20},
	{0x0A,0x08,0x01,0x02,0x10},
	{0x09,0x08,0x01,0x01,0x00}
};

const USHORT SiS_SDRDRAM_TYPE[13][5] =
{
	{ 2,12, 9,64,0x35},
	{ 1,13, 9,64,0x44},
	{ 2,12, 8,32,0x31},
	{ 2,11, 9,32,0x25},
	{ 1,12, 9,32,0x34},
	{ 1,13, 8,32,0x40},
	{ 2,11, 8,16,0x21},
	{ 1,12, 8,16,0x30},
	{ 1,11, 9,16,0x24},
	{ 1,11, 8, 8,0x20},
	{ 2, 9, 8, 4,0x01},
	{ 1,10, 8, 4,0x10},
	{ 1, 9, 8, 2,0x00}
};

const USHORT SiS_DDRDRAM_TYPE[4][5] =
{
	{ 2,12, 9,64,0x35},
	{ 2,12, 8,32,0x31},
	{ 2,11, 8,16,0x21},
	{ 2, 9, 8, 4,0x01}
};

const USHORT SiS_MDA_DAC[] =
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
        0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F
};

const USHORT SiS_CGA_DAC[] =
{
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F
};

const USHORT SiS_EGA_DAC[] =
{
        0x00,0x10,0x04,0x14,0x01,0x11,0x05,0x15,
        0x20,0x30,0x24,0x34,0x21,0x31,0x25,0x35,
        0x08,0x18,0x0C,0x1C,0x09,0x19,0x0D,0x1D,
        0x28,0x38,0x2C,0x3C,0x29,0x39,0x2D,0x3D,
        0x02,0x12,0x06,0x16,0x03,0x13,0x07,0x17,
        0x22,0x32,0x26,0x36,0x23,0x33,0x27,0x37,
        0x0A,0x1A,0x0E,0x1E,0x0B,0x1B,0x0F,0x1F,
        0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F
};

const USHORT SiS_VGA_DAC[] =
{
	0x00,0x10,0x04,0x14,0x01,0x11,0x09,0x15,
	0x2A,0x3A,0x2E,0x3E,0x2B,0x3B,0x2F,0x3F,
	0x00,0x05,0x08,0x0B,0x0E,0x11,0x14,0x18,
	0x1C,0x20,0x24,0x28,0x2D,0x32,0x38,0x3F,
	0x00,0x10,0x1F,0x2F,0x3F,0x1F,0x27,0x2F,
	0x37,0x3F,0x2D,0x31,0x36,0x3A,0x3F,0x00,
	0x07,0x0E,0x15,0x1C,0x0E,0x11,0x15,0x18,
	0x1C,0x14,0x16,0x18,0x1A,0x1C,0x00,0x04,
	0x08,0x0C,0x10,0x08,0x0A,0x0C,0x0E,0x10,
	0x0B,0x0C,0x0D,0x0F,0x10
};

static const SiS_StResInfoStruct SiS_StResInfo[]=
{
	{ 640,400},
	{ 640,350},
	{ 720,400},
	{ 720,350},
	{ 640,480}
};

static const SiS_ModeResInfoStruct SiS_ModeResInfo[] =
{
	{  320, 200, 8, 8},   /* 0x00 */
	{  320, 240, 8, 8},   /* 0x01 */
	{  320, 400, 8, 8},   /* 0x02 */
	{  400, 300, 8, 8},   /* 0x03 */
	{  512, 384, 8, 8},   /* 0x04 */
	{  640, 400, 8,16},   /* 0x05 */
	{  640, 480, 8,16},   /* 0x06 */
	{  800, 600, 8,16},   /* 0x07 */
	{ 1024, 768, 8,16},   /* 0x08 */
	{ 1280,1024, 8,16},   /* 0x09 */
	{ 1600,1200, 8,16},   /* 0x0a */
	{ 1920,1440, 8,16},   /* 0x0b */
	{ 2048,1536, 8,16},   /* 0x0c */
	{  720, 480, 8,16},   /* 0x0d */
	{  720, 576, 8,16},   /* 0x0e */
	{ 1280, 960, 8,16},   /* 0x0f */
	{  800, 480, 8,16},   /* 0x10 */
	{ 1024, 576, 8,16},   /* 0x11 */
	{ 1280, 720, 8,16},   /* 0x12 */
	{  856, 480, 8,16},   /* 0x13 */
	{ 1280, 768, 8,16},   /* 0x14 */
	{ 1400,1050, 8,16},   /* 0x15 */
	{ 1152, 864, 8,16},   /* 0x16 */
	{  848, 480, 8,16},   /* 0x17 */
	{ 1360, 768, 8,16},   /* 0x18 */
	{ 1024, 600, 8,16},   /* 0x19 */
	{ 1152, 768, 8,16},   /* 0x1a */
	{  768, 576, 8,16}    /* 0x1b */
};

#if 0
typedef struct _SiS_StandTableStruct
{
	UCHAR CRT_COLS;
	UCHAR ROWS;
	UCHAR CHAR_HEIGHT;
	USHORT CRT_LEN;
	UCHAR SR[4];
	UCHAR MISC;
	UCHAR CRTC[0x19];
	UCHAR ATTR[0x14];
	UCHAR GRC[9];
} SiS310_StandTableStruct;
#endif

static SiS_StandTableStruct SiS_StandTable[]=
{
/* 0x00: MD_0_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x01: MD_1_200 */
 {
  0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x02: MD_2_200 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x03: MD_3_200 - mode 0x03 - 0 */
 {
  0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x04: MD_4 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,   /* 0x2c is 2b for 300 */
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* 0x05: MD_5 */
 {
  0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,   /* 0x2c is 2b for 300 */
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff}
 },
/* 0x06: MD_6 */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x01,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,   /* 55,81 is 54,80 for 300 */
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xc2,
   0xff},
  {0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x01,0x00,0x01,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0x00,
   0xff}
 },
/* 0x07: MD_7 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x00,0x03,0x00,0x03},
  0xa6,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0d,0x63,0xba,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* 0x08: MDA_DAC */
 {
  0x00,0x00,0x00,0x0000,
  {0x00,0x00,0x00,0x15},
  0x15,
  {0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x00,0x00,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15},
  {0x15,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f}
 },
/* 0x09: CGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x00},
  0x10,
  {0x04,0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x10,
   0x04},
  {0x14,0x01,0x11,0x09,0x15,0x00,0x10,0x04,
   0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,0x2e,
   0x3e,0x2b,0x3b,0x2f},
  {0x3f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* 0x0a: EGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x05,0x15,0x20},
  0x30,
  {0x24,0x34,0x21,0x31,0x25,0x35,0x08,0x18,
   0x0c,0x1c,0x09,0x19,0x0d,0x1d,0x28,0x38,
   0x2c,0x3c,0x29,0x39,0x2d,0x3d,0x02,0x12,
   0x06},
  {0x16,0x03,0x13,0x07,0x17,0x22,0x32,0x26,
   0x36,0x23,0x33,0x27,0x37,0x0a,0x1a,0x0e,
   0x1e,0x0b,0x1b,0x0f},
  {0x1f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f}
 },
/* 0x0b: VGA_DAC */
 {
  0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x2a},
  0x3a,
  {0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x05,
   0x08,0x0b,0x0e,0x11,0x14,0x18,0x1c,0x20,
   0x24,0x28,0x2d,0x32,0x38,0x3f,0x00,0x10,
   0x1f},
  {0x2f,0x3f,0x1f,0x27,0x2f,0x37,0x3f,0x2d,
   0x31,0x36,0x3a,0x3f,0x00,0x07,0x0e,0x15,
   0x1c,0x0e,0x11,0x15},
  {0x18,0x1c,0x14,0x16,0x18,0x1a,0x1c,0x00,
   0x04}
 },
/* 0x0c */
 {
  0x08,0x0c,0x10,0x0a08,
  {0x0c,0x0e,0x10,0x0b},
  0x0c,
  {0x0d,0x0f,0x10,0x10,0x01,0x08,0x00,0x00,
   0x00,0x00,0x01,0x00,0x02,0x02,0x01,0x00,
   0x04,0x04,0x01,0x00,0x05,0x02,0x05,0x00,
   0x06},
  {0x01,0x06,0x05,0x06,0x00,0x08,0x01,0x08,
   0x00,0x07,0x02,0x07,0x06,0x07,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* 0x0d: MD_D */
 {
  0x28,0x18,0x08,0x2000,
  {0x09,0x0f,0x00,0x06},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,     /* 2c is 2b for 300 */
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x0e: MD_E */
 {
  0x50,0x18,0x08,0x4000,
  {0x01,0x0f,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,     /* 55,81 is 54,80 for 300 */
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x0f: ExtVGATable - modes > 0x13 */
 {
  0x00,0x00,0x00,0x0000,
  {0x01,0x0f,0x00,0x0e},
  0x23,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x01,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 },
/* 0x10: ROM_SAVEPTR - totally different for 300 */
 {
  0x9f,0x3b,0x00,0x00c0,
  {0x00,0x00,0x00,0x00},
  0x00,
  {0x00,0x00,0x00,0x00,0x00,0x00,0xbb,0x3f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x1a,0x00,0xac,0x3e,0x00,0xc0,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00}
 },
/* 0x11: MD_F */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa2,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,    /* 82,84 is 83,85 on 300 */
   0xff},
  {0x00,0x08,0x00,0x00,0x18,0x18,0x00,0x00,
   0x00,0x08,0x00,0x00,0x00,0x18,0x00,0x00,
   0x0b,0x00,0x05,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,
   0xff}
 },
/* 0x12: MD_10 */
 {
  0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x82,0x84,0x5d,0x28,0x0f,0x63,0xba,0xe3,    /* 82,84 is 83,85 on 300 */
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x13: MD_0_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,    /* b1 is a0 on 300 */
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x14: MD_1_350 */
 {
  0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x15: MD_2_350 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x16: MD_3_350 - mode 0x03 - 1 */
 {
  0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x17: MD_0_1_400 */
 {
  0x28,0x18,0x10,0x0800,
  {0x08,0x03,0x00,0x02},
  0x67,
  {0x2d,0x27,0x28,0x90,0x2b,0xb1,0xbf,0x1f,    /* b1 is a0 on 300 */
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x18: MD_2_3_400 - mode 0x03 - 2 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x67,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff}
 },
/* 0x19: MD_7_400 */
 {
  0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x66,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x0f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff}
 },
/* 0x1a: MD_11 */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xc3,    /* e9,8b is ea,8c on 300 */
   0xff},
  {0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,
   0xff}
 },
/* 0x1b: ExtEGATable - Modes <= 0x02 */
 {
  0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,    /* 55,81 is 54,80 on 300 */
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xe9,0x8b,0xdf,0x28,0x00,0xe7,0x04,0xe3,    /* e9,8b is ea,8c on 300 */
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff}
 },
/* 0x1c: MD_13 */
 {
  0x28,0x18,0x08,0x2000,
  {0x01,0x0f,0x00,0x0e},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,    /* 55,81 is 54,80 on 300 */
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x40,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x41,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff}
 }
};

static const UCHAR SiS_NTSCTiming[] = {
	0x17,0x1d,0x03,0x09,0x05,0x06,0x0c,0x0c,
	0x94,0x49,0x01,0x0a,0x06,0x0d,0x04,0x0a,
	0x06,0x14,0x0d,0x04,0x0a,0x00,0x85,0x1b,
	0x0c,0x50,0x00,0x97,0x00,0xda,0x4a,0x17,
	0x7d,0x05,0x4b,0x00,0x00,0xe2,0x00,0x02,
	0x03,0x0a,0x65,0x9d,0x08,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x50,
	0x00,0x40,0x44,0x00,0xdb,0x02,0x3b,0x00
};

static const UCHAR SiS_PALTiming[] = {
	0x19,0x52,0x35,0x6e,0x04,0x38,0x3d,0x70,
	0x94,0x49,0x01,0x12,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0x45,0x2b,
	0x70,0x50,0x00,0x9b,0x00,0xd9,0x5d,0x17,
	0x7d,0x05,0x45,0x00,0x00,0xe8,0x00,0x02,
	0x0d,0x00,0x68,0xb0,0x0b,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x63,
	0x00,0x40,0x3e,0x00,0xe1,0x02,0x28,0x00
};

static const UCHAR SiS_HiTVExtTiming[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

static const UCHAR SiS_HiTVSt1Timing[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0x7b,0xa8,0x03,0xf0,0x87,0x03,
	0x11,0x15,0x11,0xcf,0x10,0x11,0xcf,0x10,
	0x35,0x35,0x3b,0x69,0x1d,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x86,
	0xaf,0x5d,0x0e,0x00,0xfc,0xff,0x2d,0x00
};

static const UCHAR SiS_HiTVSt2Timing[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

static const UCHAR SiS_HiTVTextTiming[] = {
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0xe7,0xbc,0x03,0x0c,0x97,0x03,
	0x14,0x78,0x14,0x08,0x20,0x14,0x08,0x20,
	0xc8,0xc8,0x3b,0xd2,0x26,0x92,0x0f,0x40,
        0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x96,
	0x72,0x5c,0x11,0x00,0xfc,0xff,0x32,0x00
};

static const UCHAR SiS_HiTVGroup3Data[] = {
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x5f,
	0x05,0x21,0xb2,0xb2,0x55,0x77,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x2e,0x58,0x48,0x72,0x44,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x4f,0x7f,0x03,0xa8,0x7d,0x20,0x1a,0xa9,
	0x14,0x05,0x03,0x7e,0x64,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS_HiTVGroup3Simu[] = {
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x95,
	0xdb,0x20,0xb8,0xb8,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x15,0x26,0xd3,0xe4,0x11,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x67,0x36,0x01,0x47,0x0e,0x10,0xbe,0xb4,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS_HiTVGroup3Text[] = {
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0xa7,
	0xf5,0x20,0xce,0xce,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x18,0x2c,0x0c,0x20,0x22,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x93,0x3c,0x01,0x50,0x2f,0x10,0xf4,0xca,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS_NTSCPhase[]    = {0x21,0xed,0xba,0x08};  /* Was {0x21,0xed,0x8a,0x08}; */
static const UCHAR SiS_PALPhase[]     = {0x2a,0x05,0xe3,0x00};  /* Was {0x2a,0x05,0xd3,0x00};  */
static const UCHAR SiS_PALMPhase[]    = {0x21,0xE4,0x2E,0x9B};
static const UCHAR SiS_PALNPhase[]    = {0x21,0xF4,0x3E,0xBA};
static const UCHAR SiS_NTSCPhase2[]   = {0x21,0xF0,0x7B,0xD6};
static const UCHAR SiS_PALPhase2[]    = {0x2a,0x09,0x86,0xe9};
static const UCHAR SiS_PALMPhase2[]   = {0x21,0xE6,0xEF,0xA4};
static const UCHAR SiS_PALNPhase2[]   = {0x21,0xF6,0x94,0x46};
static const UCHAR SiS_SpecialPhase[] = {0x1e,0x8c,0x5c,0x7a};

static const SiS_TVDataStruct  SiS_StPALData[]=
{
 {    1,   1, 864, 525,1270, 400, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 350, 100,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 864, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 864, 525,1270, 480,  50,   0, 760,0xf4,0xff,0x1c,0x22},
 {    1,   1, 864, 525,1270, 600,  50,   0,   0,0xf4,0xff,0x1c,0x22}
};

static const SiS_TVDataStruct  SiS_ExtPALData[] =
{
 {   27,  10, 848, 448,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},  /* 640x400, 320x200 */
 {  108,  35, 848, 398,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
 {   12,   5, 954, 448,1270, 530,  50,   0,  50,0xf1,0x04,0x1f,0x18},
 {    9,   4, 960, 463,1644, 438,  50,   0,  50,0xf4,0x0b,0x1c,0x0a},
 {    9,   4, 848, 528,1270, 530,   0,   0,  50,0xf5,0xfb,0x1b,0x2a},  /* 640x480, 320x240 */
 {   36,  25,1060, 648,1316, 530, 438,   0, 438,0xeb,0x05,0x25,0x16},  /* 800x600, 400x300 */
 {    3,   2,1080, 619,1270, 540, 438,   0, 438,0xf3,0x00,0x1d,0x20},  /* 720x576 */
 {    1,   1,1170, 821,1270, 520, 686,   0, 686,0xF3,0x00,0x1D,0x20}   /* 1024x768 */
};

static const SiS_TVDataStruct  SiS_StNTSCData[]=
{
 {    1,   1, 858, 525,1270, 400,  50,   0, 760,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,  50,   0, 640,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
 {    1,   1, 858, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
 {    1,   1, 858, 525,1270, 480,   0,   0, 760,0xf1,0x04,0x1f,0x18}
};

static const SiS_TVDataStruct  SiS_ExtNTSCData[]=
{
 {  143,  65, 858, 443,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},    /* 640x400, 320x200 */
 {   88,  35, 858, 393,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 443,1270, 440,  92,   0,  92,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 393,1270, 440,  92,   0,  92,0xf4,0x0b,0x1c,0x0a},
 {  143,  76, 836, 523,1270, 440, 224,   0,   0,0xf1,0x05,0x1f,0x16},    /* 640x480, 320x240 */
 {  143, 120,1056, 643,1270, 440,   0, 128,   0,0xf4,0x10,0x1c,0x00},    /* 800x600, 400x300  */
 {  143,  76, 836, 523,1270, 440,   0, 128,   0,0xee,0x0c,0x22,0x08},    /* 720x480 - BETTER (from 300 series) */
/*{   2,   1, 858, 503,1270, 480,   0, 128,   0,0xee,0x0c,0x22,0x08},*/  /* 720x480  (old, from 650) */
 {    1,   1,1100, 811,1412, 440,   0, 128,   0,0xee,0x0c,0x22,0x08}     /* 1024x768 CORRECTED */
/*{  65,  64,1056, 791,1270, 480, 638,   0,   0,0xEE,0x0C,0x22,0x08} */  /* 1024x768 */
#if 0  /* 300 series was: */
 {  143,  65, 858, 443,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {   88,  35, 858, 393,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 443,1270, 440,  92,   0,  92,0xf1,0x04,0x1f,0x18},
 {  143,  70, 924, 393,1270, 440,  92,   0,  92,0xf4,0x0b,0x1c,0x0a},
 {  143,  76, 836, 523,1270, 440, 224,   0,   0,0xf1,0x05,0x1f,0x16},
 {  143, 120,1056, 643,1270, 440,   0, 128,   0,0xf4,0x10,0x1c,0x00},
 {  143,  76, 836, 523,1270, 440,   0, 128,   0,0xee,0x0c,0x22,0x08},
 {   65,  64,1056, 791,1270, 480, 638,   0,   0,0xf1,0x04,0x1f,0x18}
#endif
};


static const SiS_TVDataStruct  SiS_St2HiTVData[]=
{
 {    3,   1, 0x348,0x1e3,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x37c,0x233,0x2b2,0x2bc, 	  0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x348,0x1e3,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},
 {    1,   1, 0x3e8,0x233,0x311,0x2bc,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    5,   2, 0x348,0x233,0x670,0x3c0,0x08d,128, 0, 0x00,0x00,0x00,0x00},
 {    8,   5, 0x41a,0x2ab,0x670,0x3c0,0x17c,128, 0, 0x00,0x00,0x00,0x00}
};

static const SiS_TVDataStruct  SiS_ExtHiTVData[]=
{
 {    6,   1, 0x348,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x3c0,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x348,0x1e3,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    3,   1, 0x3c0,0x233,0x660,0x3c0,    0,  0, 0, 0x00,0x00,0x00,0x00},
 {    5,   1, 0x348,0x233,0x670,0x3c0,0x166,128, 0, 0x00,0x00,0x00,0x00},  /* 640x480   */
 {   16,   5, 0x41a,0x2ab,0x670,0x3c0,0x143,128, 0, 0x00,0x00,0x00,0x00},  /* 800x600   */
 {   25,  12, 0x4ec,0x353,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},  /* 1024x768  */
 {    5,   4, 0x627,0x464,0x670,0x3c0,0x128,  0, 0, 0x00,0x00,0x00,0x00},  /* 1280x1024 */
 {    4,   1, 0x41a,0x233,0x670,0x3c0,0x143,128, 0, 0x00,0x00,0x00,0x00},  /* 800x480   */
 {    5,   2, 0x578,0x293,0x670,0x3c0,0x032,  0, 0, 0x00,0x00,0x00,0x00},  /* 1024x576  */
 {    8,   5, 0x6d6,0x323,0x670,0x3c0,0x128,  0, 0, 0x00,0x00,0x00,0x00}   /* 1280x720  */
};

static const UCHAR SiS_OutputSelect = 0x40;

static const UCHAR SiS_SoftSetting  = 0x30;   /* TW: RAM setting */

static const SiS_LCDDataStruct  SiS_LCD1280x960Data[] =
{
	{    9,   2, 800, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{   30,  11,1056, 625,1800,1000},
	{    5,   3,1350, 800,1800,1000},
	{    1,   1,1576,1050,1576,1050},
	{    1,   1,1800,1000,1800,1000}
};

static const SiS_LCDDataStruct  SiS_StLCD1280x768Data[] =
{
	{ 211,  100, 2100,  408, 1688,  802 }, /* These values are *wrong* */
	{ 211,   64, 1536,  358, 1688,  802 },
	{ 211,  100, 2100,  408, 1688,  802 },
	{ 211,   64, 1536,  358, 1688,  802 },
	{ 211,   48,  840,  488, 1688,  802 },
	{ 211,   72, 1008,  609, 1688,  802 },
	{ 211,  128, 1400,  776, 1688,  802 },
	{ 211,  205, 1680, 1041, 1688,  802 },
	{ 1,      1, 1688,  802, 1688,  802 }  /* That's the only one that *might* be correct */
};

static const SiS_LCDDataStruct  SiS_ExtLCD1280x768Data[] =
{
	{ 211,  100, 2100,  408, 1688,  802 }, /* These values are *wrong* */
	{ 211,   64, 1536,  358, 1688,  802 },
	{ 211,  100, 2100,  408, 1688,  802 },
	{ 211,   64, 1536,  358, 1688,  802 },
	{ 211,   48,  840,  488, 1688,  802 },
	{ 211,   72, 1008,  609, 1688,  802 },
	{ 211,  128, 1400,  776, 1688,  802 },
	{ 211,  205, 1680, 1041, 1688,  802 },
	{ 1,      1, 1688,  802, 1688,  802 }  /* That's the only one that *might* be correct */
};

static const SiS_LCDDataStruct  SiS_NoScaleData1280x768[] =
{  /* All values guessed */
        { 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802},
	{ 1, 1, 1688,  802, 1688,  802}
};

static const SiS_LCDDataStruct  SiS_StLCD1400x1050Data[] =
{
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,   48,  840,  488, 1688, 1066 },
	{ 211,   72, 1008,  609, 1688, 1066 },
	{ 211,  128, 1400,  776, 1688, 1066 },
	{ 211,  205, 1680, 1041, 1688, 1066 },
	{   1,    1, 1688, 1066, 1688, 1066 }
};

static const SiS_LCDDataStruct  SiS_ExtLCD1400x1050Data[] =
{
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,  100, 2100,  408, 1688, 1066 },
	{ 211,   64, 1536,  358, 1688, 1066 },
	{ 211,   48,  840,  488, 1688, 1066 },
	{ 211,   72, 1008,  609, 1688, 1066 },
	{ 211,  128, 1400,  776, 1688, 1066 },
	{ 211,  205, 1680, 1041, 1688, 1066 },
	{   1,    1, 1688, 1066, 1688, 1066 }
};

static const SiS_LCDDataStruct  SiS_NoScaleData1400x1050[] =
{
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 },
	{ 1, 1, 1688, 1066, 1688, 1066 }
};

static const SiS_LCDDataStruct  SiS_StLCD1600x1200Data[] =
{  /* TODO */
	{    0,   0,   0,   0,   0,   0}
};

static const SiS_LCDDataStruct  SiS_ExtLCD1600x1200Data[] =
{  /* TODO */
	{    0,   0,   0,   0,   0,   0}
};

static const SiS_LCDDataStruct  SiS_NoScaleData1600x1200[] =
{  /* TODO - values guessed */
        {1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250},
	{1,  1, 2048, 1250, 2048, 1250}
};

static const SiS_LCDDataStruct  SiS_NoScaleData[] =
{
	{ 1, 1, 800, 449, 800, 449 },
	{ 1, 1, 800, 449, 800, 449 },
	{ 1, 1, 900, 449, 900, 449 },
	{ 1, 1, 900, 449, 900, 449 },
	{ 1, 1, 800, 525, 800, 525 },
	{ 1, 1,1056, 628,1056, 628 },
	{ 1, 1,1344, 806,1344, 806 },
	{ 1, 1,1688,1066,1688,1066 },
        { 1, 1,1688, 802,1688, 802 },  /* 1280x768: 802 was 806 in both cases */
        { 1, 1,2048,1250,2048,1250 },  /* 1600x1200 (guessed) */
	{ 1, 1,1800,1000,1800,1000 }   /* 1280x960 */
};

static const SiS_LVDSDataStruct  SiS_LVDS320x480Data_1[]=
{
	{ 848, 433, 400, 525},
	{ 848, 389, 400, 525},
	{ 848, 433, 400, 525},
	{ 848, 389, 400, 525},
	{ 848, 518, 400, 525},
	{1056, 628, 400, 525},
	{ 400, 525, 400, 525},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS_LVDSDataStruct  SiS_LVDS800x600Data_1[]=
{
	{ 848, 433,1060, 629},
	{ 848, 389,1060, 629},
	{ 848, 433,1060, 629},
	{ 848, 389,1060, 629},
	{ 848, 518,1060, 629},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS_LVDSDataStruct  SiS_LVDS800x600Data_2[]=
{
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{ 800, 449,1000, 644},
	{ 800, 525,1000, 635}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x768Data_1[]=
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},   /* 640x480 */
	{1050, 638,1344, 806},   /* 800x600 */
	{1344, 806,1344, 806},   /* 1024x768 */
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x768Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x1024Data_1[]=
{
	{1048, 442,1688,1066},
	{1048, 392,1688,1066},
	{1048, 442,1688,1066},
	{1048, 392,1688,1066},
	{1048, 522,1688,1066},
	{1208, 642,1688,1066},
	{1432, 810,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x1024Data_2[]=
{	
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066},
	{1688,1066,1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LVDS1400x1050Data_1[]=
{
        { 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{ 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{ 928, 496, 1688,1066},
	{1088, 616, 1688,1066},
	{1312, 784, 1688,1066},
	{1568,1040, 1688,1066},
	{1688,1066, 1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LVDS1400x1050Data_2[]=
{
        {1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
};

static const SiS_LVDSDataStruct  SiS_LVDS1600x1200Data_1[]=
{
        {1088, 450, 2048,1250},
	{1088, 400, 2048,1250},
	{1088, 450, 2048,1250},
	{1088, 400, 2048,1250},
	{1088, 530, 2048,1250},
	{1248, 650, 2048,1250},
	{1472, 818, 2048,1250},
	{1728,1066, 2048,1250},
	{1848,1066, 2048,1250},
	{2048,1250, 2048,1250}
};

static const SiS_LVDSDataStruct  SiS_LVDS1600x1200Data_2[]=
{
        {2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250},
	{2048,1250, 2048,1250}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x768Data_1[]=
{
	{ 768, 438, 1408, 806},
	{ 768, 388, 1408, 806},
	{ 768, 438, 1408, 806},
	{ 768, 388, 1408, 806},
	{ 768, 518, 1408, 806},
	{ 928, 638, 1408, 806},
	{1152, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x768Data_2[]=
{
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806},
	{1408, 806, 1408, 806}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x600Data_1[] =
{
	{840, 604,1344, 800},
	{840, 560,1344, 800},
	{840, 604,1344, 800},
	{840, 560,1344, 800},
	{840, 689,1344, 800},
	{1050, 800,1344, 800},
	{1344, 800,1344, 800},
	{800, 449,1280, 789},
	{800, 525,1280, 785}
};

static const SiS_LVDSDataStruct  SiS_LVDS1024x600Data_2[] =
{
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1152x768Data_1[] =
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1152x768Data_2[] =
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

/* TW: Pass 1:1 data */
static const SiS_LVDSDataStruct  SiS_LVDSXXXxXXXData_1[]=
{
        { 800, 449,  800, 449},
	{ 800, 449,  800, 449},
	{ 900, 449,  900, 449},
	{ 900, 449,  900, 449},
	{ 800, 525,  800, 525},  /*  640x480   */
	{1056, 628, 1056, 628},  /*  800x600   */
	{1344, 806, 1344, 806},  /* 1024x768   */
	{1344,1066, 1344,1066},  /* 1280x1024  */  /* INSERTED ! */
 	{1688, 806, 1688, 806},  /* 1280x768   */
	/* No other panels ! */
};

static const SiS_LVDSDataStruct  SiS_LVDS640x480Data_1[]=
{
	{ 800, 449, 800, 449},
	{ 800, 449, 800, 449},
	{ 800, 449, 800, 449},
	{ 800, 449, 800, 449},
	{ 800, 525, 800, 525},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x960Data_1[]=
{
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 438,1344, 806},
	{ 840, 409,1344, 806},
	{ 840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LVDS1280x960Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

/* LCDA */

static const SiS_LVDSDataStruct  SiS_LCDA1400x1050Data_1[]=
{	/* TW: Might be temporary (invalid) data */
        { 928, 416, 1688,1066},
	{ 928, 366, 1688,1066},
	{1008, 416, 1688,1066},
	{1008, 366, 1688,1066},
	{1200, 530, 1688,1066},
	{1088, 616, 1688,1066},
	{1312, 784, 1688,1066},
	{1568,1040, 1688,1066},
	{1688,1066, 1688,1066}
};

static const SiS_LVDSDataStruct  SiS_LCDA1400x1050Data_2[]=
{	/* TW: Temporary data. Not valid */
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LCDA1600x1200Data_1[]=
{	/* TW: Temporary data. Not valid */
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{ 800, 449,1280, 801},
	{ 800, 525,1280, 813}
};

static const SiS_LVDSDataStruct  SiS_LCDA1600x1200Data_2[]=
{	/* TW: Temporary data. Not valid */
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0}
};

static const SiS_LVDSDataStruct  SiS_CHTVUNTSCData[]=
{
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 840, 600, 840, 600},
	{ 784, 600, 784, 600},
	{1064, 750,1064, 750},
        {1160, 945,1160, 945}
};

static const SiS_LVDSDataStruct  SiS_CHTVONTSCData[]=
{
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 840, 525, 840, 525},
	{ 784, 525, 784, 525},
	{1040, 700,1040, 700},
        {1160, 840,1160, 840}
};

static const SiS_LVDSDesStruct SiS_PanelType1076_1[]=
{  /* 1024x768 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1076_2[]=
{  /* 1024x768 */
	{ 1184, 622 },
	{ 1184, 597 },
	{ 1184, 622 },
	{ 1184, 597 },
	{ 1152, 622 },
	{ 1232, 722 },
	{    0, 0   },
	{    0, 794 },
	{    0, 0   }
};

static const SiS_LVDSDesStruct SiS_PanelType1210_1[]=
{  /* 1280x1024 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1210_2[]=
{  /* 1280x1024 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1296_1[]=
{  /* 1400x1050 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1296_2[]=
{  /* 1400x1050 - looks heavily invalid */
	{ 808 , 740},
	{ 0   , 715},
	{ 632 , 740},
	{ 632 , 715},
	{ 1307, 780},
	{ 1387,1157},
	{ 1499, 924},
	{ 1627,1052},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1600_1[]=
{  /* 1600x1200 */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct SiS_PanelType1600_2[]=
{  /* 1600x1200 - BIOS looks heavily invalid, not copied */
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct  SiS_PanelTypeNS_1[]=
{
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 8,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0, 806},
	{ 0, 0 }
};

static const SiS_LVDSDesStruct  SiS_PanelTypeNS_2[] =
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS_LVDSDesStruct  SiS_CHTVUNTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS_LVDSDesStruct  SiS_CHTVONTSCDesData[]=
{
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS_LVDSDesStruct  SiS_CHTVUPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS_LVDSDesStruct  SiS_CHTVOPALDesData[]=
{
	{256,   0},
	{256,   0},
	{256,   0},
	{256,   0},
	{ 0,   0},
	{ 0,   0},
	{ 0,   0}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1320x480_1[] =
{
 {{0x65,0x4f,0x89,0x56,0x83,0xaa,0x1f,
   0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x54,0x9f,0xc4,0x1f,
   0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
   0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
   0x00 }},
 {{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
   0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
   0x00 }},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01 }},
 {{0x2d,0x27,0x90,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00 }}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_1[] =
{
        {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
	  0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
	  0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
	  0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
	  0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0xaf,0xba,
	  0x3b,0x82,0xdf,0xb0,0x00,0x00,0x01,
	  0x00}},
        {{0x7e,0x63,0x82,0x68,0x15,0x1e,0xf1,
	  0xae,0x85,0x57,0x1f,0x30,0x00,0x26,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x1e,0xf1,
	  0xae,0x85,0x57,0x1f,0x30,0x00,0x02,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_1_H[] =
{
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
          0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
	  0x00}},
        {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_2[] =
{
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
          0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11024x600_2_H[] =
{
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_1[] =
{
        {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00}},
        {{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_1_H[] =
{
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
	  0x00}},
        {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_2[] =
{
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11152x768_2_H[] =
{
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_1[] =
{
 {{0x5b,0x4f,0x9f,0x55,0x19,0xb4,0x1f,
   0x9c,0x8e,0x8f,0xb5,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x82,0x1f,
   0x6a,0x8c,0x5d,0x83,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0xb4,0x1f,
   0x9c,0x8e,0x8f,0xb5,0x10,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x82,0x1f,
   0x6a,0x8c,0x5d,0x83,0x30,0x00,0x01,
   0x00}},
 {{0x5b,0x4f,0x9f,0x55,0x19,0x04,0x3e,
   0xec,0x8e,0xdf,0x05,0x20,0x00,0x01,
   0x00}},
 {{0x6f,0x63,0x93,0x69,0x8d,0x7c,0xf0,
   0x64,0x86,0x57,0x7d,0x20,0x00,0x05,
   0x01}},
 {{0x8b,0x7f,0x8f,0x85,0x09,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xab,0x9f,0x8f,0xa5,0x89,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa5,0x89,0x24,0xf5,
   0x0c,0x8e,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_1_H[] =
{
 {{0x47,0x27,0x8b,0x2c,0x1a,0x9e,0x1f,
   0x93,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x30,0x1e,0x9e,0x1f,
   0x92,0x86,0x8f,0x9f,0x30,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0x6c,0x1f,
   0x60,0x84,0x5d,0x6d,0x10,0x00,0x05,
   0x00}},
 {{0x47,0x27,0x8b,0x2c,0x1a,0xee,0x1f,
   0xe2,0x86,0xdf,0xef,0x10,0x00,0x05,
   0x00}},
 {{0x51,0x31,0x95,0x36,0x04,0x66,0xf0,
   0x5a,0x8e,0x57,0x67,0x20,0x00,0x01,
   0x01}},
 {{0x5f,0x3f,0x83,0x44,0x92,0x0e,0xf5,
   0x02,0x86,0xff,0x0f,0x10,0x00,0x01,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}},
 {{0x6f,0x4f,0x93,0x54,0x82,0x0e,0x5a,
   0x02,0x86,0xff,0x0f,0x09,0x00,0x05,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_2[] =
{
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x02,
   0x00}},
 {{0xab,0x60,0x9f,0x80,0x04,0x24,0xb3,
   0x7c,0x8e,0x03,0x02,0x10,0x00,0x02,
   0x01}},
 {{0xab,0x63,0x8f,0x8a,0x8e,0x24,0xf1,
   0xb6,0x88,0x57,0x25,0x10,0x00,0x02,
   0x01}},
 {{0xab,0x7f,0x8f,0x98,0x9c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x02,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT11280x768_2_H[] =
{
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x54,0x86,0xdb,0xda,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xbb,
   0x3b,0x8d,0xc2,0xc1,0x00,0x00,0x01,
   0x00}},
 {{0x83,0x38,0x97,0x58,0x9c,0x24,0xb3,
   0x7c,0x8e,0x03,0x02,0x10,0x00,0x01,
   0x01}},
 {{0x79,0x31,0x9d,0x58,0x9c,0x24,0xf1,
   0xb6,0x88,0x57,0x25,0x10,0x00,0x01,
   0x01}},
 {{0x6b,0x3f,0x8f,0x58,0x9c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x01,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}},
 {{0xab,0x9f,0x8f,0xa8,0x8c,0x24,0xf5,
   0x0a,0x8c,0xff,0x25,0x30,0x00,0x06,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1XXXxXXX_1[] =
{
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x05,
   0x00}},
 {{0x5f,0x4f,0x82,0x55,0x81,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x05,
   0x00}},
 {{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
   0x01}},
 {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x02,
   0x01}},
 {{0xce,0x9f,0x92,0xa8,0x14,0x28,0x5a,
   0x00,0x84,0xff,0x29,0x09,0x00,0x07,
   0x01}},
 {{0xce,0x9f,0x92,0xa9,0x17,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x07,
   0x01}}
};

static const SiS_LVDSCRT1DataStruct  SiS_LVDSCRT1XXXxXXX_1_H[] =
{
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0xbf,0x1f,
   0x9c,0x8e,0x96,0xb9,0x30,0x00,0x00,
   0x00}},
 {{0x38,0x27,0x9c,0x2c,0x80,0x0b,0x3e,
   0xe9,0x8b,0xe7,0x04,0x00,0x00,0x00,
   0x00}},
 {{0x4d,0x31,0x91,0x3b,0x03,0x72,0xf0,
   0x58,0x8c,0x57,0x73,0x20,0x00,0x01,
   0x01}},
 {{0x63,0x3f,0x87,0x4a,0x92,0x24,0xf5,
   0x02,0x88,0xff,0x25,0x10,0x00,0x01,
   0x01}}
};

void     SiS_SetReg1(USHORT, USHORT, USHORT);
void     SiS_SetReg2(SiS_Private *, USHORT, USHORT, USHORT);
void     SiS_SetReg3(USHORT, USHORT);
void     SiS_SetReg4(USHORT, ULONG);
void     SiS_SetReg5(USHORT, USHORT);
UCHAR    SiS_GetReg1(USHORT, USHORT);
UCHAR    SiS_GetReg2(USHORT);
ULONG    SiS_GetReg3(USHORT);
USHORT   SiS_GetReg4(USHORT);
void     SiS_ClearDAC(SiS_Private *SiS_Pr, ULONG);
void     SiS_SetMemoryClock(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiS_SetDRAMModeRegister(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension);
BOOLEAN  SiS_SearchVBModeID(SiS_Private *SiS_Pr, UCHAR *ROMAddr, USHORT *ModeNo);
void     SiS_IsLowResolution(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex);
void     SiS_GetSysFlags(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension);

#ifdef SIS300
void     SiS_SetDRAMSize_300(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension);
USHORT   SiS_ChkBUSWidth_300(SiS_Private *SiS_Pr, ULONG FBAddress);
#endif

#ifdef SIS315H
UCHAR    SiS_Get310DRAMType(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiS_DDR_MRS(SiS_Private *SiS_Pr);
void     SiS_SDR_MRS(SiS_Private *SiS_Pr);
void     SiS_DisableRefresh(SiS_Private *SiS_Pr);
void     SiS_EnableRefresh(SiS_Private *SiS_Pr, UCHAR *ROMAddr);
void     SiS_SetDRAMSize_310(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO);
void     SiS_DisableChannelInterleaving(SiS_Private *SiS_Pr, int index,USHORT SiS_DDRDRAM_TYPE[][5]);
void     SiS_SetDRAMSizingType(SiS_Private *SiS_Pr, int index,USHORT DRAMTYPE_TABLE[][5]);
void     SiS_CheckBusWidth_310(SiS_Private *SiS_Pr, UCHAR *ROMAddress,ULONG FBAddress,
                               PSIS_HW_DEVICE_INFO HwDeviceExtension);
int      SiS_SetRank(SiS_Private *SiS_Pr, int index,UCHAR RankNo,USHORT DRAMTYPE_TABLE[][5]);
int      SiS_SetDDRChannel(SiS_Private *SiS_Pr, int index,UCHAR ChannelNo,
                           USHORT DRAMTYPE_TABLE[][5]);
int      SiS_CheckColumn(SiS_Private *SiS_Pr, int index,USHORT DRAMTYPE_TABLE[][5],ULONG FBAddress);
int      SiS_CheckBanks(SiS_Private *SiS_Pr, int index,USHORT DRAMTYPE_TABLE[][5],ULONG FBAddress);
int      SiS_CheckRank(SiS_Private *SiS_Pr, int RankNo,int index,USHORT DRAMTYPE_TABLE[][5],ULONG FBAddress);
int      SiS_CheckDDRRank(SiS_Private *SiS_Pr, int RankNo,int index,USHORT DRAMTYPE_TABLE[][5],ULONG FBAddress);
int      SiS_CheckRanks(SiS_Private *SiS_Pr, int RankNo,int index,USHORT DRAMTYPE_TABLE[][5],ULONG FBAddress);
int      SiS_CheckDDRRanks(SiS_Private *SiS_Pr, int RankNo,int index,USHORT DRAMTYPE_TABLE[][5],ULONG FBAddress);
int      SiS_SDRSizing(SiS_Private *SiS_Pr, ULONG FBAddress);
int      SiS_DDRSizing(SiS_Private *SiS_Pr, ULONG FBAddress);
int      Is315E(SiS_Private *SiS_Pr);
void     SiS_VerifyMclk(SiS_Private *SiS_Pr, ULONG FBAddr);
#endif

void     SiS_HandleCRT1(SiS_Private *SiS_Pr);
void     SiS_Handle301B_1400x1050(SiS_Private *SiS_Pr, USHORT ModeNo);
void     SiS_SetEnableDstn(SiS_Private *SiS_Pr);
void     SiS_Delay15us(SiS_Private *SiS_Pr);
BOOLEAN  SiS_SearchModeID(SiS_Private *SiS_Pr, UCHAR *ROMAddr, USHORT *ModeNo,USHORT *ModeIdIndex);
BOOLEAN  SiS_CheckMemorySize(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension,
                             USHORT ModeNo,USHORT ModeIdIndex);
UCHAR    SiS_GetModePtr(SiS_Private *SiS_Pr, UCHAR *ROMAddr, USHORT ModeNo,USHORT ModeIdIndex);
void     SiS_WhatTheHellIsThis(SiS_Private *SiS_Pr,PSIS_HW_DEVICE_INFO HwDeviceExtension,USHORT BaseAddr);
void     SiS_StrangeStuff(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiS_SetSeqRegs(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT StandTableIndex);
void     SiS_SetMiscRegs(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT StandTableIndex);
void     SiS_SetCRTCRegs(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension,
                         USHORT StandTableIndex);
void     SiS_SetATTRegs(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT StandTableIndex,
                        PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiS_SetGRCRegs(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT StandTableIndex);
void     SiS_ClearExt1Regs(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiS_SetSync(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT RefreshRateTableIndex);
void     SiS_SetCRT1CRTC(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex,
                         USHORT RefreshRateTableIndex,
			 PSIS_HW_DEVICE_INFO HwDeviceExtension);
BOOLEAN  SiS_GetLCDACRT1Ptr(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex,
                            USHORT RefreshRateTableIndex,USHORT *ResInfo,USHORT *DisplayType);
void     SiS_ResetCRT1VCLK(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiS_SetCRT1VCLK(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex,PSIS_HW_DEVICE_INFO,
                         USHORT RefreshRateTableIndex);
void     SiS_SetVCLKState(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO, USHORT ModeNo,
                          USHORT RefreshRateTableIndex, USHORT ModeIdIndex);
void     SiS_LoadDAC(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex);
void     SiS_WriteDAC(SiS_Private *SiS_Pr, USHORT, USHORT, USHORT, USHORT, USHORT, USHORT);
void     SiS_DisplayOn(SiS_Private *SiS_Pr);
void 	 SiS_DisplayOff(SiS_Private *SiS_Pr);
void     SiS_SetCRT1ModeRegs(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO,USHORT ModeNo,
                             USHORT ModeIdIndex,USHORT RefreshRateTableIndex);
void     SiS_GetVBType(SiS_Private *SiS_Pr, USHORT BaseAddr,PSIS_HW_DEVICE_INFO);
USHORT   SiS_ChkBUSWidth(SiS_Private *SiS_Pr, UCHAR *ROMAddr);
USHORT   SiS_GetModeIDLength(SiS_Private *SiS_Pr, UCHAR *ROMAddr, USHORT);
USHORT   SiS_GetRefindexLength(SiS_Private *SiS_Pr, UCHAR *ROMAddr, USHORT);
void     SiS_SetInterlace(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT RefreshRateTableIndex);
void     SiS_Set_LVDS_TRUMPION(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiS_SetCRT1Offset(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT,USHORT,USHORT,PSIS_HW_DEVICE_INFO);
#ifdef SIS315H
void     SiS_SetCRT1FIFO_310(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT,USHORT,PSIS_HW_DEVICE_INFO);
#endif
#ifdef SIS300
void     SiS_SetCRT1FIFO_300(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,PSIS_HW_DEVICE_INFO,
                             USHORT RefreshRateTableIndex);
void     SiS_SetCRT1FIFO_630(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,PSIS_HW_DEVICE_INFO,
                             USHORT RefreshRateTableIndex);
USHORT   SiS_CalcDelay(SiS_Private *SiS_Pr, UCHAR *ROMAddr, USHORT VCLK,
                       USHORT colordepth, USHORT MCLK);
USHORT   SiS_DoCalcDelay(SiS_Private *SiS_Pr, USHORT MCLK, USHORT VCLK, USHORT colordepth, USHORT key);
USHORT   SiS_CalcDelay2(SiS_Private *SiS_Pr, UCHAR *ROMAddr, UCHAR,PSIS_HW_DEVICE_INFO HwDeviceExtension);
#endif
void     SiS_ClearBuffer(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO,USHORT ModeNo);
void     SiS_SetCRT1Group(SiS_Private *SiS_Pr, UCHAR *ROMAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension,
                          USHORT ModeNo,USHORT ModeIdIndex,USHORT BaseAddr);
void     SiS_DetectMonitor(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,USHORT BaseAddr);
void     SiS_GetSenseStatus(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,UCHAR *ROMAddr);
USHORT   SiS_TestMonitorType(SiS_Private *SiS_Pr, UCHAR R_DAC,UCHAR G_DAC,UCHAR B_DAC);
USHORT   SiS_SenseCHTV(SiS_Private *SiS_Pr);
BOOLEAN  SiS_Sense(SiS_Private *SiS_Pr, USHORT tempbx,USHORT tempcx);
BOOLEAN  SiS_GetPanelID(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO);
BOOLEAN  SiS_GetLCDDDCInfo(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO);
USHORT   SiS_SenseLCD(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO);
void     SiSRegInit(SiS_Private *SiS_Pr, USHORT BaseAddr);
void     SiSInitPtr(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiSSetLVDSetc(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,USHORT ModeNo);
void     SiSInitPCIetc(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension);
void     SiSDetermineROMUsage(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension, UCHAR *ROMAddr);

#ifdef LINUX_XF86
USHORT 		SiS_CheckBuildCustomMode(ScrnInfoPtr pScrn, DisplayModePtr mode, int VBFlags);
void    	SiS_SetPitch(SiS_Private *SiS_Pr, ScrnInfoPtr pScrn, UShort BaseAddr);
void    	SiS_SetPitchCRT1(SiS_Private *SiS_Pr, ScrnInfoPtr pScrn, UShort BaseAddr);
void    	SiS_SetPitchCRT2(SiS_Private *SiS_Pr, ScrnInfoPtr pScrn, UShort BaseAddr);
extern int      SiS_compute_vclk(int Clock, int *out_n, int *out_dn, int *out_div,
	     	 		    int *out_sbit, int *out_scale);
extern unsigned char SiS_GetSetBIOSScratch(ScrnInfoPtr pScrn, USHORT offset, unsigned char value);
extern unsigned char SiS_GetSetModeID(ScrnInfoPtr pScrn, unsigned char id);
extern USHORT 	     SiS_CalcModeIndex(ScrnInfoPtr pScrn, DisplayModePtr mode);
#endif

extern USHORT    SiS_GetOffset(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex,
                       USHORT RefreshRateTableIndex,PSIS_HW_DEVICE_INFO HwDeviceExtension);
extern USHORT    SiS_GetColorDepth(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex);
extern void      SiS_DisableBridge(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension, USHORT BaseAddr);
extern BOOLEAN   SiS_SetCRT2Group301(SiS_Private *SiS_Pr, USHORT BaseAddr,UCHAR *ROMAddr,USHORT ModeNo,
                                     PSIS_HW_DEVICE_INFO HwDeviceExtension);
extern void      SiS_UnLockCRT2(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,USHORT BaseAddr);
extern void      SiS_LockCRT2(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,USHORT BaseAddr);
extern BOOLEAN   SiS_BridgeIsOn(SiS_Private *SiS_Pr, USHORT BaseAddr);
extern BOOLEAN   SiS_BridgeIsEnable(SiS_Private *SiS_Pr, USHORT BaseAddr,PSIS_HW_DEVICE_INFO );
extern void      SiS_GetVBInfo(SiS_Private *SiS_Pr, USHORT BaseAddr,UCHAR *ROMAddr,USHORT ModeNo,
                               USHORT ModeIdIndex,PSIS_HW_DEVICE_INFO HwDeviceExtension, int chkcrt2mode);
extern BOOLEAN   SiS_GetLCDResInfo(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,
                                   USHORT ModeIdIndex, PSIS_HW_DEVICE_INFO HwDeviceExtension);
extern void      SiS_SetHiVision(SiS_Private *SiS_Pr, USHORT BaseAddr,PSIS_HW_DEVICE_INFO HwDeviceExtension);
extern USHORT    SiS_GetRatePtrCRT2(SiS_Private *SiS_Pr, UCHAR *ROMAddr, USHORT ModeNo,USHORT ModeIdIndex,
                                    PSIS_HW_DEVICE_INFO HwDeviceExtension);
extern void      SiS_WhatIsThis(SiS_Private *SiS_Pr, USHORT myvbinfo);
extern void      SiS_LongWait(SiS_Private *SiS_Pr);
extern void      SiS_SetRegOR(USHORT Port,USHORT Index,USHORT DataOR);
extern void      SiS_SetRegAND(USHORT Port,USHORT Index,USHORT DataAND);
extern void      SiS_SetRegANDOR(USHORT Port,USHORT Index,USHORT DataAND,USHORT DataOR);
extern USHORT    SiS_GetResInfo(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex);
extern void      SiS_SetCH700x(SiS_Private *SiS_Pr, USHORT tempax);
extern USHORT    SiS_GetCH700x(SiS_Private *SiS_Pr, USHORT tempax);
extern void      SiS_SetCH701x(SiS_Private *SiS_Pr, USHORT tempax);
extern USHORT    SiS_GetCH701x(SiS_Private *SiS_Pr, USHORT tempax);
extern void      SiS_SetCH70xx(SiS_Private *SiS_Pr, USHORT tempax);
extern USHORT    SiS_GetCH70xx(SiS_Private *SiS_Pr, USHORT tempax);
extern BOOLEAN   SiS_GetLVDSCRT1Ptr(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex,
                                    USHORT RefreshRateTableIndex,
		                    USHORT *ResInfo,USHORT *DisplayType);
extern USHORT    SiS_GetVCLK2Ptr(SiS_Private *SiS_Pr, UCHAR *ROMAddr,USHORT ModeNo,USHORT ModeIdIndex,
                                 USHORT RefreshRateTableIndex,
				 PSIS_HW_DEVICE_INFO HwDeviceExtension);
extern BOOLEAN   SiS_Is301B(SiS_Private *SiS_Pr, USHORT BaseAddr);
extern BOOLEAN   SiS_IsM650(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension, USHORT BaseAddr);
extern BOOLEAN   SiS_LowModeStuff(SiS_Private *SiS_Pr, USHORT ModeNo,PSIS_HW_DEVICE_INFO HwDeviceExtension);
extern BOOLEAN   SiS_IsVAMode(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension, USHORT BaseAddr);
extern BOOLEAN   SiS_IsDualEdge(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension, USHORT BaseAddr);
extern USHORT    SiS_GetMCLK(SiS_Private *SiS_Pr, UCHAR *ROMAddr, PSIS_HW_DEVICE_INFO HwDeviceExtension);

#ifdef LINUX_KERNEL
int    sisfb_mode_rate_to_dclock(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,
			      unsigned char modeno, unsigned char rateindex);
int    sisfb_mode_rate_to_ddata(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,
			 unsigned char modeno, unsigned char rateindex,
			 ULONG *left_margin, ULONG *right_margin,
			 ULONG *upper_margin, ULONG *lower_margin,
			 ULONG *hsync_len, ULONG *vsync_len,
			 ULONG *sync, ULONG *vmode);
BOOLEAN sisfb_gettotalfrommode(SiS_Private *SiS_Pr, PSIS_HW_DEVICE_INFO HwDeviceExtension,
		       unsigned char modeno, int *htotal, int *vtotal, unsigned char rateindex);
#endif

#endif

