/*
 * $Id: SAXBenchmark.java,v 1.2 2006/04/01 06:01:37 jeffsuttor Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */



import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 *
 * @author JAX-RPC RI Development Team
 */
public class SAXBenchmark { 

    private static String filename = null;
    private SAXParserFactory _factory;            
    
    private static void printUsage() {
        System.out.println("usage: java -classpath CursorParse -i <count> <xmlfile>");
    }
    
    public SAXBenchmark() {
        init();
    }

    protected void init() {
        _factory = SAXParserFactory.newInstance();
        _factory.setValidating(false);
        _factory.setNamespaceAware(true);
    }

    protected void runOnce(String filename) throws Exception {
        FileInputStream inputStream = new FileInputStream(new File(filename));
        InputSource source = new InputSource(inputStream);
        SAXParser parser = _factory.newSAXParser();
        TestHandler handler = new TestHandler();
        parser.parse(source, handler);
        inputStream.close();
    }

    public static void main(String [] args){
        SAXBenchmark sb = new SAXBenchmark();
        int count = 0 ;
        
        try {
            filename = args[2];
            if(args[0].equals("-i")){
                count = Integer.parseInt(args[1]);
            }
            else{
                printUsage() ;
            }
        } catch (ArrayIndexOutOfBoundsException aioobe){
            printUsage();
            System.exit(0);
        } catch (Exception ex){
            printUsage();
            ex.printStackTrace() ;
        }
        
        System.out.println("FACTORY: " + sb._factory);
        System.out.println("filename = "+ filename);
        
        //warm up for 10 parse
        try{
            for(int i = 0 ; i < 5 ; i++){
                sb.runOnce(filename);
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        
        
        long starttime = System.currentTimeMillis() ;
        
        try{
            for(int i = 0 ; i < count ; i++){
                sb.runOnce(filename);
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        long endtime = System.currentTimeMillis();
        System.out.println(" Total number of iterations  = " + count);
        System.out.println(" Total Parsing Time in milliseconds = " + (endtime - starttime) );
        System.out.println(" Parsing Time for each iteration in milliseconds = " +((endtime - starttime)/count));
        
    }
}

class TestHandler extends DefaultHandler {
    public void startElement(java.lang.String uri,
                             java.lang.String localName,
                             java.lang.String qName,
                             Attributes attributes) {
        // no-op
    }
    public void endElement(java.lang.String uri,
                           java.lang.String localName,
                           java.lang.String qName) {
        // no-op
    }
}
