/*
 * $Id: XPP.java,v 1.2 2006/04/01 06:01:39 jeffsuttor Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */


import java.io.*;
import org.xml.sax.InputSource;
import org.xmlpull.v1.*;

/**
 *
 * @author JAX-RPC RI Development Team,K.Venugopal@sun.com
 */
public class XPP{
    
    
    public XPP(){
    }
    
    public static void main(String argv[]) {
        String fileName = null;
        int count=0;
        try {
            fileName = argv[2];
            if(argv[0].equals("-i")){
                count = Integer.parseInt(argv[1]);
            }
            else{
                printUsage() ;
            }
        } catch (ArrayIndexOutOfBoundsException aioobe){
            printUsage();
            System.exit(0);
        } catch (Exception ex){
            printUsage();
            ex.printStackTrace() ;
        }
        XPP xpp= new XPP();
        //warm up for 5 counts
        xpp.runBench(5 ,count,fileName);
        
    }
    protected XmlPullParserFactory init() {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance(
            System.getProperty(XmlPullParserFactory.PROPERTY_NAME), null);
            factory.setNamespaceAware(true);
            return factory;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    
    protected void  runBench(int initialCount,int iterations,String fileName){
        try{
            XmlPullParserFactory factory;
            factory = init();
            File sourcefile = null;
            for(int i=0;i<initialCount;i++){
                sourcefile = new File(fileName);
                Reader reader = new FileReader(sourcefile);
                XmlPullParser xpp = factory.newPullParser();
                xpp.setInput(reader);
                while (xpp.next() != XmlPullParser.END_DOCUMENT) { }
                reader.close();
            }
            
            long starttime = System.currentTimeMillis() ;
            for(int i=0;i<iterations;i++){
                sourcefile = new File(fileName);
                //Reader reader = new FileReader(sourcefile);
                XmlPullParser xpp = factory.newPullParser();
                xpp.setInput(new FileInputStream(fileName),"UTF-8");
                while (xpp.next() != XmlPullParser.END_DOCUMENT) { }
                //reader.close();
            }            
            long endtime = System.currentTimeMillis();
            System.out.println(" Total Number of Iterations = " +iterations);
            System.out.println(" Total Parsing Time in milliseconds= " + (endtime - starttime) );
            System.out.println(" Parsing Time for each iteration in milliseconds = " +((endtime - starttime)/iterations));
            
        }catch(Exception ex){ex.printStackTrace();}
    }
    private static void printUsage() {
        System.out.println("usage: java -classpath XPP -i <count> <xmlfile>");
    }
    
}
