/*
 * $Id: ZephyrBenchMark.java,v 1.2 2006/04/01 06:01:37 jeffsuttor Exp $
 */
 
/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */


import java.io.*;
import org.xml.sax.InputSource;

import javax.xml.stream.*;


public class ZephyrBenchMark {
    
    private XMLInputFactory inputFactory;
    
    public ZephyrBenchMark() {        
        
    }
            
    
    public static void main(String [] args){
        System.setProperty("xml.stream.debug" , "1");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        int count = 0 ;
        String filename = null;
        try {
            filename = args[2];
            if(args[0].equals("-i")){
                count = Integer.parseInt(args[1]);
            }
            else{
                printUsage() ;
            }
        } catch (ArrayIndexOutOfBoundsException aioobe){
            printUsage();
            System.exit(0);
        } catch (Exception ex){
            printUsage();
            ex.printStackTrace() ;
        }
        
        
        System.out.println("filename = "+ filename);
        
        //warm up for 10 parse
        int warmup = 100;
        System.out.println("warm up " + warmup + " times");
        try{
            for(int i = 0 ; i < warmup ; i++){
                XMLStreamReader reader = inputFactory.createXMLStreamReader(new FileInputStream(filename), "UTF-8");
                while (reader.next() != XMLStreamConstants.END_DOCUMENT) {
                    // no-op
                }
                reader.close();
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        
        
        long starttime = System.currentTimeMillis() ;
        
        try{
            for(int i = 0 ; i < count ; i++){
                XMLStreamReader reader = inputFactory.createXMLStreamReader(new FileInputStream(filename), "UTF-8");
                while (reader.next() != XMLStreamConstants.END_DOCUMENT) {
                    // no-op
                }
                reader.close();
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        long endtime = System.currentTimeMillis();
        System.out.println(" Total number of iterations  = " + count);
        System.out.println(" Total Parsing Time in milliseconds = " + (endtime - starttime) );
        System.out.println(" Parsing Time for each iteration in milliseconds = " +((endtime - starttime)/count));
        
    }
    
    private static void printUsage() {
        System.out.println("usage: java -classpath ZephyrBenchmark -i <count> <xmlfile>");
    }
}
