/*
 * $Id: ZephyrWriterFactory.java,v 1.5 2007/01/19 01:47:19 kohsuke Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.stream;

import com.sun.xml.stream.writers.XMLDOMWriterImpl;
import com.sun.xml.stream.writers.XMLEventWriterImpl;
import com.sun.xml.stream.writers.XMLStreamWriterImpl;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.XMLEventWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import java.io.OutputStream;
import java.io.Writer;

/**
 * This class provides the implementation of {@link XMLOutputFactory}.
 *
 * <p>
 * As long as {@link #fReuseInstance} is off, this implementation
 * is thread-safe, and the {@code create} methods can be invoked concurrently
 * from multiple threads safely.
 *
 * TODO: revisit if the instance reuse really makes sense.
 *
 * @author  Neeraj Bajaj,
 * @author k.venugopal@sun.com
 */
public class ZephyrWriterFactory extends XMLOutputFactory {
    
    //List of supported properties and default values.
    private PropertyManager fPropertyManager = new PropertyManager(PropertyManager.CONTEXT_WRITER);
    
    //cache the instance of XMLStreamWriterImpl
    private XMLStreamWriterImpl fStreamWriter = null;

    /**
     * TODO: at the current time, XMLStreamWriters are not Thread safe.
     */
    boolean fReuseInstance = false;
    
    public ZephyrWriterFactory() {
    }        
        
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return createXMLEventWriter(outputStream,  null);
    }
    
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return new XMLEventWriterImpl(createXMLStreamWriter(outputStream, encoding));
    }
    
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new XMLEventWriterImpl(createXMLStreamWriter(result));
    }
    
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new XMLEventWriterImpl(createXMLStreamWriter(writer));
    }
    
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {

        if(result instanceof StreamResult){                
            return createXMLStreamWriter((StreamResult)result, null);
        }else if(result instanceof DOMResult){
            return new XMLDOMWriterImpl((DOMResult)result);
        }else if(result instanceof Result){
            return createXMLStreamWriter(new StreamResult(result.getSystemId()));
        }
        throw new java.lang.UnsupportedOperationException("result of type " + result + " is not supported");
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return createXMLStreamWriter(toStreamResult(null, writer, null) , null);
    }
    
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return createXMLStreamWriter(outputStream, null);
    }
    
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return createXMLStreamWriter(toStreamResult(outputStream, null, null) , encoding);
    }
    
    public Object getProperty(String name) throws IllegalArgumentException {
        if(name == null){
            throw new IllegalArgumentException("Property not supported");
        }
        if(fPropertyManager.containsProperty(name))
            return fPropertyManager.getProperty(name);
        throw new IllegalArgumentException("Property not supported");
    }
    
    public boolean isPropertySupported(String name) {
        if(name == null){
            return false ;
        }
        else{
            return fPropertyManager.containsProperty(name);
        }
    }
    
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if(name == null || value == null || !fPropertyManager.containsProperty(name) ){
            throw new IllegalArgumentException("Property "+name+"is not supported");
        }
        if(name == Constants.REUSE_INSTANCE || name.equals(Constants.REUSE_INSTANCE)){
            fReuseInstance = ((Boolean)value).booleanValue();
            if(DEBUG)System.out.println("fReuseInstance is set to " + fReuseInstance);
            
            // TODO: XMLStreamWriters are not Thread safe,
            // don't let application think it is optimizing
            if (fReuseInstance) {
                throw new IllegalArgumentException(
                        "Property "
                        + name
                        + " is not supported: XMLStreamWriters are not Thread safe");
            }
        }else{//for any other property set the flag
            //REVISIT: Even in this case instance can be reused, by passing PropertyManager
            fPropertyChanged = true;
        }
        fPropertyManager.setProperty(name,value);        
    }
    
    /**
     * If property has changed or value of the property has been set, 
     * <code>PropertyManager</code> is returned else <code>'null'</code>
     * is returned.
     * 
     * @return PropertyManager returns PropertyManager.
     */
    PropertyManager getPropertyManager(){
        return fPropertyChanged ? fPropertyManager : null ;
    }

    private StreamResult toStreamResult(OutputStream os, Writer writer, String systemId){
        StreamResult sr = new StreamResult();
        sr.setOutputStream(os);
        sr.setWriter(writer);
        sr.setSystemId(systemId);
        return sr;
    }
    
    XMLStreamWriter createXMLStreamWriter(StreamResult sr, String encoding) throws XMLStreamException {
        //if factory is configured to reuse the instance & this instance can be reused 
        //& the setProperty() hasn't been called
        try{
            if(fReuseInstance && fStreamWriter != null && fStreamWriter.canReuse() && !fPropertyChanged){
                fStreamWriter.reset();
                fStreamWriter.setOutput(sr, encoding);
                if(DEBUG)System.out.println("reusing instance, object id : " + fStreamWriter);
                return fStreamWriter;
            }
            return fStreamWriter = new XMLStreamWriterImpl(sr, encoding, getPropertyManager());
        }catch(java.io.IOException io){
            throw new XMLStreamException(io);
        }
    }//createXMLStreamWriter(StreamResult,String)
    
    private static final boolean DEBUG = false;
    
    /** This flag indicates the change of property. If true,
     * <code>PropertyManager</code> should be passed when creating 
     * <code>XMLStreamWriterImpl</code> */
    private boolean fPropertyChanged ;
}//ZephyrWriterFactory

