/*
 * $Id: CommentEvent.java,v 1.2 2006/04/01 06:01:34 jeffsuttor Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.stream.events ;

import javax.xml.stream.events.Comment;
import javax.xml.stream.events.XMLEvent;

/**
 * This class contains information about Comment event.
 *
 * @author Neeraj Bajaj, Sun Microsystems.
 */
public class CommentEvent extends DummyEvent implements Comment {
    
    /* String data for this event */
    private String fText ;
    
    public CommentEvent() {
        init();
    }
    
    public CommentEvent(String text) {
        init();
        fText = text;
    }
    
    protected void init() {
        setEventType(XMLEvent.COMMENT);
    }
    
    /**
     * @return String String representation of this event
     */
    public String toString() {
        return "<!--" + getText() + "-->";
    }
    
    
    /** Return the string data of the comment, returns empty string if it
     * does not exist
     * @return String
     */
    public String getText() {
        return fText ;
    }
    
}
