/*
 * BufferAllocator.java
 *
 * Created on November 22, 2006, 1:55 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.xml.stream.util;

import java.lang.ref.*;

public class BufferAllocator {
    public static int SMALL_SIZE_LIMIT = 128;
    public static int MEDIUM_SIZE_LIMIT = 2048;
    public static int LARGE_SIZE_LIMIT = 8192;
    
    char[] smallCharBuffer;
    char[] mediumCharBuffer;
    char[] largeCharBuffer;
    
    byte[] smallByteBuffer;
    byte[] mediumByteBuffer;
    byte[] largeByteBuffer;
    
    public BufferAllocator() {
    }
    
    public char[] getCharBuffer(int size) {
        if (size <= SMALL_SIZE_LIMIT) {
            char[] buffer = smallCharBuffer;
            smallCharBuffer = null;
            return buffer;
        } 
        else if (size <= MEDIUM_SIZE_LIMIT) {
            char[] buffer = mediumCharBuffer;
            mediumCharBuffer = null;
            return buffer;
        } 
        else if (size <= LARGE_SIZE_LIMIT) {
            char[] buffer = largeCharBuffer;
            largeCharBuffer = null;
            return buffer;
        }
        return null;
    }
    
    public void returnCharBuffer(char[] c) {
        if (c == null) {
            return;
        }
        if (c.length <= SMALL_SIZE_LIMIT) {
            smallCharBuffer = c;
        }
        else if (c.length <= MEDIUM_SIZE_LIMIT) {
            mediumCharBuffer = c;
        }
        else if (c.length <= LARGE_SIZE_LIMIT) {
            largeCharBuffer = c;
        }
    }
    
    public byte[] getByteBuffer(int size) {
        if (size <= SMALL_SIZE_LIMIT) {
            byte[] buffer = smallByteBuffer;
            smallByteBuffer = null;
            return buffer;
        } 
        else if (size <= MEDIUM_SIZE_LIMIT) {
            byte[] buffer = mediumByteBuffer;
            mediumByteBuffer = null;
            return buffer;
        } 
        else if (size <= LARGE_SIZE_LIMIT) {
            byte[] buffer = largeByteBuffer;
            largeByteBuffer = null;
            return buffer;
        }        
        return null;
    }
    
    public void returnByteBuffer(byte[] b) {
        if (b == null) {
            return;
        }
        if (b.length <= SMALL_SIZE_LIMIT) {
            smallByteBuffer = b;
        }
        else if (b.length <= MEDIUM_SIZE_LIMIT) {
            mediumByteBuffer = b;
        }
        else if (b.length <= LARGE_SIZE_LIMIT) {
            largeByteBuffer = b;
        }
    }
    
}