/*
 * $Id: ReadOnlyIterator.java,v 1.2 2006/04/01 06:01:52 jeffsuttor Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.stream.util;
/**
 *
 * @author K.Venugopal ,Neeraj Bajaj Sun Microsystems.
 */

import java.util.Iterator;

public class ReadOnlyIterator implements Iterator {
    
    Iterator iterator = null;
    
    public ReadOnlyIterator(){
    }
    
    public ReadOnlyIterator(Iterator itr){
        iterator = itr;
    }
    
    /**
     * @return
     */
    public boolean hasNext() {
        if(iterator  != null)
            return iterator.hasNext();
        return false;
    }
    
    /**
     * @return
     */
    public Object next() {
        if(iterator  != null)
            return iterator.next();
        return null;
    }
    
    public void remove() {
        throw new  UnsupportedOperationException("Remove operation is not supported");
    }
    
}
