/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

/*
 * TestCoalesce.java
 *
 * Created on April 27, 2004, 3:30 PM
 */

package Coalesce;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * @author  nb131165
 */
public class TestCoalesce extends TestCase {
    
    String countryElementContent =  "START India  CS}}}}}} India END" ;
    String descriptionElementContent =  "a&b" ;
    String fooElementContent = "&< cdatastart<><>>><>><<<<cdataend entitystart insert entityend";
    
    /** Creates a new instance of TestCoalesce */
    public TestCoalesce(String name) {
        super(name);
    }
    
    public void testCoalesceProperty(){
        try{
            XMLInputFactory xifactory = XMLInputFactory.newInstance() ;
            xifactory.setProperty(XMLInputFactory.IS_COALESCING, new Boolean(true)) ;
            File file = new File("./tests/Coalesce/coalesce.xml") ;            
            InputStream xml = new FileInputStream(file);
            XMLStreamReader streamReader = xifactory.createXMLStreamReader(xml);
            while(streamReader.hasNext()){
                int eventType = streamReader.next() ;
                if(eventType == XMLStreamConstants.START_ELEMENT && streamReader.getLocalName().equals("country")){
                    eventType = streamReader.next() ;
                    if(eventType == XMLStreamConstants.CHARACTERS){
                        String text = streamReader.getText() ;
                        if(!text.equals(countryElementContent)){
                            System.out.println("String dont match");
                            System.out.println("text = " + text ) ;
                            System.out.println("countryElementContent = " + countryElementContent);
                        }
                        //assertTrue(text.equals(countryElementContent));
                    }
                }
                if(eventType == XMLStreamConstants.START_ELEMENT && streamReader.getLocalName().equals("description")){
                    eventType = streamReader.next() ;
                    if(eventType == XMLStreamConstants.CHARACTERS){
                        String text = streamReader.getText() ;                        
                        if(!text.equals(descriptionElementContent)){
                            System.out.println("String dont match");
                            System.out.println("text = " + text ) ;
                            System.out.println("descriptionElementContent = " + descriptionElementContent);
                        }                        
                        assertTrue(text.equals(descriptionElementContent));
                    }
                }
                if(eventType == XMLStreamConstants.START_ELEMENT && streamReader.getLocalName().equals("foo")){
                    eventType = streamReader.next() ;
                    if(eventType == XMLStreamConstants.CHARACTERS){
                        String text = streamReader.getText() ;                        
                        if(!text.equals(fooElementContent)){
                            System.out.println("String dont match");
                            System.out.println("text = " + text ) ;
                            System.out.println("fooElementContent = " + fooElementContent);
                        }

                        assertTrue(text.equals(fooElementContent));
                    }
                }
                
            }
        }
        catch(XMLStreamException ex){

            if( ex.getNestedException() != null){
                ex.getNestedException().printStackTrace();
            }
            //ex.printStackTrace() ;
        }    
        catch(Exception ex){
            ex.printStackTrace() ;
        }    
        
    }
    
    public static void main(String [] args){
        TestRunner.run(TestCoalesce.class);
    }
}
