
package IssueTracker9;

import java.io.FileInputStream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamConstants;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * @author Santiago.PericasGeertsen@sun.com
 */
public class Test extends TestCase {
    
    public static void main(String [] args){
        TestRunner.run(Test.class);
    }
    
    public void test0() {
        try {   
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
            
            XMLStreamReader xsr = xif.createXMLStreamReader(
                    getClass().getResource("sgml.xml").toString(),
                    getClass().getResourceAsStream("sgml.xml"));
            
            assertTrue(xsr.getEventType() == XMLStreamConstants.START_DOCUMENT);
            int event = xsr.next();            
            // Must be a DTD event since DTDs are supported
            assertTrue(event == XMLStreamConstants.DTD);
            while (xsr.hasNext()) {
                event = xsr.next();
            }
            assertTrue(event == XMLStreamConstants.END_DOCUMENT);
            xsr.close();
        } 
        catch (Exception e) {
            fail(e.getMessage());
        }
    }
    
    public void test1() {
        try {   
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            
            XMLStreamReader xsr = xif.createXMLStreamReader(
                    getClass().getResource("sgml.xml").toString(),
                    getClass().getResourceAsStream("sgml.xml"));
            
            assertTrue(xsr.getEventType() == XMLStreamConstants.START_DOCUMENT);
            int event = xsr.next();
            // Should not be a DTD event since they are ignored
            assertTrue(event == XMLStreamConstants.START_ELEMENT);
            while (xsr.hasNext()) {
                event = xsr.next();
            }
            assertTrue(event == XMLStreamConstants.END_DOCUMENT);
            xsr.close();
        } 
        catch (Exception e) {
            fail(e.getMessage());
        }
    }
    
    public void test2() {
        try {   
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            
            XMLStreamReader xsr = xif.createXMLStreamReader(
                    getClass().getResource("sgml-bad-systemId.xml").toString(),
                    getClass().getResourceAsStream("sgml-bad-systemId.xml"));
            
            assertTrue(xsr.getEventType() == XMLStreamConstants.START_DOCUMENT);
            int event = xsr.next();
            // Should not be a DTD event since they are ignored
            assertTrue(event == XMLStreamConstants.START_ELEMENT);
            while (xsr.hasNext()) {
                event = xsr.next();
            }
            assertTrue(event == XMLStreamConstants.END_DOCUMENT);
            xsr.close();
        } 
        catch (Exception e) {
            // Bogus systemId in XML document should not result in exception
            fail(e.getMessage());
        }
    }    
}
