/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

/*
 * SimpleJUnitTest.java
 * JUnit based test
 *
 * Created on February 3, 2004, 1:46 PM
 */

package ProcessingInstruction;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;
import junit.framework.*;
import junit.textui.TestRunner;

/**
 *
 * @author neeraj
 */
public class ProcessingInstructionTest extends TestCase {
    
    public ProcessingInstructionTest(java.lang.String testName) {
        super(testName);
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite(ProcessingInstructionTest.class);
        return suite;
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    public void testPITargetAndData(){
        try{
            XMLInputFactory xif = XMLInputFactory.newInstance() ;
            String PITarget = "soffice" ;
            String PIData = "WebservicesArchitecture";
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + "<?" + PITarget + " " +  PIData + "?>" + "<foo></foo>" ;            
            //System.out.println("XML = " + xml) ;
            InputStream is = new java.io.ByteArrayInputStream(xml.getBytes());
            XMLStreamReader sr = xif.createXMLStreamReader(is) ;
            while(sr.hasNext()){
                int eventType = sr.next() ;
                if(eventType == XMLStreamConstants.PROCESSING_INSTRUCTION){
                    String target = sr.getPITarget() ;                    
                    String data = sr.getPIData();                                            
                    assertTrue(target.equals(PITarget) && data.equals(PIData)) ;
                }        
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }

    
    public static void main(String[] args) {
        TestRunner.run(ProcessingInstructionTest.class);
    }

}
