
package SimpleWriterTest;

import java.io.File;
import javax.xml.stream.*;

import junit.framework.TestCase;
import junit.framework.Assert;
import junit.textui.TestRunner;

import java.io.FileWriter;

/**
 *
 * @author Santiago.PericasGeertsen@sun.com
 */
public class Test extends TestCase {
    
    public java.io.File input;
    public final String filesDir = "./";
    protected XMLInputFactory inputFactory;
    protected XMLOutputFactory outputFactory;
    
    public static void main(String [] args) {
        TestRunner.run(Test.class);
    }
    
    public void testEventReader1() {
        try {
            inputFactory = XMLInputFactory.newInstance();
            outputFactory = XMLOutputFactory.newInstance();
            input = new File(filesDir, "tests/SimpleWriterTest/play.xml");
            
            // Check if event reader returns the correct event
            XMLEventReader e1 =
                    inputFactory.createXMLEventReader(
                        inputFactory.createXMLStreamReader(
                            new java.io.FileInputStream(input), "UTF-8"));            
            Assert.assertEquals(e1.peek().getEventType(), 
                                XMLStreamConstants.START_DOCUMENT);
            
            // Repeat same steps to test factory state
            XMLEventReader e2 =
                    inputFactory.createXMLEventReader(
                        inputFactory.createXMLStreamReader(
                            new java.io.FileInputStream(input), "UTF-8"));            
            Assert.assertEquals(e2.peek().getEventType(), 
                                XMLStreamConstants.START_DOCUMENT);  
        } 
        catch (Exception e) {
            fail(e.getMessage());
        }
    }    
    
    public void testEventReader2() {
        try {
            inputFactory = XMLInputFactory.newInstance();
            outputFactory = XMLOutputFactory.newInstance();
            input = new File(filesDir, "tests/SimpleWriterTest/play.xml");
                        
            // Now advance underlying reader and then call peek on event reader
            XMLStreamReader s1 = 
                    inputFactory.createXMLStreamReader(
                        new java.io.FileInputStream(input), "UTF-8");
            Assert.assertEquals(s1.getEventType(), 
                                XMLStreamConstants.START_DOCUMENT);
            s1.next(); s1.next();    // advance to <TITLE>
            Assert.assertTrue(s1.getLocalName().equals("TITLE"));
            
            XMLEventReader e3 = inputFactory.createXMLEventReader(s1);
            Assert.assertEquals(e3.peek().getEventType(), 
                                XMLStreamConstants.START_ELEMENT);     
        } 
        catch (Exception e) {
            fail(e.getMessage());
        }
    }        
}
