/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

    /*
 * XMLStreamWriterTest.java
 *
 * Created on May 2, 2004, 8:27 AM
 */

package XMLEventWriter;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * @author  Neeraj Bajaj, Sun Microsystems
 */
public class XMLEventWriterTest extends TestCase{
    
    /** Creates a new instance of XMLStreamWriterTest */
    public XMLEventWriterTest(String name) {
        super(name);
    }
    
    public void testXMLStreamWriter(){
        try{
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(System.out);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            File file = new File("./tests/XMLEventWriter/XMLEventWriterTest.xml");
            FileInputStream inputStream = new FileInputStream(file);
            XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream);
            //adds the event to the consumer.
            eventWriter.add(eventReader);
            eventWriter.flush();
            eventWriter.close();
        }   
        catch(XMLStreamException streamException){
            streamException.printStackTrace();
        }
        catch(java.io.IOException ioexception){
            ioexception.printStackTrace();
        }
    }
    public static void main(String [] args){
        TestRunner.run(XMLEventWriterTest.class);
    }
}
