/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://jaxp.dev.java.net/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jaxp.dev.java.net/CDDLv1.0.html
 * If applicable add the following below this CDDL HEADER
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */
/*
 * $Id: DuplicateNSDeclarationTest.java,v 1.1 2007/01/09 17:50:17 jeffsuttor Exp $
 * %W% %E%
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package XMLOutputFactory;

import java.io.*;

import javax.xml.stream.*;
import javax.xml.transform.stream.StreamResult;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 * Test the writing of duplicate namespace declarations.
 *
 * Inspired by SJSXP
 * <a href="https://sjsxp.dev.java.net/issues/show_bug.cgi?id=13">Issue # 13</a>.
 *
 * @author <a href="Jeff.Suttor@Sun.com">Jeff Suttor</a>
 */

public class DuplicateNSDeclarationTest extends TestCase {

    public DuplicateNSDeclarationTest(String name) {
        super(name);
    }

    public static void main(String [] args) {
        TestRunner.run(DuplicateNSDeclarationTest.class);
    }

    public void testDuplicateNSDeclaration() {

        // expect only 1 Namespace Declaration
        final String EXPECTED_OUTPUT =
                "<?xml version=\"1.0\" ?>"
                + "<ns1:foo"
                + " xmlns:ns1=\"http://example.com/\">"
                + "</ns1:foo>";

        // have XMLOutputFactory repair Namespaces
        XMLOutputFactory ofac = XMLOutputFactory.newInstance();
        ofac.setProperty(
                XMLOutputFactory.IS_REPAIRING_NAMESPACES,
                new Boolean(true));

        // send output to a Stream
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(buffer);
        XMLStreamWriter w = null;

        //write a duplicate Namespace Declaration
        try {
            w = ofac.createXMLStreamWriter(sr);
            w.writeStartDocument();
            w.writeStartElement("ns1","foo","http://example.com/");
            w.writeNamespace("ns1","http://example.com/");
            w.writeNamespace("ns1","http://example.com/");
            w.writeEndElement();
            w.writeEndDocument();
            w.close();
        } catch (XMLStreamException xmlStreamException) {
            xmlStreamException.printStackTrace();
            fail(xmlStreamException.toString());
        }

        // debugging output for humans
        System.out.println();
        System.out.println("actual:   \"" + buffer.toString() + "\"");
        System.out.println("expected: \"" + EXPECTED_OUTPUT + "\"");

        // are results as expected?
        assertEquals(EXPECTED_OUTPUT, buffer.toString());
    }
}
