/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://jaxp.dev.java.net/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jaxp.dev.java.net/CDDLv1.0.html
 * If applicable add the following below this CDDL HEADER
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */
/*
 * $Id: StreamResultTest.java,v 1.1 2006/05/18 06:51:13 sunithareddy Exp $
 * %W% %E%
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package XMLOutputFactory;

import java.io.*;

import javax.xml.stream.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * @author Sunitha Reddy, Sun Microsystems
 */

public class StreamResultTest extends TestCase{
    
    public StreamResultTest(String name) {
        super(name);
    }
    
    public static void main(String [] args) {
        TestRunner.run(StreamResultTest.class);
    }
    
    public void testStreamResult() {
        final String EXPECTED_OUTPUT = "<?xml version=\"1.0\"?><root></root>";
        try {
            XMLOutputFactory ofac = XMLOutputFactory.newInstance();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            StreamResult sr = new StreamResult(buffer);
            XMLStreamWriter writer = ofac.createXMLStreamWriter(sr);
            writer.writeStartDocument("1.0");
            writer.writeStartElement("root");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            assertEquals(buffer.toString(), EXPECTED_OUTPUT);
        } catch(Exception e) {
            e.printStackTrace();
            fail(e.toString());
        }
    }
       
}
