/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

/*
 * XMLResolverTest.java
 *
 * Created on April 6, 2004, 3:19 PM
 */

package XMLResolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.namespace.QName;

import java.io.InputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.*;
import junit.textui.TestRunner;

/**
 *
 * @author  neeraj
 */
public class XMLResolverTest extends TestCase {
    
    /** Creates a new instance of XMLResolverTest */
    public XMLResolverTest(String testname) {
        super(testname) ;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(XMLResolverTest.class);
        return suite;
    }
    
    public void testXMLResolver() {
        try{
            XMLInputFactory xifactory = XMLInputFactory.newInstance() ;
            xifactory.setProperty(XMLInputFactory.RESOLVER, new MyStaxResolver()) ;
            File file = new File("./tests/XMLResolver/XMLResolverTest.xml") ;
            String systemId = file.toURI().toString() ;
            InputStream entityxml = new FileInputStream(file);
            XMLStreamReader streamReader = xifactory.createXMLStreamReader(systemId, entityxml);
            while(streamReader.hasNext()){
                int eventType = streamReader.next() ;
                if(eventType == XMLStreamConstants.START_ELEMENT){
                    eventType = streamReader.next() ;
                    if(eventType == XMLStreamConstants.CHARACTERS){
                        String text = streamReader.getText() ;                        
                        assertTrue(text.equals("replace2"));
                    }
                }
            }
        }
        catch(XMLStreamException ex){
            
            if( ex.getNestedException() != null){
                ex.getNestedException().printStackTrace();
            }
            //ex.printStackTrace() ;
        }
        catch(Exception io){
            io.printStackTrace() ;
        }
    }
    
    public static void main(String [] args){
        TestRunner.run(XMLResolverTest.class);        
    }
    
    
    class MyStaxResolver implements XMLResolver{
        
        public MyStaxResolver(){
        
        }
        public Object resolveEntity(String publicId, String systemId, String baseURI, String namespace) throws javax.xml.stream.XMLStreamException{
            
            Object object = null ;
            try{
                object = new FileInputStream("./tests/XMLResolver/replace2.txt");
            }catch(Exception ex){
                ex.printStackTrace() ;
            }
            return object ;
        }        
    
    }
}
