/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package XMLStreamFilterTest;

import java.io.File;
import java.io.FileReader;

import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * <p>Test get methods</p>
 *
 * @author Joe Wang
 */
public class GettersTest extends TestCase {
    
    /** Creates a new instance of HasNextTest */
    public GettersTest(String name) {
         super(name);
    }   
    
    public static void main(String[] args) {
    	TestRunner.run(GettersTest.class);
    }
 
    private HasNextTypeFilter createFilter() {

        HasNextTypeFilter f = new HasNextTypeFilter();

        f.addType(XMLEvent.START_ELEMENT);
        f.addType(XMLEvent.END_ELEMENT);
        f.addType(XMLEvent.CHARACTERS);
        f.addType(XMLEvent.ATTRIBUTE);
        f.addType(XMLEvent.START_DOCUMENT);
        return f;
    }

    private XMLStreamReader createStreamReader(HasNextTypeFilter f) {

        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            File input = new File("./tests/data/namespace.xml");
            return factory.createFilteredReader(factory.createXMLStreamReader(new FileReader(input)), (StreamFilter)f);
        } catch (Exception e) {
            e.printStackTrace();
            fail("Unexpected Exception: " + e.getMessage());
            return null;
        }
    }

    private void checkAttributes(XMLStreamReader r1){
        if (r1.getLocalName().equals("examples")) {
            if(r1.getAttributeCount() > 0){
                fail("Element <example> does not have attributes.");

            } else {
                try {
                    r1.getAttributeValue(0);
                    r1.getAttributeType(0);
                    r1.getAttributePrefix(0);
                    r1.getAttributeNamespace(0);
                    r1.getAttributeName(0);
                    System.err.println("AttributeValue(0):"+r1.getAttributeValue(0));
                } catch (Exception e) {
                    System.err.println("Expected Exception:");
                    e.printStackTrace();
                }
            }
        } else if (r1.getLocalName().equals("author")) {
            if(r1.getAttributeCount() > 0){

                assertTrue("\ngetAttributexxx fails: "
                    + "\ngetAttributeName(0) returns: " + r1.getAttributeName(0)
                    + "\ngetAttributeNamespace(0) returns: " + r1.getAttributeNamespace(0)
                    + "\ngetAttributeType(0) returns: " + r1.getAttributeType(0)
                    + "\ngetAttributePrefix(0) returns: " + r1.getAttributePrefix(0)
                    + "\ngetAttributeValue(0) returns: " + r1.getAttributeValue(0), 
                    (r1.getAttributeName(0).toString().equals("title")) && 
                        (r1.getAttributeNamespace(0) == null) &&
                        (r1.getAttributeType(0).equals("CDATA")) &&
                        (r1.getAttributePrefix(0).equals("")) &&
                        (r1.getAttributeValue(0).equals("Mr.")));


            } else {
                fail("AttributeCount returned 0 for element <section>.");
            }
        } else if (r1.getLocalName().equals("name")) {
            if(r1.getAttributeCount() > 0){

                assertTrue("getAttributexxx fails: \n"
                    + "getAttributeName(0) returns: " + r1.getAttributeName(0)
                    + "getAttributeNamespace(0) returns: " + r1.getAttributeNamespace(0)
                    + "getAttributeType(0) returns: " + r1.getAttributeType(0)
                    + "getAttributePrefix(0) returns: " + r1.getAttributePrefix(0)
                    + "getAttributeValue(0) returns: " + r1.getAttributeValue(0), 
                    (r1.getAttributeName(0).toString().equals("{http://www.w3.org/TR/REC-html40}class")) && 
                        (r1.getAttributeNamespace(0).equals("http://www.w3.org/TR/REC-html40")) &&
                        (r1.getAttributeType(0).equals("CDATA")) &&
                        (r1.getAttributePrefix(0).equals("html")) &&
                        (r1.getAttributeValue(0).equals("largeSansSerif")));


            } else {
                fail("AttributeCount returned 0 for element <section>.");
            }
        }

    }

    public void testGetAttributes() {

        try {
            HasNextTypeFilter f = createFilter();
            XMLStreamReader r1 = createStreamReader(f);

            while (r1.hasNext()) {
                r1.next();
                if(r1.isStartElement()){
                    checkAttributes(r1);
                }
            }
                        
        } catch (Exception e) {
            // unexpected
            System.err.println("Unexpected Exception: " + e.getMessage());
            e.printStackTrace();
            fail("Unexpected Exception: " + e.toString());
        }
    }
    
    
}
