/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package XMLStreamFilterTest;

import java.io.File;
import java.io.FileReader;

import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;

import junit.framework.TestCase;
import junit.textui.TestRunner;

/**
 *
 * <p>6378698 com.sun.org.apache.xerces.internal.impl.XMLStreamFilterImpl has incorrect behaviour of hasNext()</p>
 *
 * @author Sunitha Reddy
 * @author <a href="mailto:Jeff.Suttor@Sun.com>Jeff Suttor</a>
 */
public class HasNextTest extends TestCase {
    
    /** Creates a new instance of HasNextTest */
    public HasNextTest(String name) {
         super(name);
    }   
    
    public static void main(String[] args) {
    	TestRunner.run(HasNextTest.class);
    }
 
    private HasNextTypeFilter createFilter() {

        HasNextTypeFilter f = new HasNextTypeFilter();

        f.addType(XMLEvent.START_ELEMENT);
        f.addType(XMLEvent.END_ELEMENT);
        f.addType(XMLEvent.PROCESSING_INSTRUCTION);
        f.addType(XMLEvent.CHARACTERS);
        f.addType(XMLEvent.COMMENT);
        f.addType(XMLEvent.SPACE);
        f.addType(XMLEvent.START_DOCUMENT);
        f.addType(XMLEvent.END_DOCUMENT);
        return f;
    }

    private XMLStreamReader createStreamReader(HasNextTypeFilter f) {

        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            File input = new File("./tests/XMLStreamFilterTest/HasNextTest.xml");
            factory = XMLInputFactory.newInstance();
            return factory.createFilteredReader(factory.createXMLStreamReader(new FileReader(input)), (StreamFilter)f);
        } catch (Exception e) {
            e.printStackTrace();
            fail("Unexpected Exception: " + e.getMessage());
            return null;
        }
    }

    private void checkHasNext(XMLStreamReader r1) throws XMLStreamException {

        // try asking 3 times, insure all results are the same
        boolean hasNext_1 = r1.hasNext();
        boolean hasNext_2 = r1.hasNext();
        boolean hasNext_3 = r1.hasNext();

        System.out.println("XMLStreamReader.hasNext() (1): " + hasNext_1);
        System.out.println("XMLStreamReader.hasNext() (2): " + hasNext_2);
        System.out.println("XMLStreamReader.hasNext() (3): " + hasNext_3);

        assertTrue("XMLStreamReader.hasNext() returns inconsistent values for each subsequent call: "
                + hasNext_1 + ", "
                + hasNext_2 + ", "
                + hasNext_3,
                (hasNext_1 == hasNext_2) && (hasNext_1 == hasNext_3));
    }

    public void testFilterUsingNextTag() {

        try {
            HasNextTypeFilter f = createFilter();
            XMLStreamReader r1 = createStreamReader(f);

            while (r1.hasNext()) {
                try {
                    r1.nextTag();
                } catch (Exception e) {
                    System.err.println("Expected Exception: " + e.getMessage());
                    e.printStackTrace();
                }

                checkHasNext(r1);
            }
                        
        } catch (XMLStreamException e) {
           System.err.println("Unexpected Exception: " + e.getMessage());
           e.printStackTrace();
           fail("Unexpected Exception: " + e.toString());
        } catch (Exception e) {
            // if this is END_DOCUMENT, it is expected
            if (e.toString().indexOf("END_DOCUMENT") != -1) {
                // expected
                System.err.println("Expected Exception:");
                e.printStackTrace();
            } else {
                // unexpected
                System.err.println("Unexpected Exception: " + e.getMessage());
                e.printStackTrace();
                fail("Unexpected Exception: " + e.toString());
            }
        }
    }
    
    public void testFilterUsingNext() {

        try {
            HasNextTypeFilter f = createFilter();
            XMLStreamReader r1 = createStreamReader(f);

            while (r1.hasNext()) {
                r1.next();
                checkHasNext(r1);
            }
                        
        } catch (Exception e) {
            // unexpected
            System.err.println("Unexpected Exception: " + e.getMessage());
            e.printStackTrace();
            fail("Unexpected Exception: " + e.toString());
        }
    }
}
