/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package XMLStreamFilterTest;

import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.XMLStreamReader;

public class HasNextTypeFilter implements EventFilter, StreamFilter {

  protected boolean[] types= new boolean[20];

  public HasNextTypeFilter () {}
  
  public void addType(int type) {
    types[type]=true;
  }

  public boolean accept(XMLEvent e) {
    return types[e.getEventType()];
  }

  public boolean accept(XMLStreamReader r) {
    return types[r.getEventType()];
  }
}


