package XMLStreamReader;

/**
 *
 * @author Sunitha Reddy
 */
import java.io.File;
import java.io.FileInputStream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import junit.framework.TestCase;
import junit.textui.TestRunner;

public class Bug6370703Test extends TestCase{
    
    /** Creates a new instance of Bug */
    public Bug6370703Test(String name) {
         super(name);
    }   
    
    public static void main(String[] args) {
    	TestRunner.run(Bug6370703Test.class);
    }
    
    public void testStartElement() {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            // XMLStreamReader xsr = xif.createXMLStreamReader(this.getClass().getResourceAsStream("file://tests/XMLStreamReader/Bug6370703Test/sgml.xml"));
            File file = new File("./tests/XMLStreamReader/sgml.xml");
            FileInputStream inputStream = new FileInputStream(file);
            XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);

            
            while (xsr.hasNext()) {
                int event = xsr.next();
                if (event == XMLStreamReader.START_ELEMENT) {
                    String localName = xsr.getLocalName();
                    boolean print = "para".equals(localName);
                    int nrOfAttr = xsr.getAttributeCount();
                    if (print) { 
                        assertTrue("Default attribute declared in DTD is missing", nrOfAttr > 0);
                    }
                    
                }
            }
        } catch (XMLStreamException xmlStreamException) {
            
            Exception nestedException = (Exception) xmlStreamException.getNestedException();
            
            if (nestedException == null) {
                xmlStreamException.printStackTrace();
                fail("Exception occured: " + xmlStreamException.getMessage());
            }
            
            nestedException.printStackTrace();   
            fail("Exception occured: " + nestedException.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            fail("Exception occured: "+e.getMessage());
        }
    }
}
