/*
 * DefaultAttributeTest.java
 *
 * Created on May 3, 2006, 6:15 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package XMLStreamReader;

/**
 *
 * @author Sunitha Reddy
 */
import java.io.*;
import java.util.Iterator;
import javax.xml.stream.*;
import javax.xml.stream.events.*;

import junit.framework.TestCase;
import junit.textui.TestRunner;

public class DefaultAttributeTest extends TestCase{
    
    private static final String INPUT_FILE = "ExternalDTD.xml";
    
    /** Creates a new instance of Bug */
    public DefaultAttributeTest(String name) {
         super(name);
    }   
    
    public static void main(String[] args) {
    	TestRunner.run(DefaultAttributeTest.class);
    }
    
    public void testStreamReader(){
        XMLInputFactory ifac = XMLInputFactory.newInstance();
        XMLOutputFactory ofac = XMLOutputFactory.newInstance();
        
 
        try{
            ifac.setProperty(ifac.IS_REPLACING_ENTITY_REFERENCES, new Boolean(false));
           if (this.getClass().getResourceAsStream(INPUT_FILE) == null) 
                System.out.println("Stream is NULL");
            XMLStreamReader re = ifac.createXMLStreamReader(this.getClass().getResourceAsStream(INPUT_FILE));
                        
            while (re.hasNext()){
		int event = re.next();
		if (event == XMLStreamConstants.START_ELEMENT && re.getLocalName().equals("bookurn")){
			assertTrue("No attributes are expected for <bookurn> ",re.getAttributeCount() == 0);
			assertTrue("Two namespaces are expected for <bookurn> ",re.getNamespaceCount() == 2);
		}
	    }
        }catch(Exception e){
            e.printStackTrace();
            fail("Exception occured: "+e.getMessage());
        }
    }
    
    public void testEventReader(){
        try{
            XMLInputFactory ifac = XMLInputFactory.newInstance();
            XMLEventReader read = ifac.createXMLEventReader(this.getClass().getResourceAsStream(INPUT_FILE));
            while (read.hasNext()){
                XMLEvent event = read.nextEvent();
                if (event.isStartElement()){
                    StartElement startElement = event.asStartElement();
                    if (startElement.getName().getLocalPart().equals("bookurn")){
                        Iterator iterator = startElement.getNamespaces();
                        int count = 0;
                        while(iterator.hasNext()){
                           iterator.next();
                            count ++;
                        }
                        assertTrue("Two namespaces are expected for <bookurn> ", count == 2);
                        
                        Iterator attributes = startElement.getAttributes();
                        count = 0;
                        while(attributes.hasNext()){
                            iterator.next();
                            count ++;
                        }
                        assertTrue("Zero attributes are expected for <bookurn> ", count == 0);
                    }}
            }
        }catch(Exception e){
            e.printStackTrace();
            fail("Exception occured: "+e.getMessage());
        }
    }
}
